/*
 * Decompiled with CFR 0.152.
 */
package net.handle.security;

import java.math.BigInteger;
import java.security.interfaces.RSAPublicKey;
import net.handle.hdllib.Util;

public class RSAPublicKeyImpl
implements RSAPublicKey {
    private BigInteger modulus;
    private BigInteger publicExponent;

    public RSAPublicKeyImpl(BigInteger m, BigInteger exp) throws NumberFormatException {
        this.modulus = m;
        this.publicExponent = exp;
    }

    public BigInteger getModulus() {
        return this.modulus;
    }

    public BigInteger getPublicExponent() {
        return this.publicExponent;
    }

    public String getAlgorithm() {
        return "RSA";
    }

    public String getFormat() {
        return "HDL_RSA_PUB";
    }

    public byte[] getEncoded() {
        try {
            return Util.getBytesFromPublicKey(this);
        }
        catch (Exception e) {
            System.err.println("Error encoding public key: " + e);
            return null;
        }
    }
}

