/*
 * Decompiled with CFR 0.152.
 */
package net.handle.server;

import net.handle.hdllib.AbstractRequest;
import net.handle.hdllib.HandleException;
import net.handle.hdllib.HandleResolver;
import net.handle.hdllib.ResponseMessageCallback;
import net.handle.server.CacheServer;
import net.handle.server.HandleServer;
import net.handle.server.Main;
import net.handle.util.StreamTable;

public abstract class AbstractServer {
    public static final String SERVER_TYPE = "server_type";
    public static final String HDLSVR_ID = "server";
    public static final String HDLSVR_CONFIG = "server_config";
    public static final String CACHESVR_ID = "cache";
    public static final String CACHESVR_CONFIG = "cache_config";
    public static final String PROXYSVR_ID = "proxy";
    public static final String PROXYSVR_CONFIG = "proxy_config";
    public static final String TRACE_MESSAGES = "trace_outgoing_messages";
    protected HandleResolver resolver;
    protected Main main;
    private static final long ROOT_REFRESH_INTERVAL = 86400000L;

    protected AbstractServer(Main main, StreamTable config) {
        this.main = main;
        this.resolver = main.getResolver();
        if (config.containsKey(TRACE_MESSAGES)) {
            String traceMessagesStr = String.valueOf(config.get(TRACE_MESSAGES));
            if ((traceMessagesStr = traceMessagesStr.toUpperCase()).startsWith("Y")) {
                this.resolver.traceMessages = true;
            }
        }
        RootInfoUpdater riu = new RootInfoUpdater();
        riu.setDaemon(true);
        riu.start();
    }

    public abstract void processRequest(AbstractRequest var1, ResponseMessageCallback var2) throws HandleException;

    public abstract void shutdown();

    public static AbstractServer getInstance(Main main, StreamTable configTable) throws Exception {
        String serverType = String.valueOf(configTable.get(SERVER_TYPE));
        if (serverType.equals(HDLSVR_ID)) {
            return new HandleServer(main, (StreamTable)configTable.get(HDLSVR_CONFIG));
        }
        if (serverType.equals(CACHESVR_ID)) {
            return new CacheServer(main, (StreamTable)configTable.get(CACHESVR_CONFIG));
        }
        throw new Exception("Configuration setting \"server_type\" must be \"server\", or \"cache\"");
    }

    private class RootInfoUpdater
    extends Thread {
        private RootInfoUpdater() {
        }

        public void run() {
            while (true) {
                long startSleep;
                try {
                    AbstractServer.this.resolver.getConfiguration().refreshRootInfoFromNet();
                }
                catch (Throwable t) {
                    AbstractServer.this.main.logError(50, "Error refreshing root info: " + t);
                    t.printStackTrace(System.err);
                }
                long currTime = startSleep = System.currentTimeMillis();
                long endSleep = startSleep + 86400000L;
                do {
                    if (currTime >= endSleep) continue;
                    try {
                        RootInfoUpdater.sleep(endSleep - currTime);
                    }
                    catch (Throwable t) {
                        AbstractServer.this.main.logError(50, "Error: Root info updater can't sleep: " + t);
                    }
                } while ((currTime = System.currentTimeMillis()) < endSleep);
            }
        }
    }
}

