/*
 * Decompiled with CFR 0.152.
 */
package net.handle.server;

import java.io.File;
import java.net.InetAddress;
import java.util.Date;
import java.util.Vector;
import net.handle.hdllib.HandleResolver;
import net.handle.hdllib.JDBCache;
import net.handle.hdllib.Util;
import net.handle.server.AbstractServer;
import net.handle.server.NetworkInterface;
import net.handle.server.ServerLog;
import net.handle.util.StreamTable;

public class Main {
    private AbstractServer server;
    private Vector interfaces;
    private StreamTable configTable;
    private File serverDir;
    private static ServerLog logger;
    private ThreadGroup interfaceThreadGroup = null;
    private HandleResolver resolver = null;
    private static final String CACHE_STORAGE_FILE = "cache.jdb";
    private Object gcLock = new Object();

    private static void printUsage() {
        System.err.println("Usage: <program-name> <config-directory>");
    }

    public static void main(String[] argv) {
        String configDirStr = null;
        if (argv == null || argv.length != 1) {
            Main.printUsage();
            return;
        }
        if (!Util.checkJavaVersion()) {
            return;
        }
        configDirStr = argv[0];
        Main main = null;
        StreamTable configTable = new StreamTable();
        File serverDir = new File(configDirStr);
        if (!serverDir.exists() || !serverDir.isDirectory()) {
            System.err.println("Invalid configuration directory: " + configDirStr + ".");
            return;
        }
        try {
            configTable.readFromFile(new File(serverDir, "config.dct"));
        }
        catch (Exception e) {
            System.err.println("Error reading configuration: " + e);
            return;
        }
        try {
            main = new Main(serverDir, configTable);
            main.initialize();
            main.start();
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
            System.out.println("Error: " + e.getMessage());
            System.out.println("       (see the error log for details.)\n");
            System.out.println("Shutting down...");
            System.err.println("Shutting down...");
            try {
                main.shutdown();
            }
            catch (Exception e2) {
                // empty catch block
            }
            System.exit(0);
        }
    }

    public Main(File serverDir, StreamTable configTable) throws Exception {
        this.serverDir = serverDir;
        this.configTable = configTable;
        logger = new ServerLog(serverDir, configTable);
    }

    public HandleResolver getResolver() {
        return this.resolver;
    }

    public File getConfigDir() {
        return this.serverDir;
    }

    public void initialize() throws Exception {
        System.runFinalizersOnExit((boolean)true);
        this.resolver = new HandleResolver();
        if (this.configTable.containsKey("tcp_timeout")) {
            int timeout = Integer.parseInt((String)this.configTable.get("tcp_timeout"));
            this.resolver.setTcpTimeout(timeout);
        }
        this.resolver.setCheckSignatures(true);
        this.resolver.traceMessages = this.configTable.containsKey("trace_resolution");
        try {
            File cacheFile = new File(this.getConfigDir(), CACHE_STORAGE_FILE);
            if (cacheFile.exists()) {
                cacheFile.delete();
            }
            JDBCache cache = new JDBCache(cacheFile);
            this.resolver.setCache(cache);
        }
        catch (Exception e) {
            System.err.println("Warning: Cannot create handle cache (" + e + ").");
            e.printStackTrace(System.err);
        }
        if (this.configTable.containsKey("no_udp_resolution")) {
            this.resolver.setPreferredProtocols(new int[]{1, 2});
        }
        this.server = AbstractServer.getInstance(this, this.configTable);
        this.interfaces = new Vector();
        Object obj = this.configTable.get("interfaces");
        if (obj == null || !(obj instanceof Vector) || ((Vector)obj).size() < 1) {
            throw new Exception("No \"interfaces\" specified!");
        }
        Vector frontEndLabels = (Vector)obj;
        for (int i = 0; i < frontEndLabels.size(); ++i) {
            String frontEndLabel = String.valueOf(frontEndLabels.elementAt(i));
            NetworkInterface ifc = NetworkInterface.getInstance(this, frontEndLabel, this.configTable);
            this.interfaces.addElement(ifc);
        }
    }

    public AbstractServer getServer() {
        return this.server;
    }

    public void start() {
        this.interfaceThreadGroup = new ThreadGroup("Network Interfaces");
        for (int i = 0; i < this.interfaces.size(); ++i) {
            NetworkInterface interfc = (NetworkInterface)this.interfaces.elementAt(i);
            Thread t = new Thread(this.interfaceThreadGroup, interfc);
            t.start();
        }
        Runnable r = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                while (Main.this.interfaces.size() > 0) {
                    int i;
                    boolean needsGC = false;
                    for (i = Main.this.interfaces.size() - 1; i >= 0; --i) {
                        if (!((NetworkInterface)Main.this.interfaces.elementAt(i)).needsGC()) continue;
                        needsGC = true;
                        break;
                    }
                    if (needsGC) {
                        System.gc();
                        System.runFinalization();
                        for (i = Main.this.interfaces.size() - 1; i >= 0; --i) {
                            ((NetworkInterface)Main.this.interfaces.elementAt(i)).resetGC();
                        }
                    }
                    try {
                        Object i2 = Main.this.gcLock;
                        synchronized (i2) {
                            if (Main.this.interfaces.size() <= 0) {
                                return;
                            }
                            Main.this.gcLock.wait(30000L);
                        }
                    }
                    catch (Exception exception) {
                    }
                }
            }
        };
        Thread t = new Thread(r);
        t.setDaemon(true);
        t.start();
        Runtime.getRuntime().addShutdownHook(new Thread(){

            public void run() {
                Main.this.cleanUp();
            }
        });
    }

    public void shutdown() {
        System.exit(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cleanUp() {
        Object interfc;
        this.logError(25, "Shutting down server at " + new Date());
        while (this.interfaces.size() > 0) {
            interfc = (NetworkInterface)this.interfaces.elementAt(0);
            this.interfaces.removeElementAt(0);
            try {
                ((NetworkInterface)interfc).stopRunning();
            }
            catch (Throwable e) {
                this.logError(75, "unable to shut down interface " + interfc + "; reason: " + e);
            }
        }
        try {
            interfc = this.gcLock;
            synchronized (interfc) {
                this.gcLock.notifyAll();
            }
        }
        catch (Throwable e) {
            // empty catch block
        }
        try {
            this.interfaceThreadGroup.stop();
        }
        catch (Throwable t) {
            // empty catch block
        }
        try {
            this.server.shutdown();
        }
        catch (Exception e) {
            String msg = "Exception shutting down handle server :" + e;
            this.logError(75, msg);
            System.err.println(msg);
            e.printStackTrace(System.err);
        }
        if (logger != null) {
            try {
                logger.shutdown();
            }
            catch (Exception e) {
                System.err.println("Error shutting down logger: " + e);
            }
        }
    }

    public void logAccess(String accesssType, InetAddress addr, int opCode, int rsCode, String message, long time) {
        if (logger == null) {
            System.out.println("Access: type=" + accesssType + "; addr=" + addr.getHostAddress() + "; opCode: " + opCode + "; respCode: " + rsCode + "; message: " + message + "; " + time + "ms");
        } else {
            logger.logAccess(accesssType, addr, opCode, rsCode, message, time);
        }
    }

    public void logError(int level, String message) {
        if (logger == null) {
            System.err.println("Error: level=" + level + "; message: " + message);
        } else {
            logger.logError(level, message);
        }
    }
}

