/*
 * Decompiled with CFR 0.152.
 */
package net.handle.server;

import net.handle.hdllib.AbstractRequest;
import net.handle.hdllib.Interface;
import net.handle.hdllib.ServerInfo;
import net.handle.server.AbstractServer;
import net.handle.server.DnsUdpInterface;
import net.handle.server.HandleServer;
import net.handle.server.HdlHttpInterface;
import net.handle.server.HdlTcpInterface;
import net.handle.server.HdlUdpInterface;
import net.handle.server.Main;
import net.handle.server.RequestHandlerPool;
import net.handle.util.StreamTable;

public abstract class NetworkInterface
implements Runnable {
    private boolean keepRunning = true;
    protected AbstractServer server;
    protected boolean needsGC = false;
    boolean processAdminRequests = true;
    boolean processQueries = true;
    protected Main main;
    protected RequestHandlerPool handlerPool = null;
    public static final String INTFC_HDLTCP = "hdl_tcp";
    public static final String INTFC_HDLUDP = "hdl_udp";
    public static final String INTFC_HDLHTTP = "hdl_http";
    public static final String INTFC_DNS = "dns";

    public NetworkInterface(Main main) {
        this.main = main;
        this.server = main.getServer();
    }

    public static NetworkInterface getInstance(Main main, String frontEndLabel, StreamTable configTable) throws Exception {
        if (frontEndLabel.startsWith(INTFC_HDLUDP)) {
            return new HdlUdpInterface(main, (StreamTable)configTable.get(frontEndLabel + "_config"));
        }
        if (frontEndLabel.startsWith(INTFC_HDLTCP)) {
            return new HdlTcpInterface(main, (StreamTable)configTable.get(frontEndLabel + "_config"));
        }
        if (frontEndLabel.startsWith(INTFC_HDLHTTP)) {
            return new HdlHttpInterface(main, (StreamTable)configTable.get(frontEndLabel + "_config"));
        }
        if (frontEndLabel.startsWith(INTFC_DNS)) {
            return new DnsUdpInterface(main, (StreamTable)configTable.get(frontEndLabel + "_config"));
        }
        throw new Exception("Invalid interface type: \"" + frontEndLabel + "\"");
    }

    protected final void initialize() {
        if (this.server instanceof HandleServer) {
            ServerInfo svrInfo = ((HandleServer)this.server).getServerInfo();
            Interface[] ifcs = svrInfo.interfaces;
            int bindPort = this.getPort();
            byte protocol = this.getProtocol();
            for (int i = 0; ifcs != null && i < ifcs.length; ++i) {
                if (ifcs[i] == null || ifcs[i].port != bindPort || ifcs[i].protocol != protocol) continue;
                this.processAdminRequests = ifcs[i].type == 1 || ifcs[i].type == 3;
                this.processQueries = ifcs[i].type == 3 || ifcs[i].type == 2;
                break;
            }
        }
    }

    abstract byte getProtocol();

    abstract int getPort();

    final boolean needsGC() {
        return this.needsGC;
    }

    final void resetGC() {
        this.needsGC = false;
    }

    public String canProcessMsg(AbstractRequest req) {
        switch (req.opCode) {
            case 100: 
            case 101: 
            case 102: 
            case 103: 
            case 104: 
            case 105: 
            case 300: 
            case 301: 
            case 302: 
            case 1000: 
            case 1001: 
            case 1002: 
            case 1003: {
                return this.processAdminRequests ? null : "Received admin request on non-admin port ";
            }
            case 1: {
                return this.processQueries ? null : "Received query request on non-query port";
            }
            case 2: 
            case 200: 
            case 201: 
            case 400: 
            case 401: 
            case 402: {
                return null;
            }
        }
        System.err.println("Warning: cannot tell whether msg " + req + " is admin or not: unrecognized opcode!");
        return null;
    }

    public final void run() {
        while (this.keepRunning) {
            try {
                this.serveRequests();
            }
            catch (Throwable t) {
                if (!this.keepRunning) {
                    return;
                }
                this.main.logError(100, "Error establishing interface: " + t);
            }
            try {
                if (!this.keepRunning) continue;
                Thread.currentThread();
                Thread.sleep(300000L);
            }
            catch (Throwable t) {
                this.main.logError(100, "Error sleeping!: " + t);
            }
        }
    }

    public final void stopRunning() {
        this.keepRunning = false;
        this.stopService();
        RequestHandlerPool pool = this.handlerPool;
        if (pool != null) {
            pool.shutdown();
        }
    }

    protected abstract void stopService();

    public abstract void serveRequests();

    public void finalize() {
        this.stopRunning();
    }
}

