/*
 * Decompiled with CFR 0.152.
 */
package net.handle.server;

import java.io.DataInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.net.InetAddress;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.interfaces.DSAPrivateKey;
import java.security.interfaces.DSAPublicKey;
import net.handle.hdllib.AbstractResponse;
import net.handle.hdllib.Common;
import net.handle.hdllib.ConfigCommon;
import net.handle.hdllib.Encoder;
import net.handle.hdllib.GenericRequest;
import net.handle.hdllib.GetSiteInfoResponse;
import net.handle.hdllib.HandleResolver;
import net.handle.hdllib.SiteInfo;
import net.handle.hdllib.Util;
import net.handle.util.StreamTable;

public abstract class SimpleSetup {
    private static final String DEFAULT_YES = "y";
    private static final String DEFAULT_NO = "n";
    private static String DEFAULT_INTERVAL = "Never";
    private static String DEFAULT_WEEKDAY = "Sunday";
    private static final int NO_DEFAULT = -1;
    private static final int NO_LIMIT = -1;
    private static DataInputStream in = new DataInputStream(System.in);
    private static PrintStream out = System.out;
    private static PrintStream err = System.err;

    public static void main(String[] argv) {
        String prompt = null;
        try {
            int siteVersion;
            if (!Util.checkJavaVersion()) {
                return;
            }
            if (argv.length < 1) {
                err.println("ERROR:  You must specify a configuration directory.");
                return;
            }
            String configDirName = argv[0];
            File configDir = new File(configDirName);
            if (!configDir.exists()) {
                configDir.mkdirs();
            }
            out.println("\nTo configure your new Handle server, please answer\nthe questions which follow; default answers, shown in \n[square brackets] when available, can be chosen by \npressing Enter.\n");
            prompt = "\nWill this be a regular or caching Handle server?\n\n  1 - Regular Handle Server (recommended)\n  2 - Caching Handle Server\n\nPlease choose 1 or 2 and press Enter";
            int serverType = SimpleSetup.getInteger(prompt, 1, 1, 2) == 1 ? 0 : 1;
            boolean isPrimary = SimpleSetup.getBoolean("Will this be a \"primary\" server (ie, not a mirror of another server)?", DEFAULT_YES);
            InetAddress listenAddr = SimpleSetup.getIPAddress();
            int port = SimpleSetup.getInteger("Enter the (TCP/UDP) port number this server will listen to", 2641, 1, 32000);
            int httpPort = SimpleSetup.getInteger("What port number will the HTTP interface be listening to?", 8000, 1, 32000);
            boolean logAccesses = SimpleSetup.getBoolean("Would you like to log all accesses to this server?", DEFAULT_NO);
            String interval = DEFAULT_INTERVAL;
            if (logAccesses) {
                System.out.println("\n\nPlease indicate whether log files should be automatically\nrotated, and if so, how often.");
                interval = SimpleSetup.getInterval();
            }
            if (!interval.equals("Never") && interval.equals("Monthly")) {
                System.out.println("\nNOTE: Auto-saves and restarts will be done on the first of each month.");
            }
            File replPrivKeyFile = new File(configDir, "replpriv.bin");
            File replPubKeyFile = new File(configDir, "replpub.bin");
            File adminPrivKeyFile = new File(configDir, "admpriv.bin");
            File adminPubKeyFile = new File(configDir, "admpub.bin");
            File replicationSiteFile = new File(configDir, "txnsrcsv.bin");
            boolean generateReplKeys = true;
            boolean generateAdminKeys = isPrimary;
            String replicationAdminStr = "";
            String replicationAuthStr = null;
            SiteInfo replicationSite = null;
            if (serverType == 0) {
                if (isPrimary) {
                    replicationAdminStr = "300:0.NA/YOUR_NAMING_AUTHORITY";
                } else {
                    if (replPrivKeyFile.exists() && replPubKeyFile.exists()) {
                        generateReplKeys = SimpleSetup.getBoolean("Replication keys already exist, do you want to create new ones? ", DEFAULT_NO);
                    }
                    out.println("\nSince this is a secondary (\"mirror\") server, you need to\nspecify the primary site from which this server will get\nits handles.  You will be asked to specify the IP of a server\nfrom the primary site, and the port it listens to.  This\nprogram will then contact that server and request the site\ndata needed for downloading handles.");
                    boolean needReplicationInfo = true;
                    if (replicationSiteFile.exists()) {
                        out.println("\nWARNING: You have already configured a primary site from\nwhich this server is to get its handles. CHANGING THIS SETTING\nWILL REQUIRE THAT THIS SERVER RE-DOWNLOAD ALL OF THE HANDLES\nFROM THE PRIMARY SITE.");
                        needReplicationInfo = SimpleSetup.getBoolean("  Would you like to specify a different primary site?", DEFAULT_NO);
                    }
                    while (needReplicationInfo) {
                        InetAddress replSrcAddr;
                        String line = SimpleSetup.responseToPrompt("Enter the address of a primary server");
                        try {
                            if (line.length() <= 0) {
                                throw new Exception("Got empty input");
                            }
                            replSrcAddr = InetAddress.getByName(line);
                        }
                        catch (Exception e) {
                            out.println("Invalid address: \"" + line + "\"; Reason: " + e + ".  Try again.");
                            continue;
                        }
                        int replSrcPort = SimpleSetup.getInteger("Enter the port number of the same primary server (" + line + ")", 2641, 1, 32000);
                        try {
                            GenericRequest req = new GenericRequest(Common.BLANK_HANDLE, 2, null);
                            HandleResolver resolver = new HandleResolver();
                            AbstractResponse resp = resolver.sendHdlTcpRequest(req, replSrcAddr, replSrcPort, null);
                            if (resp.responseCode != 1) {
                                throw new Exception("Unexpected response from primary: " + resp);
                            }
                            replicationSite = ((GetSiteInfoResponse)resp).siteInfo;
                            break;
                        }
                        catch (Exception e) {
                            out.println("Error retrieving replication site info: " + e);
                        }
                    }
                    replicationAuthStr = "300:0.NA/YOUR_NAMING_AUTHORITY";
                }
            }
            out.println("\nEach handle site has a version/serial number assigned\nto it.  This is so that a client can tell if a particular\nsite's configuration has changed since the last time it\naccessed a server in the site.  Every time you modify a site\n(by changing an IP address, port, or adding a server, etc), \nyou should increment the version/serial number for that site.");
            while (((siteVersion = SimpleSetup.getInteger("Enter the version/serial number of this site", 1, 1, -1)) & 0xFFFF0000) != 0) {
                out.println("Invalid input: \"" + siteVersion + "\" (value out of 2-byte range).");
            }
            String siteDescription = SimpleSetup.responseToPrompt("Please enter a short description of this server/site");
            String orgName = "";
            while (orgName.length() == 0) {
                orgName = SimpleSetup.responseToPrompt("Please enter the name of your organization");
            }
            String contactName = SimpleSetup.responseToPrompt("Please enter the name of a contact person\nfor " + orgName + " (optional) [(none)]");
            String contactPhone = SimpleSetup.getContactPhone(contactName, orgName);
            String contactEmail = SimpleSetup.getContactEmail(contactName, orgName);
            out.println("\n\nThe Handle System can communicate via UDP and/or TCP sockets.\nSince UDP messages are blocked by many network firewalls, you may\nwant to disable UDP services if you are behind such a firewall.");
            boolean disableUDP = SimpleSetup.getBoolean("  Would you like to disable UDP services?", DEFAULT_NO);
            boolean generateKeys = true;
            File privKeyFile = new File(configDir, "privkey.bin");
            File pubKeyFile = new File(configDir, "pubkey.bin");
            if (privKeyFile.exists() && pubKeyFile.exists()) {
                generateKeys = SimpleSetup.getBoolean("Server keys already exist, do you want to create new ones? ", DEFAULT_NO);
            }
            if (generateKeys) {
                SimpleSetup.generateKeys(pubKeyFile, privKeyFile, "Server Certification");
            }
            if (serverType == 0) {
                if (!isPrimary && generateReplKeys) {
                    SimpleSetup.generateKeys(replPubKeyFile, replPrivKeyFile, "Replication Authentication");
                }
                if (generateAdminKeys && adminPubKeyFile.exists() && adminPrivKeyFile.exists()) {
                    generateAdminKeys = SimpleSetup.getBoolean("Administrator keys already exist, do you want to create new ones? ", DEFAULT_NO);
                }
                if (generateAdminKeys) {
                    SimpleSetup.generateKeys(adminPubKeyFile, adminPrivKeyFile, "Administration");
                }
            }
            out.println("Generating site info record...");
            SiteInfo siteInfo = new SiteInfo(siteVersion, isPrimary, false, 2, siteDescription, listenAddr, port, httpPort, pubKeyFile, disableUDP);
            FileOutputStream siteOut = new FileOutputStream(new File(configDir, "siteinfo.bin"));
            siteOut.write(Encoder.encodeSiteInfoRecord(siteInfo));
            siteOut.close();
            StreamTable contactData = ConfigCommon.contactDataTable(orgName, contactName, contactPhone, contactEmail);
            File contactDataFile = new File(configDir, "contactdata.dct");
            contactData.writeToFile(contactDataFile);
            if (replicationSite != null) {
                ConfigCommon.writeReplicationSiteFile(configDirName, "txnstat.dct", replicationSiteFile, replicationSite);
            }
            StreamTable config = ConfigCommon.configuration(serverType, disableUDP, port, logAccesses, listenAddr, 15, httpPort, interval, false, 60000, 86400000, 1, isPrimary, "300:0.NA/YOUR_NAMING_AUTHORITY", replicationAdminStr, replicationAuthStr);
            config.writeToFile(new File(configDir, "config.dct"));
            String finalMessage = null;
            if (serverType == 0) {
                ConfigCommon.createSiteBundle(configDirName, "sitebndl.zip", isPrimary, replicationAdminStr, adminPubKeyFile, replPubKeyFile, replicationAuthStr, siteInfo, contactDataFile);
                finalMessage = "\nYou have finished configuring your regular (" + (isPrimary ? "primary" : "mirror") + ") Handle service.\n" + "\nThis service now needs to be registered in the Global Handle Registry (GHR)." + "\n\nGo to http://hdl.handle.net/4263537/5014 to register to " + "\nbecome a resolution service provider and then upload " + "\nyour newly created sitebndl.zip file. Please read the " + "\ninstructions on this page carefully. When the handle " + "\nadministrator receives your file, a prefix will be " + "\ncreated and you will receive notification via email." + "\n\nPlease send all questions to hdladmin@cnri.reston.va.us." + "\nThank you for your interest in CNRI's Handle System.\n\n";
            } else {
                finalMessage = "You have Finished configuring your caching Handle server.\n\nYou can now start your server then test it by pointing\na web browser at http://" + listenAddr.getHostAddress() + ":" + httpPort + "/" + "\nand entering a handle.\n";
            }
            out.println("\n-------------------------------------------------------\n" + finalMessage);
        }
        catch (Exception e) {
            err.println("Error setting up the server:\n" + e);
            e.printStackTrace(err);
        }
    }

    private static final void generateKeys(File pubKeyFile, File privKeyFile, String purpose) throws Exception {
        KeyPairGenerator kpg = KeyPairGenerator.getInstance("DSA");
        out.println("\nGenerating keys for: " + purpose);
        kpg.initialize(1024);
        KeyPair keys = kpg.generateKeyPair();
        out.println("\nThe private key that is about to be generated should be stored\nin an encrypted form on your computer. Encryption of the\nprivate key requires that you choose a secret passphrase that\nwill need to be entered whenever the server is started.\nNote: Your private key may be stored unencrypted if you so choose.\nPlease take all precautions to make sure that only authorized\nusers can read your private key.");
        boolean encrypt = SimpleSetup.getBoolean("  Would you like to encrypt your private key?", DEFAULT_YES);
        byte[] secKey = null;
        if (encrypt) {
            byte[] secKey2;
            while (!Util.equals(secKey = Util.getPassphrase("\nPlease enter the private key passphrase for " + purpose + ": "), secKey2 = Util.getPassphrase("\nPlease re-enter the private key passphrase: "))) {
                err.println("\nPassphrases do not match!  Try again.\n");
            }
        }
        PrivateKey priv = keys.getPrivate();
        byte[] keyBytes = Util.getBytesFromPrivateKey((DSAPrivateKey)priv);
        byte[] encKeyBytes = null;
        if (encrypt) {
            int i;
            encKeyBytes = Util.encryptIfPossible(keyBytes, secKey);
            for (i = 0; i < keyBytes.length; ++i) {
                keyBytes[i] = 0;
            }
            for (i = 0; i < secKey.length; ++i) {
                secKey[i] = 0;
            }
        } else {
            encKeyBytes = Util.encrypt(keyBytes, secKey, 1);
        }
        FileOutputStream keyOut = new FileOutputStream(privKeyFile);
        keyOut.write(encKeyBytes);
        keyOut.close();
        PublicKey pub = keys.getPublic();
        keyOut = new FileOutputStream(pubKeyFile);
        keyOut.write(Util.getBytesFromPublicKey((DSAPublicKey)pub));
        keyOut.close();
    }

    private static InetAddress getIPAddress() throws Exception {
        String localAddress = "";
        String prompt = "Through what IP address will this server be accessible?";
        try {
            localAddress = InetAddress.getLocalHost().getHostAddress();
        }
        catch (Exception e) {
            localAddress = "";
        }
        if (localAddress.length() > 0) {
            prompt = prompt + " [" + localAddress + "]";
        }
        while (true) {
            String line;
            if ((line = SimpleSetup.responseToPrompt(prompt)).equals("") && localAddress.length() > 0) {
                line = localAddress;
            }
            try {
                InetAddress listenAddr = InetAddress.getByName(line);
                if (listenAddr.getHostAddress().startsWith("127.")) {
                    throw new Exception("you must enter an address that is accessible from the network");
                }
                return listenAddr;
            }
            catch (Exception e) {
                out.println("Invalid address (" + e + "), please try again.");
                continue;
            }
            break;
        }
    }

    private static String getContactPhone(String person, String org) throws Exception {
        String phoneNumber = null;
        String prompt = "Please enter the telephone number of ";
        if (person != null && !person.equals("")) {
            prompt = prompt + person + " or of ";
        }
        prompt = prompt + org + " (optional) [(none)]";
        while (phoneNumber == null) {
            phoneNumber = SimpleSetup.validatePhoneNumber(SimpleSetup.responseToPrompt(prompt));
        }
        return phoneNumber;
    }

    private static String validatePhoneNumber(String phoneNumber) {
        char c;
        int i;
        String problem = null;
        String newPhoneNumber = "";
        int openParenPosition = -1;
        int closeParenCount = 0;
        if ((phoneNumber = phoneNumber.trim()).equals("")) {
            return "";
        }
        for (i = 0; i < phoneNumber.length(); ++i) {
            c = phoneNumber.charAt(i);
            if (!ConfigCommon.validPhoneNumberChar(c)) {
                problem = "contains illegal character '" + c + "'";
            } else if (c == '-') {
                problem = i == 0 ? "begins with a dash" : (phoneNumber.charAt(i - 1) == '-' ? "contains consecutive hyphens" : null);
            } else if (c == '(') {
                if (openParenPosition > -1) {
                    problem = "contains more than one left parenthesis";
                } else {
                    openParenPosition = i;
                }
            } else if (c == ')') {
                String string = i == 0 ? "begins with a right parenthesis" : (openParenPosition == -1 ? "contains unmatched right parenthesis" : (openParenPosition == i - 1 ? "contains empty parentheses" : (problem = ++closeParenCount > 1 ? "contains more than one right parenthesis" : null)));
            }
            if (problem != null) break;
        }
        if (problem == null && openParenPosition > -1 && closeParenCount == 0) {
            problem = "containes unmatched left parenthesis";
        }
        if (problem != null) {
            out.println("\nTelephone number " + problem + ", please try again.\n");
            return null;
        }
        for (i = 0; i < phoneNumber.length(); ++i) {
            c = phoneNumber.charAt(i);
            if (c == '(' || c == ' ' && (newPhoneNumber.endsWith(" ") || newPhoneNumber.endsWith("-"))) continue;
            if (c == ')') {
                newPhoneNumber = newPhoneNumber + '-';
                continue;
            }
            if (c == '-' && newPhoneNumber.endsWith(" ")) {
                newPhoneNumber = newPhoneNumber.trim();
            }
            newPhoneNumber = newPhoneNumber + c;
        }
        if (!phoneNumber.equals(newPhoneNumber)) {
            out.println("\nF.Y.I.: Changing telephone number format to '" + newPhoneNumber + "'.\n");
            phoneNumber = newPhoneNumber;
        }
        return phoneNumber;
    }

    private static String getContactEmail(String person, String org) throws Exception {
        String emailAddress = null;
        String prompt = "Please enter the email address of ";
        if (person != null && !person.equals("")) {
            prompt = prompt + person + " or of ";
        }
        prompt = prompt + org;
        while (SimpleSetup.badEmailAddress(emailAddress = SimpleSetup.responseToPrompt(prompt))) {
        }
        return emailAddress;
    }

    private static boolean badEmailAddress(String emailAddress) {
        if ((emailAddress = emailAddress.trim()).length() == 0) {
            return true;
        }
        String message = null;
        String problem = null;
        int atCount = 0;
        int dotCount = 0;
        int atIndex = -1;
        for (int i = 0; i < emailAddress.length(); ++i) {
            if (emailAddress.charAt(i) == '@') {
                if (atCount != 0) {
                    problem = "too many '@' characters";
                    break;
                }
                ++atCount;
                atIndex = i;
                continue;
            }
            if (atCount <= 0 || emailAddress.charAt(i) != '.') continue;
            if (atIndex == i - 1) {
                problem = "'.' immediately after '@'";
                break;
            }
            ++dotCount;
        }
        if (problem == null) {
            String string = atCount == 0 ? "no '@' character" : (problem = dotCount == 0 ? "no '.' character in segment after '@' character" : null);
        }
        if (problem == null) {
            return false;
        }
        message = "Invalid email address (" + problem + "), please try again.";
        out.println(message);
        return true;
    }

    private static final int getInteger(String prompt, int defaultAnswer, int minimum, int maximum) throws Exception {
        if (prompt == null || prompt.length() < 1 || defaultAnswer != -1 && defaultAnswer < 0 || minimum != -1 && minimum < 0 || maximum != -1 && maximum < 0) {
            throw new Exception("PROGRAMMING ERROR: getInteger(" + prompt + ", " + minimum + ", " + maximum + ")");
        }
        String promptString = prompt.trim();
        if (defaultAnswer != -1) {
            promptString = promptString + " [" + defaultAnswer + "]";
        }
        String finalInstruction = "";
        if (minimum != -1) {
            finalInstruction = finalInstruction + " greater than " + (minimum - 1);
        }
        if (maximum != -1) {
            if (finalInstruction.length() > 0) {
                finalInstruction = finalInstruction + " and";
            }
            finalInstruction = finalInstruction + " less than " + (maximum + 1);
        }
        while (true) {
            String line;
            if ((line = SimpleSetup.responseToPrompt(promptString)).length() == 0) {
                if (defaultAnswer != -1) {
                    return defaultAnswer;
                }
            } else {
                try {
                    int number = Integer.parseInt(line);
                    if (!(number < 0 || minimum != -1 && number < minimum || maximum != -1 && number > maximum)) {
                        return number;
                    }
                    throw new Exception(number + " is unacceptable.");
                }
                catch (Exception e) {
                    out.println("ERROR: " + e);
                }
            }
            out.println("\nPlease enter a positive number" + finalInstruction + ".");
        }
    }

    private static final boolean getBoolean(String prompt, String defaultAnswer) throws Exception {
        if (prompt == null || prompt.length() < 1 || defaultAnswer == null || !defaultAnswer.equals(DEFAULT_NO) && !defaultAnswer.equals(DEFAULT_YES)) {
            throw new Exception("PROGRAMMING ERROR: getBoolean(" + prompt + ", " + defaultAnswer + ")");
        }
        String line;
        while ((line = SimpleSetup.responseToPrompt(prompt + "(y/n) [" + defaultAnswer + "]").toUpperCase()).length() != 0) {
            if (line.equals("N") || line.equals("NO")) {
                return false;
            }
            if (line.equals("Y") || line.equals("YES")) {
                return true;
            }
            out.println("\nUnrecognized response, try again.");
        }
        return defaultAnswer.equals(DEFAULT_YES);
    }

    private static final String getHHMMSS(String prompt, String defaultAnswer) throws Exception {
        String promptExtension;
        if (prompt == null || prompt.length() < 1 || defaultAnswer != null && ConfigCommon.badHHMMSS(defaultAnswer)) {
            throw new Exception("PROGRAMMING ERROR: getHHMMSS(" + prompt + ", " + defaultAnswer + ")");
        }
        String string = promptExtension = defaultAnswer == null ? "" : " [" + defaultAnswer + "]";
        while (true) {
            String line;
            if ((line = SimpleSetup.responseToPrompt(prompt + promptExtension)).length() == 0) {
                if (defaultAnswer != null) {
                    return defaultAnswer;
                }
            } else if (!ConfigCommon.badHHMMSS(line)) {
                return line;
            }
            out.println("\nUnrecognized response, try again.");
        }
    }

    private static final String responseToPrompt(String prompt) throws IOException {
        out.print("\n" + prompt + ": ");
        out.flush();
        return in.readLine().trim();
    }

    private static final String getAbsolutePath(String prompt, String defaultAnswer) throws Exception {
        String promptExtension;
        if (prompt == null || prompt.length() < 1) {
            throw new Exception("PROGRAMMING ERROR: getAbsolutePath(" + prompt + ", " + defaultAnswer + ")");
        }
        String string = promptExtension = defaultAnswer == null ? "" : "\n [" + defaultAnswer + "]";
        while (true) {
            String line;
            if ((line = SimpleSetup.responseToPrompt(prompt + promptExtension)).length() == 0) {
                if (defaultAnswer != null) {
                    return defaultAnswer;
                }
            } else {
                return line;
            }
            out.println("\nUnacceptable response: please enter Absolute Pathname (begins with \"/\").");
        }
    }

    private static final String getInterval() throws Exception {
        String prompt = "(\"N\" (Never), \"M\" (Monthly), \"W\" (Weekly), or \"D\" (Daily))? [" + DEFAULT_INTERVAL + "] ";
        String line;
        while ((line = SimpleSetup.responseToPrompt(prompt)).length() != 0) {
            if (line.toUpperCase().equals("N") || line.toUpperCase().equals("Never")) {
                return "Never";
            }
            if (line.toUpperCase().equals("M") || line.toUpperCase().equals("Monthly")) {
                return "Monthly";
            }
            if (line.toUpperCase().equals("W") || line.toUpperCase().equals("Weekly")) {
                return "Weekly";
            }
            if (line.toUpperCase().equals("D") || line.toUpperCase().equals("Daily")) {
                return "Daily";
            }
            out.println("\nUnrecognized response.\n");
        }
        return DEFAULT_INTERVAL;
    }

    private static final String getWeekday() throws Exception {
        String prompt = "Please select a weekday for auto-saves and restarts\n(\"Sun\", \"Mon\", \"Tue\", \"Wed\", \"Thu\", \"Fri\", or \"Sat\") [" + DEFAULT_WEEKDAY.substring(0, 3) + "]";
        String[] weekDay = new String[]{"Sunday", "Monday", "Tuesday", "Wednesday", "Thursday", "Friday", "Saturday"};
        String line;
        while ((line = SimpleSetup.responseToPrompt(prompt)).length() != 0) {
            line = line.toUpperCase();
            for (int i = 0; i < weekDay.length; ++i) {
                if (!line.equals(weekDay[i].toUpperCase().substring(0, 3)) && !line.equals(weekDay[i].toUpperCase())) continue;
                return weekDay[i];
            }
            out.println("\nUnrecognized response.\n");
        }
        return DEFAULT_WEEKDAY;
    }
}

