/*
 * Decompiled with CFR 0.152.
 */
package net.handle.server.bdbje;

import com.sleepycat.je.Cursor;
import com.sleepycat.je.Database;
import com.sleepycat.je.DatabaseConfig;
import com.sleepycat.je.DatabaseEntry;
import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.Environment;
import com.sleepycat.je.EnvironmentConfig;
import com.sleepycat.je.OperationStatus;
import com.sleepycat.je.Transaction;
import com.sleepycat.je.util.DbDump;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Enumeration;
import java.util.NoSuchElementException;
import java.util.Random;
import net.handle.hdllib.Encoder;
import net.handle.hdllib.HandleException;
import net.handle.hdllib.HandleStorage;
import net.handle.hdllib.HandleValue;
import net.handle.hdllib.ScanCallback;
import net.handle.hdllib.Util;
import net.handle.server.DBTransactionLog;
import net.handle.util.StreamTable;

public final class BDBJEHandleStorage
implements HandleStorage {
    private static final byte[] DB_STATUS_HANDLE = Util.encodeString("0.SITE/DB_STATUS");
    private static final byte[] BDBJE_STATUS_HDL_TYPE = Util.encodeString("BDBJE_STATUS");
    private Object CREATE_LOCK = new Object();
    private boolean dumpOnCheckpoint = true;
    private boolean enableStatusHandle = true;
    private boolean logTxns = false;
    private File mainServerDir;
    private File serverDir;
    private Environment environment = null;
    private DBTransactionLog txnLog;
    private static final String HANDLE_DB_NAME = "handles";
    private static final String NA_DB_NAME = "nas";
    private DBWrapper db = null;
    private DBWrapper naDB = null;
    private boolean readOnly = false;
    private static final byte[] BLANK_BYTES = new byte[0];
    private Random testR = new Random();
    private String testPrefix = "";
    private long testStopTime = 0L;
    private Thread testReader = null;
    private Thread testWriter = null;
    private Thread testScanner = null;
    private Thread testDeleter = null;
    private HandleValue[] testValues = new HandleValue[]{new HandleValue(1, Util.encodeString("URL"), Util.encodeString("http://seanreilly.com")), new HandleValue(2, Util.encodeString("EMAIL"), Util.encodeString("sreilly@seanreilly.com")), new HandleValue(3, Util.encodeString("DESC"), Util.encodeString("Test handle"))};

    public void init(StreamTable config) throws Exception {
        this.mainServerDir = new File(config.getStr("serverDir", null));
        this.serverDir = new File(config.getStr("db_directory", config.getStr("serverDir", null)));
        if (!this.serverDir.exists()) {
            this.serverDir.mkdirs();
        }
        this.logTxns = config.getBoolean("enable_recovery_log", false);
        if (this.logTxns) {
            this.txnLog = new DBTransactionLog(new File(this.serverDir, "dbtxns.log"));
        }
        this.dumpOnCheckpoint = config.getBoolean("bdbje_dump_on_checkpoint", this.dumpOnCheckpoint);
        this.enableStatusHandle = config.getBoolean("bdbje_enable_status_handle", this.enableStatusHandle);
        System.err.println("Opening Berkeley database in " + this.serverDir.getAbsolutePath());
        EnvironmentConfig envConfig = new EnvironmentConfig();
        envConfig.setTransactional(true);
        envConfig.setAllowCreate(true);
        envConfig.setLockTimeout((long)config.getInt("bdbje_timeout", 0));
        envConfig.setTxnWriteNoSync(config.getBoolean("bdbje_no_sync_on_write", false));
        this.environment = new Environment(this.serverDir, envConfig);
        this.db = new DBWrapper(HANDLE_DB_NAME);
        this.naDB = new DBWrapper(NA_DB_NAME);
    }

    public final boolean haveNA(byte[] authHandle) throws HandleException {
        try {
            return this.naDB.get(Util.upperCaseInPlace(authHandle)) != null;
        }
        catch (Exception e) {
            HandleException he = new HandleException(1, "Error retrieving NA data");
            he.initCause(e);
            throw he;
        }
    }

    public final void setHaveNA(byte[] authHandle, boolean flag) throws HandleException {
        if (this.readOnly) {
            throw new HandleException(18);
        }
        try {
            byte[] handle = Util.upperCaseInPlace(authHandle);
            if (flag) {
                if (this.logTxns) {
                    this.txnLog.log((byte)2, handle, BLANK_BYTES);
                }
                this.naDB.put(handle, BLANK_BYTES);
            } else {
                if (this.logTxns) {
                    this.txnLog.log((byte)3, handle, BLANK_BYTES);
                }
                this.naDB.del(handle);
            }
        }
        catch (Exception e) {
            HandleException he = new HandleException(1, "Error recording NA data");
            he.initCause(e);
            throw he;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void createHandle(byte[] inHandle, HandleValue[] values) throws HandleException {
        if (this.readOnly) {
            throw new HandleException(18);
        }
        int totalSize = 4;
        for (int i = 0; i < values.length; ++i) {
            totalSize += Encoder.calcStorageSize(values[i]) + 4;
        }
        byte[] data = new byte[totalSize];
        int offst = 0;
        offst += Encoder.writeInt(data, offst, values.length);
        for (int i = 0; i < values.length; ++i) {
            int clumpLen = Encoder.encodeHandleValue(data, offst + 4, values[i]);
            offst += Encoder.writeInt(data, offst, clumpLen);
            offst += clumpLen;
        }
        Object object = this.CREATE_LOCK;
        synchronized (object) {
            byte[] handle = inHandle;
            byte[] existingHandle = null;
            try {
                existingHandle = this.db.get(handle);
            }
            catch (Exception e) {
                HandleException he = new HandleException(1, "Error checking for existing handle");
                he.initCause(e);
                throw he;
            }
            if (existingHandle != null) {
                throw new HandleException(5, "Handle already exists");
            }
            try {
                if (this.logTxns) {
                    this.txnLog.log((byte)0, handle, data);
                }
                this.db.put(handle, data);
            }
            catch (HandleException e1) {
                throw e1;
            }
            catch (Exception e) {
                HandleException he = new HandleException(1, "Error creating handle");
                he.initCause(e);
                throw he;
            }
        }
    }

    public final boolean deleteHandle(byte[] handle) throws HandleException {
        if (this.readOnly) {
            throw new HandleException(18);
        }
        try {
            if (this.logTxns) {
                this.txnLog.log((byte)1, handle, BLANK_BYTES);
            }
            return this.db.del(handle);
        }
        catch (HandleException e1) {
            throw e1;
        }
        catch (Exception e) {
            HandleException he = new HandleException(1, "Error deleting handle");
            he.initCause(e);
            throw he;
        }
    }

    public final byte[][] getRawHandleValues(byte[] handle, int[] indexList, byte[][] typeList) throws HandleException {
        int clumpIndex;
        byte[] clumpType;
        int clumpLen;
        byte[] value = null;
        try {
            value = this.db.get(handle);
        }
        catch (Exception e) {
            HandleException he = new HandleException(1, "Error retrieving handle");
            he.initCause(e);
            throw he;
        }
        if (value == null) {
            if (this.enableStatusHandle && Util.equals(handle, DB_STATUS_HANDLE)) {
                ArrayList<HandleValue> vals = new ArrayList<HandleValue>();
                try {
                    StringBuffer status = new StringBuffer();
                    status.append(this.environment.getStats(null).toString());
                    vals.add(new HandleValue(1, BDBJE_STATUS_HDL_TYPE, Util.encodeString(status.toString())));
                }
                catch (Exception e) {
                    vals.add(new HandleValue(2, BDBJE_STATUS_HDL_TYPE, Util.encodeString("Error getting status: " + e)));
                }
                byte[][] valBytes = new byte[vals.size()][];
                for (int i = 0; i < valBytes.length; ++i) {
                    HandleValue val = (HandleValue)vals.get(i);
                    valBytes[i] = new byte[Encoder.calcStorageSize(val)];
                    Encoder.encodeHandleValue(valBytes[i], 0, val);
                }
                return valBytes;
            }
            return null;
        }
        int bufPos = 0;
        boolean allValues = !(indexList != null && indexList.length != 0 || typeList != null && typeList.length != 0);
        int numValues = Encoder.readInt(value, bufPos);
        int origBufPos = bufPos += 4;
        int matches = 0;
        if (allValues) {
            matches = numValues;
        } else {
            for (int i = 0; i < numValues; ++i) {
                clumpLen = Encoder.readInt(value, bufPos);
                clumpType = Encoder.getHandleValueType(value, bufPos += 4);
                clumpIndex = Encoder.getHandleValueIndex(value, bufPos);
                if (Util.isParentTypeInArray(typeList, clumpType) || Util.isInArray(indexList, clumpIndex)) {
                    ++matches;
                }
                bufPos += clumpLen;
            }
        }
        byte[][] clumps = new byte[matches][];
        int clumpNum = 0;
        bufPos = origBufPos;
        for (int i = 0; i < numValues; ++i) {
            clumpLen = Encoder.readInt(value, bufPos);
            clumpType = Encoder.getHandleValueType(value, bufPos += 4);
            clumpIndex = Encoder.getHandleValueIndex(value, bufPos);
            if (allValues || Util.isParentTypeInArray(typeList, clumpType) || Util.isInArray(indexList, clumpIndex)) {
                clumps[clumpNum] = new byte[clumpLen];
                System.arraycopy(value, bufPos, clumps[clumpNum], 0, clumpLen);
                ++clumpNum;
            }
            bufPos += clumpLen;
        }
        return clumps;
    }

    public final void updateValue(byte[] handle, HandleValue[] values) throws HandleException {
        if (this.readOnly) {
            throw new HandleException(18);
        }
        byte[] existingHandle = null;
        try {
            existingHandle = this.db.get(handle);
        }
        catch (Exception e) {
            HandleException he = new HandleException(1, "Error checking for existing handle");
            he.initCause(e);
            throw he;
        }
        if (existingHandle == null) {
            throw new HandleException(9, "Cannot modify non-existent handle");
        }
        int totalSize = 4;
        for (int i = 0; i < values.length; ++i) {
            totalSize += Encoder.calcStorageSize(values[i]) + 4;
        }
        byte[] data = new byte[totalSize];
        int offst = 0;
        offst += Encoder.writeInt(data, offst, values.length);
        for (int i = 0; i < values.length; ++i) {
            int clumpLen = Encoder.encodeHandleValue(data, offst + 4, values[i]);
            offst += Encoder.writeInt(data, offst, clumpLen);
            offst += clumpLen;
        }
        try {
            if (this.logTxns) {
                this.txnLog.log((byte)0, handle, data);
            }
            this.db.put(handle, data);
        }
        catch (HandleException e1) {
            throw e1;
        }
        catch (Exception e) {
            HandleException he = new HandleException(1, "Error updating handle");
            he.initCause(e);
            throw he;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void scanHandles(ScanCallback callback) throws HandleException {
        DBWrapper.DBIterator e = this.db.getEnumerator();
        try {
            while (e.hasMoreElements()) {
                byte[][] record = (byte[][])e.nextElement();
                callback.scanHandle(record[0]);
            }
        }
        finally {
            e.cleanup();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void scanNAs(ScanCallback callback) throws HandleException {
        DBWrapper.DBIterator e = this.naDB.getEnumerator();
        try {
            while (e.hasMoreElements()) {
                byte[][] record = (byte[][])e.nextElement();
                callback.scanHandle(record[0]);
            }
        }
        finally {
            e.cleanup();
        }
    }

    public final Enumeration getHandlesForNA(byte[] naHdl) throws HandleException {
        byte[] prefixOnly = Util.getIDPart(naHdl);
        byte[] filter = new byte[prefixOnly.length + 1];
        System.arraycopy(prefixOnly, 0, filter, 0, prefixOnly.length);
        filter[filter.length - 1] = 47;
        return new HandleEnumeration(this.db.getEnumerator(filter));
    }

    public final void deleteAllRecords() throws HandleException {
        if (this.readOnly) {
            throw new HandleException(18);
        }
        try {
            if (this.logTxns) {
                this.txnLog.log((byte)4, BLANK_BYTES, BLANK_BYTES);
            }
            this.db.deleteAllRecords();
            this.naDB.deleteAllRecords();
        }
        catch (HandleException e1) {
            throw e1;
        }
        catch (Exception e) {
            HandleException he = new HandleException(1, "Error deleting all records");
            he.initCause(e);
            throw he;
        }
    }

    public final synchronized void checkpointDatabase() throws HandleException {
        try {
            this.environment.checkpoint(null);
        }
        catch (Exception e) {
            HandleException he = new HandleException(1, "Error performing checkpoint");
            he.initCause(e);
            throw he;
        }
        if (this.dumpOnCheckpoint) {
            Calendar cal = Calendar.getInstance();
            int backupDate = cal.get(1) * 10000 + (cal.get(2) + 1) * 100 + cal.get(5);
            int backupTime = cal.get(11) * 100 + cal.get(12);
            String backupSuffix = "-" + backupDate + ":" + backupTime + ".dump";
            try {
                FileOutputStream fout = new FileOutputStream(new File(this.mainServerDir, HANDLE_DB_NAME + backupSuffix));
                PrintStream out = new PrintStream(new BufferedOutputStream(fout, 1000000));
                new DbDump(this.environment, HANDLE_DB_NAME, out, false).dump();
                out.close();
                fout = new FileOutputStream(new File(this.mainServerDir, NA_DB_NAME + backupSuffix));
                out = new PrintStream(new BufferedOutputStream(fout, 1000000));
                new DbDump(this.environment, NA_DB_NAME, out, false).dump();
                out.close();
            }
            catch (Throwable t) {
                System.err.println("Error dumping database: " + t);
                t.printStackTrace(System.err);
                HandleException he = new HandleException(1, "Error performing backup");
                he.initCause(t);
                throw he;
            }
        }
    }

    public final void shutdown() {
        try {
            this.db.close();
        }
        catch (Throwable e) {
            // empty catch block
        }
        try {
            this.naDB.close();
        }
        catch (Throwable e) {
            // empty catch block
        }
        try {
            if (this.logTxns) {
                this.txnLog.shutdown();
            }
        }
        catch (Throwable e) {
            // empty catch block
        }
        try {
            this.environment.close();
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    public void finalize() {
        this.shutdown();
    }

    private final String getRandomTestHandle() {
        return this.testPrefix + this.testR.nextInt() % 1000;
    }

    void runTests(String prefix) {
        this.testPrefix = prefix.indexOf(47) < 0 ? prefix + "/test-" : prefix;
        this.testStopTime = System.currentTimeMillis() + 120000L;
        Runnable reader = new Runnable(){

            public void run() {
                long numReads = 0L;
                while (System.currentTimeMillis() < BDBJEHandleStorage.this.testStopTime) {
                    String hdl = BDBJEHandleStorage.this.getRandomTestHandle();
                    try {
                        byte[][] vals = BDBJEHandleStorage.this.getRawHandleValues(Util.encodeString(hdl), null, null);
                        ++numReads;
                    }
                    catch (Throwable t) {
                        System.err.println("Error reading <hdl:" + hdl + ">: " + t);
                        t.printStackTrace(System.err);
                    }
                }
                System.out.println("Read " + numReads + " handles");
            }
        };
        Runnable writer = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                long numWrites = 0L;
                while (System.currentTimeMillis() < BDBJEHandleStorage.this.testStopTime) {
                    String hdl = BDBJEHandleStorage.this.getRandomTestHandle();
                    try {
                        byte[] hdlb = Util.encodeString(hdl);
                        Object object = BDBJEHandleStorage.this.CREATE_LOCK;
                        synchronized (object) {
                            if (BDBJEHandleStorage.this.getRawHandleValues(hdlb, null, null) == null) {
                                BDBJEHandleStorage.this.createHandle(hdlb, BDBJEHandleStorage.this.testValues);
                            } else {
                                BDBJEHandleStorage.this.updateValue(hdlb, BDBJEHandleStorage.this.testValues);
                            }
                            ++numWrites;
                        }
                    }
                    catch (Throwable t) {
                        System.err.println("Error writing <hdl:" + hdl + ">: " + t);
                        t.printStackTrace(System.err);
                    }
                }
                System.out.println("Wrote " + numWrites + " handles");
            }
        };
        Runnable scanner = new Runnable(){

            public void run() {
                long numGets = 0L;
                long numScans = 0L;
                String prefix = BDBJEHandleStorage.this.testPrefix;
                prefix = prefix.indexOf(47) >= 0 ? "0.NA/" + prefix.substring(0, prefix.indexOf(47)) : "0.NA/" + prefix;
                byte[] prefixb = Util.encodeString(prefix.toUpperCase());
                while (System.currentTimeMillis() < BDBJEHandleStorage.this.testStopTime) {
                    try {
                        Enumeration en = BDBJEHandleStorage.this.getHandlesForNA(prefixb);
                        while (en.hasMoreElements()) {
                            byte[] val = (byte[])en.nextElement();
                            ++numGets;
                        }
                        ++numScans;
                    }
                    catch (Throwable t) {
                        System.err.println("Error scanning prefix " + prefix + ": " + t);
                        t.printStackTrace(System.err);
                    }
                }
                System.out.println("Iterated over " + numGets + " handles");
                System.out.println("Completed " + numScans + " scans on prefix " + prefix);
            }
        };
        Runnable deleter = new Runnable(){

            public void run() {
                long numDeletes = 0L;
                while (System.currentTimeMillis() < BDBJEHandleStorage.this.testStopTime) {
                    String hdl = BDBJEHandleStorage.this.getRandomTestHandle();
                    try {
                        byte[] hdlb = Util.encodeString(hdl);
                        if (BDBJEHandleStorage.this.getRawHandleValues(hdlb, null, null) != null) {
                            BDBJEHandleStorage.this.deleteHandle(hdlb);
                        }
                        ++numDeletes;
                    }
                    catch (Throwable t) {
                        System.err.println("Error deleting <hdl:" + hdl + ">: " + t);
                        t.printStackTrace(System.err);
                    }
                }
                System.out.println("Deleted " + numDeletes + " handles");
            }
        };
        this.testReader = new Thread(reader);
        this.testWriter = new Thread(writer);
        this.testScanner = new Thread(scanner);
        this.testDeleter = new Thread(deleter);
        this.testReader.start();
        this.testWriter.start();
        this.testScanner.start();
        this.testDeleter.start();
        try {
            this.testReader.join();
            this.testWriter.join();
            this.testScanner.join();
            this.testDeleter.join();
        }
        catch (Exception e) {
            System.err.println("Error re-joining threads: " + e);
            e.printStackTrace(System.err);
        }
    }

    public static final void main(String[] argv) throws Exception {
        String usage = "usage: java net.handle.server.bdbje.BDBJEHandleStorage <dbdir> (list <prefix> | get <handle> | test <hdlprefix>)";
        if (argv.length < 2 || argv.length > 3) {
            System.err.println(usage);
            System.exit(1);
        }
        String dbdir = argv[0];
        String cmd = argv[1];
        String param = argv.length > 2 ? argv[2] : null;
        StreamTable config = new StreamTable();
        config.put("serverDir", dbdir);
        config.put("enable_recovery_log", false);
        config.put("bdbje_timeout", 0);
        BDBJEHandleStorage bdb = new BDBJEHandleStorage();
        bdb.init(config);
        if (cmd.equalsIgnoreCase("list")) {
            if (param == null) {
                System.err.println(usage);
                System.exit(1);
            }
            if (!(param = param.toUpperCase()).startsWith("0.NA/")) {
                param = "0.NA/" + param;
            }
            Enumeration en = bdb.getHandlesForNA(Util.encodeString(param));
            while (en.hasMoreElements()) {
                System.out.println(Util.decodeString((byte[])en.nextElement()));
            }
        } else if (cmd.equalsIgnoreCase("scan")) {
            bdb.scanHandles(new ScanCallback(){

                public void scanHandle(byte[] handle) throws HandleException {
                    System.out.println(Util.decodeString(handle));
                }
            });
        } else if (cmd.equalsIgnoreCase("get")) {
            if (param == null) {
                System.err.println(usage);
                System.exit(1);
            }
            byte[][] rawvals = bdb.getRawHandleValues(Util.encodeString(param), null, null);
            System.out.println(param + ": (" + rawvals.length + ") values");
            for (int i = 0; rawvals != null && i < rawvals.length; ++i) {
                HandleValue val = new HandleValue();
                Encoder.decodeHandleValue(rawvals[i], 0, val);
                System.out.println(val.toString());
            }
        } else if (cmd.equalsIgnoreCase("test")) {
            if (param == null) {
                System.err.println(usage);
                System.exit(1);
            }
            bdb.runTests(param);
        } else {
            System.err.println("Unknown command: " + cmd);
            System.exit(1);
        }
        System.exit(0);
    }

    private class DBWrapper {
        private Database db;
        private String dbName;

        public DBWrapper(String dbName) throws Exception {
            this.dbName = dbName;
            this.openDB();
        }

        private void openDB() throws Exception {
            Transaction openTxn = BDBJEHandleStorage.this.environment.beginTransaction(null, null);
            DatabaseConfig dbConfig = new DatabaseConfig();
            dbConfig.setTransactional(true);
            dbConfig.setAllowCreate(true);
            dbConfig.setSortedDuplicates(false);
            this.db = BDBJEHandleStorage.this.environment.openDatabase(openTxn, this.dbName, dbConfig);
            openTxn.commit();
            this.db.preload(0L, 0L);
        }

        public byte[] get(byte[] key) throws IOException, DatabaseException {
            DatabaseEntry dbVal = new DatabaseEntry();
            if (this.db.get(null, new DatabaseEntry(key), dbVal, null) == OperationStatus.SUCCESS) {
                return dbVal.getData();
            }
            return null;
        }

        public void put(byte[] key, byte[] data) throws IOException, DatabaseException {
            OperationStatus status = this.db.put(null, new DatabaseEntry(key), new DatabaseEntry(data));
            if (status != OperationStatus.SUCCESS) {
                throw new DatabaseException("Unknown status returned from db.put: " + status);
            }
        }

        public void close() throws IOException, DatabaseException {
            this.db.close();
        }

        public boolean del(byte[] key) throws IOException, DatabaseException {
            return this.db.delete(null, new DatabaseEntry(key)) == OperationStatus.SUCCESS;
        }

        public DBIterator getEnumerator() {
            return new DBIterator();
        }

        public DBIterator getEnumerator(byte[] filter) {
            return new DBIterator(filter);
        }

        public void deleteAllRecords() throws Exception {
            Database tmpDB = this.db;
            Transaction killTxn = BDBJEHandleStorage.this.environment.beginTransaction(null, null);
            try {
                this.db = null;
                tmpDB.close();
                tmpDB = null;
                BDBJEHandleStorage.this.environment.truncateDatabase(killTxn, this.dbName, false);
                killTxn.commitSync();
            }
            catch (Exception t) {
                try {
                    killTxn.abort();
                }
                catch (Throwable t2) {
                    // empty catch block
                }
                throw t;
            }
            finally {
                if (this.db == null) {
                    this.openDB();
                }
            }
        }

        class DBIterator
        implements Enumeration {
            private Cursor cursor = null;
            private DatabaseEntry keyEntry = new DatabaseEntry();
            private DatabaseEntry valEntry = new DatabaseEntry();
            private OperationStatus lastStatus = null;
            byte[][] currentValue = null;
            byte[] prefix = null;

            public DBIterator() {
                try {
                    this.cursor = DBWrapper.this.db.openCursor(null, null);
                    this.lastStatus = this.cursor.getFirst(this.keyEntry, this.valEntry, null);
                    if (this.lastStatus != null && this.lastStatus == OperationStatus.SUCCESS) {
                        this.loadValueFromEntries();
                    } else {
                        this.cursor.close();
                    }
                }
                catch (Exception e) {
                    System.err.println("Error in DBIterator(): " + e);
                    try {
                        this.cursor.close();
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                    this.cursor = null;
                    this.lastStatus = null;
                }
            }

            public DBIterator(byte[] prefixFilter) {
                this.prefix = prefixFilter;
                try {
                    this.cursor = DBWrapper.this.db.openCursor(null, null);
                    this.keyEntry.setData(this.prefix);
                    this.lastStatus = this.cursor.getSearchKeyRange(this.keyEntry, this.valEntry, null);
                    if (this.lastStatus != null && this.lastStatus == OperationStatus.SUCCESS) {
                        if (Util.startsWithCI(this.keyEntry.getData(), this.prefix)) {
                            this.loadValueFromEntries();
                        } else {
                            this.cursor.close();
                            this.lastStatus = null;
                        }
                    } else {
                        this.cursor.close();
                    }
                }
                catch (Exception e) {
                    System.err.println("Error in DBIterator(): " + e);
                    try {
                        this.cursor.close();
                    }
                    catch (Throwable t) {
                        // empty catch block
                    }
                    this.cursor = null;
                    this.lastStatus = null;
                }
            }

            public synchronized boolean hasMoreElements() {
                return this.lastStatus == OperationStatus.SUCCESS;
            }

            private void loadValueFromEntries() throws Exception {
                byte[][] b = new byte[][]{new byte[this.keyEntry.getSize()], new byte[this.valEntry.getSize()]};
                System.arraycopy(this.keyEntry.getData(), 0, b[0], 0, b[0].length);
                System.arraycopy(this.valEntry.getData(), 0, b[1], 0, b[1].length);
                this.currentValue = b;
            }

            public synchronized Object nextElement() throws NoSuchElementException {
                if (this.cursor == null || this.lastStatus == null || this.lastStatus != OperationStatus.SUCCESS) {
                    throw new NoSuchElementException();
                }
                byte[][] returnVal = this.currentValue;
                try {
                    this.lastStatus = this.cursor.getNext(this.keyEntry, this.valEntry, null);
                    if (this.lastStatus == null || this.lastStatus != OperationStatus.SUCCESS) {
                        this.lastStatus = null;
                        this.cursor.close();
                    } else {
                        this.loadValueFromEntries();
                        if (this.prefix != null && !Util.startsWithCI(this.currentValue[0], this.prefix)) {
                            this.cursor.close();
                            this.lastStatus = null;
                        }
                    }
                }
                catch (Exception e) {
                    System.err.println("Error scanning handles: " + e);
                    e.printStackTrace(System.err);
                    try {
                        this.cursor.close();
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                    this.cursor = null;
                    this.lastStatus = null;
                }
                return returnVal;
            }

            public void finalize() {
                this.cleanup();
            }

            void cleanup() {
                try {
                    if (this.cursor != null) {
                        this.cursor.close();
                    }
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        }
    }

    private class HandleEnumeration
    implements Enumeration {
        private DBWrapper.DBIterator en;

        public HandleEnumeration(DBWrapper.DBIterator en) {
            this.en = en;
        }

        public boolean hasMoreElements() {
            return this.en.hasMoreElements();
        }

        public Object nextElement() {
            return ((byte[][])this.en.nextElement())[0];
        }
    }
}

