/*
 * Decompiled with CFR 0.152.
 */
package net.handle.util;

public class StringUtils {
    private static final char[] hexByteMap = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H'};

    public static final String fieldIndex(String str, char delimiter, int n) {
        int thisIndex;
        int delimLoc = str.indexOf(delimiter);
        int currentField = 0;
        int lastIndex = 0;
        int strLen = str.length();
        String val = "";
        do {
            if (currentField == n) {
                thisIndex = str.indexOf(delimiter, lastIndex);
                if (thisIndex >= 0) {
                    return str.substring(lastIndex, thisIndex);
                }
                return str.substring(lastIndex, strLen);
            }
            thisIndex = str.indexOf(delimiter, lastIndex);
            if (thisIndex < 0) {
                return "";
            }
            ++currentField;
        } while ((lastIndex = thisIndex + 1) < strLen);
        return "";
    }

    public static final String[] split(String str, char ch) {
        if (str == null) {
            return new String[0];
        }
        int numFields = 1;
        int strLen = str.length();
        for (int i = 0; i < strLen; ++i) {
            if (str.charAt(i) != ch) continue;
            ++numFields;
        }
        String[] result = new String[numFields];
        int strNum = 0;
        int idx = 0;
        for (int i = 0; i < strLen; ++i) {
            if (str.charAt(i) != ch) continue;
            result[strNum++] = str.substring(idx, i);
            idx = i + 1;
        }
        result[strNum] = str.substring(idx);
        return result;
    }

    public static final String backslash(String str, String escChars) {
        int len = str.length();
        StringBuffer sb = new StringBuffer(str.length());
        for (int currPos = 0; currPos < len; ++currPos) {
            char ch = str.charAt(currPos);
            if (ch == '\\' || escChars.indexOf(ch) >= 0) {
                sb.append('\\');
                sb.append(ch);
                continue;
            }
            sb.append(ch);
        }
        return sb.toString();
    }

    public static final String unbackslash(String str) {
        int len = str.length();
        int currPos = 0;
        char backslash = '\\';
        StringBuffer sb = new StringBuffer(str.length());
        while (currPos < len) {
            char ch;
            if ((ch = str.charAt(currPos++)) == backslash && currPos < len) {
                sb.append(str.charAt(currPos++));
                continue;
            }
            sb.append(ch);
        }
        return sb.toString();
    }

    public static final String decode(String str) {
        int len = str.length();
        StringBuffer sb = new StringBuffer(str.length());
        for (int currPos = 0; currPos < len; ++currPos) {
            char ch = str.charAt(currPos);
            if (ch == '\\') {
                if (++currPos >= len) {
                    sb.append(ch);
                    break;
                }
                ch = str.charAt(currPos);
                if (ch == 'n') {
                    sb.append('\n');
                    continue;
                }
                if (ch == 't') {
                    sb.append('\t');
                    continue;
                }
                if (ch == 'r') {
                    sb.append('\r');
                    continue;
                }
                sb.append(ch);
                continue;
            }
            sb.append(ch);
        }
        return sb.toString();
    }

    public static final String encode(String str) {
        StringBuffer sb = new StringBuffer("");
        block5: for (int i = 0; i < str.length(); ++i) {
            char ch = str.charAt(i);
            switch (ch) {
                case '\t': {
                    sb.append("\\t");
                    continue block5;
                }
                case '\n': {
                    sb.append("\\n");
                    continue block5;
                }
                case '\r': {
                    sb.append("\\r");
                    continue block5;
                }
                default: {
                    sb.append(ch);
                }
            }
        }
        return sb.toString();
    }

    public static String decodeURLIgnorePlus(String str) {
        byte[] utf8Buf = new byte[str.length()];
        int utf8Loc = 0;
        int strLoc = 0;
        int strLen = str.length();
        while (strLoc < strLen) {
            char ch;
            if ((ch = str.charAt(strLoc++)) == '%' && strLoc + 2 <= strLen) {
                utf8Buf[utf8Loc++] = StringUtils.decodeHexByte(str.charAt(strLoc++), str.charAt(strLoc++));
                continue;
            }
            utf8Buf[utf8Loc++] = (byte)ch;
        }
        try {
            return new String(utf8Buf, 0, utf8Loc, "UTF8");
        }
        catch (Exception e) {
            return new String(utf8Buf, 0, utf8Loc);
        }
    }

    public static String decodeURLIgnorePlus(char[] str, int start, int len) {
        byte[] utf8Buf = new byte[len];
        int utf8Loc = 0;
        int strLoc = start;
        int strLen = start + len;
        while (strLoc < strLen) {
            char ch;
            if ((ch = str[strLoc++]) == '%' && strLoc + 2 <= strLen) {
                utf8Buf[utf8Loc++] = StringUtils.decodeHexByte(str[strLoc++], str[strLoc++]);
                continue;
            }
            utf8Buf[utf8Loc++] = (byte)ch;
        }
        try {
            return new String(utf8Buf, 0, utf8Loc, "UTF8");
        }
        catch (Exception e) {
            return new String(utf8Buf, 0, utf8Loc);
        }
    }

    public static String decodeURL(String str) {
        byte[] utf8Buf = new byte[str.length()];
        int utf8Loc = 0;
        int strLoc = 0;
        int strLen = str.length();
        while (strLoc < strLen) {
            char ch;
            if ((ch = str.charAt(strLoc++)) == '%' && strLoc + 2 <= strLen) {
                utf8Buf[utf8Loc++] = StringUtils.decodeHexByte(str.charAt(strLoc++), str.charAt(strLoc++));
                continue;
            }
            if (ch == '+') {
                utf8Buf[utf8Loc++] = 32;
                continue;
            }
            utf8Buf[utf8Loc++] = (byte)ch;
        }
        try {
            return new String(utf8Buf, 0, utf8Loc, "UTF8");
        }
        catch (Exception e) {
            return new String(utf8Buf, 0, utf8Loc);
        }
    }

    public static final byte decodeHexByte(char ch1, char ch2) {
        ch1 = (char)(ch1 >= '0' && ch1 <= '9' ? ch1 - 48 : (ch1 >= 'a' && ch1 <= 'z' ? ch1 - 97 + 10 : ch1 - 65 + 10));
        ch2 = (char)(ch2 >= '0' && ch2 <= '9' ? ch2 - 48 : (ch2 >= 'a' && ch2 <= 'z' ? ch2 - 97 + 10 : ch2 - 65 + 10));
        return (byte)(ch1 << 4 | ch2);
    }

    public static String encodeHexChar(byte b) {
        StringBuffer sb = new StringBuffer();
        sb.append(hexByteMap[(b & 0xF0) >> 4]);
        sb.append(hexByteMap[b & 0xF]);
        return sb.toString();
    }

    public static final String padr(String str, int n, char padchar) {
        StringBuffer sb = new StringBuffer(str);
        while (sb.length() < n) {
            sb.append(padchar);
        }
        return sb.toString();
    }

    public static final String padl(String str, int n, char padchar) {
        StringBuffer sb = new StringBuffer(str);
        while (sb.length() < n) {
            sb.insert(0, padchar);
        }
        return sb.toString();
    }

    public static final void sortStringArray(String[] array) {
        StringUtils.quicksortAscending(array, 0, array.length - 1);
    }

    private static final void quicksortAscending(String[] array, int first, int last) {
        if (first < last) {
            int piv_index = StringUtils.partitionAscending(array, first, last);
            StringUtils.quicksortAscending(array, first, piv_index - 1);
            StringUtils.quicksortAscending(array, piv_index, last);
        }
    }

    private static final int partitionAscending(String[] array, int first, int last) {
        String pivot = array[(first + last) / 2];
        while (first <= last) {
            while (array[first].compareTo(pivot) < 0) {
                ++first;
            }
            while (array[last].compareTo(pivot) > 0) {
                --last;
            }
            if (first > last) continue;
            String temp = array[first];
            array[first] = array[last];
            array[last] = temp;
            ++first;
            --last;
        }
        return first;
    }
}

