/*
 * Decompiled with CFR 0.152.
 */
package net.handle.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringWriter;
import java.net.URLEncoder;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import net.handle.util.TemplateException;

public class Template {
    public static int getMatchingBraceLocation(String str) {
        Stack<String> stack = new Stack<String>();
        int leftIdx = -1;
        int rightIdx = -1;
        int totIdx = 0;
        String str2 = str;
        while (true) {
            leftIdx = str2.indexOf("{{");
            rightIdx = str2.indexOf("}}");
            if (rightIdx < 0) {
                return -1;
            }
            if (leftIdx >= 0 && leftIdx < rightIdx) {
                stack.push("{{");
                str2 = str2.substring(leftIdx + 2, str2.length());
                totIdx += leftIdx + 2;
                continue;
            }
            str2 = str2.substring(rightIdx + 2, str2.length());
            totIdx += rightIdx + 2;
            if (stack.empty()) {
                return totIdx - 2;
            }
            String match = (String)stack.pop();
        }
    }

    public static String subDictIntoFile(String filename, Hashtable dict) throws IOException, TemplateException {
        return Template.subDictIntoFile(new File(filename), dict);
    }

    public static String subDictIntoFile(File file, Hashtable dict) throws IOException, TemplateException {
        BufferedReader in = new BufferedReader(new FileReader(file));
        StringBuffer sb = new StringBuffer();
        char[] ch = new char[256];
        int n = 0;
        while ((n = in.read(ch, 0, ch.length)) >= 0) {
            sb.append(ch, 0, n);
        }
        try {
            in.close();
        }
        catch (Exception e) {
            // empty catch block
        }
        return Template.subDictIntoString(sb.toString(), dict);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String subDictIntoStream(InputStream in, Hashtable dict) throws IOException, TemplateException {
        try {
            int r;
            InputStreamReader rdr = new InputStreamReader(in, "UTF8");
            StringWriter sw = new StringWriter();
            char[] ch = new char[1024];
            while ((r = rdr.read(ch, 0, ch.length)) >= 0) {
                sw.write(ch, 0, r);
            }
            String string = Template.subDictIntoString(sw.toString(), dict);
            return string;
        }
        finally {
            if (in != null) {
                in.close();
            }
        }
    }

    public static String subDictIntoString(String str, Map dict) throws TemplateException {
        String nstr = "";
        String estr = "";
        boolean noMoreTags = false;
        while (true) {
            int begTag = 0;
            int endTag = 0;
            begTag = str.indexOf("{{");
            if (begTag < 0) break;
            endTag = Template.getMatchingBraceLocation(str.substring(begTag + 2, str.length()));
            if ((endTag += begTag + 2) < 0) {
                throw new TemplateException("Unmatched {{.");
            }
            nstr = str.substring(0, begTag);
            estr = str.substring(endTag + 2);
            String key = str.substring(begTag + 2, endTag);
            String extra = null;
            int doubleColonIdx = key.indexOf("::");
            int nextOpenBracketIdx = key.indexOf("{{");
            if (doubleColonIdx >= 0 && (nextOpenBracketIdx < 0 || nextOpenBracketIdx > doubleColonIdx)) {
                extra = key.substring(doubleColonIdx + 2);
                key = key.substring(0, doubleColonIdx);
            }
            Object obj = dict.get(key);
            if (extra == null) {
                extra = "";
            }
            if (extra.startsWith("?")) {
                nstr = nstr + Template.conditionalInclude(extra.substring(1), obj, false);
            } else if (extra.startsWith("!")) {
                nstr = nstr + Template.conditionalInclude(extra.substring(1), obj, true);
            } else if (obj != null) {
                if (extra.startsWith("*")) {
                    extra = extra.substring(1);
                    if (obj instanceof List) {
                        List list = (List)obj;
                        Iterator it = list.iterator();
                        while (it.hasNext()) {
                            Object subObj = it.next();
                            if (subObj instanceof Map) {
                                nstr = nstr + Template.subDictIntoString(extra, (Map)subObj);
                                continue;
                            }
                            nstr = nstr + String.valueOf(subObj);
                        }
                    } else {
                        nstr = obj instanceof Map ? nstr + Template.subDictIntoString(extra, (Map)obj) : nstr + Template.subDictIntoString(extra, dict);
                    }
                } else {
                    nstr = extra.equalsIgnoreCase("URLEncode") ? nstr + URLEncoder.encode(String.valueOf(obj)) : (extra.equalsIgnoreCase("CGIEscape") ? nstr + Template.cgiEscape(String.valueOf(obj)) : (extra.equalsIgnoreCase("SQLString") ? nstr + Template.sqlEscape(String.valueOf(obj)) : nstr + String.valueOf(obj)));
                }
            }
            str = nstr + estr;
        }
        return str;
    }

    private static String conditionalInclude(String tagContents, Object value, boolean notEqual) {
        if (tagContents == null || tagContents.length() <= 0) {
            return "";
        }
        int firstColon = tagContents.indexOf(58);
        if (firstColon < 0) {
            return "";
        }
        boolean matches = false;
        matches = notEqual ? value == null || !tagContents.substring(0, firstColon).equals(String.valueOf(value)) : value != null && tagContents.substring(0, firstColon).equals(String.valueOf(value));
        return matches ? tagContents.substring(firstColon + 1) : "";
    }

    public static String cgiEscape(String str) {
        StringBuffer sb = new StringBuffer("");
        for (int i = 0; i < str.length(); ++i) {
            char ch = str.charAt(i);
            if (ch == '<') {
                sb.append("&lt;");
                continue;
            }
            if (ch == '>') {
                sb.append("&gt;");
                continue;
            }
            if (ch == '\"') {
                sb.append("&quot;");
                continue;
            }
            sb.append(ch);
        }
        return sb.toString();
    }

    public static String sqlEscape(String str) {
        StringBuffer sb = new StringBuffer("");
        for (int i = 0; i < str.length(); ++i) {
            char ch = str.charAt(i);
            if (ch == '\'') {
                sb.append("''");
                continue;
            }
            if (ch == '\n') {
                sb.append("\\n");
                continue;
            }
            if (ch == '\r') {
                sb.append("\\r");
                continue;
            }
            sb.append(ch);
        }
        return sb.toString();
    }
}

