/*
 * Decompiled with CFR 0.152.
 */
package edu.sdsc.grid.gui;

import edu.sdsc.grid.gui.JargonTab;
import edu.sdsc.grid.gui.JargonTree;
import edu.sdsc.grid.gui.QueryPanel;
import edu.sdsc.grid.gui.QueryTab;
import edu.sdsc.grid.io.FileFactory;
import edu.sdsc.grid.io.GeneralFile;
import edu.sdsc.grid.io.GeneralFileSystem;
import edu.sdsc.grid.io.MetaDataSelect;
import edu.sdsc.grid.io.MetaDataSet;
import edu.sdsc.grid.io.local.LocalFile;
import edu.sdsc.grid.io.srb.SRBAccount;
import edu.sdsc.grid.io.srb.SRBException;
import edu.sdsc.grid.io.srb.SRBFileSystem;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import javax.swing.Box;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenuBar;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.UIManager;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;

class JargonGui
extends JFrame
implements ActionListener {
    private JTextField addresField;
    private GeneralFile selectedFile;
    private JTabbedPane tabPane;
    private JargonTab[] tabs;
    private JToolBar toolBar;
    static HashMap registerTabs = new HashMap();
    JComponent contentPane;
    JScrollPane mainPanel;
    JScrollPane sidePanel;
    private GridBagConstraints gridBagConstraints;
    private GeneralFileSystem[] fileSystems;
    JButton queryButton;
    JargonTree jargonTree;
    BrowseTab browseTab;
    QueryTab queryTab;
    String[] selectFieldNames = new String[]{"file comments", "size", "access constraint", "user name", "definable metadata for files"};
    MetaDataSelect[] selects = MetaDataSet.newSelection(this.selectFieldNames);
    static SRBAccount srbAccount;
    static /* synthetic */ Class class$edu$sdsc$grid$gui$JargonTree;
    static /* synthetic */ Class class$edu$sdsc$grid$gui$TransferStatusPanel;
    static /* synthetic */ Class class$edu$sdsc$grid$gui$QueryPanel;

    public JargonGui() throws IOException {
        this((GeneralFile)null);
    }

    public JargonGui(String string) throws IOException {
        this(new LocalFile(string));
    }

    public JargonGui(GeneralFile generalFile) throws IOException {
        if (generalFile == null) {
            this.useTabs((GeneralFile)null);
        } else {
            this.useTabs(generalFile);
        }
        this.init();
    }

    public JargonGui(JargonTab[] jargonTabArray) throws IOException {
        if (jargonTabArray == null) {
            this.useTabs((GeneralFile)null);
        } else {
            this.useTabs(jargonTabArray);
        }
        this.init();
    }

    protected void finalize() throws Throwable {
        if (this.addresField != null) {
            this.addresField = null;
        }
        if (this.selectedFile != null) {
            this.selectedFile = null;
        }
        if (this.tabPane != null) {
            this.tabPane = null;
        }
        if (this.tabs != null) {
            this.tabs = null;
        }
        if (this.toolBar != null) {
            this.toolBar = null;
        }
        if (registerTabs != null) {
            registerTabs = null;
        }
        super.finalize();
    }

    private void init() throws IOException {
        try {
            UIManager.setLookAndFeel("com.sun.java.swing.plaf.windows.WindowsLookAndFeel");
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.gridBagConstraints = new GridBagConstraints();
        this.contentPane = (JComponent)this.getContentPane();
        Box box = new Box(0);
        box.add(Box.createGlue());
        this.toolBar = new JToolBar();
        ImageIcon imageIcon = new ImageIcon("query.gif");
        this.queryButton = new JButton(imageIcon);
        this.queryButton.setActionCommand("Query");
        this.queryButton.setToolTipText("Query");
        this.queryButton.setBackground(Color.WHITE);
        this.queryButton.setMargin(new Insets(0, 0, 0, 0));
        this.queryButton.addActionListener(this);
        this.toolBar.add(this.queryButton);
        box.add((Component)this.toolBar, "West");
        this.gridBagConstraints.gridwidth = 0;
        JToolBar jToolBar = new JToolBar();
        this.addresField = new JTextField(70);
        this.addresField.addActionListener(new ActionListener(){

            /*
             * Unable to fully structure code
             */
            public void actionPerformed(ActionEvent var1_1) {
                block6: {
                    var2_2 = ((JTextField)var1_1.getSource()).getText();
                    var3_3 = null;
                    try {
                        var3_3 = new URI(var2_2);
                        JargonGui.access$002(JargonGui.this, FileFactory.newFile(var3_3));
                    }
                    catch (URISyntaxException var4_4) {
                        JOptionPane.showMessageDialog((Component)var1_1.getSource(), "Cannot find " + var2_2 + ". Check the spelling and try again, or try " + "searching for the item by clicking the Query button and then " + "clicking Search.", "Address Bar", 0);
                    }
                    catch (SecurityException var5_5) {
                        var6_6 = 0;
                        ** while (var6_6 < JargonGui.access$100((JargonGui)JargonGui.this).length)
                    }
lbl-1000:
                    // 1 sources

                    {
                        ++var6_6;
                        continue;
lbl16:
                        // 1 sources

                        break block6;
                    }
                    catch (SRBException var6_7) {
                        JOptionPane.showMessageDialog((Component)var1_1.getSource(), var6_7.getMessage() + "\n" + var6_7.getStandardMessage() + " " + var6_7.getType(), "Error", 0);
                    }
                    catch (IOException var7_8) {
                        JOptionPane.showMessageDialog((Component)var1_1.getSource(), var7_8.getMessage(), "Error", 0);
                    }
                }
            }
        });
        this.addresField.setPreferredSize(new Dimension(500, 20));
        jToolBar.add(new JLabel("Address "));
        jToolBar.add(this.addresField);
        box.add((Component)jToolBar, "East");
        this.contentPane.add((Component)box, "North");
        this.setSidePanel(this.browseTab);
        this.setMainPanel(this.queryTab);
        Box box2 = new Box(0);
        box2.add((Component)this.sidePanel, "West");
        box2.add((Component)this.mainPanel, "East");
        this.contentPane.add((Component)box2, "South");
    }

    private void useTabs(GeneralFile generalFile) throws IOException {
        try {
            GeneralFile[] generalFileArray = new GeneralFile[]{FileFactory.newFile(new URI("file:///")), FileFactory.newFile(new SRBFileSystem(srbAccount), "/"), FileFactory.newFile(new SRBFileSystem(srbAccount), srbAccount.getHomeDirectory())};
            this.fileSystems = new GeneralFileSystem[generalFileArray.length];
            this.fileSystems[0] = generalFileArray[0].getFileSystem();
            this.fileSystems[1] = generalFileArray[1].getFileSystem();
            this.fileSystems[2] = generalFileArray[2].getFileSystem();
            this.jargonTree = new JargonTree(generalFileArray);
            this.jargonTree.setEditable(false);
            this.jargonTree.useDefaultPopupMenu(true);
            this.browseTab = new BrowseTab(this.jargonTree);
            this.queryTab = new QueryTab(new QueryPanel(generalFileArray[0]));
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    private void useTabs(JargonTab[] jargonTabArray) throws IOException {
    }

    void updateAddressBar(GeneralFile generalFile) {
        this.selectedFile = generalFile;
        this.addresField.setText(this.selectedFile.toString());
    }

    GeneralFile getSelectedFile() {
        return this.selectedFile;
    }

    private void setJToolBar(JToolBar jToolBar) {
        if (jToolBar == null) {
            return;
        }
        this.contentPane.add((Component)jToolBar, this.gridBagConstraints);
    }

    public void setJMenuBar(JMenuBar jMenuBar) {
        if (jMenuBar == null) {
            return;
        }
        super.setJMenuBar(jMenuBar);
    }

    private void setSidePanel(JargonTab jargonTab) throws IOException {
        if (this.sidePanel == null) {
            this.sidePanel = new JScrollPane(jargonTab.getComponent());
            this.sidePanel.setPreferredSize(new Dimension(200, 490));
        } else {
            this.sidePanel.setViewportView(jargonTab.getComponent(null));
        }
    }

    private void setMainPanel(JargonTab jargonTab) throws IOException {
        if (this.mainPanel == null) {
            this.mainPanel = new JScrollPane(jargonTab.getComponent());
            this.mainPanel.setPreferredSize(new Dimension(680, 490));
        } else {
            GeneralFile[] generalFileArray = new GeneralFile[]{this.getSelectedFile()};
            this.mainPanel.setViewportView(jargonTab.getComponent(generalFileArray));
        }
        this.setJMenuBar(jargonTab.getJMenuBar());
    }

    public void actionPerformed(ActionEvent actionEvent) {
        block3: {
            if (!this.queryButton.getActionCommand().equals(actionEvent.getActionCommand())) break block3;
            try {
                if (this.selectedFile != null) {
                    ((QueryPanel)this.queryTab.getComponent()).setFileSystem(this.selectedFile.getFileSystem());
                }
                this.setMainPanel(this.queryTab);
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
    }

    public static void main(String[] stringArray) {
        JargonGui jargonGui = null;
        try {
            if (stringArray.length == 0) {
                jargonGui = new JargonGui();
            } else if (stringArray[0].equals("-uri")) {
                jargonGui = new JargonGui();
            } else if (stringArray.length == 7) {
                srbAccount = new SRBAccount(stringArray[0], Integer.parseInt(stringArray[1]), stringArray[2], stringArray[3], stringArray[4], stringArray[5], stringArray[6]);
                jargonGui = new JargonGui();
            } else if (stringArray.length == 8) {
                srbAccount = new SRBAccount(stringArray[0], Integer.parseInt(stringArray[1]), stringArray[2], stringArray[3], stringArray[4], stringArray[5], stringArray[6]);
                srbAccount.setCertificateAuthority(stringArray[7]);
                jargonGui = new JargonGui();
            }
            jargonGui.addWindowListener(new WindowAdapter(){

                public void windowClosing(WindowEvent windowEvent) {
                    System.exit(0);
                }
            });
            jargonGui.setTitle("DataGrid Explorer");
            jargonGui.pack();
            jargonGui.show();
            jargonGui.validate();
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            System.out.println(((SRBException)throwable).getStandardMessage());
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static /* synthetic */ GeneralFile access$002(JargonGui jargonGui, GeneralFile generalFile) {
        jargonGui.selectedFile = generalFile;
        return jargonGui.selectedFile;
    }

    static /* synthetic */ GeneralFileSystem[] access$100(JargonGui jargonGui) {
        return jargonGui.fileSystems;
    }

    static /* synthetic */ GeneralFile access$000(JargonGui jargonGui) {
        return jargonGui.selectedFile;
    }

    static /* synthetic */ JTextField access$300(JargonGui jargonGui) {
        return jargonGui.addresField;
    }

    static {
        registerTabs.put("browseTab", class$edu$sdsc$grid$gui$JargonTree == null ? (class$edu$sdsc$grid$gui$JargonTree = JargonGui.class$("edu.sdsc.grid.gui.JargonTree")) : class$edu$sdsc$grid$gui$JargonTree);
        registerTabs.put("transferTab", class$edu$sdsc$grid$gui$TransferStatusPanel == null ? (class$edu$sdsc$grid$gui$TransferStatusPanel = JargonGui.class$("edu.sdsc.grid.gui.TransferStatusPanel")) : class$edu$sdsc$grid$gui$TransferStatusPanel);
        registerTabs.put("queryTab", class$edu$sdsc$grid$gui$QueryPanel == null ? (class$edu$sdsc$grid$gui$QueryPanel = JargonGui.class$("edu.sdsc.grid.gui.QueryPanel")) : class$edu$sdsc$grid$gui$QueryPanel);
        try {
            srbAccount = new SRBAccount();
        }
        catch (Throwable throwable) {}
    }

    class BrowseTab
    implements JargonTab {
        JargonTree display;
        public String tabName = "Browse";
        public int mnemonic = 66;

        public BrowseTab(JargonTree jargonTree) {
            this.display = jargonTree;
            jargonTree.addTreeSelectionListener(new TreeSelectionListener(this){
                private final /* synthetic */ BrowseTab this$1;
                {
                    this.this$1 = browseTab;
                }

                public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
                    Object object = treeSelectionEvent.getPath().getLastPathComponent();
                    if (object instanceof String) {
                        BrowseTab.access$200((BrowseTab)this.this$1).queryButton.setEnabled(false);
                    } else {
                        JargonGui.access$002(BrowseTab.access$200(this.this$1), (GeneralFile)object);
                        JargonGui.access$300(BrowseTab.access$200(this.this$1)).setText(JargonGui.access$000(BrowseTab.access$200(this.this$1)).toString());
                        if (JargonGui.access$000(BrowseTab.access$200(this.this$1)) instanceof LocalFile) {
                            BrowseTab.access$200((BrowseTab)this.this$1).queryButton.setEnabled(false);
                        } else {
                            BrowseTab.access$200((BrowseTab)this.this$1).queryButton.setEnabled(true);
                        }
                    }
                }
            });
        }

        public Component getComponent() throws IOException {
            return this.display;
        }

        public Component getComponent(GeneralFile[] generalFileArray) throws IOException {
            if (generalFileArray == null) {
                return this.display;
            }
            this.display = new JargonTree(generalFileArray);
            return this.display;
        }

        public JMenuBar getJMenuBar() {
            return null;
        }

        public JToolBar getJToolBar() {
            return null;
        }

        public GeneralFile getSelectedFile() {
            return (GeneralFile)this.display.getLastSelectedPathComponent();
        }

        public String getTabName() {
            return this.tabName;
        }

        public int getMnemonic() {
            return this.mnemonic;
        }

        static /* synthetic */ JargonGui access$200(BrowseTab browseTab) {
            return browseTab.JargonGui.this;
        }
    }
}

