/*
 * Decompiled with CFR 0.152.
 */
package edu.sdsc.grid.io;

import edu.sdsc.grid.io.Protocol;

public final class MetaDataField
implements Comparable {
    public static final int INT = 0;
    public static final int LONG = 1;
    public static final int FLOAT = 2;
    public static final int STRING = 3;
    public static final int DATE = 4;
    public static final int TABLE = 14;
    private String fieldName;
    private String description;
    private int type;
    private String[] extensible;
    private Protocol[] protocols = new Protocol[1];

    public MetaDataField(String string, String string2, int n, Protocol protocol) {
        this.fieldName = string;
        this.description = string2;
        this.type = n;
        this.protocols[0] = protocol;
    }

    public MetaDataField(String string, String string2, int n, Protocol protocol, String string3) {
        this.fieldName = string;
        this.description = string2;
        this.type = n;
        this.protocols[0] = protocol;
        if (string3 != null) {
            this.extensible = new String[1];
            this.extensible[0] = string3;
        }
    }

    public String getName() {
        return this.fieldName;
    }

    public String getDescription() {
        return this.description;
    }

    public int getType() {
        return this.type;
    }

    Protocol[] getProtocols() {
        return this.protocols;
    }

    Protocol getProtocol(int n) {
        return this.protocols[n];
    }

    public String getExtensibleName(Protocol protocol) {
        if (protocol != null && this.extensible != null) {
            int n = 0;
            while (n < this.protocols.length) {
                if (protocol.equals(this.protocols[n])) {
                    return this.extensible[n];
                }
                ++n;
            }
        }
        return null;
    }

    boolean isExtensible(Protocol protocol) {
        if (this.extensible == null) {
            return false;
        }
        int n = 0;
        while (n < this.protocols.length) {
            if (this.protocols[n].equals(protocol) && this.extensible[n] != null) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public boolean usesProtocol(Protocol protocol) {
        int n = 0;
        while (n < this.protocols.length) {
            if (this.protocols[n].equals(protocol)) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public void addProtocol(Protocol protocol) {
        int n = 0;
        while (n < this.protocols.length) {
            if (this.protocols[n].equals(protocol)) {
                return;
            }
            ++n;
        }
        Protocol[] protocolArray = this.protocols;
        this.protocols = new Protocol[protocolArray.length + 1];
        System.arraycopy(protocolArray, 0, this.protocols, 0, protocolArray.length);
        this.protocols[protocolArray.length] = protocol;
    }

    public void addProtocol(Protocol protocol, String string) {
        this.addProtocol(protocol);
        if (this.extensible == null) {
            this.extensible = new String[1];
            this.extensible[0] = string;
        } else {
            int n = 0;
            while (n < this.protocols.length) {
                if (this.protocols[n].equals(protocol)) {
                    this.extensible[n] = string;
                    return;
                }
                ++n;
            }
        }
    }

    public boolean equals(Object object) {
        MetaDataField metaDataField = null;
        if (object == null) {
            return false;
        }
        try {
            metaDataField = (MetaDataField)object;
        }
        catch (ClassCastException classCastException) {
            return false;
        }
        Protocol[] protocolArray = metaDataField.getProtocols();
        String string = null;
        String string2 = null;
        if (this.fieldName == metaDataField.getName() && this.description == metaDataField.getDescription() && this.type == metaDataField.getType()) {
            if (this.extensible != null) {
                int n = 0;
                while (n < protocolArray.length) {
                    string = this.getExtensibleName(protocolArray[n]);
                    string2 = metaDataField.getExtensibleName(protocolArray[n]);
                    if (string != null ? !string.equals(string2) : string2 != null && string == null) {
                        return false;
                    }
                    ++n;
                }
            }
            return true;
        }
        return false;
    }

    public String toString() {
        return this.fieldName + ": " + this.description;
    }

    public int compareTo(Object object) {
        return this.toString().compareTo(object.toString());
    }
}

