/*
 * Decompiled with CFR 0.152.
 */
package edu.sdsc.grid.io.srb;

import edu.sdsc.grid.io.FileFactory;
import edu.sdsc.grid.io.GeneralRandomAccessFile;
import edu.sdsc.grid.io.local.LocalFile;
import edu.sdsc.grid.io.srb.SRBAccount;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import org.globus.common.CoGProperties;
import org.globus.gsi.gssapi.GlobusGSSCredentialImpl;
import org.globus.gsi.gssapi.net.impl.GSIGssInputStream;
import org.globus.gsi.gssapi.net.impl.GSIGssOutputStream;
import org.globus.gsi.gssapi.net.impl.GSIGssSocket;
import org.gridforum.jgss.ExtendedGSSManager;
import org.ietf.jgss.GSSContext;
import org.ietf.jgss.GSSCredential;
import org.ietf.jgss.GSSException;

class GSIAuth {
    GSIAuth(SRBAccount sRBAccount, Socket socket, OutputStream outputStream, InputStream inputStream) throws IOException {
        this.sendGSIAuth(sRBAccount, socket, outputStream, inputStream);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    void sendGSIAuth(SRBAccount sRBAccount, Socket socket, OutputStream outputStream, InputStream inputStream) throws IOException {
        CoGProperties coGProperties = null;
        String string = null;
        GSSCredential gSSCredential = null;
        String string2 = sRBAccount.getCertificateAuthority();
        ExtendedGSSManager extendedGSSManager = (ExtendedGSSManager)ExtendedGSSManager.getInstance();
        try {
            try {
                gSSCredential = GSIAuth.getCredential(sRBAccount);
                if (string2 != null) {
                    coGProperties = CoGProperties.getDefault();
                    string = coGProperties.getCaCertLocations();
                    coGProperties.setCaCertLocations(string2);
                }
                GSSContext gSSContext = null;
                GSIGssOutputStream gSIGssOutputStream = null;
                GSIGssInputStream gSIGssInputStream = null;
                gSSContext = extendedGSSManager.createContext(null, null, gSSCredential, 0);
                gSSContext.requestCredDeleg(false);
                gSSContext.requestMutualAuth(true);
                GSIGssSocket gSIGssSocket = new GSIGssSocket(socket, gSSContext);
                gSIGssOutputStream = new GSIGssOutputStream(outputStream, gSSContext);
                gSIGssInputStream = new GSIGssInputStream(inputStream, gSSContext);
                byte[] byArray = new byte[]{};
                byte[] byArray2 = null;
                while (!gSSContext.isEstablished()) {
                    byArray2 = gSSContext.initSecContext(byArray, 0, byArray.length);
                    if (byArray2 != null) {
                        gSIGssOutputStream.writeToken(byArray2);
                    }
                    if (gSSContext.isEstablished()) continue;
                    byArray = gSIGssInputStream.readHandshakeToken();
                }
            }
            catch (GSSException gSSException) {
                SecurityException securityException = null;
                String string3 = gSSException.getMessage();
                if (string3.indexOf("Invalid buffer") >= 0) {
                    securityException = new SecurityException("GSI Authentication Failed - Invalid Proxy File");
                    securityException.initCause(gSSException);
                    throw securityException;
                } else if (string3.indexOf("Unknown CA") >= 0) {
                    securityException = new SecurityException("GSI Authentication Failed - Cannot find Certificate Authority (CA)");
                    securityException.initCause(gSSException);
                    throw securityException;
                } else {
                    securityException = new SecurityException("GSI Authentication Failed");
                    securityException.initCause(gSSException);
                }
                throw securityException;
            }
            catch (Throwable throwable) {
                SecurityException securityException = new SecurityException("GSI Authentication Failed");
                securityException.initCause(throwable);
                throw securityException;
            }
            Object var17_21 = null;
            if (string == null) return;
        }
        catch (Throwable throwable) {
            Object var17_22 = null;
            if (string == null) throw throwable;
            coGProperties.setCaCertLocations(string);
            throw throwable;
        }
        coGProperties.setCaCertLocations(string);
    }

    static String getDN(SRBAccount sRBAccount) throws IOException {
        StringBuffer stringBuffer = null;
        int n = -1;
        int n2 = -1;
        try {
            GlobusGSSCredentialImpl globusGSSCredentialImpl = (GlobusGSSCredentialImpl)GSIAuth.getCredential(sRBAccount);
            stringBuffer = new StringBuffer(globusGSSCredentialImpl.getName().toString());
        }
        catch (GSSException gSSException) {
            throw new IllegalArgumentException("Invalid or missing credentials");
        }
        n = stringBuffer.indexOf("UID");
        if (n >= 0 && (n2 = stringBuffer.lastIndexOf("CN")) > n) {
            stringBuffer = stringBuffer.delete(n2 - 1, stringBuffer.length());
        }
        n = stringBuffer.indexOf(",");
        while (n >= 0) {
            stringBuffer = stringBuffer.replace(n, n + 1, "/");
            n = stringBuffer.indexOf(",");
        }
        if (stringBuffer.indexOf("/") != 0) {
            return "/" + stringBuffer;
        }
        return stringBuffer.toString();
    }

    static GSSCredential getCredential(SRBAccount sRBAccount) throws GSSException, IOException {
        byte[] byArray = null;
        GSSCredential gSSCredential = (GSSCredential)sRBAccount.getGSSCredential();
        if (gSSCredential != null) {
            if (gSSCredential.getRemainingLifetime() <= 0) {
                throw new GSSException(8);
            }
            return gSSCredential;
        }
        String string = sRBAccount.getPassword();
        ExtendedGSSManager extendedGSSManager = (ExtendedGSSManager)ExtendedGSSManager.getInstance();
        if (string == null) {
            throw new IllegalArgumentException("Password/Proxyfile and GSSCredential cannot be null.");
        }
        if (string.startsWith("-----BEGIN CERTIFICATE-----")) {
            byArray = string.getBytes();
            gSSCredential = extendedGSSManager.createCredential(byArray, 0, 0, null, 0);
        } else {
            LocalFile localFile = new LocalFile(string);
            if (!localFile.exists()) {
                throw new IOException("Proxy file path invalid");
            }
            GeneralRandomAccessFile generalRandomAccessFile = FileFactory.newRandomAccessFile(localFile, "r");
            byArray = new byte[(int)localFile.length()];
            generalRandomAccessFile.read(byArray);
            generalRandomAccessFile.close();
            gSSCredential = extendedGSSManager.createCredential(byArray, 0, 0, null, 0);
        }
        if (gSSCredential.getRemainingLifetime() <= 0) {
            throw new GSSException(8);
        }
        return gSSCredential;
    }
}

