/*
 * Decompiled with CFR 0.152.
 */
package edu.sdsc.grid.io.srb;

import edu.sdsc.grid.io.FileFactory;
import edu.sdsc.grid.io.GeneralFile;
import edu.sdsc.grid.io.GeneralRandomAccessFile;
import edu.sdsc.grid.io.MetaDataCondition;
import edu.sdsc.grid.io.MetaDataRecordList;
import edu.sdsc.grid.io.MetaDataSelect;
import edu.sdsc.grid.io.MetaDataSet;
import edu.sdsc.grid.io.RemoteFile;
import edu.sdsc.grid.io.local.LocalFile;
import edu.sdsc.grid.io.srb.SRBFile;
import edu.sdsc.grid.io.srb.SRBFileSystem;
import edu.sdsc.grid.io.srb.SRBMetaDataRecordList;
import edu.sdsc.grid.io.srb.SRBMetaDataSet;
import edu.sdsc.grid.io.srb.SRBRandomAccessFile;
import java.io.IOException;
import java.net.URI;
import java.util.Vector;

public class SRBContainer
extends SRBFile {
    static final int DEFAULT_CONTAINER_SIZE = 0xC800000;
    public static final String PURGE_SYNC = "synchronize then purge cache";
    public static final String PRIMARY_SYNC = "synchronize primary copy";
    long containerMaxSize = 0xC800000L;
    int bufferPos = 0;
    int useBuffer = 0;
    int numRegistrationThreads = 0;
    int registeredFiles = 0;
    int filesReadyToRegister = 0;
    int registrationOffset = 0;

    public SRBContainer(SRBFileSystem sRBFileSystem, String string) {
        super(sRBFileSystem, string);
    }

    public SRBContainer(SRBFileSystem sRBFileSystem, String string, long l) {
        super(sRBFileSystem, string);
        this.setContainerMaxSize(l);
    }

    public SRBContainer(SRBFile sRBFile, String string) {
        super(sRBFile, string);
    }

    public SRBContainer(SRBFile sRBFile, String string, long l) {
        super(sRBFile, string);
        this.setContainerMaxSize(l);
    }

    public SRBContainer(SRBFileSystem sRBFileSystem, String string, String string2) {
        super(sRBFileSystem, string, string2);
    }

    public SRBContainer(SRBFileSystem sRBFileSystem, String string, String string2, long l) {
        super(sRBFileSystem, string, string2);
        this.setContainerMaxSize(l);
    }

    public SRBContainer(URI uRI) throws IOException {
        super(uRI);
        this.setContainerMaxSize(this.containerMaxSize);
    }

    public void setContainerMaxSize(long l) {
        if (l < 0L) {
            throw new IllegalArgumentException();
        }
        this.containerMaxSize = l;
    }

    public long getContainerMaxSize() {
        try {
            MetaDataRecordList[] metaDataRecordListArray = this.query("container max size");
            if (metaDataRecordListArray != null) {
                return Long.parseLong(metaDataRecordListArray[0].getValue("container max size").toString());
            }
        }
        catch (IOException iOException) {}
        return 0L;
    }

    public String getResource() throws IOException {
        MetaDataRecordList[] metaDataRecordListArray = this.query("resource name");
        if (metaDataRecordListArray != null) {
            return metaDataRecordListArray[0].getValue("resource name").toString();
        }
        return null;
    }

    public String getDataType() throws IOException {
        MetaDataRecordList[] metaDataRecordListArray = this.query("data type name");
        if (metaDataRecordListArray != null) {
            return metaDataRecordListArray[0].getValue("data type name").toString();
        }
        return null;
    }

    public void include(GeneralFile generalFile) throws IOException {
        if (!this.exists()) {
            this.createNewFile();
        }
        int n = this.srbFileSystem.srbObjCreate(SRBFile.catalogType, generalFile.getName() + "&CONTAINER=" + this.getAbsolutePath(), this.dataType, this.resource, generalFile.getParent(), "", generalFile.length());
        byte[] byArray = new byte[65535];
        long l = generalFile.length();
        GeneralRandomAccessFile generalRandomAccessFile = FileFactory.newRandomAccessFile(generalFile, "r");
        if (l > 65535L) {
            do {
                generalRandomAccessFile.read(byArray);
                this.srbFileSystem.srbObjWrite(n, byArray, byArray.length);
            } while ((l -= 65535L) > 65535L);
        }
        byArray = new byte[(int)l];
        generalRandomAccessFile.read(byArray);
        this.srbFileSystem.srbObjWrite(n, byArray, byArray.length);
        generalRandomAccessFile.close();
        this.srbFileSystem.srbObjClose(n);
    }

    public MetaDataRecordList[] query(MetaDataSelect[] metaDataSelectArray) throws IOException {
        return this.query(metaDataSelectArray, SRBFileSystem.DEFAULT_RECORDS_WANTED);
    }

    public MetaDataRecordList[] query(MetaDataSelect[] metaDataSelectArray, int n) throws IOException {
        MetaDataCondition[] metaDataConditionArray = new MetaDataCondition[]{MetaDataSet.newCondition("container name", 0, this.getAbsolutePath())};
        return this.srbFileSystem.query(metaDataConditionArray, metaDataSelectArray, n);
    }

    public void copyTo(GeneralFile generalFile, boolean bl, boolean bl2) throws IOException {
        String[] stringArray = this.list();
        if (!generalFile.exists()) {
            generalFile.mkdir();
        } else if (generalFile.isFile()) {
            throw new IllegalArgumentException("The destination cannot be a file.");
        }
        if (generalFile instanceof SRBContainer) {
            int n = 0;
            while (n < stringArray.length) {
                ((SRBContainer)generalFile).include(new SRBFile(this.srbFileSystem, stringArray[n]));
                ++n;
            }
        } else {
            int n = 0;
            while (n < stringArray.length) {
                GeneralFile generalFile2 = FileFactory.newFile(this, stringArray[n]);
                generalFile2.copyTo(FileFactory.newFile(generalFile, generalFile2.getName()));
                ++n;
            }
        }
    }

    public void copyFrom(GeneralFile generalFile, boolean bl, boolean bl2) throws IOException {
        String[] stringArray = generalFile.list();
        if (!this.exists()) {
            this.createNewFile();
        }
        if (generalFile.isFile()) {
            this.include(generalFile);
        } else {
            int n = 0;
            while (n < stringArray.length) {
                this.include(FileFactory.newFile(generalFile, stringArray[n]));
                ++n;
            }
        }
    }

    public void copyFromLocal(LocalFile localFile) throws IOException {
        if (localFile.isDirectory()) {
            this.copyFrom(localFile, false, false);
        }
        throw new UnsupportedOperationException("Cannot use copyFromLocal for containers");
    }

    public void copyFromLocal(String string) throws IOException {
        LocalFile localFile = new LocalFile(string);
        if (localFile.isDirectory()) {
            this.copyFrom(localFile, false, false);
        }
        throw new UnsupportedOperationException("Cannot use copyFromLocal for containers");
    }

    public void copyToLocal(LocalFile localFile) throws IOException {
        this.copyTo(localFile, false, false);
    }

    public void copyToLocal(String string) throws IOException {
        this.copyTo(new LocalFile(string), false, false);
    }

    public void copyToRemote(RemoteFile remoteFile) throws IOException, ClassCastException {
        this.copyTo(remoteFile);
    }

    public String getPermissions() throws IOException {
        MetaDataSelect[] metaDataSelectArray;
        MetaDataRecordList[] metaDataRecordListArray = null;
        String string = this.srbFileSystem.getUserName();
        String string2 = this.srbFileSystem.getDomainName();
        MetaDataCondition[] metaDataConditionArray = new MetaDataCondition[]{MetaDataSet.newCondition("user name", 0, string), MetaDataSet.newCondition("user domain", 0, string2)};
        metaDataRecordListArray = this.query(metaDataConditionArray, metaDataSelectArray = new MetaDataSelect[]{MetaDataSet.newSelection("user name"), MetaDataSet.newSelection("user domain"), MetaDataSet.newSelection("access constraint")});
        if (metaDataRecordListArray != null) {
            int n = 0;
            while (n < metaDataRecordListArray.length) {
                if (metaDataRecordListArray[n].getValue("user name").equals(string) && metaDataRecordListArray[n].getValue("user domain").equals(string2)) {
                    return metaDataRecordListArray[n].getValue("access constraint").toString();
                }
                ++n;
            }
        }
        return null;
    }

    public MetaDataRecordList[] getPermissions(boolean bl) throws IOException {
        return this.query("access constraint");
    }

    public void replicate(String string) throws IOException {
        this.srbFileSystem.srbReplContainer(SRBFile.catalogType, this.getPath(), string);
    }

    public void backup(String string) throws IOException {
        int n = 0;
        String string2 = this.getAbsolutePath();
        if (string == PURGE_SYNC) {
            n = 1;
        } else if (string == PRIMARY_SYNC) {
            n = 2;
        } else {
            string2 = string2 + ".*";
        }
        this.srbFileSystem.srbSyncContainer(SRBFile.catalogType, string2, n);
    }

    void bulkLoad(LocalFile[] localFileArray) throws IOException {
        int n = 4;
        long l = -1L;
        long l2 = 0L;
        byte[] byArray = new byte[0x200000];
        byte[] byArray2 = new byte[0x200000];
        SRBRandomAccessFile sRBRandomAccessFile = new SRBRandomAccessFile(this, "rw");
        Thread thread = null;
        LoadThread loadThread = null;
        this.mkdir();
        RegistrationThread[] registrationThreadArray = new RegistrationThread[n];
        int n2 = 0;
        while (n2 < n) {
            registrationThreadArray[n2] = new RegistrationThread(this.srbFileSystem, SRBFile.catalogType, this.getAbsolutePath());
            ++n2;
        }
        Thread[] threadArray = new Thread[n];
        int n3 = 0;
        while (n3 < n) {
            threadArray[n3] = new Thread(registrationThreadArray[n3]);
            ++n3;
        }
        loadThread = new LoadThread(sRBRandomAccessFile, byArray, byArray2);
        thread = new Thread(loadThread);
        thread.start();
        int n4 = 0;
        while (n4 < localFileArray.length) {
            this.loadBuffer(localFileArray[n4], loadThread, this, threadArray, registrationThreadArray, null);
            ++n4;
        }
        if (this.useBuffer == 0 || this.useBuffer == 1) {
            loadThread.buffer1Length = this.bufferPos;
        } else if (this.useBuffer == 2) {
            loadThread.buffer2Length = this.bufferPos;
        }
        loadThread.writeBuffer1 = true;
        while (loadThread.writeBuffer1) {
        }
        loadThread.writeBuffer2 = true;
        loadThread.keepLoading = false;
        ((GeneralRandomAccessFile)sRBRandomAccessFile).close();
        try {
            if (thread.isAlive()) {
                thread.join();
            }
            int n5 = 0;
            while (n5 < n) {
                registrationThreadArray[n5].forceRegister();
                ++n5;
            }
            int n6 = 0;
            while (n6 < n) {
                if (threadArray[n6] != null) {
                    // empty if block
                }
                ++n6;
            }
        }
        catch (InterruptedException interruptedException) {}
    }

    private void loadBuffer(GeneralFile generalFile, LoadThread loadThread, SRBFile sRBFile, Thread[] threadArray, RegistrationThread[] registrationThreadArray, String string) throws IOException {
        if (generalFile == null) {
            return;
        }
        if (generalFile.isDirectory()) {
            string = string == null ? generalFile.getName() : string + "/" + generalFile.getName();
            GeneralFile[] generalFileArray = generalFile.listFiles();
            if (generalFileArray == null) {
                return;
            }
            int n = 0;
            while (n < generalFileArray.length) {
                this.loadBuffer(generalFileArray[n], loadThread, sRBFile, threadArray, registrationThreadArray, string);
                ++n;
            }
        } else {
            GeneralRandomAccessFile generalRandomAccessFile = null;
            try {
                generalRandomAccessFile = FileFactory.newRandomAccessFile(generalFile, "r");
            }
            catch (SecurityException securityException) {
                return;
            }
            long l = generalFile.length();
            int n = 0;
            while (l > 0L) {
                while (loadThread.writeBuffer1 && loadThread.writeBuffer2 || loadThread.writeBuffer1 && this.useBuffer == 1 || loadThread.writeBuffer2 && this.useBuffer == 2) {
                }
                if (this.useBuffer == 0 || this.useBuffer == 1) {
                    if (l + (long)this.bufferPos < 0x200000L) {
                        n = generalRandomAccessFile.read(loadThread.buffer1, this.bufferPos, (int)l);
                        this.bufferPos += n;
                        l -= (long)n;
                    } else if (this.bufferPos < 0x200000) {
                        n = generalRandomAccessFile.read(loadThread.buffer1, this.bufferPos, 0x200000 - this.bufferPos);
                        this.bufferPos += n;
                        loadThread.buffer1Length = this.bufferPos;
                        loadThread.writeBuffer1 = true;
                        this.useBuffer = 2;
                        this.bufferPos = 0;
                        if ((l -= (long)n) < 0x200000L) {
                            n = generalRandomAccessFile.read(loadThread.buffer2, this.bufferPos, (int)l);
                            this.bufferPos += n;
                            l -= (long)n;
                        }
                    } else {
                        loadThread.buffer1Length = this.bufferPos;
                        loadThread.writeBuffer1 = true;
                        this.useBuffer = 2;
                        this.bufferPos = 0;
                        if (l < 0x200000L) {
                            n = generalRandomAccessFile.read(loadThread.buffer2, this.bufferPos, (int)l);
                            this.bufferPos += n;
                            l -= (long)n;
                        }
                    }
                }
                if (this.useBuffer != 2) continue;
                if (l + (long)this.bufferPos < 0x200000L) {
                    n = generalRandomAccessFile.read(loadThread.buffer2, this.bufferPos, (int)l);
                    this.bufferPos += n;
                    l -= (long)n;
                    continue;
                }
                if (this.bufferPos < 0x200000) {
                    n = generalRandomAccessFile.read(loadThread.buffer2, this.bufferPos, 0x200000 - this.bufferPos);
                    this.bufferPos += n;
                    loadThread.buffer2Length = this.bufferPos;
                    loadThread.writeBuffer2 = true;
                    this.useBuffer = 1;
                    this.bufferPos = 0;
                    if ((l -= (long)n) >= 0x200000L) continue;
                    n = generalRandomAccessFile.read(loadThread.buffer1, this.bufferPos, (int)l);
                    this.bufferPos += n;
                    l -= (long)n;
                    continue;
                }
                loadThread.buffer2Length = this.bufferPos;
                loadThread.writeBuffer2 = true;
                this.useBuffer = 1;
                this.bufferPos = 0;
                if (l >= 0x200000L) continue;
                n = generalRandomAccessFile.read(loadThread.buffer1, this.bufferPos, (int)l);
                this.bufferPos += n;
                l -= (long)n;
            }
            generalRandomAccessFile.close();
            ++this.filesReadyToRegister;
            if (string == null) {
                registrationThreadArray[this.numRegistrationThreads % 4].addFile(generalFile, "");
            } else {
                registrationThreadArray[this.numRegistrationThreads % 4].addFile(generalFile, string);
            }
            if (this.filesReadyToRegister % 10 == 0 && this.numRegistrationThreads < 4) {
                if (!threadArray[this.numRegistrationThreads].isAlive()) {
                    threadArray[this.numRegistrationThreads].start();
                }
                ++this.numRegistrationThreads;
            }
        }
    }

    public boolean canRead() {
        try {
            MetaDataRecordList[] metaDataRecordListArray;
            if (this.exists() && (metaDataRecordListArray = this.query("access constraint")) != null && (metaDataRecordListArray[0].getStringValue(0).equals("all") || metaDataRecordListArray[0].getStringValue(0).equals("read"))) {
                return true;
            }
        }
        catch (IOException iOException) {}
        return false;
    }

    public boolean canWrite() {
        try {
            MetaDataRecordList[] metaDataRecordListArray;
            if (this.exists() && (metaDataRecordListArray = this.query("access constraint")) != null && (metaDataRecordListArray[0].getStringValue(0).equals("all") || metaDataRecordListArray[0].getStringValue(0).equals("write"))) {
                return true;
            }
        }
        catch (IOException iOException) {}
        return false;
    }

    public int compareTo(GeneralFile generalFile) {
        return this.getAbsolutePath().compareTo(((SRBContainer)generalFile).getAbsolutePath());
    }

    public int compareTo(Object object) throws ClassCastException {
        return this.compareTo((SRBContainer)object);
    }

    public boolean createNewFile() {
        try {
            if (!this.exists()) {
                this.srbFileSystem.srbContainerCreate(SRBFile.catalogType, this.getAbsolutePath(), this.dataType, this.resource, this.containerMaxSize);
                return true;
            }
        }
        catch (IOException iOException) {}
        return false;
    }

    public static GeneralFile createTempFile(String string, String string2) throws IOException, IllegalArgumentException {
        return SRBContainer.createTempFile(string, string2, null);
    }

    public static GeneralFile createTempFile(String string, String string2, GeneralFile generalFile) throws IOException, IllegalArgumentException {
        Object object;
        if (string == null) {
            throw new NullPointerException();
        }
        if (string.length() < 3) {
            throw new IllegalArgumentException("Prefix string too short");
        }
        if (string2 == null) {
            string2 = ".tmp";
        }
        if (generalFile == null) {
            object = new SRBFileSystem();
            generalFile = new SRBContainer((SRBFileSystem)object, "");
        }
        if (((SRBContainer)(object = new SRBContainer((SRBFile)generalFile, string + string2))).exists()) {
            throw new IOException();
        }
        ((SRBContainer)object).createNewFile();
        return object;
    }

    public boolean delete() {
        return this.delete(false);
    }

    public boolean delete(boolean bl) {
        try {
            if (this.exists()) {
                this.srbFileSystem.srbRmContainer(SRBFile.catalogType, this.getAbsolutePath(), true);
                return true;
            }
        }
        catch (IOException iOException) {
            return false;
        }
        return false;
    }

    public boolean equals(Object object) {
        try {
            SRBContainer sRBContainer = (SRBContainer)object;
            return this.getAbsolutePath().equals(sRBContainer.getAbsolutePath());
        }
        catch (ClassCastException classCastException) {
            return false;
        }
    }

    public boolean exists() {
        try {
            MetaDataRecordList[] metaDataRecordListArray = null;
            int n = 0;
            MetaDataCondition[] metaDataConditionArray = new MetaDataCondition[]{MetaDataSet.newCondition("container name", n, this.getAbsolutePath())};
            MetaDataSelect[] metaDataSelectArray = new MetaDataSelect[]{MetaDataSet.newSelection("container name")};
            metaDataRecordListArray = this.srbFileSystem.query(metaDataConditionArray, metaDataSelectArray, 3);
            if (metaDataRecordListArray != null) {
                return true;
            }
        }
        catch (IOException iOException) {}
        return false;
    }

    public GeneralFile getAbsoluteFile() {
        return new SRBContainer(this.srbFileSystem, this.getAbsolutePath());
    }

    public GeneralFile getCanonicalFile() {
        return new SRBContainer(this.srbFileSystem, this.getAbsolutePath());
    }

    public GeneralFile getParentFile() {
        return new SRBContainer(this.srbFileSystem, this.getParent());
    }

    public boolean isContainer() {
        return this.exists();
    }

    public boolean isDirectory() {
        return false;
    }

    public boolean isFile() {
        return false;
    }

    public boolean isHidden() {
        return false;
    }

    public long lastModified() {
        try {
            MetaDataRecordList[] metaDataRecordListArray = this.query("modification date");
            if (metaDataRecordListArray != null) {
                return Long.parseLong(metaDataRecordListArray[0].getValue("modification date").toString());
            }
        }
        catch (IOException iOException) {
            return 0L;
        }
        return 0L;
    }

    public long length() {
        try {
            MetaDataRecordList[] metaDataRecordListArray = this.query("container size");
            if (metaDataRecordListArray != null) {
                return Long.parseLong(metaDataRecordListArray[0].getValue("container size").toString());
            }
        }
        catch (IOException iOException) {
            return 0L;
        }
        return 0L;
    }

    public String[] list() {
        String[] stringArray = new String[]{};
        String string = this.getName();
        try {
            MetaDataRecordList[] metaDataRecordListArray = this.query("file name");
            if (metaDataRecordListArray != null) {
                stringArray = new String[metaDataRecordListArray.length - 1];
                int n = 0;
                int n2 = 0;
                while (n < metaDataRecordListArray.length) {
                    String string2 = metaDataRecordListArray[n].getStringValue(0);
                    if (!string2.equals(string)) {
                        stringArray[n2] = string2;
                        ++n2;
                    }
                    ++n;
                }
            }
        }
        catch (IOException iOException) {
            return null;
        }
        return stringArray;
    }

    public boolean mkdir() {
        return this.createNewFile();
    }

    public boolean renameTo(GeneralFile generalFile) {
        try {
            if (this.exists()) {
                this.srbFileSystem.srbModifyDataset(SRBFile.catalogType, this.getName(), this.getParent(), this.resource, null, generalFile.getName(), null, 29);
                return true;
            }
        }
        catch (IOException iOException) {}
        return false;
    }

    class RegistrationThread
    implements Runnable {
        SRBFileSystem fileSystem;
        int catalogType;
        String bloadFilePath;
        boolean keepLoading = false;
        boolean newFiles = false;
        Vector files = new Vector();
        Vector paths = new Vector();

        RegistrationThread(SRBFileSystem sRBFileSystem, int n, String string) throws IOException {
            this.fileSystem = sRBFileSystem;
            this.catalogType = this.catalogType;
            this.bloadFilePath = string;
        }

        void addFile(GeneralFile generalFile, String string) {
            this.files.add(generalFile);
            this.paths.add(string);
            this.newFiles = true;
        }

        public void run() {
            this.keepLoading = true;
            while (this.keepLoading) {
                this.register();
            }
        }

        SRBMetaDataRecordList[] getFileRegistry() throws IOException {
            SRBMetaDataRecordList sRBMetaDataRecordList = null;
            SRBMetaDataRecordList[] sRBMetaDataRecordListArray = new SRBMetaDataRecordList[this.files.size()];
            GeneralFile generalFile = null;
            Object var4_4 = null;
            Object var5_5 = null;
            Object var6_6 = null;
            String string = null;
            String string2 = null;
            long l = 0L;
            int n = 0;
            while (n < sRBMetaDataRecordListArray.length) {
                generalFile = (GeneralFile)this.files.get(n);
                string = generalFile.getName();
                SRBContainer.this.registrationOffset = (int)((long)SRBContainer.this.registrationOffset + l);
                l = generalFile.length();
                string2 = (String)this.paths.get(n);
                string2 = string2 != "" ? SRBContainer.this.getAbsolutePath() + "/" + string2 : SRBContainer.this.getAbsolutePath();
                sRBMetaDataRecordList = new SRBMetaDataRecordList(SRBMetaDataSet.getField("file name"), string);
                sRBMetaDataRecordList.addRecord(SRBMetaDataSet.getField("directory name"), string2);
                sRBMetaDataRecordList.addRecord(SRBMetaDataSet.getField("size"), l);
                sRBMetaDataRecordList.addRecord(SRBMetaDataSet.getField("offset"), SRBContainer.this.registrationOffset);
                sRBMetaDataRecordListArray[n - SRBContainer.this.registeredFiles] = sRBMetaDataRecordList;
                ++n;
            }
            int n2 = 0;
            while (n2 < sRBMetaDataRecordListArray.length) {
                try {
                    this.files.remove(0);
                    this.paths.remove(0);
                }
                catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                    break;
                }
                ++n2;
            }
            return sRBMetaDataRecordListArray;
        }

        void register() {
            try {
                if (!this.newFiles) {
                    return;
                }
                if (this.files.size() < 5) {
                    return;
                }
                this.fileSystem.srbBulkLoad(this.catalogType, this.bloadFilePath, this.getFileRegistry());
            }
            catch (IOException iOException) {}
        }

        void forceRegister() {
            if (!this.newFiles) {
                return;
            }
            try {
                this.fileSystem.srbBulkLoad(this.catalogType, this.bloadFilePath, this.getFileRegistry());
            }
            catch (IOException iOException) {}
        }
    }

    class LoadThread
    implements Runnable {
        GeneralRandomAccessFile out;
        byte[] buffer1;
        byte[] buffer2;
        boolean writeBuffer1 = false;
        boolean writeBuffer2 = false;
        int buffer1Length = 0;
        int buffer2Length = 0;
        boolean keepLoading = true;

        LoadThread(GeneralRandomAccessFile generalRandomAccessFile, byte[] byArray, byte[] byArray2) {
            this.out = generalRandomAccessFile;
            this.buffer1 = byArray;
            this.buffer2 = byArray2;
        }

        public void run() {
            while (this.keepLoading) {
                this.sendBuffer();
            }
        }

        void sendBuffer() {
            try {
                if (this.writeBuffer1) {
                    this.out.write(this.buffer1, 0, this.buffer1Length);
                    this.writeBuffer1 = false;
                }
                if (this.writeBuffer2) {
                    this.out.write(this.buffer2, 0, this.buffer2Length);
                    this.writeBuffer2 = false;
                }
            }
            catch (IOException iOException) {}
        }
    }
}

