/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.hul.ois.mets;

import edu.harvard.hul.ois.mets.DigiprovMD;
import edu.harvard.hul.ois.mets.RightsMD;
import edu.harvard.hul.ois.mets.SourceMD;
import edu.harvard.hul.ois.mets.TechMD;
import edu.harvard.hul.ois.mets.helper.MetsElement;
import edu.harvard.hul.ois.mets.helper.MetsException;
import edu.harvard.hul.ois.mets.helper.MetsIDElement;
import edu.harvard.hul.ois.mets.helper.MetsReader;
import edu.harvard.hul.ois.mets.helper.MetsWriter;
import edu.harvard.hul.ois.mets.helper.parser.Attribute;
import edu.harvard.hul.ois.mets.helper.parser.Attributes;
import edu.harvard.hul.ois.mets.helper.parser.Token;
import java.util.Iterator;

public class AmdSec
extends MetsIDElement {
    public AmdSec() {
        super("amdSec");
    }

    public static AmdSec reader(MetsReader metsReader) throws MetsException {
        AmdSec amdSec = new AmdSec();
        amdSec.read(metsReader);
        return amdSec;
    }

    public void read(MetsReader metsReader) throws MetsException {
        Token token = metsReader.getStart(this._localName);
        this._qName = token.getLocalName();
        Attributes attributes = token.getAttributes();
        if (attributes.hasNext()) {
            Attribute attribute = attributes.next();
            String string = attribute.getQName();
            String string2 = attribute.getLocalName();
            String string3 = attribute.getValue();
            if (string2.equals("ID")) {
                this.setID(string3);
            } else if (string.substring(0, 6).equals("xmlns:")) {
                String string4 = string.substring(6);
                this.setSchema(string4, string3);
            }
        }
        while (metsReader.atStart("techMD")) {
            this._content.add(TechMD.reader(metsReader));
        }
        while (metsReader.atStart("rightsMD")) {
            this._content.add(RightsMD.reader(metsReader));
        }
        while (metsReader.atStart("sourceMD")) {
            this._content.add(SourceMD.reader(metsReader));
        }
        while (metsReader.atStart("digiprovMD")) {
            this._content.add(DigiprovMD.reader(metsReader));
        }
        metsReader.getEnd(this._localName);
    }

    public void write(MetsWriter metsWriter) throws MetsException {
        metsWriter.start(this._qName);
        if (this._ID != null) {
            metsWriter.attribute("ID", this._ID);
        }
        this.writeSchemas(metsWriter);
        Iterator iterator = this._content.iterator();
        while (iterator.hasNext()) {
            ((MetsElement)iterator.next()).write(metsWriter);
        }
        metsWriter.end(this._qName);
    }
}

