/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.hul.ois.mets;

import edu.harvard.hul.ois.mets.Betype;
import edu.harvard.hul.ois.mets.Exttype;
import edu.harvard.hul.ois.mets.File;
import edu.harvard.hul.ois.mets.Shape;
import edu.harvard.hul.ois.mets.helper.MetsException;
import edu.harvard.hul.ois.mets.helper.MetsIDElement;
import edu.harvard.hul.ois.mets.helper.MetsReader;
import edu.harvard.hul.ois.mets.helper.MetsValidator;
import edu.harvard.hul.ois.mets.helper.MetsWriter;
import edu.harvard.hul.ois.mets.helper.parser.Attribute;
import edu.harvard.hul.ois.mets.helper.parser.Attributes;
import edu.harvard.hul.ois.mets.helper.parser.Token;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;

public class Area
extends MetsIDElement {
    private Map _ADMID = new HashMap();
    private String _BEGIN;
    private Betype _BETYPE;
    private List _CONTENTIDS = new ArrayList();
    private String _COORDS;
    private String _END;
    private Map _FILEID = new HashMap();
    private String _EXTENT;
    private Exttype _EXTTYPE;
    private Shape _SHAPE;

    public Area() {
        super("area");
    }

    public Map getADMID() {
        return this._ADMID;
    }

    public String getBEGIN() {
        return this._BEGIN;
    }

    public Betype getBETYPE() {
        return this._BETYPE;
    }

    public List getCONTENTIDS() {
        return this._CONTENTIDS;
    }

    public String getCOORDS() {
        return this._COORDS;
    }

    public String getEND() {
        return this._END;
    }

    public String getEXTENT() {
        return this._EXTENT;
    }

    public Exttype getEXTTYPE() {
        return this._EXTTYPE;
    }

    public Map getFILEID() {
        return this._FILEID;
    }

    public Shape getSHAPE() {
        return this._SHAPE;
    }

    public void setADMID(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        while (stringTokenizer.hasMoreTokens()) {
            this.setADMID(stringTokenizer.nextToken(), null);
        }
    }

    public void setADMID(String string, MetsIDElement metsIDElement) {
        this._ADMID.put(string, metsIDElement);
        this._valid = false;
    }

    public void setBEGIN(String string) {
        this._BEGIN = string;
    }

    public void setBETYPE(Betype betype) {
        this._BETYPE = betype;
    }

    public void setCONTENTIDS(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        while (stringTokenizer.hasMoreTokens()) {
            this._CONTENTIDS.add(stringTokenizer.nextToken());
        }
    }

    public void setCOORDS(String string) {
        this._COORDS = string;
    }

    public void setEND(String string) {
        this._END = string;
    }

    public void setEXTENT(String string) {
        this._EXTENT = string;
    }

    public void setEXTTYPE(Exttype exttype) {
        this._EXTTYPE = exttype;
    }

    public void setFILEID(String string) {
        this.setFILEID(string, null);
    }

    public void setFILEID(String string, File file) {
        this._FILEID.clear();
        this._FILEID.put(string, file);
        this._valid = false;
    }

    public void setSHAPE(Shape shape) {
        this._SHAPE = shape;
    }

    public static Area reader(MetsReader metsReader) throws MetsException {
        Area area = new Area();
        area.read(metsReader);
        return area;
    }

    public void read(MetsReader metsReader) throws MetsException {
        Token token = metsReader.getStart(this._localName);
        this._qName = token.getQName();
        this._namespace = token.getNamespace();
        this._localName = token.getLocalName();
        Attributes attributes = token.getAttributes();
        while (attributes.hasNext()) {
            Attribute attribute = attributes.next();
            String string = attribute.getLocalName();
            String string2 = attribute.getValue();
            if (string.equals("ID")) {
                this.setID(string2);
                continue;
            }
            if (string.equals("FILEID")) {
                this.setFILEID(string2);
                continue;
            }
            if (string.equals("SHAPE")) {
                this.setSHAPE(Shape.parse(string2));
                continue;
            }
            if (string.equals("COORDS")) {
                this.setCOORDS(string2);
                continue;
            }
            if (string.equals("BEGIN")) {
                this.setBEGIN(string2);
                continue;
            }
            if (string.equals("END")) {
                this.setEND(string2);
                continue;
            }
            if (string.equals("BETYPE")) {
                this.setBETYPE(Betype.parse(string2));
                continue;
            }
            if (string.equals("EXTENT")) {
                this.setEXTENT(string2);
                continue;
            }
            if (string.equals("EXTTYPE")) {
                this.setEXTTYPE(Exttype.parse(string2));
                continue;
            }
            if (string.equals("ADMID")) {
                this.setADMID(string2);
                continue;
            }
            if (string.equals("CONTENTIDS")) {
                this.setCONTENTIDS(string2);
                continue;
            }
            if (this._attrs == null) {
                this._attrs = new Attributes();
            }
            this._attrs.add(new Attribute(attribute.getQName(), string2, '\"'));
        }
    }

    public void write(MetsWriter metsWriter) throws MetsException {
        metsWriter.start(this._qName);
        if (this._ID != null) {
            metsWriter.attribute("ID", this._ID);
        }
        metsWriter.attributeName("FILEID");
        Iterator iterator = this._FILEID.keySet().iterator();
        while (iterator.hasNext()) {
            metsWriter.attributeValue((String)iterator.next());
        }
        if (this._SHAPE != null) {
            metsWriter.attribute("SHAPE", this._SHAPE.toString());
        }
        if (this._COORDS != null) {
            metsWriter.attribute("COORDS", this._COORDS);
        }
        if (this._BEGIN != null) {
            metsWriter.attribute("BEGIN", this._BEGIN);
        }
        if (this._END != null) {
            metsWriter.attribute("END", this._END);
        }
        if (this._BETYPE != null) {
            metsWriter.attribute("BETYPE", this._BETYPE.toString());
        }
        if (this._EXTENT != null) {
            metsWriter.attribute("EXTENT", this._EXTENT);
        }
        if (this._EXTTYPE != null) {
            metsWriter.attribute("EXTTYPE", this._EXTTYPE.toString());
        }
        if (!this._ADMID.isEmpty()) {
            metsWriter.attributeName("ADMID");
            iterator = this._ADMID.keySet().iterator();
            while (iterator.hasNext()) {
                metsWriter.attributeValue((String)iterator.next());
            }
        }
        if (!this._CONTENTIDS.isEmpty()) {
            metsWriter.attributeName("CONTENTIDS");
            int n = this._CONTENTIDS.size();
            int n2 = 0;
            while (n2 < n) {
                metsWriter.attributeValue((String)this._CONTENTIDS.get(n2));
                ++n2;
            }
        }
        if (this._attrs != null) {
            this._attrs.reset();
            while (this._attrs.hasNext()) {
                Attribute attribute = this._attrs.next();
                metsWriter.attribute(attribute.getQName(), attribute.getValue());
            }
        }
        metsWriter.end(this._qName);
    }

    public void validateThis(MetsValidator metsValidator) throws MetsException {
        if (this._FILEID.isEmpty()) {
            throw new MetsException("No FILEID value");
        }
        this._valid = true;
    }

    public void validateThisIDREFs(MetsValidator metsValidator) throws MetsException {
        String string;
        Iterator iterator;
        Map map;
        boolean bl;
        String string2;
        Iterator iterator2;
        if (!this._ADMID.isEmpty()) {
            iterator2 = this._ADMID.keySet().iterator();
            while (iterator2.hasNext()) {
                string2 = (String)iterator2.next();
                bl = false;
                map = metsValidator.getIDs();
                iterator = map.keySet().iterator();
                while (iterator.hasNext()) {
                    string = (String)iterator.next();
                    if (!string2.equals(string)) continue;
                    bl = true;
                    this.setADMID(string2, (MetsIDElement)map.get(string));
                    break;
                }
                if (bl) continue;
                throw new MetsException("Can't resolve IDREF: " + string2);
            }
        }
        if (!this._FILEID.isEmpty()) {
            iterator2 = this._FILEID.keySet().iterator();
            while (iterator2.hasNext()) {
                string2 = (String)iterator2.next();
                bl = false;
                map = metsValidator.getIDs();
                iterator = map.keySet().iterator();
                while (iterator.hasNext()) {
                    string = (String)iterator.next();
                    if (!string2.equals(string)) continue;
                    bl = true;
                    this.setFILEID(string2, (File)map.get(string));
                    break;
                }
                if (bl) continue;
                throw new MetsException("Can't resolve IDREF: " + string2);
            }
        }
    }
}

