/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.hul.ois.mets;

import edu.harvard.hul.ois.mets.InterfaceDef;
import edu.harvard.hul.ois.mets.Mechanism;
import edu.harvard.hul.ois.mets.helper.DateTime;
import edu.harvard.hul.ois.mets.helper.MetsElement;
import edu.harvard.hul.ois.mets.helper.MetsException;
import edu.harvard.hul.ois.mets.helper.MetsIDElement;
import edu.harvard.hul.ois.mets.helper.MetsReader;
import edu.harvard.hul.ois.mets.helper.MetsValidator;
import edu.harvard.hul.ois.mets.helper.MetsWriter;
import edu.harvard.hul.ois.mets.helper.parser.Attribute;
import edu.harvard.hul.ois.mets.helper.parser.Attributes;
import edu.harvard.hul.ois.mets.helper.parser.Token;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.StringTokenizer;

public class Behavior
extends MetsIDElement {
    private Map _ADMID = new HashMap();
    private String _BTYPE;
    private Date _CREATED;
    private String _GROUPID;
    private String _LABEL;
    private Map _STRUCTID = new HashMap();

    public Behavior() {
        super("behavior");
    }

    public Map getADMID() {
        return this._ADMID;
    }

    public String getBTYPE() {
        return this._BTYPE;
    }

    public Map getSTRUCTID() {
        return this._STRUCTID;
    }

    public Date getCREATED() {
        return this._CREATED;
    }

    public String getGROUPID() {
        return this._GROUPID;
    }

    public String getLABEL() {
        return this._LABEL;
    }

    public void setADMID(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        while (stringTokenizer.hasMoreTokens()) {
            this.setADMID(stringTokenizer.nextToken(), null);
        }
    }

    public void setADMID(String string, MetsIDElement metsIDElement) {
        this._ADMID.put(string, metsIDElement);
        this._valid = false;
    }

    public void setBTYPE(String string) {
        this._BTYPE = string;
    }

    public void setCREATED(Date date) {
        this._CREATED = date;
    }

    public void setGROUPID(String string) {
        this._GROUPID = string;
    }

    public void setLABEL(String string) {
        this._LABEL = string;
    }

    public void setSTRUCTID(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        while (stringTokenizer.hasMoreTokens()) {
            this.setSTRUCTID(stringTokenizer.nextToken(), null);
        }
    }

    public void setSTRUCTID(String string, MetsIDElement metsIDElement) {
        this._STRUCTID.put(string, metsIDElement);
        this._valid = false;
    }

    public static Behavior reader(MetsReader metsReader) throws MetsException {
        Behavior behavior = new Behavior();
        behavior.read(metsReader);
        return behavior;
    }

    public void read(MetsReader metsReader) throws MetsException {
        Object object;
        Token token = metsReader.getStart(this._localName);
        this._qName = token.getQName();
        this._namespace = token.getNamespace();
        this._localName = token.getLocalName();
        Attributes attributes = token.getAttributes();
        while (attributes.hasNext()) {
            object = attributes.next();
            String string = ((Attribute)object).getLocalName();
            String string2 = ((Attribute)object).getValue();
            if (string.equals("ID")) {
                this.setID(string2);
                continue;
            }
            if (string.equals("STRUCTID")) {
                this.setSTRUCTID(string2);
                continue;
            }
            if (string.equals("BTYPE")) {
                this.setBTYPE(string2);
                continue;
            }
            if (string.equals("CREATED")) {
                try {
                    this.setCREATED(DateTime.parse(string2));
                    continue;
                }
                catch (Exception exception) {
                    throw new MetsException(exception.toString());
                }
            }
            if (string.equals("LABEL")) {
                this.setLABEL(string2);
                continue;
            }
            if (string.equals("GROUPID")) {
                this.setGROUPID(string2);
                continue;
            }
            if (string.equals("ADMID")) {
                this.setADMID(string2);
                continue;
            }
            if (this._attrs == null) {
                this._attrs = new Attributes();
            }
            this._attrs.add(new Attribute(((Attribute)object).getQName(), string2, '\"'));
        }
        if (metsReader.atStart("interfaceDef")) {
            object = InterfaceDef.reader(metsReader);
            this._content.add(object);
        }
        object = Mechanism.reader(metsReader);
        this._content.add(object);
        metsReader.getEnd(this._localName);
    }

    public void write(MetsWriter metsWriter) throws MetsException {
        Object object;
        metsWriter.start(this._qName);
        if (this._ID != null) {
            metsWriter.attribute("ID", this._ID);
        }
        if (!this._STRUCTID.isEmpty()) {
            metsWriter.attributeName("STRUCTID");
            object = this._STRUCTID.keySet().iterator();
            while (object.hasNext()) {
                metsWriter.attributeValue((String)object.next());
            }
        }
        if (this._BTYPE != null) {
            metsWriter.attribute("BTYPE", this._BTYPE);
        }
        if (this._CREATED != null) {
            metsWriter.attribute("CREATED", DateTime.format(this._CREATED));
        }
        if (this._LABEL != null) {
            metsWriter.attribute("LABEL", this._LABEL);
        }
        if (this._GROUPID != null) {
            metsWriter.attribute("GROUPID", this._GROUPID);
        }
        if (!this._ADMID.isEmpty()) {
            metsWriter.attributeName("ADMID");
            object = this._ADMID.keySet().iterator();
            while (object.hasNext()) {
                metsWriter.attributeValue((String)object.next());
            }
        }
        if (this._attrs != null) {
            this._attrs.reset();
            while (this._attrs.hasNext()) {
                object = this._attrs.next();
                metsWriter.attribute(((Attribute)object).getQName(), ((Attribute)object).getValue());
            }
        }
        object = this._content.iterator();
        while (object.hasNext()) {
            ((MetsElement)object.next()).write(metsWriter);
        }
        metsWriter.end(this._qName);
    }

    public void validateThis(MetsValidator metsValidator) throws MetsException {
        if (this._content == null || this._content.isEmpty()) {
            throw new MetsException("No behavior mechanism");
        }
        this._valid = true;
    }

    public void validateThisIDREFs(MetsValidator metsValidator) throws MetsException {
        String string;
        Iterator iterator;
        Map map;
        boolean bl;
        String string2;
        Iterator iterator2;
        if (!this._STRUCTID.isEmpty()) {
            iterator2 = this._STRUCTID.keySet().iterator();
            while (iterator2.hasNext()) {
                string2 = (String)iterator2.next();
                bl = false;
                map = metsValidator.getIDs();
                iterator = map.keySet().iterator();
                while (iterator.hasNext()) {
                    string = (String)iterator.next();
                    if (!string2.equals(string)) continue;
                    bl = true;
                    this.setSTRUCTID(string2, (MetsIDElement)map.get(string));
                    break;
                }
                if (bl) continue;
                throw new MetsException("Can't resolve IDREF: " + string2);
            }
        }
        if (!this._ADMID.isEmpty()) {
            iterator2 = this._ADMID.keySet().iterator();
            while (iterator2.hasNext()) {
                string2 = (String)iterator2.next();
                bl = false;
                map = metsValidator.getIDs();
                iterator = map.keySet().iterator();
                while (iterator.hasNext()) {
                    string = (String)iterator.next();
                    if (!string2.equals(string)) continue;
                    bl = true;
                    this.setADMID(string2, (MetsIDElement)map.get(string));
                    break;
                }
                if (bl) continue;
                throw new MetsException("Can't resolve IDREF: " + string2);
            }
        }
    }
}

