/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.hul.ois.mets;

import edu.harvard.hul.ois.mets.DmdSec;
import edu.harvard.hul.ois.mets.Fptr;
import edu.harvard.hul.ois.mets.Mptr;
import edu.harvard.hul.ois.mets.helper.MetsElement;
import edu.harvard.hul.ois.mets.helper.MetsException;
import edu.harvard.hul.ois.mets.helper.MetsIDElement;
import edu.harvard.hul.ois.mets.helper.MetsReader;
import edu.harvard.hul.ois.mets.helper.MetsValidator;
import edu.harvard.hul.ois.mets.helper.MetsWriter;
import edu.harvard.hul.ois.mets.helper.parser.Attribute;
import edu.harvard.hul.ois.mets.helper.parser.Attributes;
import edu.harvard.hul.ois.mets.helper.parser.Token;
import edu.harvard.hul.ois.mets.helper.parser.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;

public class Div
extends MetsIDElement {
    private Map _ADMID = new HashMap();
    private List _CONTENTIDS = new ArrayList();
    private Map _DMDID = new HashMap();
    private boolean _hasORDER = false;
    private String _LABEL;
    private int _ORDER;
    private String _ORDERLABEL;
    private String _TYPE;

    public Div() {
        super("div");
    }

    public Map getADMID() {
        return this._ADMID;
    }

    public List getCONTENTIDS() {
        return this._CONTENTIDS;
    }

    public Map getDMDID() {
        return this._DMDID;
    }

    public String getLABEL() {
        return this._LABEL;
    }

    public int getORDER() throws MetsException {
        if (!this._hasORDER) {
            throw new MetsException("ORDER is null");
        }
        return this._ORDER;
    }

    public String getORDERLABEL() {
        return this._ORDERLABEL;
    }

    public String getTYPE() {
        return this._TYPE;
    }

    public void setADMID(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        while (stringTokenizer.hasMoreTokens()) {
            this.setADMID(stringTokenizer.nextToken(), null);
        }
    }

    public void setADMID(String string, MetsIDElement metsIDElement) {
        this._ADMID.put(string, metsIDElement);
        this._valid = false;
    }

    public void setCONTENTIDS(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        while (stringTokenizer.hasMoreTokens()) {
            this._CONTENTIDS.add(stringTokenizer.nextToken());
        }
    }

    public void setDMDID(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        while (stringTokenizer.hasMoreTokens()) {
            this.setDMDID(stringTokenizer.nextToken(), null);
        }
    }

    public void setDMDID(String string, DmdSec dmdSec) {
        this._DMDID.put(string, dmdSec);
        this._valid = false;
    }

    public void setLABEL(String string) {
        this._LABEL = string;
    }

    public void setORDER(int n) {
        this._ORDER = n;
        this._hasORDER = true;
    }

    public void setORDERLABEL(String string) {
        this._ORDERLABEL = string;
    }

    public void setTYPE(String string) {
        this._TYPE = string;
    }

    public static Div reader(MetsReader metsReader) throws MetsException {
        Div div = new Div();
        div.read(metsReader);
        return div;
    }

    public void read(MetsReader metsReader) throws MetsException {
        Object object;
        Object object2;
        Token token = metsReader.getStart(this._localName);
        this._qName = token.getQName();
        this._namespace = token.getNamespace();
        this._localName = token.getLocalName();
        Attributes attributes = token.getAttributes();
        while (attributes.hasNext()) {
            object2 = attributes.next();
            object = ((Attribute)object2).getLocalName();
            String string = ((Attribute)object2).getValue();
            if (((String)object).equals("ID")) {
                this.setID(string);
                continue;
            }
            if (((String)object).equals("ORDER")) {
                this.setORDER(Integer.parseInt(string));
                continue;
            }
            if (((String)object).equals("ORDERLABEL")) {
                this.setORDERLABEL(string);
                continue;
            }
            if (((String)object).equals("LABEL")) {
                this.setLABEL(string);
                continue;
            }
            if (((String)object).equals("DMDID")) {
                this.setDMDID(string);
                continue;
            }
            if (((String)object).equals("ADMID")) {
                this.setADMID(string);
                continue;
            }
            if (((String)object).equals("TYPE")) {
                this.setTYPE(string);
                continue;
            }
            if (((String)object).equals("CONTENTIDS")) {
                this.setCONTENTIDS(string);
                continue;
            }
            if (this._attrs == null) {
                this._attrs = new Attributes();
            }
            this._attrs.add(new Attribute(((Attribute)object2).getQName(), string, '\"'));
        }
        object2 = token.getType();
        if (!((Type)object2).equals(Type.EMPTY_TAG)) {
            while (metsReader.atStart("mptr")) {
                object = Mptr.reader(metsReader);
                this._content.add(object);
            }
            while (metsReader.atStart("fptr")) {
                object = Fptr.reader(metsReader);
                this._content.add(object);
            }
            while (metsReader.atStart("div")) {
                object = Div.reader(metsReader);
                this._content.add(object);
            }
            if (metsReader.atEnd(this._localName)) {
                metsReader.getEnd(this._localName);
            }
        }
    }

    public void write(MetsWriter metsWriter) throws MetsException {
        Iterator iterator;
        metsWriter.start(this._qName);
        if (this._ID != null) {
            metsWriter.attribute("ID", this._ID);
        }
        if (this._hasORDER) {
            metsWriter.attribute("ORDER", String.valueOf(this._ORDER));
        }
        if (this._ORDERLABEL != null) {
            metsWriter.attribute("ORDERLABEL", this._ORDERLABEL);
        }
        if (this._LABEL != null) {
            metsWriter.attribute("LABEL", this._LABEL);
        }
        if (!this._DMDID.isEmpty()) {
            metsWriter.attributeName("DMDID");
            iterator = this._DMDID.keySet().iterator();
            while (iterator.hasNext()) {
                metsWriter.attributeValue((String)iterator.next());
            }
        }
        if (!this._ADMID.isEmpty()) {
            metsWriter.attributeName("ADMID");
            iterator = this._ADMID.keySet().iterator();
            while (iterator.hasNext()) {
                metsWriter.attributeValue((String)iterator.next());
            }
        }
        if (this._TYPE != null) {
            metsWriter.attribute("TYPE", this._TYPE);
        }
        if (!this._CONTENTIDS.isEmpty()) {
            metsWriter.attributeName("CONTENTIDS");
            int n = this._CONTENTIDS.size();
            int n2 = 0;
            while (n2 < n) {
                metsWriter.attributeValue((String)this._CONTENTIDS.get(n2));
                ++n2;
            }
        }
        if (this._attrs != null) {
            this._attrs.reset();
            while (this._attrs.hasNext()) {
                Attribute attribute = this._attrs.next();
                metsWriter.attribute(attribute.getQName(), attribute.getValue());
            }
        }
        Iterator iterator2 = this._content.iterator();
        while (iterator2.hasNext()) {
            ((MetsElement)iterator2.next()).write(metsWriter);
        }
        metsWriter.end(this._qName);
    }

    public void validateThisIDREFs(MetsValidator metsValidator) throws MetsException {
        String string;
        Iterator iterator;
        Map map;
        boolean bl;
        String string2;
        Iterator iterator2;
        if (!this._ADMID.isEmpty()) {
            iterator2 = this._ADMID.keySet().iterator();
            while (iterator2.hasNext()) {
                string2 = (String)iterator2.next();
                bl = false;
                map = metsValidator.getIDs();
                iterator = map.keySet().iterator();
                while (iterator.hasNext()) {
                    string = (String)iterator.next();
                    if (!string2.equals(string)) continue;
                    bl = true;
                    this.setADMID(string2, (MetsIDElement)map.get(string));
                    break;
                }
                if (bl) continue;
                throw new MetsException("Can't resolve IDREF: " + string2);
            }
        }
        if (!this._DMDID.isEmpty()) {
            iterator2 = this._DMDID.keySet().iterator();
            while (iterator2.hasNext()) {
                string2 = (String)iterator2.next();
                bl = false;
                map = metsValidator.getIDs();
                iterator = map.keySet().iterator();
                while (iterator.hasNext()) {
                    string = (String)iterator.next();
                    if (!string2.equals(string)) continue;
                    bl = true;
                    this.setDMDID(string2, (DmdSec)map.get(string));
                    break;
                }
                if (bl) continue;
                throw new MetsException("Can't resolve IDREF: " + string2);
            }
        }
    }
}

