/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.hul.ois.mets;

import edu.harvard.hul.ois.mets.Checksumtype;
import edu.harvard.hul.ois.mets.DmdSec;
import edu.harvard.hul.ois.mets.FContent;
import edu.harvard.hul.ois.mets.FLocat;
import edu.harvard.hul.ois.mets.Stream;
import edu.harvard.hul.ois.mets.TransformFile;
import edu.harvard.hul.ois.mets.helper.DateTime;
import edu.harvard.hul.ois.mets.helper.MetsException;
import edu.harvard.hul.ois.mets.helper.MetsIDElement;
import edu.harvard.hul.ois.mets.helper.MetsReader;
import edu.harvard.hul.ois.mets.helper.MetsSerializable;
import edu.harvard.hul.ois.mets.helper.MetsValidator;
import edu.harvard.hul.ois.mets.helper.MetsWriter;
import edu.harvard.hul.ois.mets.helper.parser.Attribute;
import edu.harvard.hul.ois.mets.helper.parser.Attributes;
import edu.harvard.hul.ois.mets.helper.parser.Token;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.StringTokenizer;

public class File
extends MetsIDElement {
    private Map _ADMID = new HashMap();
    private String _CHECKSUM;
    private Checksumtype _CHECKSUMTYPE;
    private Date _CREATED;
    private Map _DMDID = new HashMap();
    private String _GROUPID;
    private boolean _hasSEQ = false;
    private boolean _hasSIZE = false;
    private String _MIMETYPE;
    private String _OWNERID;
    private int _SEQ;
    private long _SIZE;
    private String _USE;

    public File() {
        super("file");
    }

    public Map getADMID() {
        return this._ADMID;
    }

    public String getCHECKSUM() {
        return this._CHECKSUM;
    }

    public Checksumtype getCHECKSUMTYPE() {
        return this._CHECKSUMTYPE;
    }

    public Date getCREATED() {
        return this._CREATED;
    }

    public Map getDMDID() {
        return this._DMDID;
    }

    public String getGROUPID() {
        return this._GROUPID;
    }

    public String getMIMETYPE() {
        return this._MIMETYPE;
    }

    public String getOWNERID() {
        return this._OWNERID;
    }

    public int getSEQ() throws MetsException {
        if (!this._hasSEQ) {
            throw new MetsException("No file SEQ value");
        }
        return this._SEQ;
    }

    public long getSIZE() throws MetsException {
        if (!this._hasSIZE) {
            throw new MetsException("No file SIZE value");
        }
        return this._SIZE;
    }

    public String getUSE() {
        return this._USE;
    }

    public void setADMID(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        while (stringTokenizer.hasMoreTokens()) {
            this.setADMID(stringTokenizer.nextToken(), null);
        }
    }

    public void setADMID(String string, MetsIDElement metsIDElement) {
        this._ADMID.put(string, metsIDElement);
        this._valid = false;
    }

    public void setCHECKSUM(String string) {
        this._CHECKSUM = string;
    }

    public void setCHECKSUMTYPE(Checksumtype checksumtype) {
        this._CHECKSUMTYPE = checksumtype;
    }

    public void setCREATED(Date date) {
        this._CREATED = date;
    }

    public void setDMDID(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        while (stringTokenizer.hasMoreTokens()) {
            this.setDMDID(stringTokenizer.nextToken(), null);
        }
    }

    public void setDMDID(String string, DmdSec dmdSec) {
        this._DMDID.put(string, dmdSec);
        this._valid = false;
    }

    public void setGROUPID(String string) {
        this._GROUPID = string;
    }

    public void setMIMETYPE(String string) {
        this._MIMETYPE = string;
    }

    public void setOWNERID(String string) {
        this._OWNERID = string;
    }

    public void setSEQ(int n) {
        this._SEQ = n;
        this._hasSEQ = true;
    }

    public void setSIZE(long l) {
        this._SIZE = l;
        this._hasSIZE = true;
    }

    public void setUSE(String string) {
        this._USE = string;
    }

    public static File reader(MetsReader metsReader) throws MetsException {
        File file = new File();
        file.read(metsReader);
        return file;
    }

    public void read(MetsReader metsReader) throws MetsException {
        Object object;
        Token token = metsReader.getStart(this._localName);
        this._qName = token.getQName();
        this._namespace = token.getNamespace();
        this._localName = token.getLocalName();
        Attributes attributes = token.getAttributes();
        while (attributes.hasNext()) {
            object = attributes.next();
            String string = ((Attribute)object).getQName();
            String string2 = ((Attribute)object).getLocalName();
            String string3 = ((Attribute)object).getValue();
            if (string2.equals("ID")) {
                this.setID(string3);
                continue;
            }
            if (string2.equals("MIMETYPE")) {
                this.setMIMETYPE(string3);
                continue;
            }
            if (string2.equals("SEQ")) {
                this.setSEQ(Integer.parseInt(string3));
                continue;
            }
            if (string2.equals("SIZE")) {
                this.setSIZE(Long.parseLong(string3));
                continue;
            }
            if (string2.equals("CREATED")) {
                try {
                    this.setCREATED(DateTime.parse(string3));
                    continue;
                }
                catch (Exception exception) {
                    throw new MetsException(exception.toString());
                }
            }
            if (string2.equals("CHECKSUM")) {
                this.setCHECKSUM(string3);
                continue;
            }
            if (string2.equals("CHECKSUMTYPE")) {
                this.setCHECKSUMTYPE(Checksumtype.parse(string3));
                continue;
            }
            if (string2.equals("OWNERID")) {
                this.setOWNERID(string3);
                continue;
            }
            if (string2.equals("ADMID")) {
                this.setADMID(string3);
                continue;
            }
            if (string2.equals("DMDID")) {
                this.setDMDID(string3);
                continue;
            }
            if (string2.equals("GROUPID")) {
                this.setGROUPID(string3);
                continue;
            }
            if (string2.equals("USE")) {
                this.setUSE(string3);
                continue;
            }
            if (string.substring(0, 6).equals("xmlns:")) {
                String string4 = string.substring(6);
                this.setSchema(string4, string3);
                continue;
            }
            if (this._attrs == null) {
                this._attrs = new Attributes();
            }
            this._attrs.add(new Attribute(((Attribute)object).getQName(), string3, '\"'));
        }
        while (metsReader.atStart("FLocat")) {
            object = FLocat.reader(metsReader);
            this._content.add(object);
        }
        if (metsReader.atStart("FContent")) {
            object = FContent.reader(metsReader);
            this._content.add(object);
        }
        while (metsReader.atStart("stream")) {
            object = Stream.reader(metsReader);
            this._content.add(object);
        }
        while (metsReader.atStart("transformFile")) {
            object = TransformFile.reader(metsReader);
            this._content.add(object);
        }
        while (metsReader.atStart("file")) {
            object = File.reader(metsReader);
            this._content.add(object);
        }
        metsReader.getEnd(this._localName);
    }

    public void write(MetsWriter metsWriter) throws MetsException {
        Object object;
        metsWriter.start(this._qName);
        metsWriter.attribute("ID", this._ID);
        if (this._MIMETYPE != null) {
            metsWriter.attribute("MIMETYPE", this._MIMETYPE);
        }
        if (this._hasSEQ) {
            metsWriter.attribute("SEQ", String.valueOf(this._SEQ));
        }
        if (this._hasSIZE) {
            metsWriter.attribute("SIZE", String.valueOf(this._SIZE));
        }
        if (this._CREATED != null) {
            metsWriter.attribute("CREATED", DateTime.format(this._CREATED));
        }
        if (this._CHECKSUM != null) {
            metsWriter.attribute("CHECKSUM", this._CHECKSUM);
        }
        if (this._CHECKSUMTYPE != null) {
            metsWriter.attribute("CHECKSUMTYPE", this._CHECKSUMTYPE.toString());
        }
        if (this._OWNERID != null) {
            metsWriter.attribute("OWNERID", this._OWNERID);
        }
        if (!this._ADMID.isEmpty()) {
            metsWriter.attributeName("ADMID");
            object = this._ADMID.keySet().iterator();
            while (object.hasNext()) {
                metsWriter.attributeValue((String)object.next());
            }
        }
        if (!this._DMDID.isEmpty()) {
            metsWriter.attributeName("DMDID");
            object = this._DMDID.keySet().iterator();
            while (object.hasNext()) {
                metsWriter.attributeValue((String)object.next());
            }
        }
        if (this._GROUPID != null) {
            metsWriter.attribute("GROUPID", this._GROUPID);
        }
        if (this._USE != null) {
            metsWriter.attribute("USE", this._USE);
        }
        if (this._attrs != null) {
            this._attrs.reset();
            while (this._attrs.hasNext()) {
                object = this._attrs.next();
                metsWriter.attribute(((Attribute)object).getQName(), ((Attribute)object).getValue());
            }
        }
        this.writeSchemas(metsWriter);
        object = this._content.iterator();
        while (object.hasNext()) {
            ((MetsSerializable)object.next()).write(metsWriter);
        }
        metsWriter.end(this._qName);
    }

    public void validateThis(MetsValidator metsValidator) throws MetsException {
        if (this._ID == null) {
            throw new MetsException("No file ID value");
        }
        this._valid = true;
    }

    public void validateThisIDREFs(MetsValidator metsValidator) throws MetsException {
        String string;
        Iterator iterator;
        Map map;
        boolean bl;
        String string2;
        Iterator iterator2;
        if (!this._ADMID.isEmpty()) {
            iterator2 = this._ADMID.keySet().iterator();
            while (iterator2.hasNext()) {
                string2 = (String)iterator2.next();
                bl = false;
                map = metsValidator.getIDs();
                iterator = map.keySet().iterator();
                while (iterator.hasNext()) {
                    string = (String)iterator.next();
                    if (!string2.equals(string)) continue;
                    bl = true;
                    this.setADMID(string2, (MetsIDElement)map.get(string));
                    break;
                }
                if (bl) continue;
                throw new MetsException("Can't resolve IDREF: " + string2);
            }
        }
        if (!this._DMDID.isEmpty()) {
            iterator2 = this._DMDID.keySet().iterator();
            while (iterator2.hasNext()) {
                string2 = (String)iterator2.next();
                bl = false;
                map = metsValidator.getIDs();
                iterator = map.keySet().iterator();
                while (iterator.hasNext()) {
                    string = (String)iterator.next();
                    if (!string2.equals(string)) continue;
                    bl = true;
                    this.setDMDID(string2, (DmdSec)map.get(string));
                    break;
                }
                if (bl) continue;
                throw new MetsException("Can't resolve IDREF: " + string2);
            }
        }
    }
}

