/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.hul.ois.mets;

import edu.harvard.hul.ois.mets.File;
import edu.harvard.hul.ois.mets.helper.DateTime;
import edu.harvard.hul.ois.mets.helper.MetsElement;
import edu.harvard.hul.ois.mets.helper.MetsException;
import edu.harvard.hul.ois.mets.helper.MetsIDElement;
import edu.harvard.hul.ois.mets.helper.MetsReader;
import edu.harvard.hul.ois.mets.helper.MetsWriter;
import edu.harvard.hul.ois.mets.helper.parser.Attribute;
import edu.harvard.hul.ois.mets.helper.parser.Attributes;
import edu.harvard.hul.ois.mets.helper.parser.Token;
import edu.harvard.hul.ois.mets.helper.parser.Type;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;

public class FileGrp
extends MetsIDElement {
    private Map _ADMID = new HashMap();
    private String _USE;
    private Date _VERSDATE;

    public FileGrp() {
        super("fileGrp");
    }

    public Map getADMID() {
        return this._ADMID;
    }

    public String getUSE() {
        return this._USE;
    }

    public Date getVERSDATE() {
        return this._VERSDATE;
    }

    public void setADMID(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        while (stringTokenizer.hasMoreTokens()) {
            this.setADMID(stringTokenizer.nextToken(), null);
        }
    }

    public void setADMID(String string, MetsIDElement metsIDElement) {
        this._ADMID.put(string, metsIDElement);
        this._valid = false;
    }

    public void setUSE(String string) {
        this._USE = string;
    }

    public void setVERSDATE(Date date) {
        this._VERSDATE = date;
    }

    public static FileGrp reader(MetsReader metsReader) throws MetsException {
        FileGrp fileGrp = new FileGrp();
        fileGrp.read(metsReader);
        return fileGrp;
    }

    public void read(MetsReader metsReader) throws MetsException {
        Object object;
        Object object2;
        Token token = metsReader.getStart(this._localName);
        this._qName = token.getQName();
        this._namespace = token.getNamespace();
        this._localName = token.getLocalName();
        Attributes attributes = token.getAttributes();
        while (attributes.hasNext()) {
            object2 = attributes.next();
            object = ((Attribute)object2).getQName();
            String string = ((Attribute)object2).getLocalName();
            String string2 = ((Attribute)object2).getValue();
            if (string.equals("ID")) {
                this.setID(string2);
                continue;
            }
            if (string.equals("VERSDATE")) {
                try {
                    this.setVERSDATE(DateTime.parse(string2));
                    continue;
                }
                catch (Exception exception) {
                    throw new MetsException(exception.toString());
                }
            }
            if (string.equals("ADMID")) {
                this.setADMID(string2);
                continue;
            }
            if (string.equals("USE")) {
                this.setUSE(string2);
                continue;
            }
            if (((String)object).substring(0, 6).equals("xmlns:")) {
                String string3 = ((String)object).substring(6);
                this.setSchema(string3, string2);
                continue;
            }
            if (this._attrs == null) {
                this._attrs = new Attributes();
            }
            this._attrs.add(new Attribute(((Attribute)object2).getQName(), string2, '\"'));
        }
        object2 = token.getType();
        if (!((Type)object2).equals(Type.EMPTY_TAG)) {
            while (metsReader.atStart("fileGrp")) {
                object = FileGrp.reader(metsReader);
                this._content.add(object);
            }
            while (metsReader.atStart("file")) {
                object = File.reader(metsReader);
                this._content.add(object);
            }
            if (metsReader.atEnd(this._localName)) {
                metsReader.getEnd(this._localName);
            }
        }
    }

    public void write(MetsWriter metsWriter) throws MetsException {
        Object object;
        metsWriter.start(this._qName);
        if (this._ID != null) {
            metsWriter.attribute("ID", this._ID);
        }
        if (this._VERSDATE != null) {
            metsWriter.attribute("VERSDATE", DateTime.format(this._VERSDATE));
        }
        if (!this._ADMID.isEmpty()) {
            metsWriter.attributeName("ADMID");
            object = this._ADMID.keySet().iterator();
            while (object.hasNext()) {
                metsWriter.attributeValue((String)object.next());
            }
        }
        if (this._USE != null) {
            metsWriter.attribute("USE", this._USE);
        }
        if (this._attrs != null) {
            this._attrs.reset();
            while (this._attrs.hasNext()) {
                object = this._attrs.next();
                metsWriter.attribute(((Attribute)object).getQName(), ((Attribute)object).getValue());
            }
        }
        this.writeSchemas(metsWriter);
        object = this._content.iterator();
        while (object.hasNext()) {
            ((MetsElement)object.next()).write(metsWriter);
        }
        metsWriter.end(this._qName);
    }
}

