/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.hul.ois.mets;

import edu.harvard.hul.ois.mets.BinData;
import edu.harvard.hul.ois.mets.Mdtype;
import edu.harvard.hul.ois.mets.XmlData;
import edu.harvard.hul.ois.mets.helper.MetsElement;
import edu.harvard.hul.ois.mets.helper.MetsException;
import edu.harvard.hul.ois.mets.helper.MetsIDElement;
import edu.harvard.hul.ois.mets.helper.MetsReader;
import edu.harvard.hul.ois.mets.helper.MetsValidator;
import edu.harvard.hul.ois.mets.helper.MetsWriter;
import edu.harvard.hul.ois.mets.helper.parser.Attribute;
import edu.harvard.hul.ois.mets.helper.parser.Attributes;
import edu.harvard.hul.ois.mets.helper.parser.Token;

public class MdWrap
extends MetsIDElement {
    private String _LABEL;
    private Mdtype _MDTYPE;
    private String _MIMETYPE;
    private String _OTHERMDTYPE;

    public MdWrap() {
        super("mdWrap");
    }

    public String getLABEL() {
        return this._LABEL;
    }

    public Mdtype getMDTYPE() {
        return this._MDTYPE;
    }

    public String getMIMETYPE() {
        return this._MIMETYPE;
    }

    public String getOTHERMDTYPE() {
        return this._OTHERMDTYPE;
    }

    public void setLABEL(String string) {
        this._LABEL = string;
    }

    public void setMDTYPE(Mdtype mdtype) {
        this._MDTYPE = mdtype;
    }

    public void setMIMETYPE(String string) {
        this._MIMETYPE = string;
    }

    public void setOTHERMDTYPE(String string) {
        this._OTHERMDTYPE = string;
    }

    public static MdWrap reader(MetsReader metsReader) throws MetsException {
        MdWrap mdWrap = new MdWrap();
        mdWrap.read(metsReader);
        return mdWrap;
    }

    public void read(MetsReader metsReader) throws MetsException {
        Object object;
        Token token = metsReader.getStart(this._localName);
        this._qName = token.getQName();
        this._namespace = token.getNamespace();
        this._localName = token.getLocalName();
        Attributes attributes = token.getAttributes();
        while (attributes.hasNext()) {
            object = attributes.next();
            String string = ((Attribute)object).getQName();
            String string2 = ((Attribute)object).getLocalName();
            String string3 = ((Attribute)object).getValue();
            if (string2.equals("ID")) {
                this.setID(string3);
                continue;
            }
            if (string2.equals("MIMETYPE")) {
                this.setMIMETYPE(string3);
                continue;
            }
            if (string2.equals("MDTYPE")) {
                this.setMDTYPE(Mdtype.parse(string3));
                continue;
            }
            if (string2.equals("OTHERMDTYPE")) {
                this.setOTHERMDTYPE(string3);
                continue;
            }
            if (string2.equals("LABEL")) {
                this.setLABEL(string3);
                continue;
            }
            if (string.substring(0, 6).equals("xmlns:")) {
                String string4 = string.substring(6);
                this.setSchema(string4, string3);
                continue;
            }
            if (this._attrs == null) {
                this._attrs = new Attributes();
            }
            this._attrs.add(new Attribute(((Attribute)object).getQName(), string3, '\"'));
        }
        if (metsReader.atStart("binData")) {
            object = BinData.reader(metsReader);
            this._content.add(object);
        }
        if (metsReader.atStart("xmlData")) {
            object = XmlData.reader(metsReader);
            this._content.add(object);
        }
        metsReader.getEnd(this._localName);
    }

    public void write(MetsWriter metsWriter) throws MetsException {
        Object object;
        metsWriter.start(this._qName);
        if (this._ID != null) {
            metsWriter.attribute("ID", this._ID);
        }
        if (this._MIMETYPE != null) {
            metsWriter.attribute("MIMETYPE", this._MIMETYPE);
        }
        metsWriter.attribute("MDTYPE", this._MDTYPE.toString());
        if (this._OTHERMDTYPE != null) {
            metsWriter.attribute("OTHERMDTYPE", this._OTHERMDTYPE);
        }
        if (this._LABEL != null) {
            metsWriter.attribute("LABEL", this._LABEL);
        }
        if (this._attrs != null) {
            this._attrs.reset();
            while (this._attrs.hasNext()) {
                object = this._attrs.next();
                metsWriter.attribute(((Attribute)object).getQName(), ((Attribute)object).getValue());
            }
        }
        this.writeSchemas(metsWriter);
        object = this._content.iterator();
        while (object.hasNext()) {
            ((MetsElement)object.next()).write(metsWriter);
        }
        metsWriter.end(this._qName);
    }

    public void validateThis(MetsValidator metsValidator) throws MetsException {
        if (this._MDTYPE == null) {
            throw new MetsException("No mdWrap MDTYPE value");
        }
        if (this._MDTYPE.toString().equals("OTHER")) {
            if (this._OTHERMDTYPE == null) {
                System.err.println("No mdWrap OTHERMDTYPE value");
            }
        } else if (this._OTHERMDTYPE != null) {
            System.err.println("mdWrap OTHERMDTYPE only valid with MDTYPE=\"OTHER\"");
        }
        if (this._content == null || this._content.isEmpty()) {
            throw new MetsException("No mdWrap binData or xmlData");
        }
        this._valid = true;
    }
}

