/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.hul.ois.mets;

import edu.harvard.hul.ois.mets.AmdSec;
import edu.harvard.hul.ois.mets.BehaviorSec;
import edu.harvard.hul.ois.mets.DmdSec;
import edu.harvard.hul.ois.mets.FileSec;
import edu.harvard.hul.ois.mets.MetsHdr;
import edu.harvard.hul.ois.mets.StructLink;
import edu.harvard.hul.ois.mets.StructMap;
import edu.harvard.hul.ois.mets.helper.MetsElement;
import edu.harvard.hul.ois.mets.helper.MetsException;
import edu.harvard.hul.ois.mets.helper.MetsIDElement;
import edu.harvard.hul.ois.mets.helper.MetsReader;
import edu.harvard.hul.ois.mets.helper.MetsValidator;
import edu.harvard.hul.ois.mets.helper.MetsWriter;
import edu.harvard.hul.ois.mets.helper.parser.Attribute;
import edu.harvard.hul.ois.mets.helper.parser.Attributes;
import edu.harvard.hul.ois.mets.helper.parser.Token;

public class Mets
extends MetsIDElement {
    private String _LABEL;
    private String _OBJID;
    private String _PROFILE;
    private String _TYPE;

    public Mets() {
        super("mets");
        this.init(false);
    }

    public Mets(boolean bl) {
        super("mets");
        this.init(bl);
    }

    private void init(boolean bl) {
        if (!bl) {
            this.setSchema(null, "http://www.loc.gov/METS/", "http://www.loc.gov/standards/mets/mets.xsd");
            this.setSchema("xlink", "http://www.w3.org/1999/xlink");
            this.setSchema("xsi", "http://www.w3.org/2001/XMLSchema-instance");
        }
    }

    public String getLABEL() {
        return this._LABEL;
    }

    public String getOBJID() {
        return this._OBJID;
    }

    public String getPROFILE() {
        return this._PROFILE;
    }

    public String getTYPE() {
        return this._TYPE;
    }

    public void setLABEL(String string) {
        this._LABEL = string;
    }

    public void setOBJID(String string) {
        this._OBJID = string;
    }

    public void setPROFILE(String string) {
        this._PROFILE = string;
    }

    public void setTYPE(String string) {
        this._TYPE = string;
    }

    public static Mets reader(MetsReader metsReader) throws MetsException {
        return Mets.reader(metsReader, false);
    }

    public static Mets reader(MetsReader metsReader, boolean bl) throws MetsException {
        Mets mets = new Mets(bl);
        mets.read(metsReader);
        return mets;
    }

    public void read(MetsReader metsReader) throws MetsException {
        Object object;
        Token token = metsReader.getStart(this._localName);
        this._qName = token.getQName();
        this._namespace = token.getNamespace();
        this._localName = token.getLocalName();
        Attributes attributes = token.getAttributes();
        while (attributes.hasNext()) {
            object = attributes.next();
            String string = ((Attribute)object).getQName();
            String string2 = ((Attribute)object).getValue();
            if (string.equals("ID")) {
                this.setID(string2);
                continue;
            }
            if (string.equals("OBJID")) {
                this.setOBJID(string2);
                continue;
            }
            if (string.equals("LABEL")) {
                this.setLABEL(string2);
                continue;
            }
            if (string.equals("TYPE")) {
                this.setTYPE(string2);
                continue;
            }
            if (string.equals("PROFILE")) {
                this.setPROFILE(string2);
                continue;
            }
            if (string.equals("xmlns") || string.equals("xmlns:xlink") || string.equals("xmlns:xsi") || string.equals("xsi:schemaLocation")) continue;
            if (string.substring(0, 6).equals("xmlns:")) {
                String string3 = string.substring(6);
                this.setSchema(string3, string2);
                continue;
            }
            if (this._attrs == null) {
                this._attrs = new Attributes();
            }
            this._attrs.add(new Attribute(((Attribute)object).getQName(), string2, '\"'));
        }
        if (metsReader.atStart("metsHdr")) {
            object = MetsHdr.reader(metsReader);
            this._content.add(object);
        }
        while (metsReader.atStart("dmdSec")) {
            object = DmdSec.reader(metsReader);
            this._content.add(object);
        }
        while (metsReader.atStart("amdSec")) {
            object = AmdSec.reader(metsReader);
            this._content.add(object);
        }
        if (metsReader.atStart("fileSec")) {
            object = FileSec.reader(metsReader);
            this._content.add(object);
        }
        while (metsReader.atStart("structMap")) {
            object = StructMap.reader(metsReader);
            this._content.add(object);
        }
        while (metsReader.atStart("structLink")) {
            object = StructLink.reader(metsReader);
            this._content.add(object);
        }
        while (metsReader.atStart("behaviorSec")) {
            object = BehaviorSec.reader(metsReader);
            this._content.add(object);
        }
        metsReader.getEnd(this._localName);
    }

    public void write(MetsWriter metsWriter) throws MetsException {
        this.write(metsWriter, false);
    }

    public void write(MetsWriter metsWriter, boolean bl) throws MetsException {
        Object object;
        if (!bl) {
            metsWriter.declaration();
        }
        metsWriter.start(this._qName);
        if (this._ID != null) {
            metsWriter.attribute("ID", this._ID);
        }
        if (this._OBJID != null) {
            metsWriter.attribute("OBJID", this._OBJID);
        }
        if (this._LABEL != null) {
            metsWriter.attribute("LABEL", this._LABEL);
        }
        if (this._TYPE != null) {
            metsWriter.attribute("TYPE", this._TYPE);
        }
        if (this._PROFILE != null) {
            metsWriter.attribute("PROFILE", this._PROFILE);
        }
        if (this._attrs != null) {
            this._attrs.reset();
            while (this._attrs.hasNext()) {
                object = this._attrs.next();
                metsWriter.attribute(((Attribute)object).getQName(), ((Attribute)object).getValue());
            }
        }
        this.writeSchemas(metsWriter);
        object = this._content.iterator();
        while (object.hasNext()) {
            ((MetsElement)object.next()).write(metsWriter);
        }
        metsWriter.end(this._qName);
        metsWriter.flush();
    }

    public void validateThis(MetsValidator metsValidator) throws MetsException {
        if (this._content == null || this._content.isEmpty()) {
            throw new MetsException("No mets structMap");
        }
        metsValidator.validateIDREFs(this);
        this._valid = true;
    }
}

