/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.hul.ois.mets;

import edu.harvard.hul.ois.mets.Actuate;
import edu.harvard.hul.ois.mets.Show;
import edu.harvard.hul.ois.mets.helper.MetsException;
import edu.harvard.hul.ois.mets.helper.MetsIDElement;
import edu.harvard.hul.ois.mets.helper.MetsReader;
import edu.harvard.hul.ois.mets.helper.MetsValidator;
import edu.harvard.hul.ois.mets.helper.MetsWriter;
import edu.harvard.hul.ois.mets.helper.parser.Attribute;
import edu.harvard.hul.ois.mets.helper.parser.Attributes;
import edu.harvard.hul.ois.mets.helper.parser.Token;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class SmLink
extends MetsIDElement {
    private Map _from = new HashMap();
    private Map _to = new HashMap();
    private Actuate _xlinkActuate;
    private String _xlinkArcrole;
    private String _xlinkFrom;
    private Show _xlinkShow;
    private String _xlinkTitle;
    private String _xlinkTo;

    public SmLink() {
        super("smLink");
    }

    public Map getFrom() {
        return this._from;
    }

    public Map getTo() {
        return this._to;
    }

    public Actuate getXlinkActuate() {
        return this._xlinkActuate;
    }

    public String getXlinkArcrole() {
        return this._xlinkArcrole;
    }

    public Show getXlinkShow() {
        return this._xlinkShow;
    }

    public String getXlinkFrom() {
        return this._xlinkFrom;
    }

    public String getXlinkTitle() {
        return this._xlinkTitle;
    }

    public String getXlinkTo() {
        return this._xlinkTo;
    }

    public void setFrom(String string) {
        this.setFrom(string, null);
    }

    public void setFrom(String string, MetsIDElement metsIDElement) {
        this._from.clear();
        this._from.put(string, metsIDElement);
        this._valid = false;
    }

    public void setTo(String string) {
        this.setTo(string, null);
    }

    public void setTo(String string, MetsIDElement metsIDElement) {
        this._to.clear();
        this._to.put(string, metsIDElement);
        this._valid = false;
    }

    public void setXlinkActuate(Actuate actuate) {
        this._xlinkActuate = actuate;
    }

    public void setXlinkArcrole(String string) {
        this._xlinkArcrole = string;
    }

    public void setXlinkFrom(String string) {
        this._xlinkFrom = string;
    }

    public void setXlinkShow(Show show) {
        this._xlinkShow = show;
    }

    public void setXlinkTitle(String string) {
        this._xlinkTitle = string;
    }

    public void setXlinkTo(String string) {
        this._xlinkTo = string;
    }

    public static SmLink reader(MetsReader metsReader) throws MetsException {
        SmLink smLink = new SmLink();
        smLink.read(metsReader);
        return smLink;
    }

    public void read(MetsReader metsReader) throws MetsException {
        Token token = metsReader.getStart(this._localName);
        this._qName = token.getQName();
        this._namespace = token.getNamespace();
        this._localName = token.getLocalName();
        Attributes attributes = token.getAttributes();
        while (attributes.hasNext()) {
            Attribute attribute = attributes.next();
            String string = attribute.getQName();
            String string2 = attribute.getLocalName();
            String string3 = attribute.getValue();
            if (string2.equals("ID")) {
                this.setID(string3);
                continue;
            }
            if (string.equals("xlink:arcrole")) {
                this.setXlinkArcrole(string3);
                continue;
            }
            if (string.equals("xlink:title")) {
                this.setXlinkTitle(string3);
                continue;
            }
            if (string.equals("xlink:show")) {
                this.setXlinkShow(Show.parse(string3));
                continue;
            }
            if (string.equals("xlink:actuate")) {
                this.setXlinkActuate(Actuate.parse(string3));
                continue;
            }
            if (string2.equals("to")) {
                this.setTo(string3);
                continue;
            }
            if (string.equals("xlink:to")) {
                this.setXlinkTo(string3);
                continue;
            }
            if (string2.equals("from")) {
                this.setFrom(string3);
                continue;
            }
            if (string.equals("xlink:from")) {
                this.setXlinkFrom(string3);
                continue;
            }
            if (this._attrs == null) {
                this._attrs = new Attributes();
            }
            this._attrs.add(new Attribute(string, string3, '\"'));
        }
    }

    public void write(MetsWriter metsWriter) throws MetsException {
        Object object;
        metsWriter.start(this._qName);
        if (this._ID != null) {
            metsWriter.attribute("ID", this._ID);
        }
        if (this._xlinkArcrole != null) {
            metsWriter.attribute("xlink:arcrole", this._xlinkArcrole);
        }
        if (this._xlinkTitle != null) {
            metsWriter.attribute("xlink:title", this._xlinkTitle);
        }
        if (this._xlinkShow != null) {
            metsWriter.attribute("xlink:show", this._xlinkShow.toString());
        }
        if (this._xlinkActuate != null) {
            metsWriter.attribute("xlink:actuate", this._xlinkActuate.toString());
        }
        if (this._xlinkTo != null) {
            metsWriter.attribute("xlink:to", this._xlinkTo);
        } else {
            metsWriter.attributeName("to");
            object = this._to.keySet().iterator();
            while (object.hasNext()) {
                metsWriter.attributeValue((String)object.next());
            }
        }
        if (this._xlinkFrom != null) {
            metsWriter.attribute("xlink:from", this._xlinkFrom);
        } else {
            metsWriter.attributeName("from");
            object = this._from.keySet().iterator();
            while (object.hasNext()) {
                metsWriter.attributeValue((String)object.next());
            }
        }
        if (this._attrs != null) {
            this._attrs.reset();
            while (this._attrs.hasNext()) {
                object = this._attrs.next();
                metsWriter.attribute(((Attribute)object).getQName(), ((Attribute)object).getValue());
            }
        }
        metsWriter.end(this._qName);
    }

    public void validateThis(MetsValidator metsValidator) throws MetsException {
        if (this._to.isEmpty() && this._xlinkTo == null) {
            if (this._xlinkTo == null) {
                throw new MetsException("No smLink xlink:to value");
            }
            throw new MetsException("No smLink to value");
        }
        if (this._from.isEmpty() && this._xlinkFrom == null) {
            if (this._xlinkFrom == null) {
                throw new MetsException("No smLink xlink:from value");
            }
            throw new MetsException("No smLink from value");
        }
        this._valid = true;
    }

    public void validateThisIDREFs(MetsValidator metsValidator) throws MetsException {
        String string;
        Iterator iterator;
        Map map;
        boolean bl;
        String string2;
        Iterator iterator2;
        if (!this._from.isEmpty()) {
            iterator2 = this._from.keySet().iterator();
            while (iterator2.hasNext()) {
                string2 = (String)iterator2.next();
                bl = false;
                map = metsValidator.getIDs();
                iterator = map.keySet().iterator();
                while (iterator.hasNext()) {
                    string = (String)iterator.next();
                    if (!string2.equals(string)) continue;
                    bl = true;
                    this.setFrom(string2, (MetsIDElement)map.get(string));
                    break;
                }
                if (bl) continue;
                throw new MetsException("Can't resolve IDREF: " + string2);
            }
        }
        if (!this._to.isEmpty()) {
            iterator2 = this._to.keySet().iterator();
            while (iterator2.hasNext()) {
                string2 = (String)iterator2.next();
                bl = false;
                map = metsValidator.getIDs();
                iterator = map.keySet().iterator();
                while (iterator.hasNext()) {
                    string = (String)iterator.next();
                    if (!string2.equals(string)) continue;
                    bl = true;
                    this.setTo(string2, (MetsIDElement)map.get(string));
                    break;
                }
                if (bl) continue;
                throw new MetsException("Can't resolve IDREF: " + string2);
            }
        }
    }
}

