/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.hul.ois.mets;

import edu.harvard.hul.ois.mets.Div;
import edu.harvard.hul.ois.mets.helper.MetsElement;
import edu.harvard.hul.ois.mets.helper.MetsException;
import edu.harvard.hul.ois.mets.helper.MetsIDElement;
import edu.harvard.hul.ois.mets.helper.MetsReader;
import edu.harvard.hul.ois.mets.helper.MetsValidator;
import edu.harvard.hul.ois.mets.helper.MetsWriter;
import edu.harvard.hul.ois.mets.helper.parser.Attribute;
import edu.harvard.hul.ois.mets.helper.parser.Attributes;
import edu.harvard.hul.ois.mets.helper.parser.Token;

public class StructMap
extends MetsIDElement {
    private String _LABEL;
    private String _TYPE;

    public StructMap() {
        super("structMap");
    }

    public String getLABEL() {
        return this._LABEL;
    }

    public String getTYPE() {
        return this._TYPE;
    }

    public void setLABEL(String string) {
        this._LABEL = string;
    }

    public void setTYPE(String string) {
        this._TYPE = string;
    }

    public static StructMap reader(MetsReader metsReader) throws MetsException {
        StructMap structMap = new StructMap();
        structMap.read(metsReader);
        return structMap;
    }

    public void read(MetsReader metsReader) throws MetsException {
        Object object;
        Token token = metsReader.getStart(this._localName);
        this._qName = token.getQName();
        this._namespace = token.getNamespace();
        this._localName = token.getLocalName();
        Attributes attributes = token.getAttributes();
        while (attributes.hasNext()) {
            object = attributes.next();
            String string = ((Attribute)object).getLocalName();
            String string2 = ((Attribute)object).getValue();
            if (string.equals("ID")) {
                this.setID(string2);
                continue;
            }
            if (string.equals("TYPE")) {
                this.setTYPE(string2);
                continue;
            }
            if (string.equals("LABEL")) {
                this.setLABEL(string2);
                continue;
            }
            if (this._attrs == null) {
                this._attrs = new Attributes();
            }
            this._attrs.add(new Attribute(((Attribute)object).getQName(), string2, '\"'));
        }
        object = Div.reader(metsReader);
        this._content.add(object);
        metsReader.getEnd(this._localName);
    }

    public void write(MetsWriter metsWriter) throws MetsException {
        Object object;
        metsWriter.start(this._qName);
        if (this._ID != null) {
            metsWriter.attribute("ID", this._ID);
        }
        if (this._LABEL != null) {
            metsWriter.attribute("LABEL", this._LABEL);
        }
        if (this._TYPE != null) {
            metsWriter.attribute("TYPE", this._TYPE);
        }
        if (this._attrs != null) {
            this._attrs.reset();
            while (this._attrs.hasNext()) {
                object = this._attrs.next();
                metsWriter.attribute(((Attribute)object).getQName(), ((Attribute)object).getValue());
            }
        }
        object = this._content.iterator();
        while (object.hasNext()) {
            ((MetsElement)object.next()).write(metsWriter);
        }
        metsWriter.end(this._qName);
    }

    public void validateThis(MetsValidator metsValidator) throws MetsException {
        if (this._content == null || this._content.isEmpty()) {
            throw new MetsException("No structMap div");
        }
        this._valid = true;
    }
}

