/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.hul.ois.mets.helper;

import edu.harvard.hul.ois.mets.helper.MetsException;
import edu.harvard.hul.ois.mets.helper.MetsReader;
import edu.harvard.hul.ois.mets.helper.MetsSerializable;
import edu.harvard.hul.ois.mets.helper.MetsWriter;
import edu.harvard.hul.ois.mets.helper.Schema;
import edu.harvard.hul.ois.mets.helper.parser.Attributes;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;

public abstract class MetsElement
implements MetsSerializable {
    protected Attributes _attrs;
    protected List _content;
    protected String _localName;
    protected String _namespace;
    protected String _qName;
    protected List _schema;

    public MetsElement() {
        this.init();
    }

    public MetsElement(String string) {
        this._qName = string;
        int n = this._qName.indexOf(58);
        if (n == -1) {
            this._namespace = null;
            this._localName = this._qName;
        } else {
            this._namespace = this._qName.substring(0, n);
            this._localName = this._qName.substring(n + 1);
        }
        this.init();
    }

    public void init() {
        this._content = new ArrayList();
        this._schema = new ArrayList();
    }

    public List getContent() {
        return this._content;
    }

    public String getLocalName() {
        return this._localName;
    }

    public String getNamespace() {
        return this._namespace;
    }

    public String getQName() {
        return this._qName;
    }

    public List getSchemas() {
        return this._schema;
    }

    public void setSchema(String string, String string2) {
        this._schema.add(new Schema(string, string2));
    }

    public void setSchema(String string, String string2, String string3) {
        this._schema.add(new Schema(string, string2, string3));
    }

    public abstract void read(MetsReader var1) throws MetsException;

    public abstract void write(MetsWriter var1) throws MetsException;

    public void writeSchemas(MetsWriter metsWriter) throws MetsException {
        String string;
        Object object;
        Object object2;
        ListIterator listIterator = this._schema.listIterator();
        while (listIterator.hasNext()) {
            object2 = (Schema)listIterator.next();
            object = ((Schema)object2).getNamespacePrefix();
            string = ((Schema)object2).getNamespaceURI();
            if (object == null) {
                metsWriter.attribute("xmlns", string);
                continue;
            }
            metsWriter.attribute("xmlns:" + (String)object, string);
        }
        object2 = null;
        listIterator = this._schema.listIterator();
        while (listIterator.hasNext()) {
            object = (Schema)listIterator.next();
            string = ((Schema)object).getLocationURI();
            if (string == null) continue;
            if (object2 == null) {
                object2 = new StringBuffer();
            } else {
                ((StringBuffer)object2).append(" ");
            }
            ((StringBuffer)object2).append(((Schema)object).getNamespaceURI());
            ((StringBuffer)object2).append(" ");
            ((StringBuffer)object2).append(string);
        }
        if (object2 != null) {
            metsWriter.attribute("xsi:schemaLocation", ((StringBuffer)object2).toString());
        }
    }
}

