/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.hul.ois.mets.helper;

import edu.harvard.hul.ois.mets.helper.MetsException;
import edu.harvard.hul.ois.mets.helper.parser.Parser;
import edu.harvard.hul.ois.mets.helper.parser.Token;
import edu.harvard.hul.ois.mets.helper.parser.Type;
import java.io.InputStream;

public class MetsReader {
    private boolean _debug;
    private Parser _parser;

    public MetsReader(InputStream inputStream) throws MetsException {
        this.init(inputStream, false);
    }

    public MetsReader(InputStream inputStream, boolean bl) throws MetsException {
        this.init(inputStream, bl);
    }

    private void init(InputStream inputStream, boolean bl) throws MetsException {
        this._debug = bl;
        try {
            this._parser = new Parser();
            this._parser.setInput(inputStream);
        }
        catch (Exception exception) {
            throw new MetsException(exception.toString());
        }
    }

    public Token atContent() throws MetsException {
        if (this._debug) {
            System.out.println("atContent()");
        }
        Token token = null;
        try {
            while ((token = this._parser.peekAtToken(this._debug)) != null) {
                Type type = token.getType();
                if (type.equals(Type.TEXT) || type.equals(Type.CHAR_REF) || type.equals(Type.ENTITY_REF) || type.equals(Type.CDATA)) {
                    return token;
                }
                if (type.equals(Type.START_TAG) || type.equals(Type.EMPTY_TAG)) {
                    return token;
                }
                if (type.equals(Type.COMMENT) || type.equals(Type.PI) || type.equals(Type.START_DOC) || type.equals(Type.TEXT) || type.equals(Type.WHITESPACE) || type.equals(Type.XML_DECL)) {
                    this._parser.getToken(this._debug);
                    continue;
                }
                return null;
            }
            throw new MetsException("premature end-of-file");
        }
        catch (Exception exception) {
            throw new MetsException(exception.toString());
        }
    }

    public boolean atEnd(String string) throws MetsException {
        if (this._debug) {
            System.out.println("atEnd(" + string + ")");
        }
        Token token = null;
        try {
            while ((token = this._parser.peekAtToken(this._debug)) != null) {
                Type type = token.getType();
                if (type.equals(Type.END_TAG)) {
                    return token.getLocalName().equals(string);
                }
                if (type.equals(Type.COMMENT) || type.equals(Type.PI) || type.equals(Type.START_DOC) || type.equals(Type.TEXT) || type.equals(Type.WHITESPACE) || type.equals(Type.XML_DECL)) {
                    this._parser.getToken(this._debug);
                    continue;
                }
                return false;
            }
            throw new MetsException("premature end-of-file");
        }
        catch (Exception exception) {
            throw new MetsException(exception.toString());
        }
    }

    public boolean atStart() throws MetsException {
        if (this._debug) {
            System.out.println("atStart()");
        }
        Token token = null;
        try {
            while ((token = this._parser.peekAtToken(this._debug)) != null) {
                Type type = token.getType();
                if (type.equals(Type.START_TAG) || type.equals(Type.EMPTY_TAG)) {
                    return true;
                }
                if (type.equals(Type.COMMENT) || type.equals(Type.PI) || type.equals(Type.START_DOC) || type.equals(Type.TEXT) || type.equals(Type.WHITESPACE) || type.equals(Type.XML_DECL)) {
                    this._parser.getToken(this._debug);
                    continue;
                }
                return false;
            }
            throw new MetsException("premature end-of-file");
        }
        catch (Exception exception) {
            throw new MetsException(exception.toString());
        }
    }

    public boolean atStart(String string) throws MetsException {
        if (this._debug) {
            System.out.println("atStart(" + string + ")");
        }
        Token token = null;
        try {
            while ((token = this._parser.peekAtToken(this._debug)) != null) {
                Type type = token.getType();
                if (type.equals(Type.START_TAG) || type.equals(Type.EMPTY_TAG)) {
                    return token.getLocalName().equals(string);
                }
                if (type.equals(Type.COMMENT) || type.equals(Type.PI) || type.equals(Type.START_DOC) || type.equals(Type.TEXT) || type.equals(Type.WHITESPACE) || type.equals(Type.XML_DECL)) {
                    this._parser.getToken(this._debug);
                    continue;
                }
                return false;
            }
            throw new MetsException("premature end-of-file");
        }
        catch (Exception exception) {
            throw new MetsException(exception.toString());
        }
    }

    public boolean atText() throws MetsException {
        if (this._debug) {
            System.out.println("atText()");
        }
        Token token = null;
        try {
            while ((token = this._parser.peekAtToken(this._debug)) != null) {
                Type type = token.getType();
                if (type.equals(Type.TEXT) || type.equals(Type.CHAR_REF) || type.equals(Type.CDATA)) {
                    return true;
                }
                if (type.equals(Type.COMMENT) || type.equals(Type.PI)) {
                    this._parser.getToken(this._debug);
                    continue;
                }
                return false;
            }
            throw new MetsException("premature end-of-file");
        }
        catch (Exception exception) {
            throw new MetsException(exception.toString());
        }
    }

    public void getEnd(String string) throws MetsException {
        if (this._debug) {
            System.out.println("getEnd(" + string + ")");
        }
        Token token = null;
        try {
            while ((token = this._parser.peekAtToken(this._debug)) != null) {
                Type type = token.getType();
                if (type.equals(Type.END_TAG)) {
                    if (!token.getLocalName().equals(string)) {
                        throw new MetsException("expecting \"" + string + "\"; saw \"" + token.getLocalName() + "\"");
                    }
                    this._parser.getToken(this._debug);
                    return;
                }
                if (type.equals(Type.COMMENT) || type.equals(Type.PI) || type.equals(Type.TEXT) || type.equals(Type.WHITESPACE)) {
                    this._parser.getToken(this._debug);
                    continue;
                }
                throw new MetsException("Invalid parser token: " + type.toString());
            }
            throw new MetsException("Premature end-of-file");
        }
        catch (Exception exception) {
            throw new MetsException(exception.toString());
        }
    }

    public Token getStart() throws MetsException {
        if (this._debug) {
            System.out.println("getStart()");
        }
        Token token = null;
        try {
            while ((token = this._parser.peekAtToken(this._debug)) != null) {
                Type type = token.getType();
                if (type.equals(Type.START_TAG) || type.equals(Type.EMPTY_TAG)) {
                    this._parser.getToken(this._debug);
                    return token;
                }
                if (type.equals(Type.COMMENT) || type.equals(Type.PI) || type.equals(Type.START_DOC) || type.equals(Type.TEXT) || type.equals(Type.WHITESPACE) || type.equals(Type.XML_DECL)) {
                    this._parser.getToken(this._debug);
                    continue;
                }
                throw new MetsException("Invalid parser token: " + type.toString());
            }
            throw new MetsException("Premature end-of-file");
        }
        catch (Exception exception) {
            throw new MetsException(exception.toString());
        }
    }

    public Token getStart(String string) throws MetsException {
        if (this._debug) {
            System.out.println("getStart(" + string + ")");
        }
        Token token = null;
        try {
            while ((token = this._parser.peekAtToken(this._debug)) != null) {
                Type type = token.getType();
                if (type.equals(Type.START_TAG) || type.equals(Type.EMPTY_TAG)) {
                    if (token.getLocalName().equals(string)) {
                        this._parser.getToken(this._debug);
                        return token;
                    }
                    throw new MetsException("expecting \"" + string + "\"; saw \"" + token.getLocalName() + "\"");
                }
                if (type.equals(Type.COMMENT) || type.equals(Type.PI) || type.equals(Type.START_DOC) || type.equals(Type.TEXT) || type.equals(Type.WHITESPACE) || type.equals(Type.XML_DECL)) {
                    this._parser.getToken(this._debug);
                    continue;
                }
                throw new MetsException("Invalid parser token: " + type.toString());
            }
            throw new MetsException("Premature end-of-file");
        }
        catch (Exception exception) {
            throw new MetsException(exception.toString());
        }
    }

    public String getText() throws MetsException {
        if (this._debug) {
            System.out.println("getText()");
        }
        Token token = null;
        StringBuffer stringBuffer = new StringBuffer();
        try {
            while ((token = this._parser.peekAtToken(this._debug)) != null) {
                Type type = token.getType();
                if (type.equals(Type.TEXT) || type.equals(Type.ENTITY_REF) || type.equals(Type.CDATA)) {
                    token = this._parser.getToken(this._debug);
                    stringBuffer.append(token.getValue());
                    continue;
                }
                if (type.equals(Type.CHAR_REF)) {
                    token = this._parser.getToken(this._debug);
                    stringBuffer.append(token.getChar());
                    continue;
                }
                if (type.equals(Type.COMMENT) || type.equals(Type.PI)) {
                    this._parser.getToken(this._debug);
                    continue;
                }
                return stringBuffer.toString();
            }
            throw new MetsException("Premature end-of-file");
        }
        catch (Exception exception) {
            throw new MetsException(exception.toString());
        }
    }

    public boolean isDebug() {
        return this._debug;
    }
}

