/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.hul.ois.mets.helper;

import edu.harvard.hul.ois.mets.helper.MetsException;
import edu.harvard.hul.ois.mets.helper.MetsIdentifiable;
import edu.harvard.hul.ois.mets.helper.MetsVElement;
import edu.harvard.hul.ois.mets.helper.MetsValidatable;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;

public class MetsValidator {
    private Map _ID = new Hashtable();

    public Map getIDs() {
        return this._ID;
    }

    public void validate(MetsVElement metsVElement) throws MetsException {
        Object object;
        if (metsVElement.isValid()) {
            return;
        }
        if (metsVElement instanceof MetsIdentifiable && (object = ((MetsIdentifiable)((Object)metsVElement)).getID()) != null) {
            if (this._ID.containsKey(object)) {
                throw new MetsException("ID \"" + (String)object + "\" already exists");
            }
            this._ID.put(object, metsVElement);
        }
        object = metsVElement.getContent().iterator();
        while (object.hasNext()) {
            Object e = object.next();
            if (!(e instanceof MetsValidatable)) continue;
            ((MetsValidatable)e).validate(this);
        }
        metsVElement.validateThis(this);
    }

    public void validateIDREFs(MetsVElement metsVElement) throws MetsException {
        Iterator iterator = metsVElement.getContent().iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            if (!(e instanceof MetsVElement)) continue;
            ((MetsVElement)e).validateIDREFs(this);
        }
        metsVElement.validateThisIDREFs(this);
    }
}

