/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.hul.ois.mets.helper;

import edu.harvard.hul.ois.mets.helper.MetsException;
import edu.harvard.hul.ois.mets.helper.MetsReader;
import edu.harvard.hul.ois.mets.helper.MetsSerializable;
import edu.harvard.hul.ois.mets.helper.MetsWriter;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;

public class PCData
implements MetsSerializable {
    private static final int BUFFERSIZE = 8192;
    private List _content;
    private Reader _reader;

    public PCData() {
        this.init();
    }

    public PCData(String string) {
        this.init();
        this._content.add(string);
    }

    public PCData(Reader reader) {
        this._reader = reader;
    }

    private void init() {
        this._content = new ArrayList();
    }

    public List getContent() {
        return this._content;
    }

    public void add(String string) {
        this._content.add(string);
    }

    public static PCData reader(MetsReader metsReader) throws MetsException {
        PCData pCData = new PCData();
        pCData.read(metsReader);
        return pCData;
    }

    public void read(MetsReader metsReader) throws MetsException {
        String string = metsReader.getText();
        this._content.add(string);
    }

    public void write(MetsWriter metsWriter) throws MetsException {
        if (this._reader != null) {
            char[] cArray = new char[8192];
            try {
                int n;
                while ((n = this._reader.read(cArray, 0, 8192)) > 0) {
                    metsWriter.text(new String(cArray, 0, n));
                }
            }
            catch (IOException iOException) {
                throw new MetsException(iOException.toString());
            }
        } else {
            int n = 0;
            while (n < this._content.size()) {
                metsWriter.text((String)this._content.get(n));
                ++n;
            }
        }
    }
}

