/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.hul.ois.mets.helper.parser;

import edu.harvard.hul.ois.mets.helper.parser.Attributes;
import edu.harvard.hul.ois.mets.helper.parser.Context;
import edu.harvard.hul.ois.mets.helper.parser.Type;

public class Token {
    private Attributes _attrs;
    private int _charValue;
    private Context _context;
    private String _encoding;
    private boolean _hexValue;
    private String _localName;
    private String _namespace;
    private String _qName;
    private boolean _standalone;
    private Type _type;
    private String _value;
    private String _version;

    public Token(Type type, Context context) {
        this.init(type, context);
    }

    public Token(Type type, Context context, int n) {
        this.init(type, context);
        this._charValue = n;
        this._hexValue = false;
    }

    public Token(Type type, Context context, int n, boolean bl) {
        this.init(type, context);
        this._charValue = n;
        this._hexValue = bl;
    }

    public Token(Type type, Context context, String string) {
        this.init(type, context, string);
    }

    public Token(Type type, Context context, StringBuffer stringBuffer) {
        this.init(type, context, stringBuffer.toString());
    }

    public Token(Type type, Context context, String string, Attributes attributes) {
        this.init(type, context, string, attributes);
    }

    public Token(Type type, Context context, StringBuffer stringBuffer, Attributes attributes) {
        this.init(type, context, stringBuffer.toString(), attributes);
    }

    public Token(Type type, Context context, String string, String string2) {
        this.init(type, context);
    }

    public Token(Type type, Context context, String string, StringBuffer stringBuffer) {
        this.init(type, context, string, stringBuffer.toString());
    }

    public Token(Type type, Context context, StringBuffer stringBuffer, String string) {
        this.init(type, context, stringBuffer.toString(), string);
    }

    public Token(Type type, Context context, StringBuffer stringBuffer, StringBuffer stringBuffer2) {
        this.init(type, context, stringBuffer.toString(), stringBuffer2.toString());
    }

    private void init(Type type, Context context) {
        this._type = type;
        this._context = context;
        this._qName = null;
        this._attrs = null;
        this._value = null;
        this._charValue = 0;
        this._hexValue = false;
        this._encoding = "utf-8";
        this._standalone = true;
        this._version = "1.0";
    }

    private void init(Type type, Context context, String string) {
        this.init(type, context);
        if (type.equals(Type.END_TAG) || type.equals(Type.ENTITY_REF)) {
            this._qName = string;
            if (type.equals(Type.END_TAG)) {
                int n = this._qName.indexOf(58);
                if (n == -1) {
                    this._namespace = null;
                    this._localName = this._qName;
                } else {
                    this._namespace = this._qName.substring(0, n);
                    this._localName = this._qName.substring(n + 1);
                }
            }
        } else {
            this._value = string;
        }
    }

    private void init(Type type, Context context, String string, String string2) {
        this.init(type, context);
        this._qName = string;
        this._value = string2;
    }

    private void init(Type type, Context context, String string, Attributes attributes) {
        this.init(type, context);
        this._qName = string;
        this._attrs = attributes;
        int n = this._qName.indexOf(58);
        if (n == -1) {
            this._namespace = null;
            this._localName = this._qName;
        } else {
            this._namespace = this._qName.substring(0, n);
            this._localName = this._qName.substring(n + 1);
        }
    }

    public Attributes getAttributes() {
        return this._attrs;
    }

    public char getChar() {
        return (char)this._charValue;
    }

    public int getCharValue() {
        return this._charValue;
    }

    public Context getContext() {
        return this._context;
    }

    public String getEncoding() {
        return this._encoding;
    }

    public String getLocalName() {
        return this._localName;
    }

    public String getNamespace() {
        return this._namespace;
    }

    public String getQName() {
        return this._qName;
    }

    public Type getType() {
        return this._type;
    }

    public String getValue() {
        return this._value;
    }

    public String getVersion() {
        return this._version;
    }

    public boolean isHexValue() {
        return this._hexValue;
    }

    public boolean isStandalone() {
        return this._standalone;
    }

    public void isStandalone(boolean bl) {
        this._standalone = bl;
    }

    public void setEncoding(String string) {
        this._encoding = string;
    }

    public void setVersion(String string) {
        this._version = string;
    }
}

