/*
 * Decompiled with CFR 0.152.
 */
package ORG.oclc.oai.harvester2.verb;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.Date;
import java.util.HashMap;
import java.util.StringTokenizer;
import java.util.zip.GZIPInputStream;
import java.util.zip.InflaterInputStream;
import java.util.zip.ZipInputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.log4j.BasicConfigurator;
import org.apache.log4j.Logger;
import org.apache.xpath.XPathAPI;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public abstract class HarvesterVerb {
    private static Logger logger = Logger.getLogger(HarvesterVerb.class);
    public static final String SCHEMA_LOCATION_V2_0 = "http://www.openarchives.org/OAI/2.0/ http://www.openarchives.org/OAI/2.0/OAI-PMH.xsd";
    public static final String SCHEMA_LOCATION_V1_1_GET_RECORD = "http://www.openarchives.org/OAI/1.1/OAI_GetRecord http://www.openarchives.org/OAI/1.1/OAI_GetRecord.xsd";
    public static final String SCHEMA_LOCATION_V1_1_IDENTIFY = "http://www.openarchives.org/OAI/1.1/OAI_Identify http://www.openarchives.org/OAI/1.1/OAI_Identify.xsd";
    public static final String SCHEMA_LOCATION_V1_1_LIST_IDENTIFIERS = "http://www.openarchives.org/OAI/1.1/OAI_ListIdentifiers http://www.openarchives.org/OAI/1.1/OAI_ListIdentifiers.xsd";
    public static final String SCHEMA_LOCATION_V1_1_LIST_METADATA_FORMATS = "http://www.openarchives.org/OAI/1.1/OAI_ListMetadataFormats http://www.openarchives.org/OAI/1.1/OAI_ListMetadataFormats.xsd";
    public static final String SCHEMA_LOCATION_V1_1_LIST_RECORDS = "http://www.openarchives.org/OAI/1.1/OAI_ListRecords http://www.openarchives.org/OAI/1.1/OAI_ListRecords.xsd";
    public static final String SCHEMA_LOCATION_V1_1_LIST_SETS = "http://www.openarchives.org/OAI/1.1/OAI_ListSets http://www.openarchives.org/OAI/1.1/OAI_ListSets.xsd";
    private Document doc = null;
    private String schemaLocation = null;
    private String requestURL = null;
    private static HashMap builderMap;
    private static Element namespaceElement;
    private static DocumentBuilderFactory factory;
    private static TransformerFactory xformFactory;

    public Document getDocument() {
        return this.doc;
    }

    public String getSchemaLocation() {
        return this.schemaLocation;
    }

    public NodeList getErrors() throws TransformerException {
        if (SCHEMA_LOCATION_V2_0.equals(this.getSchemaLocation())) {
            return this.getNodeList("/oai20:OAI-PMH/oai20:error");
        }
        return null;
    }

    public String getRequestURL() {
        return this.requestURL;
    }

    public HarvesterVerb() {
    }

    public HarvesterVerb(String requestURL) throws IOException, ParserConfigurationException, SAXException, TransformerException {
        this.harvest(requestURL);
    }

    public void harvest(String requestURL) throws IOException, ParserConfigurationException, SAXException, TransformerException {
        this.requestURL = requestURL;
        logger.debug((Object)("requestURL=" + requestURL));
        InputStream in = null;
        URL url = new URL(requestURL);
        HttpURLConnection con = null;
        int responseCode = 0;
        do {
            con = (HttpURLConnection)url.openConnection();
            con.setRequestProperty("User-Agent", "OAIHarvester/2.0");
            con.setRequestProperty("Accept-Encoding", "compress, gzip, identify");
            try {
                responseCode = con.getResponseCode();
                logger.debug((Object)("responseCode=" + responseCode));
            }
            catch (FileNotFoundException e) {
                logger.info((Object)requestURL, (Throwable)e);
                responseCode = 503;
            }
            if (responseCode != 503) continue;
            long retrySeconds = con.getHeaderFieldInt("Retry-After", -1);
            if (retrySeconds == -1L) {
                long now = new Date().getTime();
                long retryDate = con.getHeaderFieldDate("Retry-After", now);
                retrySeconds = retryDate - now;
            }
            if (retrySeconds == 0L) {
                throw new FileNotFoundException("Bad URL?");
            }
            System.err.println("Server response: Retry-After=" + retrySeconds);
            if (retrySeconds <= 0L) continue;
            try {
                Thread.sleep(retrySeconds * 1000L);
            }
            catch (InterruptedException ex) {
                ex.printStackTrace();
            }
        } while (responseCode == 503);
        String contentEncoding = con.getHeaderField("Content-Encoding");
        logger.debug((Object)("contentEncoding=" + contentEncoding));
        if ("compress".equals(contentEncoding)) {
            ZipInputStream zis = new ZipInputStream(con.getInputStream());
            zis.getNextEntry();
            in = zis;
        } else {
            in = "gzip".equals(contentEncoding) ? new GZIPInputStream(con.getInputStream()) : ("deflate".equals(contentEncoding) ? new InflaterInputStream(con.getInputStream()) : con.getInputStream());
        }
        InputSource data = new InputSource(in);
        Thread t = Thread.currentThread();
        DocumentBuilder builder = (DocumentBuilder)builderMap.get(t);
        if (builder == null) {
            builder = factory.newDocumentBuilder();
            builderMap.put(t, builder);
        }
        this.doc = builder.parse(data);
        StringTokenizer tokenizer = new StringTokenizer(this.getSingleString("/*/@xsi:schemaLocation"), " ");
        StringBuffer sb = new StringBuffer();
        while (tokenizer.hasMoreTokens()) {
            if (sb.length() > 0) {
                sb.append(" ");
            }
            sb.append(tokenizer.nextToken());
        }
        this.schemaLocation = sb.toString();
    }

    public String getSingleString(String xpath) throws TransformerException {
        return this.getSingleString(this.getDocument(), xpath);
    }

    public String getSingleString(Node node, String xpath) throws TransformerException {
        return XPathAPI.eval((Node)node, (String)xpath, (Node)namespaceElement).str();
    }

    public NodeList getNodeList(String xpath) throws TransformerException {
        return XPathAPI.selectNodeList((Node)this.getDocument(), (String)xpath, (Node)namespaceElement);
    }

    public String toString() {
        DOMSource input = new DOMSource(this.getDocument());
        StringWriter sw = new StringWriter();
        StreamResult output = new StreamResult(sw);
        try {
            Transformer idTransformer = xformFactory.newTransformer();
            idTransformer.setOutputProperty("omit-xml-declaration", "yes");
            idTransformer.transform(input, output);
            return sw.toString();
        }
        catch (TransformerException e) {
            return e.getMessage();
        }
    }

    static {
        BasicConfigurator.configure();
        builderMap = new HashMap();
        namespaceElement = null;
        factory = null;
        xformFactory = TransformerFactory.newInstance();
        try {
            factory = DocumentBuilderFactory.newInstance();
            factory.setNamespaceAware(true);
            Thread t = Thread.currentThread();
            DocumentBuilder builder = factory.newDocumentBuilder();
            builderMap.put(t, builder);
            DOMImplementation impl = builder.getDOMImplementation();
            Document namespaceHolder = impl.createDocument("http://www.oclc.org/research/software/oai/harvester", "harvester:namespaceHolder", null);
            namespaceElement = namespaceHolder.getDocumentElement();
            namespaceElement.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:harvester", "http://www.oclc.org/research/software/oai/harvester");
            namespaceElement.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:xsi", "http://www.w3.org/2001/XMLSchema-instance");
            namespaceElement.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:oai20", "http://www.openarchives.org/OAI/2.0/");
            namespaceElement.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:oai11_GetRecord", "http://www.openarchives.org/OAI/1.1/OAI_GetRecord");
            namespaceElement.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:oai11_Identify", "http://www.openarchives.org/OAI/1.1/OAI_Identify");
            namespaceElement.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:oai11_ListIdentifiers", "http://www.openarchives.org/OAI/1.1/OAI_ListIdentifiers");
            namespaceElement.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:oai11_ListMetadataFormats", "http://www.openarchives.org/OAI/1.1/OAI_ListMetadataFormats");
            namespaceElement.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:oai11_ListRecords", "http://www.openarchives.org/OAI/1.1/OAI_ListRecords");
            namespaceElement.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:oai11_ListSets", "http://www.openarchives.org/OAI/1.1/OAI_ListSets");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

