/*
 * Decompiled with CFR 0.152.
 */
package com.lyncode.xoai.builders.dataprovider;

import com.lyncode.xoai.dataprovider.OAIRequestParameters;
import com.lyncode.xoai.dataprovider.services.api.DateProvider;
import com.lyncode.xoai.dataprovider.services.impl.BaseDateProvider;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public class OAIRequestParametersBuilder {
    private Map<String, List<String>> parameters = new TreeMap<String, List<String>>();
    private DateProvider formatter = new BaseDateProvider();

    public OAIRequestParametersBuilder withVerb(String verb) {
        if (verb != null) {
            this.parameters.put("verb", Arrays.asList(verb));
        }
        return this;
    }

    public OAIRequestParametersBuilder withFrom(Date from) {
        if (from != null) {
            this.parameters.put("from", Arrays.asList(this.formatter.format(from)));
        }
        return this;
    }

    public OAIRequestParametersBuilder withUntil(Date until) {
        if (until != null) {
            this.parameters.put("until", Arrays.asList(this.formatter.format(until)));
        }
        return this;
    }

    public OAIRequestParametersBuilder withIdentifier(String id) {
        if (id != null) {
            this.parameters.put("identifier", Arrays.asList(id));
        }
        return this;
    }

    public OAIRequestParametersBuilder withMetadataPrefix(String metadataPrefix) {
        if (metadataPrefix != null) {
            this.parameters.put("metadataPrefix", Arrays.asList(metadataPrefix));
        }
        return this;
    }

    public OAIRequestParametersBuilder withResumptionToken(String resumptionToken) {
        if (resumptionToken != null) {
            this.parameters.put("resumptionToken", Arrays.asList(resumptionToken));
        }
        return this;
    }

    public OAIRequestParametersBuilder withSet(String set) {
        if (set != null) {
            this.parameters.put("set", Arrays.asList(set));
        }
        return this;
    }

    public OAIRequestParametersBuilder with(String name, String ... values) {
        this.parameters.put(name, Arrays.asList(values));
        return this;
    }

    public OAIRequestParameters build() {
        return new OAIRequestParameters(this.parameters);
    }
}

