/*
 * Decompiled with CFR 0.152.
 */
package com.lyncode.xoai.dataprovider;

import com.lyncode.xoai.dataprovider.OAIRequestParameters;
import com.lyncode.xoai.dataprovider.core.OAIParameters;
import com.lyncode.xoai.dataprovider.core.XOAIContext;
import com.lyncode.xoai.dataprovider.core.XOAIManager;
import com.lyncode.xoai.dataprovider.data.internal.ItemRepositoryHelper;
import com.lyncode.xoai.dataprovider.data.internal.SetRepositoryHelper;
import com.lyncode.xoai.dataprovider.exceptions.BadArgumentException;
import com.lyncode.xoai.dataprovider.exceptions.HandlerException;
import com.lyncode.xoai.dataprovider.exceptions.InvalidContextException;
import com.lyncode.xoai.dataprovider.exceptions.OAIException;
import com.lyncode.xoai.dataprovider.exceptions.WritingXmlException;
import com.lyncode.xoai.dataprovider.handlers.ErrorHandler;
import com.lyncode.xoai.dataprovider.handlers.GetRecordHandler;
import com.lyncode.xoai.dataprovider.handlers.IdentifyHandler;
import com.lyncode.xoai.dataprovider.handlers.ListIdentifiersHandler;
import com.lyncode.xoai.dataprovider.handlers.ListMetadataFormatsHandler;
import com.lyncode.xoai.dataprovider.handlers.ListRecordsHandler;
import com.lyncode.xoai.dataprovider.handlers.ListSetsHandler;
import com.lyncode.xoai.dataprovider.services.api.DateProvider;
import com.lyncode.xoai.dataprovider.services.api.ItemRepository;
import com.lyncode.xoai.dataprovider.services.api.RepositoryConfiguration;
import com.lyncode.xoai.dataprovider.services.api.ResumptionTokenFormatter;
import com.lyncode.xoai.dataprovider.services.api.SetRepository;
import com.lyncode.xoai.dataprovider.services.impl.BaseDateProvider;
import com.lyncode.xoai.dataprovider.services.impl.DefaultResumptionTokenFormatter;
import com.lyncode.xoai.dataprovider.xml.XmlOutputContext;
import com.lyncode.xoai.dataprovider.xml.oaipmh.OAIPMH;
import com.lyncode.xoai.dataprovider.xml.oaipmh.OAIPMHtype;
import com.lyncode.xoai.dataprovider.xml.oaipmh.RequestType;
import com.lyncode.xoai.dataprovider.xml.oaipmh.VerbType;
import java.io.OutputStream;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.List;
import javax.xml.stream.XMLStreamException;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;

public class OAIDataProvider {
    private static Logger log = LogManager.getLogger(OAIDataProvider.class);
    private static DateProvider formatter = new BaseDateProvider();
    private XOAIManager manager;
    private RepositoryConfiguration repositoryConfiguration;
    private SetRepositoryHelper setRepository;
    private ItemRepositoryHelper itemRepository;
    private List<String> compressions;
    private XOAIContext xoaiContext;
    private ResumptionTokenFormatter resumptionTokenFormatter;
    private GetRecordHandler getRecordHandler;
    private IdentifyHandler identifyHandler;
    private ListIdentifiersHandler listIdentifiersHandler;
    private ListMetadataFormatsHandler listMetadataFormatsHandler;
    private ListRecordsHandler listRecordsHandler;
    private ListSetsHandler listSetsHandler;
    private ErrorHandler errorHandler;

    public static void setDateFormatter(DateProvider newFormat) {
        formatter = newFormat;
    }

    public OAIDataProvider(XOAIManager manager, String contextUrl, RepositoryConfiguration identify, SetRepository setRepository, ItemRepository itemRepository) throws InvalidContextException {
        log.debug((Object)("ContextConfiguration chosen: " + contextUrl));
        this.manager = manager;
        this.xoaiContext = this.manager.getContextManager().getOAIContext(contextUrl);
        if (this.xoaiContext == null) {
            throw new InvalidContextException("ContextConfiguration \"" + contextUrl + "\" does not exist");
        }
        this.repositoryConfiguration = identify;
        this.setRepository = new SetRepositoryHelper(setRepository);
        this.itemRepository = new ItemRepositoryHelper(itemRepository);
        this.compressions = new ArrayList<String>();
        this.resumptionTokenFormatter = new DefaultResumptionTokenFormatter();
        this.getRecordHandler = new GetRecordHandler(formatter, this.xoaiContext, this.itemRepository, this.repositoryConfiguration);
        this.identifyHandler = new IdentifyHandler(formatter, this.repositoryConfiguration, this.compressions);
        this.listMetadataFormatsHandler = new ListMetadataFormatsHandler(formatter, this.itemRepository, this.xoaiContext);
        this.listRecordsHandler = new ListRecordsHandler(formatter, this.manager.getMaxListRecordsSize(), this.setRepository, this.itemRepository, this.repositoryConfiguration, this.xoaiContext, this.resumptionTokenFormatter);
        this.listIdentifiersHandler = new ListIdentifiersHandler(formatter, this.manager.getMaxListIdentifiersSize(), this.setRepository, this.itemRepository, this.repositoryConfiguration, this.xoaiContext, this.resumptionTokenFormatter);
        this.listSetsHandler = new ListSetsHandler(formatter, this.manager.getMaxListSetsSize(), this.setRepository, this.xoaiContext, this.resumptionTokenFormatter);
        this.errorHandler = new ErrorHandler();
    }

    public OAIDataProvider(XOAIManager manager, String contexturl, RepositoryConfiguration identify, SetRepository setRepository, ItemRepository itemRepository, ResumptionTokenFormatter format) throws InvalidContextException {
        log.debug((Object)("ContextConfiguration chosen: " + contexturl));
        this.manager = manager;
        this.xoaiContext = this.manager.getContextManager().getOAIContext(contexturl);
        if (this.xoaiContext == null) {
            throw new InvalidContextException("ContextConfiguration \"" + contexturl + "\" does not exist");
        }
        this.repositoryConfiguration = identify;
        this.setRepository = new SetRepositoryHelper(setRepository);
        this.itemRepository = new ItemRepositoryHelper(itemRepository);
        this.compressions = new ArrayList<String>();
        this.resumptionTokenFormatter = format;
        this.getRecordHandler = new GetRecordHandler(formatter, this.xoaiContext, this.itemRepository, this.repositoryConfiguration);
        this.identifyHandler = new IdentifyHandler(formatter, this.repositoryConfiguration, this.compressions);
        this.listMetadataFormatsHandler = new ListMetadataFormatsHandler(formatter, this.itemRepository, this.xoaiContext);
        this.listRecordsHandler = new ListRecordsHandler(formatter, this.manager.getMaxListRecordsSize(), this.setRepository, this.itemRepository, this.repositoryConfiguration, this.xoaiContext, this.resumptionTokenFormatter);
        this.listIdentifiersHandler = new ListIdentifiersHandler(formatter, this.manager.getMaxListIdentifiersSize(), this.setRepository, this.itemRepository, this.repositoryConfiguration, this.xoaiContext, this.resumptionTokenFormatter);
        this.listSetsHandler = new ListSetsHandler(formatter, this.manager.getMaxListSetsSize(), this.setRepository, this.xoaiContext, this.resumptionTokenFormatter);
        this.errorHandler = new ErrorHandler();
    }

    public OAIDataProvider(XOAIManager manager, String contexturl, RepositoryConfiguration identify, SetRepository setRepository, ItemRepository itemRepository, List<String> compressions) throws InvalidContextException {
        this.manager = manager;
        this.xoaiContext = this.manager.getContextManager().getOAIContext(contexturl);
        if (this.xoaiContext == null) {
            throw new InvalidContextException();
        }
        this.repositoryConfiguration = identify;
        this.setRepository = new SetRepositoryHelper(setRepository);
        this.itemRepository = new ItemRepositoryHelper(itemRepository);
        this.compressions = compressions;
        this.resumptionTokenFormatter = new DefaultResumptionTokenFormatter();
        this.getRecordHandler = new GetRecordHandler(formatter, this.xoaiContext, this.itemRepository, this.repositoryConfiguration);
        this.identifyHandler = new IdentifyHandler(formatter, this.repositoryConfiguration, this.compressions);
        this.listMetadataFormatsHandler = new ListMetadataFormatsHandler(formatter, this.itemRepository, this.xoaiContext);
        this.listRecordsHandler = new ListRecordsHandler(formatter, this.manager.getMaxListRecordsSize(), this.setRepository, this.itemRepository, this.repositoryConfiguration, this.xoaiContext, this.resumptionTokenFormatter);
        this.listIdentifiersHandler = new ListIdentifiersHandler(formatter, this.manager.getMaxListIdentifiersSize(), this.setRepository, this.itemRepository, this.repositoryConfiguration, this.xoaiContext, this.resumptionTokenFormatter);
        this.listSetsHandler = new ListSetsHandler(formatter, this.manager.getMaxListSetsSize(), this.setRepository, this.xoaiContext, this.resumptionTokenFormatter);
        this.errorHandler = new ErrorHandler();
    }

    public OAIPMH handle(OAIRequestParameters params) throws OAIException {
        log.debug((Object)"Starting handling OAI request");
        OAIPMH response = new OAIPMH(this.manager);
        OAIPMHtype info = new OAIPMHtype();
        response.setInfo(info);
        RequestType request = new RequestType();
        info.setRequest(request);
        info.setResponseDate(formatter.now());
        request.setValue(this.repositoryConfiguration.getBaseUrl());
        try {
            OAIParameters parameters = new OAIParameters(params, this.resumptionTokenFormatter);
            VerbType verb = parameters.getVerb();
            request.setVerb(verb);
            if (params.getResumptionToken() != null) {
                request.setResumptionToken(params.getResumptionToken());
            }
            if (params.getIdentifier() != null) {
                request.setIdentifier(parameters.getIdentifier());
            }
            if (params.getFrom() != null) {
                try {
                    request.setFrom(formatter.parse(params.getFrom()));
                }
                catch (ParseException e) {
                    throw new BadArgumentException("Invalid date given in from parameter");
                }
            }
            if (params.getMetadataPrefix() != null) {
                request.setMetadataPrefix(params.getMetadataPrefix());
            }
            if (params.getSet() != null) {
                request.setSet(params.getSet());
            }
            if (params.getUntil() != null) {
                try {
                    request.setUntil(formatter.parse(params.getUntil()));
                }
                catch (ParseException e) {
                    throw new BadArgumentException("Invalid date given in until parameter");
                }
            }
            switch (verb) {
                case IDENTIFY: {
                    info.setIdentify(this.identifyHandler.handle(parameters));
                    break;
                }
                case LIST_SETS: {
                    info.setListSets(this.listSetsHandler.handle(parameters));
                    break;
                }
                case LIST_METADATA_FORMATS: {
                    info.setListMetadataFormats(this.listMetadataFormatsHandler.handle(parameters));
                    break;
                }
                case GET_RECORD: {
                    info.setGetRecord(this.getRecordHandler.handle(parameters));
                    break;
                }
                case LIST_IDENTIFIERS: {
                    info.setListIdentifiers(this.listIdentifiersHandler.handle(parameters));
                    break;
                }
                case LIST_RECORDS: {
                    info.setListRecords(this.listRecordsHandler.handle(parameters));
                }
            }
        }
        catch (HandlerException e) {
            log.debug((Object)e.getMessage(), (Throwable)e);
            info.getError().add(this.errorHandler.handle(e));
        }
        return response;
    }

    public void handle(OAIRequestParameters params, OutputStream out) throws OAIException, XMLStreamException, WritingXmlException {
        XmlOutputContext context = XmlOutputContext.emptyContext(out);
        context.getWriter().writeStartDocument();
        this.handle(params).write(context);
        context.getWriter().writeEndDocument();
        context.getWriter().flush();
        context.getWriter().close();
    }
}

