/*
 * Decompiled with CFR 0.152.
 */
package com.lyncode.xoai.dataprovider.core;

import com.lyncode.xoai.dataprovider.core.XOAIContext;
import com.lyncode.xoai.dataprovider.data.internal.MetadataFormat;
import com.lyncode.xoai.dataprovider.data.internal.MetadataTransformer;
import com.lyncode.xoai.dataprovider.exceptions.ConfigurationException;
import com.lyncode.xoai.dataprovider.filter.FilterManager;
import com.lyncode.xoai.dataprovider.format.MetadataFormatManager;
import com.lyncode.xoai.dataprovider.sets.StaticSet;
import com.lyncode.xoai.dataprovider.sets.StaticSetManager;
import com.lyncode.xoai.dataprovider.transform.TransformManager;
import com.lyncode.xoai.dataprovider.xml.xoaiconfig.BundleReference;
import com.lyncode.xoai.dataprovider.xml.xoaiconfig.ContextConfiguration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ContextManager {
    private Map<String, XOAIContext> contexts = new HashMap<String, XOAIContext>();

    public ContextManager(List<ContextConfiguration> contexts, FilterManager filterManager, TransformManager tm, MetadataFormatManager mfm, StaticSetManager sm) throws ConfigurationException {
        for (ContextConfiguration contextConfiguration : contexts) {
            MetadataTransformer transformer = new MetadataTransformer();
            if (contextConfiguration.getTransformers() != null && contextConfiguration.getTransformers().getReference() != null) {
                transformer = tm.getTransformer(contextConfiguration.getTransformers().getReference());
            }
            ArrayList<StaticSet> sets = new ArrayList<StaticSet>();
            for (BundleReference b : contextConfiguration.getSets()) {
                if (!sm.setExists(b.getReference())) {
                    throw new ConfigurationException("Set referred as " + b.getReference() + " does not exist");
                }
                sets.add(sm.getSet(b.getReference()));
            }
            ArrayList<MetadataFormat> formats = new ArrayList<MetadataFormat>();
            for (BundleReference b : contextConfiguration.getFormats()) {
                if (!mfm.formatExists(b.getReference())) {
                    throw new ConfigurationException("Metadata FormatConfiguration referred as " + b.getReference() + " does not exist");
                }
                formats.add(mfm.getFormat(b.getReference()));
            }
            XOAIContext xoaiContext = new XOAIContext(contextConfiguration.getBaseUrl(), contextConfiguration.getName(), contextConfiguration.getDescription(), transformer, formats, sets);
            if (contextConfiguration.hasFilter()) {
                xoaiContext.setCondition(filterManager.getFilter(contextConfiguration.getFilters().getReference()));
            }
            this.contexts.put(contextConfiguration.getBaseUrl(), xoaiContext);
        }
    }

    public boolean contextExists(String baseUrl) {
        return this.contexts.containsKey(baseUrl);
    }

    public XOAIContext getOAIContext(String baseUrl) {
        return this.contexts.get(baseUrl);
    }

    public Collection<XOAIContext> getContexts() {
        return this.contexts.values();
    }
}

