/*
 * Decompiled with CFR 0.152.
 */
package com.lyncode.xoai.dataprovider.core;

import com.lyncode.xoai.dataprovider.core.ContextManager;
import com.lyncode.xoai.dataprovider.exceptions.ConfigurationException;
import com.lyncode.xoai.dataprovider.filter.FilterManager;
import com.lyncode.xoai.dataprovider.format.MetadataFormatManager;
import com.lyncode.xoai.dataprovider.services.api.FilterResolver;
import com.lyncode.xoai.dataprovider.services.api.ResourceResolver;
import com.lyncode.xoai.dataprovider.sets.StaticSetManager;
import com.lyncode.xoai.dataprovider.transform.TransformManager;
import com.lyncode.xoai.dataprovider.xml.xoaiconfig.Configuration;

public class XOAIManager {
    private FilterManager filter;
    private ContextManager context;
    private TransformManager transformer;
    private MetadataFormatManager format;
    private StaticSetManager set;
    private int listSetsSize;
    private int listRecordsSize;
    private int listIdentifiersSize;
    private boolean identation;
    private String styleSheet;
    private FilterResolver filterResolver;

    public XOAIManager(FilterResolver filterResolver, ResourceResolver resolver, Configuration config) throws ConfigurationException {
        this.filterResolver = filterResolver;
        this.filter = new FilterManager(filterResolver, config.getFilters(), config.getConditions());
        this.transformer = new TransformManager(resolver, config.getTransformers());
        this.format = new MetadataFormatManager(resolver, config.getFormats(), this.filter);
        this.set = new StaticSetManager(config.getSets(), this.filter);
        this.listSetsSize = config.getMaxListSetsSize();
        this.listIdentifiersSize = config.getMaxListRecordsSize();
        this.listRecordsSize = config.getMaxListRecordsSize();
        this.identation = config.getIndented();
        this.styleSheet = config.getStylesheet();
        this.context = new ContextManager(config.getContexts(), this.filter, this.transformer, this.format, this.set);
    }

    public boolean hasStyleSheet() {
        return this.styleSheet != null;
    }

    public String getStyleSheet() {
        return this.styleSheet;
    }

    public ContextManager getContextManager() {
        return this.context;
    }

    public FilterManager getFilterManager() {
        return this.filter;
    }

    public MetadataFormatManager getFormatManager() {
        return this.format;
    }

    public StaticSetManager getSetManager() {
        return this.set;
    }

    public TransformManager getTransformerManager() {
        return this.transformer;
    }

    public int getMaxListIdentifiersSize() {
        return this.listIdentifiersSize;
    }

    public int getMaxListRecordsSize() {
        return this.listRecordsSize;
    }

    public int getMaxListSetsSize() {
        return this.listSetsSize;
    }

    public boolean isIndentated() {
        return this.identation;
    }
}

