/*
 * Decompiled with CFR 0.152.
 */
package com.lyncode.xoai.dataprovider.data.internal;

import com.lyncode.xoai.dataprovider.data.ItemIdentifier;
import com.lyncode.xoai.dataprovider.filter.conditions.Condition;
import javax.xml.transform.Transformer;

public class MetadataFormat {
    private String prefix;
    private Transformer xsltTransformer;
    private String namespace;
    private String schemaLocation;
    private Condition filter;

    public MetadataFormat(String prefix, Transformer transformer, String namespace, String schemaLocation) {
        this.prefix = prefix;
        this.xsltTransformer = transformer;
        this.namespace = namespace;
        this.schemaLocation = schemaLocation;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public Transformer getTransformer() {
        return this.xsltTransformer;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public String getSchemaLocation() {
        return this.schemaLocation;
    }

    public boolean isApplicable(ItemIdentifier item) {
        if (item.isDeleted()) {
            return true;
        }
        if (this.hasCondition()) {
            return this.getCondition().getFilter().isItemShown(item);
        }
        return true;
    }

    public Condition getCondition() {
        return this.filter;
    }

    public boolean hasCondition() {
        return this.filter != null;
    }

    public void setFilter(Condition filter) {
        this.filter = filter;
    }
}

