/*
 * Decompiled with CFR 0.152.
 */
package com.lyncode.xoai.dataprovider.handlers;

import com.lyncode.xoai.dataprovider.core.ListItemIdentifiersResult;
import com.lyncode.xoai.dataprovider.core.OAIParameters;
import com.lyncode.xoai.dataprovider.core.ReferenceSet;
import com.lyncode.xoai.dataprovider.core.ResumptionToken;
import com.lyncode.xoai.dataprovider.core.XOAIContext;
import com.lyncode.xoai.dataprovider.data.ItemIdentifier;
import com.lyncode.xoai.dataprovider.data.internal.ItemIdentifyHelper;
import com.lyncode.xoai.dataprovider.data.internal.ItemRepositoryHelper;
import com.lyncode.xoai.dataprovider.data.internal.MetadataFormat;
import com.lyncode.xoai.dataprovider.data.internal.SetRepositoryHelper;
import com.lyncode.xoai.dataprovider.exceptions.BadArgumentException;
import com.lyncode.xoai.dataprovider.exceptions.CannotDisseminateFormatException;
import com.lyncode.xoai.dataprovider.exceptions.CannotDisseminateRecordException;
import com.lyncode.xoai.dataprovider.exceptions.DoesNotSupportSetsException;
import com.lyncode.xoai.dataprovider.exceptions.HandlerException;
import com.lyncode.xoai.dataprovider.exceptions.NoMatchesException;
import com.lyncode.xoai.dataprovider.exceptions.NoMetadataFormatsException;
import com.lyncode.xoai.dataprovider.exceptions.OAIException;
import com.lyncode.xoai.dataprovider.handlers.VerbHandler;
import com.lyncode.xoai.dataprovider.services.api.DateProvider;
import com.lyncode.xoai.dataprovider.services.api.RepositoryConfiguration;
import com.lyncode.xoai.dataprovider.services.api.ResumptionTokenFormatter;
import com.lyncode.xoai.dataprovider.xml.oaipmh.HeaderType;
import com.lyncode.xoai.dataprovider.xml.oaipmh.ListIdentifiersType;
import com.lyncode.xoai.dataprovider.xml.oaipmh.ResumptionTokenType;
import com.lyncode.xoai.dataprovider.xml.oaipmh.StatusType;
import java.util.List;

public class ListIdentifiersHandler
extends VerbHandler<ListIdentifiersType> {
    private final int maxListSize;
    private SetRepositoryHelper setRepository;
    private ItemRepositoryHelper itemRepositoryHelper;
    private RepositoryConfiguration identify;
    private XOAIContext context;
    private ResumptionTokenFormatter resumptionFormat;

    public ListIdentifiersHandler(DateProvider formatter, int maxListSize, SetRepositoryHelper setRepository, ItemRepositoryHelper itemRepositoryHelper, RepositoryConfiguration identify, XOAIContext context, ResumptionTokenFormatter _format) {
        super(formatter);
        this.maxListSize = maxListSize;
        this.setRepository = setRepository;
        this.itemRepositoryHelper = itemRepositoryHelper;
        this.identify = identify;
        this.context = context;
        this.resumptionFormat = _format;
    }

    @Override
    public ListIdentifiersType handle(OAIParameters parameters) throws OAIException, HandlerException {
        ListItemIdentifiersResult result;
        ListIdentifiersType res = new ListIdentifiersType();
        ResumptionToken token = parameters.getResumptionToken();
        if (parameters.hasSet() && !this.setRepository.supportSets()) {
            throw new DoesNotSupportSetsException();
        }
        int length = this.maxListSize;
        if (!parameters.hasSet()) {
            result = parameters.hasFrom() && !parameters.hasUntil() ? this.itemRepositoryHelper.getItemIdentifiers(this.context, token.getOffset(), length, parameters.getMetadataPrefix(), parameters.getFrom()) : (!parameters.hasFrom() && parameters.hasUntil() ? this.itemRepositoryHelper.getItemIdentifiersUntil(this.context, token.getOffset(), length, parameters.getMetadataPrefix(), parameters.getUntil()) : (parameters.hasFrom() && parameters.hasUntil() ? this.itemRepositoryHelper.getItemIdentifiers(this.context, token.getOffset(), length, parameters.getMetadataPrefix(), parameters.getFrom(), parameters.getUntil()) : this.itemRepositoryHelper.getItemIdentifiers(this.context, token.getOffset(), length, parameters.getMetadataPrefix())));
        } else {
            if (!this.setRepository.exists(this.context, parameters.getSet())) {
                throw new NoMatchesException();
            }
            result = parameters.hasFrom() && !parameters.hasUntil() ? this.itemRepositoryHelper.getItemIdentifiers(this.context, token.getOffset(), length, parameters.getMetadataPrefix(), parameters.getSet(), parameters.getFrom()) : (!parameters.hasFrom() && parameters.hasUntil() ? this.itemRepositoryHelper.getItemIdentifiersUntil(this.context, token.getOffset(), length, parameters.getMetadataPrefix(), parameters.getSet(), parameters.getUntil()) : (parameters.hasFrom() && parameters.hasUntil() ? this.itemRepositoryHelper.getItemIdentifiers(this.context, token.getOffset(), length, parameters.getMetadataPrefix(), parameters.getSet(), parameters.getFrom(), parameters.getUntil()) : this.itemRepositoryHelper.getItemIdentifiers(this.context, token.getOffset(), length, parameters.getMetadataPrefix(), parameters.getSet())));
        }
        List<ItemIdentifier> results = result.getResults();
        if (results.isEmpty()) {
            throw new NoMatchesException();
        }
        ResumptionToken newToken = result.hasMore() ? new ResumptionToken(token.getOffset() + length, parameters) : new ResumptionToken();
        if (parameters.hasResumptionToken() || !newToken.isEmpty()) {
            ResumptionTokenType resToken = new ResumptionTokenType();
            if (!newToken.isEmpty()) {
                resToken.setValue(this.resumptionFormat.format(newToken));
            }
            resToken.setCursor(token.getOffset() / this.maxListSize);
            if (result.hasTotalResults()) {
                resToken.setCompleteListSize(result.getTotal());
            }
            res.setResumptionToken(resToken);
        }
        for (ItemIdentifier itemIdentifier : results) {
            res.getHeader().add(this.createHeader(parameters, itemIdentifier));
        }
        return res;
    }

    private HeaderType createHeader(OAIParameters parameters, ItemIdentifier itemIdentifier) throws BadArgumentException, CannotDisseminateRecordException, OAIException, NoMetadataFormatsException, CannotDisseminateFormatException {
        MetadataFormat format = this.context.getFormatByPrefix(parameters.getMetadataPrefix());
        if (!itemIdentifier.isDeleted() && !format.isApplicable(itemIdentifier)) {
            throw new CannotDisseminateRecordException();
        }
        HeaderType header = new HeaderType();
        header.setDatestamp(this.getFormatter().format(itemIdentifier.getDatestamp(), this.identify.getGranularity()));
        header.setIdentifier(itemIdentifier.getIdentifier());
        if (itemIdentifier.isDeleted()) {
            header.setStatus(StatusType.DELETED);
        }
        ItemIdentifyHelper ident = new ItemIdentifyHelper(itemIdentifier);
        for (ReferenceSet s : ident.getSets(this.context)) {
            header.getSetSpec().add(s.getSetSpec());
        }
        return header;
    }
}

