/*
 * Decompiled with CFR 0.152.
 */
package com.lyncode.xoai.dataprovider.transform;

import com.lyncode.xoai.dataprovider.data.internal.MetadataTransformer;
import com.lyncode.xoai.dataprovider.exceptions.ConfigurationException;
import com.lyncode.xoai.dataprovider.services.api.ResourceResolver;
import com.lyncode.xoai.dataprovider.transform.XSLTransformer;
import com.lyncode.xoai.dataprovider.xml.xoaiconfig.TransformerConfiguration;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.transform.TransformerConfigurationException;

public class TransformManager {
    private Map<String, MetadataTransformer> _contexts = new HashMap<String, MetadataTransformer>();

    public TransformManager(ResourceResolver resolver, List<TransformerConfiguration> transformerConfigurations) throws ConfigurationException {
        if (transformerConfigurations != null) {
            for (TransformerConfiguration t : transformerConfigurations) {
                try {
                    this._contexts.put(t.getId(), new MetadataTransformer(new XSLTransformer(resolver.getTransformer(t.getXslt()))));
                }
                catch (TransformerConfigurationException e) {
                    throw new ConfigurationException(e.getMessage(), e);
                }
                catch (IOException e) {
                    throw new ConfigurationException(e.getMessage(), e);
                }
            }
        }
    }

    public boolean transformerExists(String id) {
        return this._contexts.containsKey(id);
    }

    public MetadataTransformer getTransformer(String id) {
        return this._contexts.get(id);
    }
}

