/*
 * Decompiled with CFR 0.152.
 */
package com.lyncode.xoai.dataprovider.xml.xoaiconfig;

import com.google.common.base.Function;
import com.lyncode.builder.ListBuilder;
import com.lyncode.xoai.dataprovider.exceptions.WritingXmlException;
import com.lyncode.xoai.dataprovider.xml.XMLWritable;
import com.lyncode.xoai.dataprovider.xml.XmlOutputContext;
import com.lyncode.xoai.dataprovider.xml.xoaiconfig.BundleReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.xml.stream.XMLStreamException;

public class ContextConfiguration
implements XMLWritable {
    private BundleReference transformers;
    private BundleReference filters;
    private List<BundleReference> sets = new ArrayList<BundleReference>();
    private List<BundleReference> formats = new ArrayList<BundleReference>();
    private String description;
    private String name;
    private String baseUrl;

    public ContextConfiguration(String baseUrl) {
        this.baseUrl = baseUrl;
    }

    public BundleReference getTransformers() {
        return this.transformers;
    }

    public BundleReference getFilters() {
        return this.filters;
    }

    public List<BundleReference> getSets() {
        return this.sets;
    }

    public String getDescription() {
        return this.description;
    }

    public String getName() {
        return this.name;
    }

    public String getBaseUrl() {
        return this.baseUrl;
    }

    public List<BundleReference> getFormats() {
        return this.formats;
    }

    public ContextConfiguration withTransformer(String transformerId) {
        this.transformers = new BundleReference(transformerId);
        return this;
    }

    public ContextConfiguration withFilter(String filterId) {
        this.filters = new BundleReference(filterId);
        return this;
    }

    public ContextConfiguration withSets(Collection<String> setsIds) {
        this.sets.addAll(new ListBuilder().add(setsIds).build((Function)new Function<String, BundleReference>(){

            public BundleReference apply(String elem) {
                return new BundleReference(elem);
            }
        }));
        return this;
    }

    public ContextConfiguration withSets(String ... setsIds) {
        this.sets.addAll(new ListBuilder().add((Object[])setsIds).build((Function)new Function<String, BundleReference>(){

            public BundleReference apply(String elem) {
                return new BundleReference(elem);
            }
        }));
        return this;
    }

    public ContextConfiguration withSet(String setId) {
        this.sets.add(new BundleReference(setId));
        return this;
    }

    public ContextConfiguration withFormats(Collection<String> formats) {
        this.formats.addAll(new ListBuilder().add(formats).build((Function)new Function<String, BundleReference>(){

            public BundleReference apply(String elem) {
                return new BundleReference(elem);
            }
        }));
        return this;
    }

    public ContextConfiguration withFormats(String ... formats) {
        this.formats.addAll(new ListBuilder().add((Object[])formats).build((Function)new Function<String, BundleReference>(){

            public BundleReference apply(String elem) {
                return new BundleReference(elem);
            }
        }));
        return this;
    }

    public ContextConfiguration withFormat(String formatId) {
        this.formats.add(new BundleReference(formatId));
        return this;
    }

    public ContextConfiguration withDescription(String description) {
        this.description = description;
        return this;
    }

    public ContextConfiguration withName(String name) {
        this.name = name;
        return this;
    }

    @Override
    public void write(XmlOutputContext writer) throws WritingXmlException {
        this.validate();
        try {
            writer.getWriter().writeStartElement("Context");
            writer.getWriter().writeAttribute("baseurl", this.baseUrl);
            if (this.hasName()) {
                writer.getWriter().writeAttribute("name", this.name);
            }
            if (this.hasTransformer()) {
                writer.getWriter().writeStartElement("Transformer");
                this.transformers.write(writer);
                writer.getWriter().writeEndElement();
            }
            if (this.hasFilter()) {
                writer.getWriter().writeStartElement("Filter");
                this.filters.write(writer);
                writer.getWriter().writeEndElement();
            }
            if (this.hasSets()) {
                for (BundleReference setReference : this.sets) {
                    writer.getWriter().writeStartElement("Set");
                    setReference.write(writer);
                    writer.getWriter().writeEndElement();
                }
            }
            for (BundleReference formatReference : this.formats) {
                writer.getWriter().writeStartElement("Format");
                formatReference.write(writer);
                writer.getWriter().writeEndElement();
            }
            if (this.hasDescription()) {
                writer.getWriter().writeStartElement("Description");
                writer.getWriter().writeCharacters(this.description);
                writer.getWriter().writeEndElement();
            }
            writer.getWriter().writeEndElement();
        }
        catch (XMLStreamException e) {
            throw new WritingXmlException(e);
        }
    }

    public boolean hasDescription() {
        return this.description != null;
    }

    public boolean hasSets() {
        return this.sets != null && !this.sets.isEmpty();
    }

    public boolean hasFilter() {
        return this.filters != null;
    }

    public boolean hasTransformer() {
        return this.transformers != null;
    }

    private boolean hasName() {
        return this.name != null;
    }

    private void validate() throws WritingXmlException {
        if (this.baseUrl == null) {
            throw new WritingXmlException("ContextConfiguration baseUrl is mandatory");
        }
        if (this.formats == null || this.formats.isEmpty()) {
            throw new WritingXmlException("ContextConfiguration must contain at least one FormatConfiguration");
        }
    }
}

