/*
 * Decompiled with CFR 0.152.
 */
package com.lyncode.xoai.serviceprovider.oaipmh;

import com.lyncode.xoai.serviceprovider.OAIServiceConfiguration;
import com.lyncode.xoai.serviceprovider.exceptions.ParseException;
import com.lyncode.xoai.serviceprovider.oaipmh.ElementParser;
import com.lyncode.xoai.serviceprovider.oaipmh.ResumptionTokenParser;
import com.lyncode.xoai.serviceprovider.oaipmh.SetParser;
import com.lyncode.xoai.serviceprovider.oaipmh.spec.ListSetsType;
import com.lyncode.xoai.serviceprovider.oaipmh.spec.ResumptionTokenType;
import com.lyncode.xoai.serviceprovider.oaipmh.spec.SetType;
import com.lyncode.xoai.serviceprovider.parser.AboutItemParser;
import com.lyncode.xoai.serviceprovider.parser.AboutSetParser;
import com.lyncode.xoai.serviceprovider.parser.DescriptionParser;
import com.lyncode.xoai.serviceprovider.parser.MetadataParser;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLStreamException;

public class ListSetsParser
extends ElementParser<ListSetsType> {
    public static final String NAME = "ListSets";
    private SetParser setParser;
    private ResumptionTokenParser resParser;

    public ListSetsParser(OAIServiceConfiguration<MetadataParser, AboutItemParser, DescriptionParser, AboutSetParser> oaiServiceConfiguration) {
        super(oaiServiceConfiguration);
        this.setParser = new SetParser(oaiServiceConfiguration);
        this.resParser = new ResumptionTokenParser(oaiServiceConfiguration);
    }

    @Override
    protected ListSetsType parseElement(XMLEventReader reader) throws ParseException {
        ListSetsType result = new ListSetsType();
        try {
            if (!reader.peek().asStartElement().getName().getLocalPart().equals(NAME)) {
                throw new ParseException("Expected ListSets element");
            }
            reader.nextEvent();
            this.nextElement(reader);
            while (reader.peek().asStartElement().getName().getLocalPart().equals("set")) {
                result.getSet().add((SetType)this.setParser.parse(reader));
            }
            result.setResumptionToken((ResumptionTokenType)this.resParser.parse(reader));
        }
        catch (XMLStreamException e) {
            throw new ParseException(e);
        }
        return result;
    }
}

