/*
 * Decompiled with CFR 0.152.
 */
package com.lyncode.xoai.serviceprovider.verbs.runners;

import com.lyncode.xoai.serviceprovider.OAIServiceConfiguration;
import com.lyncode.xoai.serviceprovider.core.Parameters;
import com.lyncode.xoai.serviceprovider.exceptions.InternalHarvestException;
import com.lyncode.xoai.serviceprovider.exceptions.ParseException;
import com.lyncode.xoai.serviceprovider.oaipmh.OAIPMHParser;
import com.lyncode.xoai.serviceprovider.oaipmh.spec.OAIPMHtype;
import com.lyncode.xoai.serviceprovider.oaipmh.spec.RecordType;
import com.lyncode.xoai.serviceprovider.parser.AboutItemParser;
import com.lyncode.xoai.serviceprovider.parser.AboutSetParser;
import com.lyncode.xoai.serviceprovider.parser.DescriptionParser;
import com.lyncode.xoai.serviceprovider.parser.MetadataParser;
import com.lyncode.xoai.util.ProcessingQueue;
import java.io.IOException;
import java.io.InputStream;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.StatusLine;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.DefaultHttpClient;

public class RetrieveListRecords
implements Runnable {
    private ProcessingQueue<RecordType> queue;
    private Parameters parameters;
    private OAIServiceConfiguration<MetadataParser, AboutItemParser, DescriptionParser, AboutSetParser> config;

    public RetrieveListRecords(ProcessingQueue<RecordType> list, OAIServiceConfiguration<MetadataParser, AboutItemParser, DescriptionParser, AboutSetParser> config, Parameters params) {
        this.queue = list;
        this.config = config;
        this.parameters = params;
    }

    private String makeUrl(String resumption) {
        return this.parameters.toUrl(resumption);
    }

    @Override
    public void run() {
        try {
            long timeBefore = System.currentTimeMillis();
            String resumption = null;
            resumption = this.harvest(this.makeUrl(resumption));
            long timeAfter = System.currentTimeMillis();
            if (timeAfter - timeBefore < (long)this.config.getIntervalBetweenRequests()) {
                Thread.sleep((long)this.config.getIntervalBetweenRequests() - (timeAfter - timeBefore));
            }
            while (resumption != null) {
                timeBefore = System.currentTimeMillis();
                resumption = this.harvest(this.makeUrl(resumption));
                timeAfter = System.currentTimeMillis();
                if (timeAfter - timeBefore >= (long)this.config.getIntervalBetweenRequests()) continue;
                Thread.sleep((long)this.config.getIntervalBetweenRequests() - (timeAfter - timeBefore));
            }
            this.queue.finish();
        }
        catch (InternalHarvestException e) {
            this.config.getLogger().error((Object)"Internal error", (Throwable)e);
            this.queue.finish();
        }
        catch (InterruptedException e) {
            this.config.getLogger().error((Object)"Internal error", (Throwable)e);
            this.queue.finish();
        }
    }

    private String harvest(String url) throws InternalHarvestException {
        DefaultHttpClient httpclient = new DefaultHttpClient();
        this.config.getLogger().info((Object)("Harvesting: " + url));
        HttpGet httpget = new HttpGet(url);
        httpget.addHeader("User-Agent", this.config.getServiceName() + " : XOAI Service Provider");
        httpget.addHeader("From", this.config.getServiceName());
        HttpResponse response = null;
        try {
            HttpEntity entity;
            InputStream instream;
            OAIPMHtype res;
            response = httpclient.execute((HttpUriRequest)httpget);
            StatusLine status = response.getStatusLine();
            this.config.getLogger().debug((Object)response.getStatusLine());
            if (status.getStatusCode() == 503) {
                Header[] headers;
                for (Header header : headers = response.getAllHeaders()) {
                    if (!header.getName().equals("Retry-After")) continue;
                    String retry_time = header.getValue();
                    try {
                        Thread.sleep(Integer.parseInt(retry_time) * 1000);
                    }
                    catch (NumberFormatException e) {
                        this.config.getLogger().warn((Object)("Cannot parse " + retry_time + " to Integer"), (Throwable)e);
                    }
                    catch (InterruptedException e) {
                        this.config.getLogger().debug((Object)e.getMessage(), (Throwable)e);
                    }
                    httpclient.getConnectionManager().shutdown();
                    httpclient = new DefaultHttpClient();
                    response = httpclient.execute((HttpUriRequest)httpget);
                }
            }
            if ((res = OAIPMHParser.parse(instream = (entity = response.getEntity()).getContent(), this.config)).getListRecords() != null) {
                for (RecordType recordType : res.getListRecords().getRecord()) {
                    this.queue.enqueue(recordType);
                }
                if (res.getListRecords().getResumptionToken() != null) {
                    String result = res.getListRecords().getResumptionToken().getValue();
                    if (result != null && result.trim().equals("")) {
                        return null;
                    }
                    return result;
                }
            }
            return null;
        }
        catch (IOException e) {
            throw new InternalHarvestException(e);
        }
        catch (ParseException e) {
            throw new InternalHarvestException(e);
        }
    }
}

