/*
 * Decompiled with CFR 0.152.
 */
package com.lyncode.xoai.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;

public class XSLPipeline {
    private InputStream inputStream;
    private ByteArrayOutputStream outputStream;
    private boolean omitXMLDeclaration;

    public XSLPipeline(InputStream inputStream, boolean omitXMLDeclaration) {
        this.inputStream = inputStream;
        this.omitXMLDeclaration = omitXMLDeclaration;
    }

    public XSLPipeline apply(Transformer xslTransformer) throws TransformerException {
        this.outputStream = new ByteArrayOutputStream();
        xslTransformer.setOutputProperty("omit-xml-declaration", this.omitXMLDeclaration ? "yes" : "no");
        xslTransformer.transform(new StreamSource(this.inputStream), new StreamResult(this.outputStream));
        this.inputStream = new ByteArrayInputStream(this.outputStream.toByteArray());
        return this;
    }

    public InputStream getTransformed() {
        return this.inputStream;
    }
}

