/*
 * Decompiled with CFR 0.152.
 */
package org.dstadler.commons.email;

import com.dumbster.smtp.SmtpMessage;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import org.dstadler.commons.email.SafeCloseSmtpServer;
import org.dstadler.commons.net.SocketUtils;

public class MockSMTPServer
implements AutoCloseable {
    private static final int PORT_RANGE_START = 15110;
    private static final int PORT_RANGE_END = 15119;
    private SafeCloseSmtpServer server;
    private int port = -1;

    public void start() throws IOException {
        this.port = SocketUtils.getNextFreePort((int)15110, (int)15119);
        this.server = SafeCloseSmtpServer.start(this.port);
    }

    public boolean isRunning() {
        return this.server != null && !this.server.isStopped();
    }

    public void stop() {
        this.port = -1;
        this.server.stop();
    }

    public int getPort() {
        return this.port;
    }

    public int getMessageCount() {
        return this.server.getReceivedEmailSize();
    }

    public Iterator<String> getMessages() {
        Iterator<SmtpMessage> it = this.server.getReceivedEmail();
        ArrayList<String> msgs = new ArrayList<String>();
        while (it.hasNext()) {
            SmtpMessage msg = it.next();
            msgs.add(msg.toString());
        }
        return msgs.iterator();
    }

    @Override
    public void close() {
        this.stop();
    }
}

