/*
 * Decompiled with CFR 0.152.
 */
package org.dstadler.commons.email;

import com.dumbster.smtp.SmtpActionType;
import com.dumbster.smtp.SmtpMessage;
import com.dumbster.smtp.SmtpRequest;
import com.dumbster.smtp.SmtpResponse;
import com.dumbster.smtp.SmtpState;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.ServerSocket;
import java.net.Socket;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Semaphore;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class SafeCloseSmtpServer
implements Runnable {
    private static final Logger log = Logger.getLogger(SafeCloseSmtpServer.class.getName());
    private static final int MAXIMUM_CONCURRENT_READERS = 100;
    private static final int TIMEOUT = 500;
    private final CountDownLatch startupBarrier = new CountDownLatch(1);
    private final List<SmtpMessage> receivedMail;
    private volatile boolean stopped = true;
    private ServerSocket serverSocket;
    private final int port;
    private final Semaphore semaphore = new Semaphore(100);

    private SafeCloseSmtpServer(int port) {
        this.receivedMail = new ArrayList<SmtpMessage>();
        this.port = port;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        this.stopped = false;
        try {
            try {
                this.serverSocket = new ServerSocket(this.port);
                this.serverSocket.setSoTimeout(500);
            }
            finally {
                this.startupBarrier.countDown();
            }
            while (!this.isStopped()) {
                Socket socket;
                if (!this.semaphore.tryAcquire()) {
                    throw new IllegalStateException("Could not get semaphore, number of possible threads is too low.");
                }
                try {
                    socket = this.serverSocket.accept();
                }
                catch (Exception e) {
                    this.semaphore.release();
                    continue;
                }
                try {
                    BufferedReader input = new BufferedReader(new InputStreamReader(socket.getInputStream(), StandardCharsets.UTF_8));
                    PrintWriter out = new PrintWriter(socket.getOutputStream());
                    SafeCloseSmtpServer safeCloseSmtpServer = this;
                    synchronized (safeCloseSmtpServer) {
                        List<SmtpMessage> messages = this.handleTransaction(out, input);
                        this.receivedMail.addAll(messages);
                    }
                    socket.close();
                }
                finally {
                    this.semaphore.release();
                }
            }
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "Caught exception: ", e);
        }
        finally {
            if (this.serverSocket != null) {
                try {
                    this.serverSocket.close();
                }
                catch (IOException e) {
                    log.log(Level.SEVERE, "Caught exception: ", e);
                }
            }
        }
    }

    public boolean isStopped() {
        return this.stopped;
    }

    public synchronized void stop() {
        if (this.isStopped()) {
            return;
        }
        this.stopped = true;
        try {
            this.serverSocket.close();
            this.semaphore.acquireUninterruptibly(100);
            this.semaphore.release(100);
        }
        catch (IOException e) {
            log.log(Level.SEVERE, "Caught exception: ", e);
        }
    }

    private List<SmtpMessage> handleTransaction(PrintWriter out, BufferedReader input) throws IOException {
        String line;
        SmtpState smtpState = SmtpState.CONNECT;
        SmtpRequest smtpRequest = new SmtpRequest(SmtpActionType.CONNECT, "", smtpState);
        SmtpResponse smtpResponse = smtpRequest.execute();
        SafeCloseSmtpServer.sendResponse(out, smtpResponse);
        smtpState = smtpResponse.getNextState();
        ArrayList<SmtpMessage> msgList = new ArrayList<SmtpMessage>();
        SmtpMessage msg = new SmtpMessage();
        while (smtpState != SmtpState.CONNECT && (line = input.readLine()) != null) {
            SmtpRequest request = SmtpRequest.createRequest((String)line, (SmtpState)smtpState);
            SmtpResponse response = request.execute();
            smtpState = response.getNextState();
            SafeCloseSmtpServer.sendResponse(out, response);
            String params = request.getParams();
            msg.store(response, params);
            if (smtpState != SmtpState.QUIT) continue;
            msgList.add(msg);
            msg = new SmtpMessage();
        }
        return msgList;
    }

    private static void sendResponse(PrintWriter out, SmtpResponse smtpResponse) {
        if (smtpResponse.getCode() > 0) {
            int code = smtpResponse.getCode();
            String message = smtpResponse.getMessage();
            out.print(code + " " + message + "\r\n");
            out.flush();
        }
    }

    public synchronized Iterator<SmtpMessage> getReceivedEmail() {
        return this.receivedMail.iterator();
    }

    public synchronized int getReceivedEmailSize() {
        return this.receivedMail.size();
    }

    public static SafeCloseSmtpServer start(int port) {
        SafeCloseSmtpServer server = new SafeCloseSmtpServer(port);
        Thread t = new Thread((Runnable)server, "Mock SMTP Server Thread");
        t.start();
        try {
            server.startupBarrier.await();
        }
        catch (InterruptedException e) {
            log.log(Level.WARNING, "Interrupted", e);
        }
        return server;
    }
}

