/*
 * Decompiled with CFR 0.152.
 */
package org.dstadler.commons.testing;

import com.sun.management.HotSpotDiagnosticMXBean;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import org.dstadler.commons.util.SuppressForbidden;

@SuppressForbidden(reason="This class can only work when using internal hotspot functionality")
public class HeapDump {
    private static final String HOTSPOT_BEAN_NAME = "com.sun.management:type=HotSpotDiagnostic";
    private static volatile HotSpotDiagnosticMXBean hotspotMBean;

    public static void dumpHeap(String fileName, boolean live) throws IOException {
        HeapDump.initHotspotMBean();
        hotspotMBean.dumpHeap(fileName, live);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void initHotspotMBean() throws IOException {
        if (hotspotMBean != null) return;
        Class<HeapDump> clazz = HeapDump.class;
        synchronized (HeapDump.class) {
            if (hotspotMBean != null) return;
            hotspotMBean = HeapDump.getHotspotMBean();
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    private static HotSpotDiagnosticMXBean getHotspotMBean() throws IOException {
        return ManagementFactory.newPlatformMXBeanProxy(ManagementFactory.getPlatformMBeanServer(), HOTSPOT_BEAN_NAME, HotSpotDiagnosticMXBean.class);
    }
}

