/*
 * Decompiled with CFR 0.152.
 */
package org.dstadler.commons.testing;

import java.io.IOException;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.List;
import org.dstadler.commons.testing.HeapDump;
import org.junit.jupiter.api.Assertions;

public class MemoryLeakVerifier {
    private static final int MAX_GC_ITERATIONS = 50;
    private static final int GC_SLEEP_TIME = 100;
    protected static final String HEAP_DUMP_FILE_NAME = "MemoryLeakVerifier.hprof";
    private final List<WeakReference<Object>> references = new ArrayList<WeakReference<Object>>();
    private boolean dumpHeap = true;

    public void setHeapDump(boolean dumpHeap) {
        this.dumpHeap = dumpHeap;
    }

    public void addObject(Object object) {
        this.references.add(new WeakReference<Object>(object));
    }

    public void assertGarbageCollected() {
        this.assertGarbageCollected(50);
    }

    void assertGarbageCollected(int maxIterations) {
        try {
            for (WeakReference<Object> ref : this.references) {
                MemoryLeakVerifier.assertGarbageCollected(ref, maxIterations, this.dumpHeap);
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private static void assertGarbageCollected(WeakReference<Object> ref, int maxIterations, boolean dumpHeap) throws InterruptedException {
        if (ref.get() == null) {
            return;
        }
        Runtime runtime = Runtime.getRuntime();
        for (int i = 0; i < maxIterations; ++i) {
            runtime.runFinalization();
            runtime.gc();
            if (ref.get() == null) {
                return;
            }
            Thread.sleep(100L);
        }
        if (dumpHeap && ref.get() != null) {
            try {
                HeapDump.dumpHeap(HEAP_DUMP_FILE_NAME, true);
            }
            catch (IOException e) {
                throw new IllegalStateException("Failed to write heap-dump to MemoryLeakVerifier.hprof", e);
            }
        }
        Assertions.assertNull(ref.get(), (String)("Object should not exist after 50 collections" + (dumpHeap ? ", a heap-dump was written to MemoryLeakVerifier.hprof" : "")));
    }
}

