/*
 * Decompiled with CFR 0.152.
 */
package org.dstadler.commons.testing;

import java.io.Closeable;
import java.io.IOException;
import java.net.ServerSocket;
import java.util.Properties;
import java.util.concurrent.Callable;
import java.util.logging.Logger;
import org.dstadler.commons.http.NanoHTTPD;

public class MockRESTServer
implements Closeable {
    private static final Logger log = Logger.getLogger(MockRESTServer.class.getName());
    private static final int PORT_RANGE_START = 15100;
    private static final int PORT_RANGE_END = 15110;
    private final NanoHTTPD httpd;
    private final int port = MockRESTServer.getNextFreePort();

    public MockRESTServer(final String status, final String mime, final String msg) throws IOException {
        this.httpd = new NanoHTTPD(this.port){

            public NanoHTTPD.Response serve(String uri, String method, Properties header, Properties params) {
                return new NanoHTTPD.Response(status, mime, msg);
            }
        };
    }

    public MockRESTServer(final Runnable response, final String status, final String mime, final String msg) throws IOException {
        this.httpd = new NanoHTTPD(this.port){

            public NanoHTTPD.Response serve(String uri, String method, Properties header, Properties params) {
                response.run();
                return new NanoHTTPD.Response(status, mime, msg);
            }
        };
    }

    public MockRESTServer(final Callable<NanoHTTPD.Response> response) throws IOException {
        this.httpd = new NanoHTTPD(this.port){

            public NanoHTTPD.Response serve(String uri, String method, Properties header, Properties params) {
                try {
                    return (NanoHTTPD.Response)response.call();
                }
                catch (Exception e) {
                    throw new IllegalStateException(e);
                }
            }
        };
    }

    private static int getNextFreePort() throws IOException {
        for (int port = 15100; port < 15110; ++port) {
            try {
                ServerSocket sock = new ServerSocket(port);
                sock.close();
                return port;
            }
            catch (IOException e) {
                log.warning("Port " + port + " seems to be used already, trying next one: " + e);
                continue;
            }
        }
        throw new IOException("No free port found in the range of [15100 - 15110]");
    }

    public int getPort() {
        return this.port;
    }

    @Override
    public void close() {
        this.httpd.stop();
    }
}

