/*
 * Decompiled with CFR 0.152.
 */
package org.dstadler.commons.testing;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Objects;
import java.util.UUID;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.io.FileUtils;
import org.dstadler.commons.logging.jdk.LoggerFactory;
import org.junit.jupiter.api.Assertions;

public class TestEnvironment {
    private static final Logger log = LoggerFactory.make();
    public static final String TEST_DATA_PATH = "testsrc/data";
    public static final String ABS_TEST_DATA_PATH = new File("testsrc/data").getAbsolutePath();
    public static final String RUNTIME_DATA_PATH = "build/testdata/" + UUID.randomUUID();
    public static final String ABS_RUNTIME_DATA_PATH = new File(RUNTIME_DATA_PATH).getAbsolutePath();

    public static void createOrClearRuntimeData() throws IOException {
        File dir = new File(ABS_RUNTIME_DATA_PATH);
        if (dir.exists()) {
            TestEnvironment.clearRuntimeData();
        }
        if (!dir.mkdirs()) {
            log.info("Waiting for 3 seconds to see if we can then create directory " + dir + ": " + dir.exists() + ": " + dir.isDirectory() + ": " + dir.isFile() + ": " + dir.lastModified());
            try {
                Thread.sleep(3000L);
            }
            catch (InterruptedException e) {
                throw new IOException(e);
            }
            if (!dir.mkdirs()) {
                throw new IOException("Could not create directory " + dir + ": " + dir.exists() + ": " + dir.isDirectory() + ": " + dir.isFile() + ": " + dir.lastModified());
            }
        }
    }

    public static void clearRuntimeData() throws IOException {
        Assertions.assertTrue((boolean)ABS_RUNTIME_DATA_PATH.endsWith(RUNTIME_DATA_PATH.replace("/", File.separator).replace("\\", File.separator)), (String)("Had: " + ABS_RUNTIME_DATA_PATH));
        Assertions.assertTrue((boolean)ABS_RUNTIME_DATA_PATH.contains(File.separator + "build" + File.separator), (String)("Had: " + ABS_RUNTIME_DATA_PATH));
        File directory = new File(ABS_RUNTIME_DATA_PATH);
        TestEnvironment.deleteDirectory(directory);
        Assertions.assertFalse((boolean)directory.exists());
    }

    public static File createTestDirectory(Class<?> testClass) throws IOException {
        File directory = TestEnvironment.getTestDirectory(testClass);
        if (!directory.mkdirs()) {
            throw new IOException("Could not create directory " + directory);
        }
        return directory;
    }

    public static File getTestDirectory(Class<?> testClass) {
        return new File(ABS_RUNTIME_DATA_PATH, testClass.getCanonicalName());
    }

    public static File createTempFile(String prefix, String suffix) throws IOException {
        return File.createTempFile(prefix, suffix, new File(ABS_RUNTIME_DATA_PATH));
    }

    public static void deleteDirectory(File directory) throws IOException {
        try {
            FileUtils.deleteDirectory((File)directory);
        }
        catch (IOException e) {
            log.log(Level.WARNING, "Could not delete directory " + directory + ", trying once more after some time: " + e);
            try {
                Thread.sleep(5000L);
            }
            catch (InterruptedException e2) {
                throw new IllegalStateException(e2);
            }
            try {
                FileUtils.deleteDirectory((File)directory);
            }
            catch (IOException e1) {
                Object[] list = directory.list();
                Objects.requireNonNull(list, "Directory " + directory + " not found or not accessible");
                StringBuilder builder = new StringBuilder("Had leftover files/directories: ").append(Arrays.toString(list)).append("\n");
                for (Object file : list) {
                    File subFile = new File(directory, (String)file);
                    if (!subFile.isDirectory()) continue;
                    builder.append("Had leftover sub-files/directories: ").append(Arrays.toString(subFile.list())).append("\n");
                }
                throw new IOException(builder.toString(), e1);
            }
        }
    }
}

