/*
 * Decompiled with CFR 0.152.
 */
package org.dstadler.commons.testing;

import java.awt.GraphicsEnvironment;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.Comparator;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Assumptions;

public class TestHelpers {
    public static void EqualsTest(Object obj, Object equal, Object notequal) {
        Assertions.assertNotNull((Object)obj, (String)"Object in EqualsTest should not be null!");
        Assertions.assertNotNull((Object)equal, (String)"Equals-object in EqualsTest should not be null!");
        Assertions.assertNotNull((Object)notequal, (String)"Non-equal-object in EqualsTest should not be null!");
        Assertions.assertFalse((obj == equal ? 1 : 0) != 0, (String)"Object and equals-object in EqualsTest should not be identical");
        Assertions.assertFalse((obj == notequal ? 1 : 0) != 0, (String)"Object and non-equals-object in EqualsTest should not be identical");
        Assertions.assertTrue((boolean)obj.getClass().equals(equal.getClass()), (String)"Classes of objects in EqualsTest should be equal!");
        Assertions.assertTrue((boolean)obj.getClass().equals(notequal.getClass()), (String)"Classes of objects in EqualsTest should be equal!");
        Assertions.assertTrue((boolean)obj.equals(equal), (String)"Object and equal-object should be equal in EqualsTest!");
        Assertions.assertFalse((boolean)obj.equals(notequal), (String)"Object and non-equal-object should not be equal in EqualsTest!");
        Assertions.assertTrue((boolean)obj.equals(obj), (String)"Reflexive: object should be equal to itself in EqualsTest!");
        Assertions.assertTrue((boolean)equal.equals(equal), (String)"Reflexive: equal-object should be equal to itself in EqualsTest!");
        Assertions.assertTrue((boolean)notequal.equals(notequal), (String)"Reflexive: non-equal-object should be equal to itself in EqualsTest!");
        Assertions.assertFalse((boolean)obj.equals(null), (String)"Object should not be equal to null in EqualsTest!");
        Assertions.assertFalse((boolean)equal.equals(null), (String)"Equal-object should not be equal to null in EqualsTest!");
        Assertions.assertFalse((boolean)notequal.equals(null), (String)"Non-equal-object should not be equal to null in EqualsTest!");
        Assertions.assertFalse((boolean)obj.equals("TestString"), (String)"Object should not be equal to an arbitrary string in EqualsTest!");
        Assertions.assertFalse((boolean)"TestString".equals(obj), (String)"Object should not be equal to an arbitrary string in EqualsTest!");
        Assertions.assertTrue((boolean)obj.equals(equal), (String)"Symmetric: Object should be equal to equal-object in EqualsTest");
        Assertions.assertTrue((boolean)equal.equals(obj), (String)"Symmetric: Equals-object should be equal to object in EqualsTest!");
        Assertions.assertFalse((boolean)obj.equals(notequal), (String)"Symmetric: Object should NOT be equal to non-equal-object in EqualsTest");
        Assertions.assertFalse((boolean)notequal.equals(obj), (String)"Symmetric: Non-equals-object should NOT be equal to object in EqualsTest!");
        Assertions.assertTrue((obj.hashCode() == equal.hashCode() ? 1 : 0) != 0, (String)"Transitive: Equal objects should have equal hash-code in EqualsTest!");
        Assertions.assertTrue((obj.hashCode() == obj.hashCode() ? 1 : 0) != 0, (String)"Transitive: Equal objects should have equal hash-code in EqualsTest!");
        Assertions.assertTrue((equal.hashCode() == equal.hashCode() ? 1 : 0) != 0, (String)"Transitive: Equal objects should have equal hash-code in EqualsTest!");
        Assertions.assertTrue((notequal.hashCode() == notequal.hashCode() ? 1 : 0) != 0, (String)"Transitive: Equal objects should have equal hash-code in EqualsTest!");
    }

    public static <T extends Comparable<T>> void CompareToTest(T obj, T equal, T notequal, boolean notEqualIsLess) {
        Assertions.assertNotNull(obj, (String)"Object in CompareToTest should not be null!");
        Assertions.assertNotNull(equal, (String)"Equals-object in CompareToTest should not be null!");
        Assertions.assertNotNull(notequal, (String)"Non-equal-object in CompareToTest should not be null!");
        Assertions.assertFalse((obj == equal ? 1 : 0) != 0, (String)"Object and equals-object in CompareToTest should not be identical");
        Assertions.assertFalse((obj == notequal ? 1 : 0) != 0, (String)"Object and non-equals-object in CompareToTest should not be identical");
        Assertions.assertEquals((int)0, (int)obj.compareTo(equal), (String)"Object and equal-object should compare in CompareToTest!");
        Assertions.assertFalse((0 == obj.compareTo(notequal) ? 1 : 0) != 0, (String)"Object and non-equal-object should not compare in CompareToTest!");
        Assertions.assertFalse((0 == equal.compareTo(notequal) ? 1 : 0) != 0, (String)"Equal-object and non-equal-object should not compare in CompareToTest!");
        Assertions.assertEquals((int)0, (int)obj.compareTo(obj), (String)"Reflexive: object should be equal to itself in CompareToTest!");
        Assertions.assertEquals((int)0, (int)equal.compareTo(equal), (String)"Reflexive: equal-object should be equal to itself in CompareToTest!");
        Assertions.assertEquals((int)0, (int)notequal.compareTo(notequal), (String)"Reflexive: non-equal-object should be equal to itself in CompareToTest!");
        Assertions.assertTrue((0 != obj.compareTo(null) ? 1 : 0) != 0, (String)"Object should not be equal to null in CompareToTest!");
        Assertions.assertTrue((0 != equal.compareTo(null) ? 1 : 0) != 0, (String)"Equal-object should not be equal to null in CompareToTest!");
        Assertions.assertTrue((0 != notequal.compareTo(null) ? 1 : 0) != 0, (String)"Non-equal-object should not be equal to null in CompareToTest!");
        Assertions.assertEquals((int)0, (int)obj.compareTo(equal), (String)"Symmetric: Object should be equal to equal-object in CompareToTest");
        Assertions.assertEquals((int)0, (int)equal.compareTo(obj), (String)"Symmetric: Equals-object should be equal to object in CompareToTest!");
        Assertions.assertFalse((0 == obj.compareTo(notequal) ? 1 : 0) != 0, (String)"Symmetric: Object should NOT be equal to non-equal-object in CompareToTest");
        Assertions.assertFalse((0 == notequal.compareTo(obj) ? 1 : 0) != 0, (String)"Symmetric: Non-equals-object should NOT be equal to object in CompareToTest!");
        Assertions.assertEquals((int)Integer.signum(obj.compareTo(notequal)), (int)(-1 * Integer.signum(notequal.compareTo(obj))), (String)"Symmetric: Comparing object and non-equal-object in both directions should lead to the same result.");
        Assertions.assertEquals((int)Integer.signum(obj.compareTo(notequal)), (int)Integer.signum(equal.compareTo(notequal)), (String)"Congruence: Comparing object and non-equal-object should have the same result as comparing the equal object and the non-equal-object");
        if (notEqualIsLess) {
            Assertions.assertTrue((obj.compareTo(notequal) > 0 ? 1 : 0) != 0, (String)("Item 'notequal' should be less than item 'equal' in CompareToTest, but compare was: " + obj.compareTo(notequal)));
        } else {
            Assertions.assertTrue((obj.compareTo(notequal) < 0 ? 1 : 0) != 0, (String)("Item 'notequal' should be higher than item 'equal' in CompareToTest, but compare was: " + obj.compareTo(notequal)));
        }
        Assertions.assertTrue((boolean)obj.equals(equal), (String)"Findbugs: Comparable objects should implement equals() the same way as compareTo().");
        Assertions.assertFalse((boolean)obj.equals(notequal), (String)"Findbugs: Comparable objects should implement equals() the same way as compareTo().");
        TestHelpers.EqualsTest(obj, equal, notequal);
        Assertions.assertEquals((int)obj.hashCode(), (int)equal.hashCode(), (String)"Findbugs: Comparable objects should implement hashCode() the same way as compareTo().");
        TestHelpers.HashCodeTest(obj, equal);
    }

    public static <T> void ComparatorTest(Comparator<T> comparator, T obj, T equal, T notequal, boolean notEqualIsLess) {
        Assertions.assertNotNull(obj, (String)"Object in ComparatorTest should not be null!");
        Assertions.assertNotNull(equal, (String)"Equals-object in ComparatorTest should not be null!");
        Assertions.assertNotNull(notequal, (String)"Non-equal-object in ComparatorTest should not be null!");
        Assertions.assertFalse((obj == equal ? 1 : 0) != 0, (String)"Object and equals-object in ComparatorTest should not be identical");
        Assertions.assertFalse((obj == notequal ? 1 : 0) != 0, (String)"Object and non-equals-object in ComparatorTest should not be identical");
        Assertions.assertEquals((int)0, (int)comparator.compare(obj, equal), (String)"Object and equal-object should compare in ComparatorTest!");
        Assertions.assertFalse((0 == comparator.compare(obj, notequal) ? 1 : 0) != 0, (String)"Object and non-equal-object should not compare in ComparatorTest!");
        Assertions.assertEquals((int)0, (int)comparator.compare(obj, obj), (String)"Reflexive: object should be equal to itself in ComparatorTest!");
        Assertions.assertEquals((int)0, (int)comparator.compare(equal, equal), (String)"Reflexive: equal-object should be equal to itself in ComparatorTest!");
        Assertions.assertEquals((int)0, (int)comparator.compare(notequal, notequal), (String)"Reflexive: non-equal-object should be equal to itself in ComparatorTest!");
        Assertions.assertEquals((int)0, (int)comparator.compare(obj, equal), (String)"Symmetric: Object should be equal to equal-object in ComparatorTest");
        Assertions.assertEquals((int)0, (int)comparator.compare(equal, obj), (String)"Symmetric: Equals-object should be equal to object in ComparatorTest!");
        Assertions.assertFalse((0 == comparator.compare(obj, notequal) ? 1 : 0) != 0, (String)"Symmetric: Object should NOT be equal to non-equal-object in ComparatorTest");
        Assertions.assertFalse((0 == comparator.compare(notequal, obj) ? 1 : 0) != 0, (String)"Symmetric: Non-equals-object should NOT be equal to object in ComparatorTest!");
        int signumObjEqual = Integer.signum(comparator.compare(obj, notequal));
        Assertions.assertEquals((int)signumObjEqual, (int)(-1 * Integer.signum(comparator.compare(notequal, obj))), (String)"Symmetric: Comparing object and non-equal-object in both directions should lead to the same result.");
        Assertions.assertEquals((int)signumObjEqual, (int)Integer.signum(comparator.compare(equal, notequal)), (String)"Congruence: Comparing object and non-equal-object should have the same result as comparing the equal object and the non-equal-object");
        if (notEqualIsLess) {
            Assertions.assertTrue((comparator.compare(notequal, obj) < 0 ? 1 : 0) != 0, (String)("Item 'notequal' should be less than item 'equal' in ComparatorTest, but compare was: " + comparator.compare(notequal, obj)));
        } else {
            Assertions.assertTrue((comparator.compare(notequal, obj) > 0 ? 1 : 0) != 0, (String)("Item 'notequal' should be higher than item 'equal' in ComparatorTest, but compare was: " + comparator.compare(notequal, obj)));
        }
        Assertions.assertEquals((int)0, (int)comparator.compare(null, null), (String)"compare(null,null) should have 0 as compare-result");
        Assertions.assertTrue((comparator.compare(obj, null) != 0 ? 1 : 0) != 0, (String)"compare(obj,null) should not have 0 as compare-result");
        Assertions.assertTrue((comparator.compare(null, obj) != 0 ? 1 : 0) != 0, (String)"compare(null,obj) should not have 0 as compare-result");
    }

    public static void ToStringTest(Object obj) {
        Assertions.assertNotNull((Object)obj.toString(), (String)"A derived toString() should not return null!");
        Assertions.assertFalse((boolean)obj.toString().equals(""), (String)"A derived toString() should not return an empty string!");
        String value = obj.toString();
        for (int i = 0; i < 10; ++i) {
            Assertions.assertEquals((Object)value, (Object)obj.toString(), (String)"toString() is expected to result in the same result across repeated calls!");
        }
    }

    public static void CloneTest(Cloneable obj) throws Exception {
        Method m = obj.getClass().getMethod("clone", new Class[0]);
        Assertions.assertNotNull((Object)m, (String)("Need to find a method called 'clone' in object of type '" + obj.getClass().getName() + "' in CloneTest!"));
        Assertions.assertTrue((obj != m.invoke((Object)obj, new Object[0]) ? 1 : 0) != 0, (String)"clone() should not return the object itself in CloneTest!");
        Assertions.assertTrue((m.invoke((Object)obj, new Object[0]).getClass() == obj.getClass() ? 1 : 0) != 0, (String)"clone() should return the same type of object (i.e. the same class) in CloneTest!");
        Assertions.assertTrue((boolean)m.invoke((Object)obj, new Object[0]).equals(obj), (String)"clone() should return an object that is equal() to the original object in CloneTest!");
    }

    public static void HashCodeTest(Object obj, Object equ) {
        Assertions.assertFalse((obj == equ ? 1 : 0) != 0, (String)"HashCodeTest expects two distinct objects with equal hashCode, but the same object is provided twice!");
        int hash = obj.hashCode();
        Assertions.assertEquals((int)hash, (int)obj.hashCode(), (String)"hashCode() on object returned different hash after some iterations!");
        Assertions.assertEquals((int)hash, (int)obj.hashCode(), (String)"hashCode() on object returned different hash after some iterations!");
        Assertions.assertEquals((int)hash, (int)obj.hashCode(), (String)"hashCode() on object returned different hash after some iterations!");
        Assertions.assertEquals((int)hash, (int)obj.hashCode(), (String)"hashCode() on object returned different hash after some iterations!");
        Assertions.assertEquals((int)hash, (int)obj.hashCode(), (String)"hashCode() on object returned different hash after some iterations!");
        Assertions.assertEquals((Object)obj, (Object)equ, (String)"Equal Assert failed, but input to HashCodeTest should be two equal objects! Check if the class implements equals() as well to fulfill this contract");
        Assertions.assertEquals((int)obj.hashCode(), (int)equ.hashCode(), (String)"Equal objects should have equal hashCode() by Java contract!");
    }

    public static <T extends Enum<T>> void EnumTest(Enum<T> enumtype, Class<T> enumclass, String element) throws NoSuchMethodException, InvocationTargetException, IllegalAccessException {
        Assertions.assertEquals(enumtype, Enum.valueOf(enumclass, element));
        Method m = enumclass.getMethod("values", null);
        Object obj = m.invoke(enumtype, (Object[])null);
        Assertions.assertNotNull((Object)obj);
        Assertions.assertInstanceOf(Object[].class, (Object)obj);
        obj = Enum.valueOf(enumclass, element);
        Assertions.assertNotNull((Object)obj);
        TestHelpers.assertContains(Assertions.assertThrows(IllegalArgumentException.class, () -> Enum.valueOf(enumclass, "nonexistingenumelement"), (String)"Should catch exception IllegalArgumentException when calling Enum.valueOf() with incorrect enum-value!"), "No enum");
    }

    public static void assertContains(Throwable throwable, String ... searches) {
        TestHelpers.assertContains("", throwable, searches);
    }

    public static void assertContains(String msg, Throwable throwable, String ... searches) {
        Assertions.assertNotNull((Object)throwable, (String)"Cannot verify message contents of a Throwable when it is null.");
        Assertions.assertTrue((searches.length > 0 ? 1 : 0) != 0, (String)"Specify at least one search-term to be searched in the string");
        String str = throwable.getMessage();
        if (str == null) {
            throw new IllegalArgumentException("Throwable of type " + throwable.getClass() + " contains a null-string as message, cannot assertContains", throwable);
        }
        for (String search : searches) {
            Assertions.assertTrue((boolean)str.contains(search), (String)(msg + ". Expected to find string '" + search + "', but was not contained in provided string '" + str + "'\n" + ExceptionUtils.getStackTrace((Throwable)throwable)));
        }
    }

    public static void assertContains(String str, String ... searches) {
        Assertions.assertNotNull((Object)str, (String)"Cannot assertContains on a null-string");
        Assertions.assertTrue((searches.length > 0 ? 1 : 0) != 0, (String)"Specify at least one search-term to be searched in the string");
        for (String search : searches) {
            Assertions.assertTrue((boolean)str.contains(search), (String)("Expected to find string '" + search + "', but was not contained in provided string '" + str + "'"));
        }
    }

    public static void assertContainsMsg(String msg, String str, String ... searches) {
        Assertions.assertNotNull((Object)str, (String)"Cannot assertContains on a null-string");
        Assertions.assertTrue((searches.length > 0 ? 1 : 0) != 0, (String)"Specify at least one search-term to be searched in the string");
        for (String search : searches) {
            Assertions.assertTrue((boolean)str.contains(search), (String)(msg + ". Expected to find string '" + search + "', but was not contained in provided string '" + str + "'"));
        }
    }

    public static void assertNotContains(String str, String ... searches) {
        Assertions.assertNotNull((Object)str, (String)"Cannot assertNotContains on a null-string");
        Assertions.assertTrue((searches.length > 0 ? 1 : 0) != 0, (String)"Specify at least one search-term to be searched in the string");
        for (String search : searches) {
            Assertions.assertFalse((boolean)str.contains(search), (String)("Expected to NOT find '" + search + "' but was contained in string '" + str + "'"));
        }
    }

    public static void assertNotContainsMsg(String msg, String str, String ... searches) {
        Assertions.assertNotNull((Object)str, (String)"Cannot assertNotContains on a null-string");
        Assertions.assertTrue((searches.length > 0 ? 1 : 0) != 0, (String)"Specify at least one search-term to be searched in the string");
        for (String search : searches) {
            Assertions.assertFalse((boolean)str.contains(search), (String)(msg + ". Expected to NOT find '" + search + "' but was contained in string '" + str + "'"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void runTestWithDifferentLogLevel(Runnable test, String className, Level ... levels) {
        Logger localLogger = Logger.getLogger(className);
        Level origLevel = localLogger.getLevel();
        for (Level level : levels) {
            localLogger.setLevel(level);
            try {
                test.run();
            }
            finally {
                localLogger.setLevel(origLevel);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void assertURLWorks(String urlString, int timeout) throws IOException {
        URL url = new URL(urlString);
        HttpURLConnection conn = (HttpURLConnection)url.openConnection();
        try {
            conn.setDoOutput(false);
            conn.setDoInput(true);
            conn.setConnectTimeout(timeout);
            conn.setReadTimeout(timeout);
            conn.connect();
            Assertions.assertEquals((int)200, (int)conn.getResponseCode(), (String)("Expect URL '" + urlString + "' to be available and return HTTP 200"));
        }
        finally {
            conn.disconnect();
        }
    }

    public static void assumeCanShowDialogs() {
        Assertions.assertNotNull((Object)GraphicsEnvironment.getLocalGraphicsEnvironment());
        Assumptions.assumeFalse((boolean)GraphicsEnvironment.isHeadless(), (String)"Can not run some tests when tests are executed in headless mode");
    }

    public static File createTempDirectory(String prefix, String suffix) throws IOException {
        File dir = File.createTempFile(prefix, suffix);
        Assertions.assertTrue((boolean)dir.delete());
        Assertions.assertTrue((boolean)dir.mkdir());
        Assertions.assertTrue((boolean)dir.exists());
        return dir;
    }
}

