/*
 * Decompiled with CFR 0.152.
 */
package org.dstadler.commons.testing;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.CyclicBarrier;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.lang3.concurrent.BasicThreadFactory;
import org.dstadler.commons.logging.jdk.LoggerFactory;
import org.dstadler.commons.util.ThreadDump;
import org.junit.jupiter.api.Assertions;

public class ThreadTestHelper {
    private static final Logger log = LoggerFactory.make();
    private final int threadCount;
    private final int testsPerThread;
    private volatile Throwable exception = null;
    private final int[] executions;

    public ThreadTestHelper(int threadCount, int testsPerThread) {
        this.threadCount = threadCount;
        this.testsPerThread = testsPerThread;
        this.executions = new int[threadCount];
    }

    public void executeTest(TestRunnable run) throws Throwable {
        int i;
        log.info("Starting thread test");
        ArrayList<Thread> threads = new ArrayList<Thread>();
        for (i = 0; i < this.threadCount; ++i) {
            Thread t = this.startThread(i, run);
            threads.add(t);
        }
        for (i = 0; i < this.threadCount; ++i) {
            ((Thread)threads.get(i)).join();
        }
        if (this.exception != null) {
            throw new Exception("Caught an exception in one of the threads", this.exception);
        }
        for (i = 0; i < this.threadCount; ++i) {
            Assertions.assertEquals((int)this.testsPerThread, (int)this.executions[i], (String)("Thread " + i + " did not execute all iterations"));
        }
    }

    public static <T> List<T> executeTest(Callable<T> testable, int runs) throws Throwable {
        CyclicBarrier barrier = new CyclicBarrier(runs);
        ExecutorService executor = Executors.newCachedThreadPool((ThreadFactory)new BasicThreadFactory.Builder().uncaughtExceptionHandler((t, e) -> log.log(Level.SEVERE, "An uncaught exception happened in Thread " + t.getName(), e)).namingPattern(ThreadTestHelper.class.getSimpleName() + "-Thread-%d").build());
        try {
            ArrayList<Callable<Object>> tasks = new ArrayList<Callable<Object>>(runs);
            for (int i = 0; i < runs; ++i) {
                tasks.add(() -> {
                    barrier.await();
                    return testable.call();
                });
            }
            List futures = executor.invokeAll(tasks);
            ArrayList results = new ArrayList(futures.size());
            for (Future future : futures) {
                results.add(future.get());
            }
            ArrayList arrayList = results;
            return arrayList;
        }
        catch (ExecutionException e2) {
            throw e2.getCause();
        }
        finally {
            executor.shutdownNow();
        }
    }

    private Thread startThread(int threadNum, TestRunnable run) {
        log.info("Starting thread number: " + threadNum);
        Thread t1 = new Thread(() -> {
            try {
                for (int itNum = 0; itNum < this.testsPerThread && this.exception == null; ++itNum) {
                    run.run(threadNum, itNum);
                    int n = threadNum;
                    this.executions[n] = this.executions[n] + 1;
                }
                run.doEnd(threadNum);
            }
            catch (Throwable e) {
                this.exception = e;
            }
        }, "ThreadTestHelper-Thread " + threadNum + ": " + run.getClass().getName());
        t1.start();
        return t1;
    }

    public static void waitForThreadToFinish(String name) throws InterruptedException {
        int count = Thread.currentThread().getThreadGroup().activeCount();
        Thread[] threads = new Thread[count];
        Thread.currentThread().getThreadGroup().enumerate(threads);
        for (Thread t : threads) {
            if (t == null || !name.equals(t.getName())) continue;
            t.join();
        }
    }

    public static void waitForThreadToFinishSubstring(String contains) throws InterruptedException {
        ThreadTestHelper.waitForThreadToFinishSubstring(contains, 0L);
    }

    public static void waitForThreadToFinishSubstring(String contains, long timeout) throws InterruptedException {
        int count = Thread.currentThread().getThreadGroup().activeCount();
        Thread[] threads = new Thread[count];
        Thread.currentThread().getThreadGroup().enumerate(threads);
        for (Thread t : threads) {
            if (t == null || !t.getName().contains(contains) || t.getName().startsWith("SUITE-")) continue;
            t.join(timeout);
        }
    }

    public static void assertNoThreadLeft(String error, String contains) {
        int count = Thread.currentThread().getThreadGroup().activeCount();
        Thread[] threads = new Thread[count];
        Thread.currentThread().getThreadGroup().enumerate(threads);
        for (Thread t : threads) {
            if (t == null || !t.getName().contains(contains) || t.getName().startsWith("SUITE-")) continue;
            log.info("ThreadDump: " + new ThreadDump(true, true));
            Assertions.fail((String)(error + t));
        }
    }

    public static interface TestRunnable {
        public void run(int var1, int var2) throws Exception;

        default public void doEnd(int threadNum) throws Exception {
        }
    }
}

