/*
 * Decompiled with CFR 0.152.
 */
package org.duckdb;

import java.nio.ByteBuffer;
import java.sql.Array;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.NClob;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLClientInfoException;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Savepoint;
import java.sql.Statement;
import java.sql.Struct;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.Executor;
import org.duckdb.DuckDBDatabase;
import org.duckdb.DuckDBDatabaseMetaData;
import org.duckdb.DuckDBNative;
import org.duckdb.DuckDBPreparedStatement;

public class DuckDBConnection
implements Connection {
    protected ByteBuffer conn_ref = null;
    protected DuckDBDatabase db;

    public DuckDBConnection(DuckDBDatabase duckDBDatabase) {
        this.conn_ref = DuckDBNative.duckdb_jdbc_connect(duckDBDatabase.db_ref);
        DuckDBNative.duckdb_jdbc_set_auto_commit(this.conn_ref, true);
        this.db = duckDBDatabase;
    }

    @Override
    public Statement createStatement() throws SQLException {
        if (this.isClosed()) {
            throw new SQLException("Connection was closed");
        }
        return new DuckDBPreparedStatement(this);
    }

    @Override
    public void commit() throws SQLException {
        Statement statement = this.createStatement();
        statement.execute("COMMIT");
        statement.close();
    }

    @Override
    public void rollback() throws SQLException {
        Statement statement = this.createStatement();
        statement.execute("ROLLBACK");
        statement.close();
    }

    protected void finalize() throws Throwable {
        this.close();
    }

    @Override
    public synchronized void close() throws SQLException {
        if (this.conn_ref != null) {
            DuckDBNative.duckdb_jdbc_disconnect(this.conn_ref);
            this.conn_ref = null;
        }
        this.db = null;
    }

    @Override
    public boolean isClosed() throws SQLException {
        return this.conn_ref == null;
    }

    @Override
    public boolean isValid(int n) throws SQLException {
        if (this.isClosed()) {
            return false;
        }
        Statement statement = this.createStatement();
        ResultSet resultSet = statement.executeQuery("SELECT 42");
        if (!resultSet.next() || resultSet.getInt(1) != 42) {
            resultSet.close();
            statement.close();
            return false;
        }
        resultSet.close();
        statement.close();
        return true;
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        return null;
    }

    @Override
    public void clearWarnings() throws SQLException {
    }

    @Override
    public void setTransactionIsolation(int n) throws SQLException {
        if (n > 4) {
            throw new SQLFeatureNotSupportedException();
        }
    }

    @Override
    public int getTransactionIsolation() throws SQLException {
        return 4;
    }

    @Override
    public void setReadOnly(boolean bl) throws SQLException {
        if (bl) {
            throw new SQLFeatureNotSupportedException("Invidual connections can't be read-only");
        }
    }

    @Override
    public boolean isReadOnly() throws SQLException {
        return false;
    }

    @Override
    public void setAutoCommit(boolean bl) throws SQLException {
        if (this.isClosed()) {
            throw new SQLException("Connection was closed");
        }
        DuckDBNative.duckdb_jdbc_set_auto_commit(this.conn_ref, bl);
    }

    @Override
    public boolean getAutoCommit() throws SQLException {
        if (this.isClosed()) {
            throw new SQLException("Connection was closed");
        }
        return DuckDBNative.duckdb_jdbc_get_auto_commit(this.conn_ref);
    }

    @Override
    public PreparedStatement prepareStatement(String string) throws SQLException {
        if (this.isClosed()) {
            throw new SQLException("Connection was closed");
        }
        return new DuckDBPreparedStatement(this, string);
    }

    @Override
    public DatabaseMetaData getMetaData() throws SQLException {
        return new DuckDBDatabaseMetaData(this);
    }

    @Override
    public void setCatalog(String string) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public String getCatalog() throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void setSchema(String string) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public String getSchema() throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void abort(Executor executor) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public Clob createClob() throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public Blob createBlob() throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public <T> T unwrap(Class<T> clazz) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public boolean isWrapperFor(Class<?> clazz) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public CallableStatement prepareCall(String string) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public String nativeSQL(String string) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public Statement createStatement(int n, int n2) throws SQLException {
        if (n2 == 1007 && n == 1003) {
            return this.createStatement();
        }
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public PreparedStatement prepareStatement(String string, int n, int n2) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public CallableStatement prepareCall(String string, int n, int n2) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public Map<String, Class<?>> getTypeMap() throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void setTypeMap(Map<String, Class<?>> map) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void setHoldability(int n) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public int getHoldability() throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public Savepoint setSavepoint() throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public Savepoint setSavepoint(String string) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void rollback(Savepoint savepoint) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void releaseSavepoint(Savepoint savepoint) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public Statement createStatement(int n, int n2, int n3) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public PreparedStatement prepareStatement(String string, int n, int n2, int n3) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public CallableStatement prepareCall(String string, int n, int n2, int n3) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public PreparedStatement prepareStatement(String string, int n) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public PreparedStatement prepareStatement(String string, int[] nArray) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public PreparedStatement prepareStatement(String string, String[] stringArray) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public NClob createNClob() throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public SQLXML createSQLXML() throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void setClientInfo(String string, String string2) throws SQLClientInfoException {
        throw new SQLClientInfoException();
    }

    @Override
    public void setClientInfo(Properties properties) throws SQLClientInfoException {
        throw new SQLClientInfoException();
    }

    @Override
    public String getClientInfo(String string) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public Properties getClientInfo() throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public Array createArrayOf(String string, Object[] objectArray) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public Struct createStruct(String string, Object[] objectArray) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void setNetworkTimeout(Executor executor, int n) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public int getNetworkTimeout() throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }
}

