/*
 * Decompiled with CFR 0.152.
 */
package org.duckdb;

public class JsonNode {
    private final String source;

    public JsonNode(String string) {
        this.source = string;
    }

    public boolean isArray() {
        return this.source.charAt(0) == '[';
    }

    public boolean isObject() {
        return this.source.charAt(0) == '{';
    }

    public boolean isBoolean() {
        return this.source == "true" || this.source == "false";
    }

    public boolean isNull() {
        return this.source == "null";
    }

    public boolean isNumber() {
        return Character.isDigit(this.source.charAt(0));
    }

    public boolean isString() {
        return !this.isObject() && !this.isBoolean() && !this.isNull() && !this.isArray() && !this.isNumber();
    }

    public String toString() {
        return this.source;
    }
}

