/*
 * Decompiled with CFR 0.152.
 */
package org.duckdb.test;

import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.RoundingMode;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.sql.Blob;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.Date;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.Duration;
import java.time.LocalDateTime;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Properties;
import java.util.TimeZone;
import javax.sql.rowset.CachedRowSet;
import javax.sql.rowset.RowSetProvider;
import org.duckdb.DuckDBAppender;
import org.duckdb.DuckDBColumnType;
import org.duckdb.DuckDBConnection;
import org.duckdb.DuckDBDatabase;
import org.duckdb.DuckDBDriver;
import org.duckdb.DuckDBResultSetMetaData;
import org.duckdb.DuckDBTimestamp;
import org.duckdb.JsonNode;

public class TestDuckDBJDBC {
    private static void assertTrue(boolean bl) throws Exception {
        TestDuckDBJDBC.assertTrue(bl, null);
    }

    private static void assertTrue(boolean bl, String string) throws Exception {
        if (!bl) {
            throw new Exception(string);
        }
    }

    private static void assertFalse(boolean bl) throws Exception {
        TestDuckDBJDBC.assertTrue(!bl);
    }

    private static void assertEquals(Object object, Object object2) throws Exception {
        if (object == null && object2 == null) {
            return;
        }
        TestDuckDBJDBC.assertTrue(object.equals(object2), String.format("%s should equal %s", object, object2));
    }

    private static void assertNull(Object object) throws Exception {
        TestDuckDBJDBC.assertTrue(object == null);
    }

    private static void assertEquals(double d, double d2, double d3) throws Exception {
        TestDuckDBJDBC.assertTrue(Math.abs(d - d2) < d3);
    }

    private static void fail() throws Exception {
        TestDuckDBJDBC.assertTrue(false);
    }

    public static void test_connection() throws Exception {
        Connection connection = DriverManager.getConnection("jdbc:duckdb:");
        TestDuckDBJDBC.assertTrue(connection.isValid(0));
        TestDuckDBJDBC.assertFalse(connection.isClosed());
        Statement statement = connection.createStatement();
        ResultSet resultSet = statement.executeQuery("SELECT 42 as a");
        TestDuckDBJDBC.assertFalse(statement.isClosed());
        TestDuckDBJDBC.assertFalse(resultSet.isClosed());
        TestDuckDBJDBC.assertTrue(resultSet.next());
        int n = resultSet.getInt(1);
        TestDuckDBJDBC.assertEquals(n, 42);
        TestDuckDBJDBC.assertFalse(resultSet.wasNull());
        n = resultSet.getInt(1);
        TestDuckDBJDBC.assertEquals(n, 42);
        TestDuckDBJDBC.assertFalse(resultSet.wasNull());
        n = resultSet.getInt("a");
        TestDuckDBJDBC.assertEquals(n, 42);
        TestDuckDBJDBC.assertFalse(resultSet.wasNull());
        try {
            n = resultSet.getInt(0);
            TestDuckDBJDBC.fail();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        try {
            n = resultSet.getInt(2);
            TestDuckDBJDBC.fail();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        try {
            n = resultSet.getInt("b");
            TestDuckDBJDBC.fail();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        TestDuckDBJDBC.assertFalse(resultSet.next());
        TestDuckDBJDBC.assertFalse(resultSet.next());
        resultSet.close();
        resultSet.close();
        TestDuckDBJDBC.assertTrue(resultSet.isClosed());
        try {
            n = resultSet.getInt(1);
            TestDuckDBJDBC.fail();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        statement.close();
        statement.close();
        TestDuckDBJDBC.assertTrue(statement.isClosed());
        connection.close();
        connection.close();
        TestDuckDBJDBC.assertFalse(connection.isValid(0));
        TestDuckDBJDBC.assertTrue(connection.isClosed());
        try {
            statement = connection.createStatement();
            TestDuckDBJDBC.fail();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    public static void test_prepare_exception() throws Exception {
        Connection connection = DriverManager.getConnection("jdbc:duckdb:");
        Statement statement = connection.createStatement();
        statement = connection.createStatement();
        try {
            statement.execute("this is no SQL;");
            TestDuckDBJDBC.fail();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    public static void test_execute_exception() throws Exception {
        Connection connection = DriverManager.getConnection("jdbc:duckdb:");
        Statement statement = connection.createStatement();
        statement = connection.createStatement();
        statement.execute("CREATE TABLE t (id INT, b UUID)");
        statement.execute("INSERT INTO t VALUES (1, uuid())");
        try {
            ResultSet resultSet = statement.executeQuery("SELECT * FROM t");
            resultSet.next();
            TestDuckDBJDBC.fail();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    public static void test_autocommit_off() throws Exception {
        Connection connection = DriverManager.getConnection("jdbc:duckdb:");
        Statement statement = connection.createStatement();
        connection.setAutoCommit(false);
        statement = connection.createStatement();
        statement.execute("CREATE TABLE t (id INT);");
        connection.commit();
        statement.execute("INSERT INTO t (id) VALUES (1);");
        statement.execute("INSERT INTO t (id) VALUES (2);");
        statement.execute("INSERT INTO t (id) VALUES (3);");
        connection.commit();
        ResultSet resultSet = statement.executeQuery("SELECT COUNT(*) FROM T");
        resultSet.next();
        TestDuckDBJDBC.assertEquals(resultSet.getInt(1), 3);
        resultSet.close();
        statement.execute("INSERT INTO t (id) VALUES (4);");
        statement.execute("INSERT INTO t (id) VALUES (5);");
        connection.rollback();
        resultSet = statement.executeQuery("SELECT COUNT(*) FROM T");
        resultSet.next();
        TestDuckDBJDBC.assertEquals(resultSet.getInt(1), 3);
        statement.execute("INSERT INTO t (id) VALUES (6);");
        statement.execute("INSERT INTO t (id) VALUES (7);");
        connection.setAutoCommit(true);
        resultSet = statement.executeQuery("SELECT COUNT(*) FROM T");
        resultSet.next();
        TestDuckDBJDBC.assertEquals(resultSet.getInt(1), 5);
        try {
            connection.rollback();
            TestDuckDBJDBC.fail();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        statement.execute("INSERT INTO t (id) VALUES (8);");
        resultSet = statement.executeQuery("SELECT COUNT(*) FROM T");
        resultSet.next();
        TestDuckDBJDBC.assertEquals(resultSet.getInt(1), 6);
        resultSet.close();
        statement.close();
        connection.close();
    }

    public static void test_enum() throws Exception {
        Connection connection = DriverManager.getConnection("jdbc:duckdb:");
        Statement statement = connection.createStatement();
        statement.execute("CREATE TYPE enum_test AS ENUM ('Enum1', 'enum2', '1\u00fc\u00f6\u00f1');");
        statement.execute("CREATE TABLE t (id INT, e1 enum_test);");
        statement.execute("INSERT INTO t (id, e1) VALUES (1, 'Enum1');");
        statement.execute("INSERT INTO t (id, e1) VALUES (2, 'enum2');");
        statement.execute("INSERT INTO t (id, e1) VALUES (3, '1\u00fc\u00f6\u00f1');");
        PreparedStatement preparedStatement = connection.prepareStatement("SELECT e1 FROM t WHERE id = ?");
        preparedStatement.setObject(1, 1);
        ResultSet resultSet = preparedStatement.executeQuery();
        resultSet.next();
        TestDuckDBJDBC.assertTrue(resultSet.getObject(1, String.class).equals("Enum1"));
        TestDuckDBJDBC.assertTrue(resultSet.getString(1).equals("Enum1"));
        TestDuckDBJDBC.assertTrue(resultSet.getString("e1").equals("Enum1"));
        resultSet.close();
        preparedStatement.setObject(1, 2);
        resultSet = preparedStatement.executeQuery();
        resultSet.next();
        TestDuckDBJDBC.assertTrue(resultSet.getObject(1, String.class).equals("enum2"));
        TestDuckDBJDBC.assertTrue(resultSet.getObject(1).equals("enum2"));
        resultSet.close();
        preparedStatement.setObject(1, 3);
        resultSet = preparedStatement.executeQuery();
        resultSet.next();
        TestDuckDBJDBC.assertTrue(resultSet.getObject(1, String.class).equals("1\u00fc\u00f6\u00f1"));
        TestDuckDBJDBC.assertTrue(resultSet.getObject(1).equals("1\u00fc\u00f6\u00f1"));
        TestDuckDBJDBC.assertTrue(resultSet.getObject("e1").equals("1\u00fc\u00f6\u00f1"));
        resultSet.close();
        preparedStatement = connection.prepareStatement("SELECT e1 FROM t WHERE e1 = ?");
        preparedStatement.setObject(1, "1\u00fc\u00f6\u00f1");
        resultSet = preparedStatement.executeQuery();
        resultSet.next();
        TestDuckDBJDBC.assertTrue(resultSet.getObject(1, String.class).equals("1\u00fc\u00f6\u00f1"));
        TestDuckDBJDBC.assertTrue(resultSet.getString(1).equals("1\u00fc\u00f6\u00f1"));
        TestDuckDBJDBC.assertTrue(resultSet.getString("e1").equals("1\u00fc\u00f6\u00f1"));
        resultSet.close();
        statement.execute("CREATE TYPE enum_long AS ENUM ('enum0' ,'enum1' ,'enum2' ,'enum3' ,'enum4' ,'enum5' ,'enum6','enum7' ,'enum8' ,'enum9' ,'enum10' ,'enum11' ,'enum12' ,'enum13' ,'enum14' ,'enum15' ,'enum16' ,'enum17','enum18' ,'enum19' ,'enum20' ,'enum21' ,'enum22' ,'enum23' ,'enum24' ,'enum25' ,'enum26' ,'enum27' ,'enum28','enum29' ,'enum30' ,'enum31' ,'enum32' ,'enum33' ,'enum34' ,'enum35' ,'enum36' ,'enum37' ,'enum38' ,'enum39','enum40' ,'enum41' ,'enum42' ,'enum43' ,'enum44' ,'enum45' ,'enum46' ,'enum47' ,'enum48' ,'enum49' ,'enum50','enum51' ,'enum52' ,'enum53' ,'enum54' ,'enum55' ,'enum56' ,'enum57' ,'enum58' ,'enum59' ,'enum60' ,'enum61','enum62' ,'enum63' ,'enum64' ,'enum65' ,'enum66' ,'enum67' ,'enum68' ,'enum69' ,'enum70' ,'enum71' ,'enum72','enum73' ,'enum74' ,'enum75' ,'enum76' ,'enum77' ,'enum78' ,'enum79' ,'enum80' ,'enum81' ,'enum82' ,'enum83','enum84' ,'enum85' ,'enum86' ,'enum87' ,'enum88' ,'enum89' ,'enum90' ,'enum91' ,'enum92' ,'enum93' ,'enum94','enum95' ,'enum96' ,'enum97' ,'enum98' ,'enum99' ,'enum100' ,'enum101' ,'enum102' ,'enum103' ,'enum104' ,'enum105' ,'enum106' ,'enum107' ,'enum108' ,'enum109' ,'enum110' ,'enum111' ,'enum112' ,'enum113' ,'enum114','enum115' ,'enum116' ,'enum117' ,'enum118' ,'enum119' ,'enum120' ,'enum121' ,'enum122' ,'enum123' ,'enum124','enum125' ,'enum126' ,'enum127' ,'enum128' ,'enum129' ,'enum130' ,'enum131' ,'enum132' ,'enum133' ,'enum134','enum135' ,'enum136' ,'enum137' ,'enum138' ,'enum139' ,'enum140' ,'enum141' ,'enum142' ,'enum143' ,'enum144','enum145' ,'enum146' ,'enum147' ,'enum148' ,'enum149' ,'enum150' ,'enum151' ,'enum152' ,'enum153' ,'enum154','enum155' ,'enum156' ,'enum157' ,'enum158' ,'enum159' ,'enum160' ,'enum161' ,'enum162' ,'enum163' ,'enum164','enum165' ,'enum166' ,'enum167' ,'enum168' ,'enum169' ,'enum170' ,'enum171' ,'enum172' ,'enum173' ,'enum174','enum175' ,'enum176' ,'enum177' ,'enum178' ,'enum179' ,'enum180' ,'enum181' ,'enum182' ,'enum183' ,'enum184','enum185' ,'enum186' ,'enum187' ,'enum188' ,'enum189' ,'enum190' ,'enum191' ,'enum192' ,'enum193' ,'enum194','enum195' ,'enum196' ,'enum197' ,'enum198' ,'enum199' ,'enum200' ,'enum201' ,'enum202' ,'enum203' ,'enum204','enum205' ,'enum206' ,'enum207' ,'enum208' ,'enum209' ,'enum210' ,'enum211' ,'enum212' ,'enum213' ,'enum214','enum215' ,'enum216' ,'enum217' ,'enum218' ,'enum219' ,'enum220' ,'enum221' ,'enum222' ,'enum223' ,'enum224','enum225' ,'enum226' ,'enum227' ,'enum228' ,'enum229' ,'enum230' ,'enum231' ,'enum232' ,'enum233' ,'enum234','enum235' ,'enum236' ,'enum237' ,'enum238' ,'enum239' ,'enum240' ,'enum241' ,'enum242' ,'enum243' ,'enum244','enum245' ,'enum246' ,'enum247' ,'enum248' ,'enum249' ,'enum250' ,'enum251' ,'enum252' ,'enum253' ,'enum254','enum255' ,'enum256' ,'enum257' ,'enum258' ,'enum259' ,'enum260' ,'enum261' ,'enum262' ,'enum263' ,'enum264','enum265' ,'enum266' ,'enum267' ,'enum268' ,'enum269' ,'enum270' ,'enum271' ,'enum272' ,'enum273' ,'enum274','enum275' ,'enum276' ,'enum277' ,'enum278' ,'enum279' ,'enum280' ,'enum281' ,'enum282' ,'enum283' ,'enum284','enum285' ,'enum286' ,'enum287' ,'enum288' ,'enum289' ,'enum290' ,'enum291' ,'enum292' ,'enum293' ,'enum294','enum295' ,'enum296' ,'enum297' ,'enum298' ,'enum299');");
        statement.execute("CREATE TABLE t2 (id INT, e1 enum_long);");
        statement.execute("INSERT INTO t2 (id, e1) VALUES (1, 'enum290');");
        preparedStatement = connection.prepareStatement("SELECT e1 FROM t2 WHERE id = ?");
        preparedStatement.setObject(1, 1);
        resultSet = preparedStatement.executeQuery();
        resultSet.next();
        TestDuckDBJDBC.assertTrue(resultSet.getObject(1, String.class).equals("enum290"));
        TestDuckDBJDBC.assertTrue(resultSet.getString(1).equals("enum290"));
        TestDuckDBJDBC.assertTrue(resultSet.getString("e1").equals("enum290"));
        resultSet.close();
        connection.close();
    }

    public static void test_timestamp_ms() throws Exception {
        String string = "2022-08-17 12:11:10.999";
        String string2 = "SELECT '2022-08-17T12:11:10.999'::TIMESTAMP_MS as ts_ms";
        TestDuckDBJDBC.assert_timestamp_match(string2, string, "TIMESTAMP_MS");
    }

    public static void test_timestamp_ns() throws Exception {
        String string = "2022-08-17 12:11:10.999999";
        String string2 = "SELECT '2022-08-17T12:11:10.999999999'::TIMESTAMP_NS as ts_ns";
        TestDuckDBJDBC.assert_timestamp_match(string2, string, "TIMESTAMP_NS");
    }

    public static void test_timestamp_s() throws Exception {
        String string = "2022-08-17 12:11:10";
        String string2 = "SELECT '2022-08-17T12:11:10'::TIMESTAMP_S as ts_s";
        TestDuckDBJDBC.assert_timestamp_match(string2, string, "TIMESTAMP_S");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void assert_timestamp_match(String string, String string2, String string3) throws Exception {
        String string4 = System.getProperty("user.timezone");
        TimeZone timeZone = TimeZone.getDefault();
        try {
            TimeZone.setDefault(TimeZone.getTimeZone("UTC"));
            System.setProperty("user.timezone", "UTC");
            Connection connection = DriverManager.getConnection("jdbc:duckdb:");
            Statement statement = connection.createStatement();
            ResultSet resultSet = statement.executeQuery(string);
            TestDuckDBJDBC.assertTrue(resultSet.next());
            Timestamp timestamp = resultSet.getTimestamp(1);
            Timestamp timestamp2 = Timestamp.valueOf(string2);
            TestDuckDBJDBC.assertEquals(timestamp2.getTime(), timestamp.getTime());
            TestDuckDBJDBC.assertEquals(timestamp2.getNanos(), timestamp.getNanos());
            TestDuckDBJDBC.assertEquals(93, resultSet.getMetaData().getColumnType(1));
            TestDuckDBJDBC.assertEquals(string3, resultSet.getMetaData().getColumnTypeName(1));
            resultSet.close();
            statement.close();
            connection.close();
        }
        finally {
            TimeZone.setDefault(timeZone);
            System.setProperty("user.timezone", string4);
        }
    }

    public static void test_timestamp_tz() throws Exception {
        Connection connection = DriverManager.getConnection("jdbc:duckdb:");
        Statement statement = connection.createStatement();
        statement.execute("CREATE TABLE t (id INT, t1 TIMESTAMPTZ)");
        statement.execute("INSERT INTO t (id, t1) VALUES (1, '2022-01-01T12:11:10+02')");
        statement.execute("INSERT INTO t (id, t1) VALUES (2, '2022-01-01T12:11:10')");
        PreparedStatement preparedStatement = connection.prepareStatement("INSERT INTO T (id, t1) VALUES (?, ?)");
        OffsetDateTime offsetDateTime = OffsetDateTime.of(2020, 10, 7, 13, 15, 7, 12345, ZoneOffset.ofHours(7));
        OffsetDateTime offsetDateTime2 = OffsetDateTime.of(2020, 10, 7, 13, 15, 7, 12000, ZoneOffset.ofHours(7));
        OffsetDateTime offsetDateTime3 = OffsetDateTime.of(1878, 10, 2, 1, 15, 7, 12345, ZoneOffset.ofHours(-5));
        OffsetDateTime offsetDateTime4 = OffsetDateTime.of(1878, 10, 2, 1, 15, 7, 13000, ZoneOffset.ofHours(-5));
        OffsetDateTime offsetDateTime5 = OffsetDateTime.of(2022, 1, 1, 12, 11, 10, 0, ZoneOffset.ofHours(2));
        OffsetDateTime offsetDateTime6 = OffsetDateTime.of(2022, 1, 1, 12, 11, 10, 0, ZoneOffset.ofHours(0));
        OffsetDateTime offsetDateTime7 = OffsetDateTime.of(1900, 11, 27, 23, 59, 59, 0, ZoneOffset.ofHours(1));
        preparedStatement.setObject(1, 3);
        preparedStatement.setObject(2, offsetDateTime);
        preparedStatement.execute();
        preparedStatement.setObject(1, 4);
        preparedStatement.setObject(2, (Object)offsetDateTime7, 2014);
        preparedStatement.execute();
        preparedStatement.setObject(1, 5);
        preparedStatement.setObject(2, offsetDateTime3);
        preparedStatement.execute();
        ResultSet resultSet = statement.executeQuery("SELECT * FROM t ORDER BY id");
        ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
        resultSet.next();
        TestDuckDBJDBC.assertTrue(resultSet.getObject(2, OffsetDateTime.class).isEqual(offsetDateTime5));
        resultSet.next();
        TestDuckDBJDBC.assertEquals(resultSet.getObject(2, OffsetDateTime.class), offsetDateTime6);
        resultSet.next();
        TestDuckDBJDBC.assertTrue(resultSet.getObject(2, OffsetDateTime.class).isEqual(offsetDateTime2));
        resultSet.next();
        TestDuckDBJDBC.assertTrue(resultSet.getObject(2, OffsetDateTime.class).isEqual(offsetDateTime7));
        resultSet.next();
        TestDuckDBJDBC.assertTrue(resultSet.getObject(2, OffsetDateTime.class).isEqual(offsetDateTime4));
        TestDuckDBJDBC.assertTrue(((OffsetDateTime)resultSet.getObject(2)).isEqual(offsetDateTime4));
        DuckDBResultSetMetaData cfr_ignored_0 = (DuckDBResultSetMetaData)resultSetMetaData;
        TestDuckDBJDBC.assertEquals(2014, DuckDBResultSetMetaData.type_to_int(DuckDBColumnType.TIMESTAMP_WITH_TIME_ZONE));
        TestDuckDBJDBC.assertTrue(OffsetDateTime.class.toString().equals(resultSetMetaData.getColumnClassName(2)));
        resultSet.close();
        statement.close();
        connection.close();
    }

    public static void test_throw_wrong_datatype() throws Exception {
        Connection connection = DriverManager.getConnection("jdbc:duckdb:");
        Statement statement = connection.createStatement();
        statement.execute("CREATE TABLE t (id INT, t1 TIMESTAMPTZ, t2 TIMESTAMP)");
        statement.execute("INSERT INTO t (id, t1, t2) VALUES (1, '2022-01-01T12:11:10+02', '2022-01-01T12:11:10')");
        ResultSet resultSet = statement.executeQuery("SELECT * FROM t");
        resultSet.next();
        try {
            resultSet.getTimestamp(2);
            TestDuckDBJDBC.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        resultSet.close();
        statement.close();
        connection.close();
    }

    public static void test_result() throws Exception {
        Connection connection = DriverManager.getConnection("jdbc:duckdb:");
        Statement statement = connection.createStatement();
        ResultSet resultSet = statement.executeQuery("SELECT CAST(42 AS INTEGER) as a, CAST(4.2 AS DOUBLE) as b");
        ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
        TestDuckDBJDBC.assertEquals(resultSetMetaData.getColumnCount(), 2);
        TestDuckDBJDBC.assertEquals(resultSetMetaData.getColumnName(1), "a");
        TestDuckDBJDBC.assertEquals(resultSetMetaData.getColumnName(2), "b");
        TestDuckDBJDBC.assertEquals(resultSetMetaData.getColumnTypeName(1), "INTEGER");
        TestDuckDBJDBC.assertEquals(resultSetMetaData.getColumnTypeName(2), "DOUBLE");
        try {
            resultSetMetaData.getColumnName(0);
            TestDuckDBJDBC.fail();
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            // empty catch block
        }
        try {
            resultSetMetaData.getColumnTypeName(0);
            TestDuckDBJDBC.fail();
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            // empty catch block
        }
        try {
            resultSetMetaData.getColumnName(3);
            TestDuckDBJDBC.fail();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        try {
            resultSetMetaData.getColumnTypeName(3);
            TestDuckDBJDBC.fail();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        TestDuckDBJDBC.assertTrue(resultSet.next());
        TestDuckDBJDBC.assertEquals(resultSet.getInt(1), 42);
        TestDuckDBJDBC.assertEquals(resultSet.getString(1), "42");
        TestDuckDBJDBC.assertEquals(resultSet.getDouble(1), 42.0, 0.001);
        TestDuckDBJDBC.assertTrue(resultSet.getObject(1).equals(42));
        TestDuckDBJDBC.assertEquals(resultSet.getInt("a"), 42);
        TestDuckDBJDBC.assertEquals(resultSet.getString("a"), "42");
        TestDuckDBJDBC.assertEquals(resultSet.getDouble("a"), 42.0, 0.001);
        TestDuckDBJDBC.assertTrue(resultSet.getObject("a").equals(42));
        TestDuckDBJDBC.assertEquals(resultSet.getInt(2), 4);
        TestDuckDBJDBC.assertEquals(resultSet.getString(2), "4.2");
        TestDuckDBJDBC.assertEquals(resultSet.getDouble(2), 4.2, 0.001);
        TestDuckDBJDBC.assertTrue(resultSet.getObject(2).equals(4.2));
        TestDuckDBJDBC.assertEquals(resultSet.getInt("b"), 4);
        TestDuckDBJDBC.assertEquals(resultSet.getString("b"), "4.2");
        TestDuckDBJDBC.assertEquals(resultSet.getDouble("b"), 4.2, 0.001);
        TestDuckDBJDBC.assertTrue(resultSet.getObject("b").equals(4.2));
        TestDuckDBJDBC.assertFalse(resultSet.next());
        resultSet.close();
        statement.close();
        Connection connection2 = ((DuckDBConnection)connection).duplicate();
        ResultSet resultSet2 = connection2.createStatement().executeQuery("SELECT 42");
        resultSet2.next();
        TestDuckDBJDBC.assertEquals(42, resultSet2.getInt(1));
        resultSet2.close();
        connection.close();
        connection2.close();
    }

    public static void test_empty_table() throws Exception {
        Connection connection = DriverManager.getConnection("jdbc:duckdb:");
        Statement statement = connection.createStatement();
        statement.execute("CREATE TABLE a (i iNTEGER)");
        ResultSet resultSet = statement.executeQuery("SELECT * FROM a");
        TestDuckDBJDBC.assertFalse(resultSet.next());
        try {
            resultSet.getObject(1);
            TestDuckDBJDBC.fail();
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            // empty catch block
        }
        resultSet.close();
        statement.close();
        connection.close();
    }

    public static void test_broken_next() throws Exception {
        Connection connection = DriverManager.getConnection("jdbc:duckdb:");
        Statement statement = connection.createStatement();
        statement.execute("CREATE TABLE t0(c0 INT8, c1 VARCHAR)");
        statement.execute("INSERT INTO t0(c1, c0) VALUES (-315929644, 1), (-315929644, -315929644), (-634993846, -1981637379)");
        statement.execute("INSERT INTO t0(c0, c1) VALUES (-433000283, -433000283)");
        statement.execute("INSERT INTO t0(c0) VALUES (-995217820)");
        statement.execute("INSERT INTO t0(c1, c0) VALUES (-315929644, -315929644)");
        ResultSet resultSet = statement.executeQuery("SELECT c0 FROM t0");
        while (resultSet.next()) {
            TestDuckDBJDBC.assertTrue(!resultSet.getObject(1).equals(null));
        }
        resultSet.close();
        statement.close();
        connection.close();
    }

    public static void test_multiple_connections() throws Exception {
        Connection connection = DriverManager.getConnection("jdbc:duckdb:");
        Statement statement = connection.createStatement();
        Connection connection2 = DriverManager.getConnection("jdbc:duckdb:");
        Statement statement2 = connection2.createStatement();
        Statement statement3 = connection2.createStatement();
        ResultSet resultSet = statement.executeQuery("SELECT 42");
        TestDuckDBJDBC.assertTrue(resultSet.next());
        TestDuckDBJDBC.assertEquals(42, resultSet.getInt(1));
        resultSet.close();
        ResultSet resultSet2 = statement2.executeQuery("SELECT 43");
        TestDuckDBJDBC.assertTrue(resultSet2.next());
        TestDuckDBJDBC.assertEquals(43, resultSet2.getInt(1));
        ResultSet resultSet3 = statement3.executeQuery("SELECT 44");
        TestDuckDBJDBC.assertTrue(resultSet3.next());
        TestDuckDBJDBC.assertEquals(44, resultSet3.getInt(1));
        resultSet3.close();
        statement2.close();
        resultSet3 = statement3.executeQuery("SELECT 44");
        TestDuckDBJDBC.assertTrue(resultSet3.next());
        TestDuckDBJDBC.assertEquals(44, resultSet3.getInt(1));
        statement2.close();
        resultSet2.close();
        resultSet3.close();
        System.gc();
        System.gc();
        resultSet = statement.executeQuery("SELECT 42");
        TestDuckDBJDBC.assertTrue(resultSet.next());
        TestDuckDBJDBC.assertEquals(42, resultSet.getInt(1));
        resultSet.close();
        resultSet3 = statement3.executeQuery("SELECT 42");
        TestDuckDBJDBC.assertTrue(resultSet3.next());
        TestDuckDBJDBC.assertEquals(42, resultSet3.getInt(1));
        resultSet3.close();
        connection2.close();
        statement3.close();
        resultSet2 = null;
        resultSet3 = null;
        statement2 = null;
        statement3 = null;
        connection2 = null;
        System.gc();
        System.gc();
        resultSet = statement.executeQuery("SELECT 42");
        TestDuckDBJDBC.assertTrue(resultSet.next());
        TestDuckDBJDBC.assertEquals(42, resultSet.getInt(1));
        resultSet.close();
        connection.close();
        statement.close();
    }

    public static void test_duckdb_timestamp() throws Exception {
        TestDuckDBJDBC.duckdb_timestamp_test();
        TimeZone timeZone = TimeZone.getDefault();
        TimeZone.setDefault(TimeZone.getTimeZone("America/Lima"));
        TestDuckDBJDBC.duckdb_timestamp_test();
        TimeZone.setDefault(TimeZone.getTimeZone("Europe/Berlin"));
        TestDuckDBJDBC.duckdb_timestamp_test();
        TimeZone.setDefault(timeZone);
    }

    public static void duckdb_timestamp_test() throws Exception {
        Connection connection = DriverManager.getConnection("jdbc:duckdb:");
        Statement statement = connection.createStatement();
        statement.execute("CREATE TABLE a (ts TIMESTAMP)");
        Timestamp timestamp = Timestamp.valueOf("1970-01-01 00:00:00");
        Timestamp timestamp2 = Timestamp.valueOf("2021-07-29 21:13:11");
        Timestamp timestamp3 = Timestamp.valueOf("2021-07-29 21:13:11.123456");
        Timestamp timestamp4 = Timestamp.valueOf("1921-07-29 21:13:11");
        Timestamp timestamp5 = Timestamp.valueOf("1921-07-29 21:13:11.123456");
        Timestamp timestamp6 = new DuckDBTimestamp(timestamp).toSqlTimestamp();
        Timestamp timestamp7 = new DuckDBTimestamp(timestamp2).toSqlTimestamp();
        Timestamp timestamp8 = new DuckDBTimestamp(timestamp3).toSqlTimestamp();
        Timestamp timestamp9 = new DuckDBTimestamp(timestamp4).toSqlTimestamp();
        Timestamp timestamp10 = new DuckDBTimestamp(timestamp5).toSqlTimestamp();
        TestDuckDBJDBC.assertTrue(timestamp.getTime() == timestamp6.getTime());
        TestDuckDBJDBC.assertTrue(timestamp.compareTo(timestamp6) == 0);
        TestDuckDBJDBC.assertTrue(timestamp2.getTime() == timestamp7.getTime());
        TestDuckDBJDBC.assertTrue(timestamp2.compareTo(timestamp7) == 0);
        TestDuckDBJDBC.assertTrue(timestamp3.getTime() == timestamp8.getTime());
        TestDuckDBJDBC.assertTrue(timestamp3.compareTo(timestamp8) == 0);
        TestDuckDBJDBC.assertTrue(timestamp4.getTime() == timestamp9.getTime());
        TestDuckDBJDBC.assertTrue(timestamp4.compareTo(timestamp9) == 0);
        TestDuckDBJDBC.assertTrue(timestamp5.getTime() == timestamp10.getTime());
        TestDuckDBJDBC.assertTrue(timestamp5.compareTo(timestamp10) == 0);
        TestDuckDBJDBC.assertTrue(DuckDBTimestamp.getMicroseconds(DuckDBTimestamp.toSqlTimestamp(5678912345L)) == 5678912345L);
        DuckDBTimestamp duckDBTimestamp = new DuckDBTimestamp(timestamp2);
        TestDuckDBJDBC.assertTrue(duckDBTimestamp.toSqlTimestamp().compareTo(timestamp2) == 0);
        DuckDBTimestamp duckDBTimestamp2 = new DuckDBTimestamp(timestamp3);
        TestDuckDBJDBC.assertTrue(duckDBTimestamp2.toSqlTimestamp().compareTo(timestamp3) == 0);
        statement.execute("INSERT INTO a (ts) VALUES ('2005-11-02 07:59:58')");
        ResultSet resultSet = statement.executeQuery("SELECT * FROM a");
        TestDuckDBJDBC.assertTrue(resultSet.next());
        TestDuckDBJDBC.assertEquals(resultSet.getObject("ts"), Timestamp.valueOf("2005-11-02 07:59:58"));
        TestDuckDBJDBC.assertEquals(resultSet.getTimestamp("ts"), Timestamp.valueOf("2005-11-02 07:59:58"));
        resultSet.close();
        statement.close();
        PreparedStatement preparedStatement = connection.prepareStatement("SELECT COUNT(ts) FROM a WHERE ts = ?");
        preparedStatement.setTimestamp(1, Timestamp.valueOf("2005-11-02 07:59:58"));
        ResultSet resultSet2 = preparedStatement.executeQuery();
        TestDuckDBJDBC.assertTrue(resultSet2.next());
        TestDuckDBJDBC.assertEquals(resultSet2.getInt(1), 1);
        resultSet2.close();
        preparedStatement.close();
        preparedStatement = connection.prepareStatement("SELECT COUNT(ts) FROM a WHERE ts = ?");
        preparedStatement.setObject(1, Timestamp.valueOf("2005-11-02 07:59:58"));
        ResultSet resultSet3 = preparedStatement.executeQuery();
        TestDuckDBJDBC.assertTrue(resultSet3.next());
        TestDuckDBJDBC.assertEquals(resultSet3.getInt(1), 1);
        resultSet3.close();
        preparedStatement.close();
        preparedStatement = connection.prepareStatement("SELECT COUNT(ts) FROM a WHERE ts = ?");
        preparedStatement.setObject(1, (Object)Timestamp.valueOf("2005-11-02 07:59:58"), 93);
        ResultSet resultSet4 = preparedStatement.executeQuery();
        TestDuckDBJDBC.assertTrue(resultSet4.next());
        TestDuckDBJDBC.assertEquals(resultSet4.getInt(1), 1);
        resultSet4.close();
        preparedStatement.close();
        Statement statement2 = connection.createStatement();
        statement2.execute("INSERT INTO a (ts) VALUES ('1905-11-02 07:59:58.12345')");
        preparedStatement = connection.prepareStatement("SELECT COUNT(ts) FROM a WHERE ts = ?");
        preparedStatement.setTimestamp(1, Timestamp.valueOf("1905-11-02 07:59:58.12345"));
        ResultSet resultSet5 = preparedStatement.executeQuery();
        TestDuckDBJDBC.assertTrue(resultSet5.next());
        TestDuckDBJDBC.assertEquals(resultSet5.getInt(1), 1);
        resultSet5.close();
        preparedStatement.close();
        preparedStatement = connection.prepareStatement("SELECT ts FROM a WHERE ts = ?");
        preparedStatement.setTimestamp(1, Timestamp.valueOf("1905-11-02 07:59:58.12345"));
        ResultSet resultSet6 = preparedStatement.executeQuery();
        TestDuckDBJDBC.assertTrue(resultSet6.next());
        TestDuckDBJDBC.assertEquals(resultSet6.getTimestamp(1), Timestamp.valueOf("1905-11-02 07:59:58.12345"));
        resultSet6.close();
        preparedStatement.close();
        connection.close();
    }

    public static void test_duckdb_localdatetime() throws Exception {
        Connection connection = DriverManager.getConnection("jdbc:duckdb:");
        Statement statement = connection.createStatement();
        statement.execute("CREATE TABLE x (ts TIMESTAMP)");
        LocalDateTime localDateTime = LocalDateTime.of(2021, 1, 18, 21, 20, 7);
        PreparedStatement preparedStatement = connection.prepareStatement("INSERT INTO x VALUES (?)");
        preparedStatement.setObject(1, localDateTime);
        preparedStatement.execute();
        preparedStatement.close();
        PreparedStatement preparedStatement2 = connection.prepareStatement("SELECT * FROM x");
        ResultSet resultSet = preparedStatement2.executeQuery();
        resultSet.next();
        TestDuckDBJDBC.assertEquals(resultSet.getTimestamp(1), resultSet.getObject(1, Timestamp.class));
        TestDuckDBJDBC.assertEquals(resultSet.getObject(1, LocalDateTime.class), localDateTime);
        resultSet.close();
        preparedStatement2.close();
        statement.close();
        connection.close();
    }

    public static void test_duckdb_getObject_with_class() throws Exception {
        Connection connection = DriverManager.getConnection("jdbc:duckdb:");
        Statement statement = connection.createStatement();
        statement.execute("CREATE TABLE b (vchar VARCHAR, bo BOOLEAN, sint SMALLINT, nint INTEGER, bigi BIGINT, flt FLOAT, dbl DOUBLE, dte DATE, tme TIME, ts TIMESTAMP, dec16 DECIMAL(3,1), dec32 DECIMAL(9,8), dec64 DECIMAL(16,1), dec128 DECIMAL(30,10), tint TINYINT, utint UTINYINT, usint USMALLINT, uint UINTEGER, ubig UBIGINT, hin HUGEINT, blo BLOB)");
        statement.execute("INSERT INTO b VALUES ('varchary', true, 6, 42, 666, 42.666, 666.42, '1970-01-02', '01:00:34', '1970-01-03 03:42:23', 42.2, 1.23456789, 987654321012345.6, 111112222233333.44444,  -4, 200, 50001, 4000111222, 18446744073709551615, 18446744073709551616, 'yeah'::BLOB)");
        PreparedStatement preparedStatement = connection.prepareStatement("SELECT * FROM b");
        ResultSet resultSet = preparedStatement.executeQuery();
        resultSet.next();
        TestDuckDBJDBC.assertEquals(resultSet.getString(1), resultSet.getObject(1, String.class));
        TestDuckDBJDBC.assertEquals(resultSet.getBoolean(2), resultSet.getObject(2, Boolean.class));
        TestDuckDBJDBC.assertEquals(resultSet.getShort(3), resultSet.getObject(3, Short.class));
        TestDuckDBJDBC.assertEquals(resultSet.getInt(4), resultSet.getObject(4, Integer.class));
        TestDuckDBJDBC.assertEquals(resultSet.getLong(5), resultSet.getObject(5, Long.class));
        TestDuckDBJDBC.assertEquals(Float.valueOf(resultSet.getFloat(6)), resultSet.getObject(6, Float.class));
        TestDuckDBJDBC.assertEquals(resultSet.getDouble(7), resultSet.getObject(7, Double.class));
        TestDuckDBJDBC.assertEquals(resultSet.getDate(8), resultSet.getObject(8, Date.class));
        TestDuckDBJDBC.assertEquals(resultSet.getTime(9), resultSet.getObject(9, Time.class));
        TestDuckDBJDBC.assertEquals(resultSet.getTimestamp(10), resultSet.getObject(10, Timestamp.class));
        TestDuckDBJDBC.assertEquals(resultSet.getObject(10, LocalDateTime.class), LocalDateTime.parse("1970-01-03T03:42:23"));
        TestDuckDBJDBC.assertEquals(resultSet.getObject(10, LocalDateTime.class), LocalDateTime.of(1970, 1, 3, 3, 42, 23));
        TestDuckDBJDBC.assertEquals(resultSet.getBigDecimal(11), resultSet.getObject(11, BigDecimal.class));
        TestDuckDBJDBC.assertEquals(resultSet.getBigDecimal(12), resultSet.getObject(12, BigDecimal.class));
        TestDuckDBJDBC.assertEquals(resultSet.getBigDecimal(13), resultSet.getObject(13, BigDecimal.class));
        TestDuckDBJDBC.assertEquals(resultSet.getBigDecimal(14), resultSet.getObject(14, BigDecimal.class));
        try {
            resultSet.getObject(11, Integer.class);
            TestDuckDBJDBC.assertTrue(false);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        try {
            resultSet.getObject(12, Integer.class);
            TestDuckDBJDBC.assertTrue(false);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        try {
            resultSet.getObject(13, Integer.class);
            TestDuckDBJDBC.assertTrue(false);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        try {
            resultSet.getObject(14, Long.class);
            TestDuckDBJDBC.assertTrue(false);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        try {
            resultSet.getObject(15, BigInteger.class);
            TestDuckDBJDBC.assertTrue(false);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        try {
            resultSet.getObject(16, BigInteger.class);
            TestDuckDBJDBC.assertTrue(false);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        try {
            resultSet.getObject(16, Blob.class);
            TestDuckDBJDBC.assertTrue(false);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        resultSet.close();
        preparedStatement.close();
        statement.close();
        connection.close();
    }

    public static void test_multiple_statements_execution() throws Exception {
        DuckDBConnection duckDBConnection = (DuckDBConnection)DriverManager.getConnection("jdbc:duckdb:");
        Statement statement = duckDBConnection.createStatement();
        ResultSet resultSet = statement.executeQuery("CREATE TABLE integers(i integer);\ninsert into integers select * from range(10);select * from integers;");
        int n = 0;
        while (resultSet.next()) {
            TestDuckDBJDBC.assertEquals(resultSet.getInt("i"), n);
            ++n;
        }
        TestDuckDBJDBC.assertEquals(n, 10);
    }

    public static void test_multiple_statements_exception() throws Exception {
        DuckDBConnection duckDBConnection = (DuckDBConnection)DriverManager.getConnection("jdbc:duckdb:");
        Statement statement = duckDBConnection.createStatement();
        boolean bl = false;
        try {
            statement.executeQuery("CREATE TABLE integers(i integer, i boolean);\nCREATE TABLE integers2(i integer);\ninsert into integers2 select * from range(10);\nselect * from integers2;");
            bl = true;
        }
        catch (Exception exception) {
            TestDuckDBJDBC.assertFalse(bl);
        }
    }

    public static void test_bigdecimal() throws Exception {
        Connection connection = DriverManager.getConnection("jdbc:duckdb:");
        Statement statement = connection.createStatement();
        statement.execute("CREATE TABLE q (id DECIMAL(3,0), dec16 DECIMAL(4,1), dec32 DECIMAL(9,4), dec64 DECIMAL(18,7), dec128 DECIMAL(38,10))");
        PreparedStatement preparedStatement = connection.prepareStatement("INSERT INTO q (id, dec16, dec32, dec64, dec128) VALUES (?, ?, ?, ?, ?)");
        preparedStatement.setObject(1, new BigDecimal("1"));
        preparedStatement.setObject(2, new BigDecimal("999.9"));
        preparedStatement.setObject(3, new BigDecimal("99999.9999"));
        preparedStatement.setObject(4, new BigDecimal("99999999999.9999999"));
        preparedStatement.setObject(5, new BigDecimal("9999999999999999999999999999.9999999999"));
        preparedStatement.execute();
        preparedStatement.clearParameters();
        preparedStatement.setBigDecimal(1, new BigDecimal("2"));
        preparedStatement.setBigDecimal(2, new BigDecimal("-999.9"));
        preparedStatement.setBigDecimal(3, new BigDecimal("-99999.9999"));
        preparedStatement.setBigDecimal(4, new BigDecimal("-99999999999.9999999"));
        preparedStatement.setBigDecimal(5, new BigDecimal("-9999999999999999999999999999.9999999999"));
        preparedStatement.execute();
        preparedStatement.clearParameters();
        preparedStatement.setObject(1, (Object)new BigDecimal("3"), 3);
        preparedStatement.setObject(2, (Object)new BigDecimal("-5"), 3);
        preparedStatement.setObject(3, (Object)new BigDecimal("-999"), 3);
        preparedStatement.setObject(4, (Object)new BigDecimal("-88888888"), 3);
        preparedStatement.setObject(5, (Object)new BigDecimal("-123456789654321"), 3);
        preparedStatement.execute();
        preparedStatement.close();
        statement.execute("INSERT INTO q (id, dec16, dec32, dec64, dec128) VALUES (4, -0, -0, -0, -0)");
        statement.execute("INSERT INTO q (id, dec16, dec32, dec64, dec128) VALUES (5, 0, 0, 0, 18446744073709551615)");
        statement.execute("INSERT INTO q (id, dec16, dec32, dec64, dec128) VALUES (6, 0, 0, 0, 18446744073709551616)");
        statement.execute("INSERT INTO q (id, dec16, dec32, dec64, dec128) VALUES (7, 0, 0, 0, -18446744073709551615)");
        statement.execute("INSERT INTO q (id, dec16, dec32, dec64, dec128) VALUES (8, 0, 0, 0, -18446744073709551616)");
        statement.close();
        PreparedStatement preparedStatement2 = connection.prepareStatement("SELECT * FROM q ORDER BY id");
        ResultSet resultSet = preparedStatement2.executeQuery();
        while (resultSet.next()) {
            TestDuckDBJDBC.assertEquals(resultSet.getBigDecimal(1), resultSet.getObject(1, BigDecimal.class));
            TestDuckDBJDBC.assertEquals(resultSet.getBigDecimal(2), resultSet.getObject(2, BigDecimal.class));
            TestDuckDBJDBC.assertEquals(resultSet.getBigDecimal(3), resultSet.getObject(3, BigDecimal.class));
            TestDuckDBJDBC.assertEquals(resultSet.getBigDecimal(4), resultSet.getObject(4, BigDecimal.class));
            TestDuckDBJDBC.assertEquals(resultSet.getBigDecimal(5), resultSet.getObject(5, BigDecimal.class));
        }
        resultSet.close();
        ResultSet resultSet2 = preparedStatement2.executeQuery();
        DuckDBResultSetMetaData duckDBResultSetMetaData = (DuckDBResultSetMetaData)resultSet2.getMetaData();
        resultSet2.next();
        TestDuckDBJDBC.assertEquals(resultSet2.getBigDecimal(1), new BigDecimal("1"));
        TestDuckDBJDBC.assertEquals(resultSet2.getBigDecimal(2), new BigDecimal("999.9"));
        TestDuckDBJDBC.assertEquals(resultSet2.getBigDecimal(3), new BigDecimal("99999.9999"));
        TestDuckDBJDBC.assertEquals(resultSet2.getBigDecimal(4), new BigDecimal("99999999999.9999999"));
        TestDuckDBJDBC.assertEquals(resultSet2.getBigDecimal(5), new BigDecimal("9999999999999999999999999999.9999999999"));
        resultSet2.next();
        TestDuckDBJDBC.assertEquals(resultSet2.getBigDecimal(1), new BigDecimal("2"));
        TestDuckDBJDBC.assertEquals(resultSet2.getBigDecimal(2), new BigDecimal("-999.9"));
        TestDuckDBJDBC.assertEquals(resultSet2.getBigDecimal(3), new BigDecimal("-99999.9999"));
        TestDuckDBJDBC.assertEquals(resultSet2.getBigDecimal(4), new BigDecimal("-99999999999.9999999"));
        TestDuckDBJDBC.assertEquals(resultSet2.getBigDecimal(5), new BigDecimal("-9999999999999999999999999999.9999999999"));
        resultSet2.next();
        TestDuckDBJDBC.assertEquals(resultSet2.getBigDecimal(1), new BigDecimal("3"));
        TestDuckDBJDBC.assertEquals(resultSet2.getBigDecimal(2), new BigDecimal("-5.0"));
        TestDuckDBJDBC.assertEquals(resultSet2.getBigDecimal(3), new BigDecimal("-999.0000"));
        TestDuckDBJDBC.assertEquals(resultSet2.getBigDecimal(4), new BigDecimal("-88888888.0000000"));
        TestDuckDBJDBC.assertEquals(resultSet2.getBigDecimal(5), new BigDecimal("-123456789654321.0000000000"));
        resultSet2.next();
        TestDuckDBJDBC.assertEquals(resultSet2.getBigDecimal(1), new BigDecimal("4"));
        TestDuckDBJDBC.assertEquals(resultSet2.getBigDecimal(2), new BigDecimal("-0.0"));
        TestDuckDBJDBC.assertEquals(resultSet2.getBigDecimal(3), new BigDecimal("-0.0000"));
        TestDuckDBJDBC.assertEquals(resultSet2.getBigDecimal(4), new BigDecimal("-0.0000000"));
        TestDuckDBJDBC.assertEquals(resultSet2.getBigDecimal(5), new BigDecimal("-0.0000000000"));
        resultSet2.next();
        TestDuckDBJDBC.assertEquals(resultSet2.getBigDecimal(1), new BigDecimal("5"));
        TestDuckDBJDBC.assertEquals(resultSet2.getBigDecimal(5), new BigDecimal("18446744073709551615.0000000000"));
        resultSet2.next();
        TestDuckDBJDBC.assertEquals(resultSet2.getBigDecimal(1), new BigDecimal("6"));
        TestDuckDBJDBC.assertEquals(resultSet2.getBigDecimal(5), new BigDecimal("18446744073709551616.0000000000"));
        resultSet2.next();
        TestDuckDBJDBC.assertEquals(resultSet2.getBigDecimal(1), new BigDecimal("7"));
        TestDuckDBJDBC.assertEquals(resultSet2.getBigDecimal(5), new BigDecimal("-18446744073709551615.0000000000"));
        resultSet2.next();
        TestDuckDBJDBC.assertEquals(resultSet2.getBigDecimal(1), new BigDecimal("8"));
        TestDuckDBJDBC.assertEquals(resultSet2.getBigDecimal(5), new BigDecimal("-18446744073709551616.0000000000"));
        resultSet2.close();
        TestDuckDBJDBC.assertEquals(3, DuckDBResultSetMetaData.type_to_int(DuckDBColumnType.DECIMAL));
        TestDuckDBJDBC.assertTrue(BigDecimal.class.toString().equals(duckDBResultSetMetaData.getColumnClassName(1)));
        TestDuckDBJDBC.assertTrue(BigDecimal.class.toString().equals(duckDBResultSetMetaData.getColumnClassName(2)));
        TestDuckDBJDBC.assertTrue(BigDecimal.class.toString().equals(duckDBResultSetMetaData.getColumnClassName(3)));
        TestDuckDBJDBC.assertTrue(BigDecimal.class.toString().equals(duckDBResultSetMetaData.getColumnClassName(4)));
        TestDuckDBJDBC.assertEquals(3, duckDBResultSetMetaData.getPrecision(1));
        TestDuckDBJDBC.assertEquals(0, duckDBResultSetMetaData.getScale(1));
        TestDuckDBJDBC.assertEquals(4, duckDBResultSetMetaData.getPrecision(2));
        TestDuckDBJDBC.assertEquals(1, duckDBResultSetMetaData.getScale(2));
        TestDuckDBJDBC.assertEquals(9, duckDBResultSetMetaData.getPrecision(3));
        TestDuckDBJDBC.assertEquals(4, duckDBResultSetMetaData.getScale(3));
        TestDuckDBJDBC.assertEquals(18, duckDBResultSetMetaData.getPrecision(4));
        TestDuckDBJDBC.assertEquals(7, duckDBResultSetMetaData.getScale(4));
        TestDuckDBJDBC.assertEquals(38, duckDBResultSetMetaData.getPrecision(5));
        TestDuckDBJDBC.assertEquals(10, duckDBResultSetMetaData.getScale(5));
        connection.close();
    }

    public static void test_lots_of_timestamps() throws Exception {
        long l;
        Connection connection = DriverManager.getConnection("jdbc:duckdb:");
        Statement statement = connection.createStatement();
        statement.execute("CREATE TABLE a (ts TIMESTAMP)");
        Timestamp timestamp = Timestamp.valueOf("1970-01-01 01:01:01");
        for (l = 134234533L; l < 13423453300L; l += 73512L) {
            timestamp.setTime(l);
            statement.execute("INSERT INTO a (ts) VALUES ('" + timestamp + "')");
        }
        statement.close();
        for (l = 134234533L; l < 13423453300L; l += 73512L) {
            PreparedStatement preparedStatement = connection.prepareStatement("SELECT COUNT(ts) FROM a WHERE ts = ?");
            preparedStatement.setTimestamp(1, timestamp);
            ResultSet resultSet = preparedStatement.executeQuery();
            TestDuckDBJDBC.assertTrue(resultSet.next());
            TestDuckDBJDBC.assertEquals(resultSet.getInt(1), 1);
            resultSet.close();
            preparedStatement.close();
        }
        connection.close();
    }

    public static void test_lots_of_decimals() throws Exception {
        Connection connection = DriverManager.getConnection("jdbc:duckdb:");
        Statement statement = connection.createStatement();
        statement.execute("CREATE TABLE q (id DECIMAL(4,0), dec32 DECIMAL(9,4), dec64 DECIMAL(18,7), dec128 DECIMAL(38,10))");
        statement.close();
        PreparedStatement preparedStatement = connection.prepareStatement("INSERT INTO q (id, dec32, dec64, dec128) VALUES (?, ?, ?, ?)");
        preparedStatement.setObject(1, new BigDecimal("1"));
        BigDecimal bigDecimal = new BigDecimal("99999.9999");
        BigDecimal bigDecimal2 = new BigDecimal("99999999999.9999999");
        BigDecimal bigDecimal3 = new BigDecimal("9999999999999999999999999999.9999999999");
        preparedStatement.setObject(2, bigDecimal);
        preparedStatement.setObject(3, bigDecimal2);
        preparedStatement.setObject(4, bigDecimal3);
        preparedStatement.execute();
        PreparedStatement preparedStatement2 = connection.prepareStatement("SELECT * FROM q WHERE id = ?");
        BigDecimal bigDecimal4 = new BigDecimal("0.987");
        for (int i = 2; i < 10000; ++i) {
            preparedStatement2.setObject(1, new BigDecimal(i - 1));
            ResultSet resultSet = preparedStatement2.executeQuery();
            TestDuckDBJDBC.assertTrue(resultSet.next());
            BigDecimal bigDecimal5 = resultSet.getObject(2, BigDecimal.class);
            BigDecimal bigDecimal6 = resultSet.getObject(3, BigDecimal.class);
            BigDecimal bigDecimal7 = resultSet.getObject(4, BigDecimal.class);
            TestDuckDBJDBC.assertEquals(bigDecimal, bigDecimal5);
            TestDuckDBJDBC.assertEquals(bigDecimal2, bigDecimal6);
            TestDuckDBJDBC.assertEquals(bigDecimal3, bigDecimal7);
            bigDecimal5 = resultSet.getBigDecimal(2);
            bigDecimal6 = resultSet.getBigDecimal(3);
            bigDecimal7 = resultSet.getBigDecimal(4);
            TestDuckDBJDBC.assertEquals(bigDecimal, bigDecimal5);
            TestDuckDBJDBC.assertEquals(bigDecimal2, bigDecimal6);
            TestDuckDBJDBC.assertEquals(bigDecimal3, bigDecimal7);
            resultSet.close();
            bigDecimal = bigDecimal5.multiply(bigDecimal4).setScale(4, RoundingMode.HALF_EVEN);
            bigDecimal2 = bigDecimal6.multiply(bigDecimal4).setScale(7, RoundingMode.HALF_EVEN);
            bigDecimal3 = bigDecimal7.multiply(bigDecimal4).setScale(10, RoundingMode.HALF_EVEN);
            preparedStatement.clearParameters();
            preparedStatement.setObject(1, new BigDecimal(i));
            preparedStatement.setObject(2, bigDecimal);
            preparedStatement.setObject(3, bigDecimal2);
            preparedStatement.setObject(4, bigDecimal3);
            preparedStatement.execute();
        }
        preparedStatement.close();
        preparedStatement2.close();
        connection.close();
    }

    public static void test_big_data() throws Exception {
        Connection connection = DriverManager.getConnection("jdbc:duckdb:");
        Statement statement = connection.createStatement();
        int n = 10000;
        statement.execute("CREATE TABLE a (i iNTEGER)");
        for (int i = 0; i < n; ++i) {
            statement.execute("INSERT INTO a VALUES (" + i + ")");
        }
        ResultSet resultSet = statement.executeQuery("SELECT CAST(i AS SMALLINT), CAST(i AS INTEGER), CAST(i AS BIGINT), CAST(i AS FLOAT), CAST(i AS DOUBLE), CAST(i as STRING), NULL FROM a");
        int n2 = 0;
        while (resultSet.next()) {
            int n3;
            for (n3 = 1; n3 <= 6; ++n3) {
                TestDuckDBJDBC.assertEquals(resultSet.getShort(n3), (short)n2);
                TestDuckDBJDBC.assertFalse(resultSet.wasNull());
                TestDuckDBJDBC.assertEquals(resultSet.getInt(n3), n2);
                TestDuckDBJDBC.assertFalse(resultSet.wasNull());
                TestDuckDBJDBC.assertEquals(resultSet.getLong(n3), n2);
                TestDuckDBJDBC.assertFalse(resultSet.wasNull());
                TestDuckDBJDBC.assertEquals(resultSet.getFloat(n3), n2, 0.001);
                TestDuckDBJDBC.assertFalse(resultSet.wasNull());
                TestDuckDBJDBC.assertEquals(resultSet.getDouble(n3), n2, 0.001);
                TestDuckDBJDBC.assertFalse(resultSet.wasNull());
                TestDuckDBJDBC.assertEquals(Double.parseDouble(resultSet.getString(n3)), n2, 0.001);
                TestDuckDBJDBC.assertFalse(resultSet.wasNull());
                Object object = resultSet.getObject(n3);
                TestDuckDBJDBC.assertFalse(resultSet.wasNull());
            }
            n3 = resultSet.getShort(7);
            TestDuckDBJDBC.assertTrue(resultSet.wasNull());
            int n4 = resultSet.getInt(7);
            TestDuckDBJDBC.assertTrue(resultSet.wasNull());
            long l = resultSet.getLong(7);
            TestDuckDBJDBC.assertTrue(resultSet.wasNull());
            float f = resultSet.getFloat(7);
            TestDuckDBJDBC.assertTrue(resultSet.wasNull());
            double d = resultSet.getDouble(7);
            TestDuckDBJDBC.assertTrue(resultSet.wasNull());
            String string = resultSet.getString(7);
            TestDuckDBJDBC.assertTrue(resultSet.wasNull());
            Object object = resultSet.getObject(7);
            TestDuckDBJDBC.assertTrue(resultSet.wasNull());
            ++n2;
        }
        TestDuckDBJDBC.assertEquals(n, n2);
        resultSet.close();
        statement.close();
        connection.close();
    }

    public static void test_crash_bug496() throws Exception {
        Connection connection = DriverManager.getConnection("jdbc:duckdb:");
        Statement statement = connection.createStatement();
        statement.execute("CREATE TABLE t0(c0 BOOLEAN, c1 INT)");
        statement.execute("CREATE INDEX i0 ON t0(c1, c0)");
        statement.execute("INSERT INTO t0(c1) VALUES (0)");
        statement.close();
        connection.close();
    }

    public static void test_tablepragma_bug491() throws Exception {
        Connection connection = DriverManager.getConnection("jdbc:duckdb:");
        Statement statement = connection.createStatement();
        statement.execute("CREATE TABLE t0(c0 INT)");
        ResultSet resultSet = statement.executeQuery("PRAGMA table_info('t0')");
        TestDuckDBJDBC.assertTrue(resultSet.next());
        TestDuckDBJDBC.assertEquals(resultSet.getInt("cid"), 0);
        TestDuckDBJDBC.assertEquals(resultSet.getString("name"), "c0");
        TestDuckDBJDBC.assertEquals(resultSet.getString("type"), "INTEGER");
        TestDuckDBJDBC.assertEquals(resultSet.getBoolean("notnull"), false);
        resultSet.getString("dflt_value");
        TestDuckDBJDBC.assertEquals(resultSet.getBoolean("pk"), false);
        TestDuckDBJDBC.assertFalse(resultSet.next());
        resultSet.close();
        statement.close();
        connection.close();
    }

    public static void test_nulltruth_bug489() throws Exception {
        Connection connection = DriverManager.getConnection("jdbc:duckdb:");
        Statement statement = connection.createStatement();
        statement.execute("CREATE TABLE t0(c0 INT)");
        statement.execute("INSERT INTO t0(c0) VALUES (0)");
        ResultSet resultSet = statement.executeQuery("SELECT * FROM t0 WHERE NOT(NULL OR TRUE)");
        TestDuckDBJDBC.assertFalse(resultSet.next());
        resultSet = statement.executeQuery("SELECT NOT(NULL OR TRUE)");
        TestDuckDBJDBC.assertTrue(resultSet.next());
        boolean bl = resultSet.getBoolean(1);
        TestDuckDBJDBC.assertEquals(bl, false);
        TestDuckDBJDBC.assertFalse(resultSet.wasNull());
        resultSet.close();
        statement.close();
        connection.close();
    }

    public static void test_empty_prepare_bug500() throws Exception {
        String string = "CREATE TABLE t0(c0 VARCHAR, c1 DOUBLE);\nCREATE TABLE t1(c0 DOUBLE, PRIMARY KEY(c0));\nINSERT INTO t0(c0) VALUES (0), (0), (0), (0);\nINSERT INTO t0(c0) VALUES (NULL), (NULL);\nINSERT INTO t1(c0) VALUES (0), (1);\n\nSELECT t0.c0 FROM t0, t1;";
        Connection connection = DriverManager.getConnection("jdbc:duckdb:");
        for (String string2 : string.split("\n")) {
            Statement statement = connection.createStatement();
            try {
                statement.execute(string2);
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
        connection.close();
    }

    public static void test_borked_string_bug539() throws Exception {
        Connection connection = DriverManager.getConnection("jdbc:duckdb:");
        Statement statement = connection.createStatement();
        statement.executeUpdate("CREATE TABLE t0 (c0 VARCHAR)");
        String string = String.format("INSERT INTO t0 VALUES('%c')", 55995);
        statement.executeUpdate(string);
        statement.close();
        connection.close();
    }

    public static void test_prepare_types() throws Exception {
        Connection connection = DriverManager.getConnection("jdbc:duckdb:");
        PreparedStatement preparedStatement = connection.prepareStatement("SELECT CAST(? AS BOOLEAN) c1, CAST(? AS TINYINT) c2, CAST(? AS SMALLINT) c3, CAST(? AS INTEGER) c4, CAST(? AS BIGINT) c5, CAST(? AS FLOAT) c6, CAST(? AS DOUBLE) c7, CAST(? AS STRING) c8");
        preparedStatement.setBoolean(1, true);
        preparedStatement.setByte(2, (byte)42);
        preparedStatement.setShort(3, (short)43);
        preparedStatement.setInt(4, 44);
        preparedStatement.setLong(5, 45L);
        preparedStatement.setFloat(6, 4.6f);
        preparedStatement.setDouble(7, 4.7);
        preparedStatement.setString(8, "four eight");
        ResultSet resultSet = preparedStatement.executeQuery();
        TestDuckDBJDBC.assertTrue(resultSet.next());
        TestDuckDBJDBC.assertEquals(resultSet.getBoolean(1), true);
        TestDuckDBJDBC.assertEquals(resultSet.getByte(2), (byte)42);
        TestDuckDBJDBC.assertEquals(resultSet.getShort(3), (short)43);
        TestDuckDBJDBC.assertEquals(resultSet.getInt(4), 44);
        TestDuckDBJDBC.assertEquals(resultSet.getLong(5), 45L);
        TestDuckDBJDBC.assertEquals(resultSet.getFloat(6), 4.6, 0.001);
        TestDuckDBJDBC.assertEquals(resultSet.getDouble(7), 4.7, 0.001);
        TestDuckDBJDBC.assertEquals(resultSet.getString(8), "four eight");
        resultSet.close();
        preparedStatement.setBoolean(1, false);
        preparedStatement.setByte(2, (byte)82);
        preparedStatement.setShort(3, (short)83);
        preparedStatement.setInt(4, 84);
        preparedStatement.setLong(5, 85L);
        preparedStatement.setFloat(6, 8.6f);
        preparedStatement.setDouble(7, 8.7);
        preparedStatement.setString(8, "eight eight\n\t");
        resultSet = preparedStatement.executeQuery();
        TestDuckDBJDBC.assertTrue(resultSet.next());
        TestDuckDBJDBC.assertEquals(resultSet.getBoolean(1), false);
        TestDuckDBJDBC.assertEquals(resultSet.getByte(2), (byte)82);
        TestDuckDBJDBC.assertEquals(resultSet.getShort(3), (short)83);
        TestDuckDBJDBC.assertEquals(resultSet.getInt(4), 84);
        TestDuckDBJDBC.assertEquals(resultSet.getLong(5), 85L);
        TestDuckDBJDBC.assertEquals(resultSet.getFloat(6), 8.6, 0.001);
        TestDuckDBJDBC.assertEquals(resultSet.getDouble(7), 8.7, 0.001);
        TestDuckDBJDBC.assertEquals(resultSet.getString(8), "eight eight\n\t");
        resultSet.close();
        preparedStatement.setObject(1, false);
        preparedStatement.setObject(2, (byte)82);
        preparedStatement.setObject(3, (short)83);
        preparedStatement.setObject(4, 84);
        preparedStatement.setObject(5, 85L);
        preparedStatement.setObject(6, Float.valueOf(8.6f));
        preparedStatement.setObject(7, 8.7);
        preparedStatement.setObject(8, "\ud86d\udf7c\ud83d\udd25\ud83d\ude1c\u4b54\ud83d\udfe2");
        resultSet = preparedStatement.executeQuery();
        TestDuckDBJDBC.assertTrue(resultSet.next());
        TestDuckDBJDBC.assertEquals(resultSet.getBoolean(1), false);
        TestDuckDBJDBC.assertEquals(resultSet.getByte(2), (byte)82);
        TestDuckDBJDBC.assertEquals(resultSet.getShort(3), (short)83);
        TestDuckDBJDBC.assertEquals(resultSet.getInt(4), 84);
        TestDuckDBJDBC.assertEquals(resultSet.getLong(5), 85L);
        TestDuckDBJDBC.assertEquals(resultSet.getFloat(6), 8.6, 0.001);
        TestDuckDBJDBC.assertEquals(resultSet.getDouble(7), 8.7, 0.001);
        TestDuckDBJDBC.assertEquals(resultSet.getString(8), "\ud86d\udf7c\ud83d\udd25\ud83d\ude1c\u4b54\ud83d\udfe2");
        preparedStatement.setNull(1, 0);
        preparedStatement.setNull(2, 0);
        preparedStatement.setNull(3, 0);
        preparedStatement.setNull(4, 0);
        preparedStatement.setNull(5, 0);
        preparedStatement.setNull(6, 0);
        preparedStatement.setNull(7, 0);
        preparedStatement.setNull(8, 0);
        resultSet = preparedStatement.executeQuery();
        TestDuckDBJDBC.assertTrue(resultSet.next());
        TestDuckDBJDBC.assertEquals(8, resultSet.getMetaData().getColumnCount());
        for (int i = 1; i <= resultSet.getMetaData().getColumnCount(); ++i) {
            TestDuckDBJDBC.assertNull(resultSet.getObject(i));
            TestDuckDBJDBC.assertTrue(resultSet.wasNull());
            TestDuckDBJDBC.assertNull(resultSet.getString(i));
            TestDuckDBJDBC.assertTrue(resultSet.wasNull());
        }
        resultSet.close();
        preparedStatement.close();
        connection.close();
    }

    public static void test_prepare_insert() throws Exception {
        int n;
        Connection connection = DriverManager.getConnection("jdbc:duckdb:");
        connection.createStatement().executeUpdate("create table ctstable1 (TYPE_ID int, TYPE_DESC varchar(32), primary key(TYPE_ID))");
        PreparedStatement preparedStatement = connection.prepareStatement("insert into ctstable1 values(?, ?)");
        int n2 = 1;
        while (n2 <= 10) {
            String string = "Type-" + n2;
            n = n2++;
            preparedStatement.setInt(1, n);
            preparedStatement.setString(2, string);
            int n3 = preparedStatement.executeUpdate();
            TestDuckDBJDBC.assertEquals(n3, 1);
        }
        preparedStatement.close();
        connection.createStatement().executeUpdate("create table ctstable2 (KEY_ID int, COF_NAME varchar(32), PRICE float, TYPE_ID int, primary key(KEY_ID) )");
        PreparedStatement preparedStatement2 = connection.prepareStatement("insert into ctstable2 values(?, ?, ?, ?)");
        for (int i = 1; i <= 10; ++i) {
            n = i;
            String string = "xx-" + i;
            float f = (float)i + 0.0f;
            int n4 = i % 5;
            if (n4 == 0) {
                n4 = 5;
            }
            preparedStatement2.setInt(1, n);
            preparedStatement2.setString(2, string);
            preparedStatement2.setFloat(3, f);
            preparedStatement2.setInt(4, n4);
            preparedStatement2.executeUpdate();
        }
        preparedStatement2.close();
        Statement statement = connection.createStatement();
        ResultSet resultSet = statement.executeQuery("SELECT COUNT(*) FROM ctstable1");
        TestDuckDBJDBC.assertTrue(resultSet.next());
        TestDuckDBJDBC.assertEquals(resultSet.getInt(1), 10);
        resultSet.close();
        statement.executeUpdate("DELETE FROM ctstable1");
        resultSet = statement.executeQuery("SELECT COUNT(*) FROM ctstable1");
        TestDuckDBJDBC.assertTrue(resultSet.next());
        TestDuckDBJDBC.assertEquals(resultSet.getInt(1), 0);
        resultSet.close();
        statement.close();
        connection.close();
    }

    public static void test_read_only() throws Exception {
        AutoCloseable autoCloseable;
        Object object;
        Path path = Files.createTempFile("duckdb-jdbc-test-", ".duckdb", new FileAttribute[0]);
        path.toFile().delete();
        String string = "jdbc:duckdb:" + path.toString();
        Properties properties = new Properties();
        properties.setProperty("duckdb.read_only", "true");
        Connection connection = DriverManager.getConnection(string);
        TestDuckDBJDBC.assertFalse(connection.isReadOnly());
        Statement statement = connection.createStatement();
        statement.execute("CREATE TABLE test (i INTEGER)");
        statement.execute("INSERT INTO test VALUES (42)");
        statement.close();
        try {
            object = DriverManager.getConnection(string);
            TestDuckDBJDBC.fail();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            object = DriverManager.getConnection(string, properties);
            TestDuckDBJDBC.fail();
        }
        catch (Exception exception) {
            // empty catch block
        }
        object = ((DuckDBConnection)connection).getDatabase();
        connection.close();
        ((DuckDBDatabase)object).shutdown();
        try {
            autoCloseable = connection.createStatement();
            autoCloseable.executeQuery("SELECT 42");
            autoCloseable.close();
            TestDuckDBJDBC.fail();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        try {
            autoCloseable = ((DuckDBConnection)connection).duplicate();
            autoCloseable.close();
            TestDuckDBJDBC.fail();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    public static void test_hugeint() throws Exception {
        Connection connection = DriverManager.getConnection("jdbc:duckdb:");
        Statement statement = connection.createStatement();
        ResultSet resultSet = statement.executeQuery("SELECT 42::hugeint hi1, -42::hugeint hi2, 454564646545646546545646545::hugeint hi3, -454564646545646546545646545::hugeint hi4");
        TestDuckDBJDBC.assertTrue(resultSet.next());
        TestDuckDBJDBC.assertEquals(resultSet.getObject("hi1"), new BigInteger("42"));
        TestDuckDBJDBC.assertEquals(resultSet.getObject("hi2"), new BigInteger("-42"));
        TestDuckDBJDBC.assertEquals(resultSet.getLong("hi1"), 42L);
        TestDuckDBJDBC.assertEquals(resultSet.getLong("hi2"), -42L);
        TestDuckDBJDBC.assertEquals(resultSet.getObject("hi3"), new BigInteger("454564646545646546545646545"));
        TestDuckDBJDBC.assertEquals(resultSet.getObject("hi4"), new BigInteger("-454564646545646546545646545"));
        TestDuckDBJDBC.assertTrue(resultSet.getBigDecimal("hi1").compareTo(new BigDecimal("42")) == 0);
        TestDuckDBJDBC.assertTrue(resultSet.getBigDecimal("hi2").compareTo(new BigDecimal("-42")) == 0);
        TestDuckDBJDBC.assertTrue(resultSet.getBigDecimal("hi3").compareTo(new BigDecimal("454564646545646546545646545")) == 0);
        TestDuckDBJDBC.assertTrue(resultSet.getBigDecimal("hi4").compareTo(new BigDecimal("-454564646545646546545646545")) == 0);
        TestDuckDBJDBC.assertFalse(resultSet.next());
        resultSet.close();
        statement.close();
        connection.close();
    }

    public static void test_exotic_types() throws Exception {
        Connection connection = DriverManager.getConnection("jdbc:duckdb:");
        Statement statement = connection.createStatement();
        ResultSet resultSet = statement.executeQuery("SELECT '2019-11-26 21:11:00'::timestamp ts, '2019-11-26'::date dt, interval '5 days' iv, '21:11:00'::time te");
        TestDuckDBJDBC.assertTrue(resultSet.next());
        TestDuckDBJDBC.assertEquals(resultSet.getObject("ts"), Timestamp.valueOf("2019-11-26 21:11:00"));
        TestDuckDBJDBC.assertEquals(resultSet.getTimestamp("ts"), Timestamp.valueOf("2019-11-26 21:11:00"));
        TestDuckDBJDBC.assertEquals(resultSet.getObject("dt"), Date.valueOf("2019-11-26"));
        TestDuckDBJDBC.assertEquals(resultSet.getDate("dt"), Date.valueOf("2019-11-26"));
        TestDuckDBJDBC.assertEquals(resultSet.getObject("iv"), "5 days");
        TestDuckDBJDBC.assertEquals(resultSet.getObject("te"), Time.valueOf("21:11:00"));
        TestDuckDBJDBC.assertEquals(resultSet.getTime("te"), Time.valueOf("21:11:00"));
        TestDuckDBJDBC.assertFalse(resultSet.next());
        resultSet.close();
        statement.close();
        connection.close();
    }

    public static void test_exotic_nulls() throws Exception {
        Connection connection = DriverManager.getConnection("jdbc:duckdb:");
        Statement statement = connection.createStatement();
        ResultSet resultSet = statement.executeQuery("SELECT NULL::timestamp ts, NULL::date dt, NULL::time te");
        TestDuckDBJDBC.assertTrue(resultSet.next());
        TestDuckDBJDBC.assertNull(resultSet.getObject("ts"));
        TestDuckDBJDBC.assertNull(resultSet.getTimestamp("ts"));
        TestDuckDBJDBC.assertNull(resultSet.getObject("dt"));
        TestDuckDBJDBC.assertNull(resultSet.getDate("dt"));
        TestDuckDBJDBC.assertNull(resultSet.getObject("te"));
        TestDuckDBJDBC.assertNull(resultSet.getTime("te"));
        TestDuckDBJDBC.assertFalse(resultSet.next());
        resultSet.close();
        statement.close();
        connection.close();
    }

    public static void test_evil_date() throws Exception {
        Connection connection = DriverManager.getConnection("jdbc:duckdb:");
        Statement statement = connection.createStatement();
        ResultSet resultSet = statement.executeQuery("SELECT '5131-08-05 (BC)'::date d");
        TestDuckDBJDBC.assertTrue(resultSet.next());
        TestDuckDBJDBC.assertNull(resultSet.getDate("d"));
        TestDuckDBJDBC.assertFalse(resultSet.next());
        resultSet.close();
        statement.close();
        connection.close();
    }

    public static void test_decimal() throws Exception {
        Connection connection = DriverManager.getConnection("jdbc:duckdb:");
        Statement statement = connection.createStatement();
        ResultSet resultSet = statement.executeQuery("SELECT '1.23'::decimal(3,2) d");
        TestDuckDBJDBC.assertTrue(resultSet.next());
        TestDuckDBJDBC.assertEquals(resultSet.getDouble("d"), 1.23);
        TestDuckDBJDBC.assertFalse(resultSet.next());
        resultSet.close();
        statement.close();
        connection.close();
    }

    public static void test_schema_reflection() throws Exception {
        Connection connection = DriverManager.getConnection("jdbc:duckdb:");
        Statement statement = connection.createStatement();
        statement.execute("CREATE TABLE a (i INTEGER)");
        statement.execute("CREATE VIEW b AS SELECT i::STRING AS j FROM a");
        DatabaseMetaData databaseMetaData = connection.getMetaData();
        ResultSet resultSet = databaseMetaData.getTableTypes();
        TestDuckDBJDBC.assertTrue(resultSet.next());
        TestDuckDBJDBC.assertEquals(resultSet.getString("TABLE_TYPE"), "BASE TABLE");
        TestDuckDBJDBC.assertEquals(resultSet.getString(1), "BASE TABLE");
        TestDuckDBJDBC.assertTrue(resultSet.next());
        TestDuckDBJDBC.assertEquals(resultSet.getString("TABLE_TYPE"), "VIEW");
        TestDuckDBJDBC.assertEquals(resultSet.getString(1), "VIEW");
        TestDuckDBJDBC.assertFalse(resultSet.next());
        resultSet.close();
        resultSet = databaseMetaData.getCatalogs();
        TestDuckDBJDBC.assertTrue(resultSet.next());
        TestDuckDBJDBC.assertNull(resultSet.getObject("TABLE_CAT"));
        TestDuckDBJDBC.assertNull(resultSet.getObject(1));
        TestDuckDBJDBC.assertFalse(resultSet.next());
        resultSet.close();
        resultSet = databaseMetaData.getSchemas(null, "ma%");
        TestDuckDBJDBC.assertTrue(resultSet.next());
        TestDuckDBJDBC.assertEquals(resultSet.getString("TABLE_SCHEM"), "main");
        TestDuckDBJDBC.assertNull(resultSet.getObject("TABLE_CATALOG"));
        TestDuckDBJDBC.assertEquals(resultSet.getString(1), "main");
        TestDuckDBJDBC.assertNull(resultSet.getObject(2));
        TestDuckDBJDBC.assertFalse(resultSet.next());
        resultSet.close();
        resultSet = databaseMetaData.getSchemas(null, "xxx");
        TestDuckDBJDBC.assertFalse(resultSet.next());
        resultSet.close();
        resultSet = databaseMetaData.getTables(null, null, "%", null);
        TestDuckDBJDBC.assertTrue(resultSet.next());
        TestDuckDBJDBC.assertNull(resultSet.getObject("TABLE_CAT"));
        TestDuckDBJDBC.assertNull(resultSet.getObject(1));
        TestDuckDBJDBC.assertEquals(resultSet.getString("TABLE_SCHEM"), "main");
        TestDuckDBJDBC.assertEquals(resultSet.getString(2), "main");
        TestDuckDBJDBC.assertEquals(resultSet.getString("TABLE_NAME"), "a");
        TestDuckDBJDBC.assertEquals(resultSet.getString(3), "a");
        TestDuckDBJDBC.assertEquals(resultSet.getString("TABLE_TYPE"), "BASE TABLE");
        TestDuckDBJDBC.assertEquals(resultSet.getString(4), "BASE TABLE");
        TestDuckDBJDBC.assertNull(resultSet.getObject("REMARKS"));
        TestDuckDBJDBC.assertNull(resultSet.getObject(5));
        TestDuckDBJDBC.assertNull(resultSet.getObject("TYPE_CAT"));
        TestDuckDBJDBC.assertNull(resultSet.getObject(6));
        TestDuckDBJDBC.assertNull(resultSet.getObject("TYPE_SCHEM"));
        TestDuckDBJDBC.assertNull(resultSet.getObject(7));
        TestDuckDBJDBC.assertNull(resultSet.getObject("TYPE_NAME"));
        TestDuckDBJDBC.assertNull(resultSet.getObject(8));
        TestDuckDBJDBC.assertNull(resultSet.getObject("SELF_REFERENCING_COL_NAME"));
        TestDuckDBJDBC.assertNull(resultSet.getObject(9));
        TestDuckDBJDBC.assertNull(resultSet.getObject("REF_GENERATION"));
        TestDuckDBJDBC.assertNull(resultSet.getObject(10));
        TestDuckDBJDBC.assertTrue(resultSet.next());
        TestDuckDBJDBC.assertNull(resultSet.getObject("TABLE_CAT"));
        TestDuckDBJDBC.assertNull(resultSet.getObject(1));
        TestDuckDBJDBC.assertEquals(resultSet.getString("TABLE_SCHEM"), "main");
        TestDuckDBJDBC.assertEquals(resultSet.getString(2), "main");
        TestDuckDBJDBC.assertEquals(resultSet.getString("TABLE_NAME"), "b");
        TestDuckDBJDBC.assertEquals(resultSet.getString(3), "b");
        TestDuckDBJDBC.assertEquals(resultSet.getString("TABLE_TYPE"), "VIEW");
        TestDuckDBJDBC.assertEquals(resultSet.getString(4), "VIEW");
        TestDuckDBJDBC.assertNull(resultSet.getObject("REMARKS"));
        TestDuckDBJDBC.assertNull(resultSet.getObject(5));
        TestDuckDBJDBC.assertNull(resultSet.getObject("TYPE_CAT"));
        TestDuckDBJDBC.assertNull(resultSet.getObject(6));
        TestDuckDBJDBC.assertNull(resultSet.getObject("TYPE_SCHEM"));
        TestDuckDBJDBC.assertNull(resultSet.getObject(7));
        TestDuckDBJDBC.assertNull(resultSet.getObject("TYPE_NAME"));
        TestDuckDBJDBC.assertNull(resultSet.getObject(8));
        TestDuckDBJDBC.assertNull(resultSet.getObject("SELF_REFERENCING_COL_NAME"));
        TestDuckDBJDBC.assertNull(resultSet.getObject(9));
        TestDuckDBJDBC.assertNull(resultSet.getObject("REF_GENERATION"));
        TestDuckDBJDBC.assertNull(resultSet.getObject(10));
        TestDuckDBJDBC.assertFalse(resultSet.next());
        resultSet.close();
        resultSet = databaseMetaData.getTables(null, "main", "a", null);
        TestDuckDBJDBC.assertTrue(resultSet.next());
        TestDuckDBJDBC.assertNull(resultSet.getObject("TABLE_CAT"));
        TestDuckDBJDBC.assertNull(resultSet.getObject(1));
        TestDuckDBJDBC.assertEquals(resultSet.getString("TABLE_SCHEM"), "main");
        TestDuckDBJDBC.assertEquals(resultSet.getString(2), "main");
        TestDuckDBJDBC.assertEquals(resultSet.getString("TABLE_NAME"), "a");
        TestDuckDBJDBC.assertEquals(resultSet.getString(3), "a");
        TestDuckDBJDBC.assertEquals(resultSet.getString("TABLE_TYPE"), "BASE TABLE");
        TestDuckDBJDBC.assertEquals(resultSet.getString(4), "BASE TABLE");
        TestDuckDBJDBC.assertNull(resultSet.getObject("REMARKS"));
        TestDuckDBJDBC.assertNull(resultSet.getObject(5));
        TestDuckDBJDBC.assertNull(resultSet.getObject("TYPE_CAT"));
        TestDuckDBJDBC.assertNull(resultSet.getObject(6));
        TestDuckDBJDBC.assertNull(resultSet.getObject("TYPE_SCHEM"));
        TestDuckDBJDBC.assertNull(resultSet.getObject(7));
        TestDuckDBJDBC.assertNull(resultSet.getObject("TYPE_NAME"));
        TestDuckDBJDBC.assertNull(resultSet.getObject(8));
        TestDuckDBJDBC.assertNull(resultSet.getObject("SELF_REFERENCING_COL_NAME"));
        TestDuckDBJDBC.assertNull(resultSet.getObject(9));
        TestDuckDBJDBC.assertNull(resultSet.getObject("REF_GENERATION"));
        TestDuckDBJDBC.assertNull(resultSet.getObject(10));
        TestDuckDBJDBC.assertFalse(resultSet.next());
        resultSet.close();
        resultSet = databaseMetaData.getTables(null, "main", "xxx", null);
        TestDuckDBJDBC.assertFalse(resultSet.next());
        resultSet.close();
        resultSet = databaseMetaData.getColumns(null, null, "a", null);
        TestDuckDBJDBC.assertTrue(resultSet.next());
        TestDuckDBJDBC.assertNull(resultSet.getObject("TABLE_CAT"));
        TestDuckDBJDBC.assertNull(resultSet.getObject(1));
        TestDuckDBJDBC.assertEquals(resultSet.getString("TABLE_SCHEM"), "main");
        TestDuckDBJDBC.assertEquals(resultSet.getString(2), "main");
        TestDuckDBJDBC.assertEquals(resultSet.getString("TABLE_NAME"), "a");
        TestDuckDBJDBC.assertEquals(resultSet.getString(3), "a");
        TestDuckDBJDBC.assertEquals(resultSet.getString("COLUMN_NAME"), "i");
        TestDuckDBJDBC.assertEquals(resultSet.getString(4), "i");
        TestDuckDBJDBC.assertEquals(resultSet.getInt("DATA_TYPE"), 4);
        TestDuckDBJDBC.assertEquals(resultSet.getInt(5), 4);
        TestDuckDBJDBC.assertEquals(resultSet.getString("TYPE_NAME"), "INTEGER");
        TestDuckDBJDBC.assertEquals(resultSet.getString(6), "INTEGER");
        TestDuckDBJDBC.assertNull(resultSet.getObject("COLUMN_SIZE"));
        TestDuckDBJDBC.assertNull(resultSet.getObject(7));
        TestDuckDBJDBC.assertNull(resultSet.getObject("BUFFER_LENGTH"));
        TestDuckDBJDBC.assertNull(resultSet.getObject(8));
        TestDuckDBJDBC.assertFalse(resultSet.next());
        resultSet.close();
        resultSet = databaseMetaData.getColumns(null, "main", "a", "i");
        TestDuckDBJDBC.assertTrue(resultSet.next());
        TestDuckDBJDBC.assertNull(resultSet.getObject("TABLE_CAT"));
        TestDuckDBJDBC.assertNull(resultSet.getObject(1));
        TestDuckDBJDBC.assertEquals(resultSet.getString("TABLE_SCHEM"), "main");
        TestDuckDBJDBC.assertEquals(resultSet.getString(2), "main");
        TestDuckDBJDBC.assertEquals(resultSet.getString("TABLE_NAME"), "a");
        TestDuckDBJDBC.assertEquals(resultSet.getString(3), "a");
        TestDuckDBJDBC.assertEquals(resultSet.getString("COLUMN_NAME"), "i");
        TestDuckDBJDBC.assertEquals(resultSet.getString(4), "i");
        TestDuckDBJDBC.assertEquals(resultSet.getInt("DATA_TYPE"), 4);
        TestDuckDBJDBC.assertEquals(resultSet.getInt(5), 4);
        TestDuckDBJDBC.assertEquals(resultSet.getString("TYPE_NAME"), "INTEGER");
        TestDuckDBJDBC.assertEquals(resultSet.getString(6), "INTEGER");
        TestDuckDBJDBC.assertNull(resultSet.getObject("COLUMN_SIZE"));
        TestDuckDBJDBC.assertNull(resultSet.getObject(7));
        TestDuckDBJDBC.assertNull(resultSet.getObject("BUFFER_LENGTH"));
        TestDuckDBJDBC.assertNull(resultSet.getObject(8));
        TestDuckDBJDBC.assertFalse(resultSet.next());
        resultSet.close();
        resultSet = databaseMetaData.getColumns(connection.getCatalog(), "main", "a", "i");
        TestDuckDBJDBC.assertTrue(resultSet.next());
        TestDuckDBJDBC.assertNull(resultSet.getObject("TABLE_CAT"));
        TestDuckDBJDBC.assertNull(resultSet.getObject(1));
        TestDuckDBJDBC.assertEquals(resultSet.getString("TABLE_SCHEM"), "main");
        TestDuckDBJDBC.assertEquals(resultSet.getString(2), "main");
        TestDuckDBJDBC.assertEquals(resultSet.getString("TABLE_NAME"), "a");
        TestDuckDBJDBC.assertEquals(resultSet.getString(3), "a");
        TestDuckDBJDBC.assertEquals(resultSet.getString("COLUMN_NAME"), "i");
        TestDuckDBJDBC.assertEquals(resultSet.getString(4), "i");
        TestDuckDBJDBC.assertEquals(resultSet.getInt("DATA_TYPE"), 4);
        TestDuckDBJDBC.assertEquals(resultSet.getInt(5), 4);
        TestDuckDBJDBC.assertEquals(resultSet.getString("TYPE_NAME"), "INTEGER");
        TestDuckDBJDBC.assertEquals(resultSet.getString(6), "INTEGER");
        TestDuckDBJDBC.assertNull(resultSet.getObject("COLUMN_SIZE"));
        TestDuckDBJDBC.assertNull(resultSet.getObject(7));
        TestDuckDBJDBC.assertNull(resultSet.getObject("BUFFER_LENGTH"));
        TestDuckDBJDBC.assertNull(resultSet.getObject(8));
        TestDuckDBJDBC.assertFalse(resultSet.next());
        resultSet.close();
        resultSet = databaseMetaData.getColumns(null, "xxx", "a", "i");
        TestDuckDBJDBC.assertFalse(resultSet.next());
        resultSet.close();
        resultSet = databaseMetaData.getColumns(null, "main", "xxx", "i");
        TestDuckDBJDBC.assertFalse(resultSet.next());
        resultSet.close();
        resultSet = databaseMetaData.getColumns(null, "main", "a", "xxx");
        TestDuckDBJDBC.assertFalse(resultSet.next());
        resultSet.close();
        connection.close();
    }

    public static void test_connect_wrong_url_bug848() throws Exception {
        DuckDBDriver duckDBDriver = new DuckDBDriver();
        TestDuckDBJDBC.assertNull(duckDBDriver.connect("jdbc:h2:", null));
    }

    public static void test_parquet_reader() throws Exception {
        Connection connection = DriverManager.getConnection("jdbc:duckdb:");
        Statement statement = connection.createStatement();
        ResultSet resultSet = statement.executeQuery("SELECT COUNT(*) FROM parquet_scan('data/parquet-testing/userdata1.parquet')");
        TestDuckDBJDBC.assertTrue(resultSet.next());
        TestDuckDBJDBC.assertEquals(resultSet.getInt(1), 1000);
        resultSet.close();
        statement.close();
        connection.close();
    }

    public static void test_crash_autocommit_bug939() throws Exception {
        Connection connection = DriverManager.getConnection("jdbc:duckdb:");
        PreparedStatement preparedStatement = connection.prepareStatement("CREATE TABLE ontime(flightdate DATE)");
        connection.setAutoCommit(false);
        preparedStatement.executeUpdate();
        preparedStatement.close();
        connection.close();
    }

    public static void test_explain_bug958() throws Exception {
        Connection connection = DriverManager.getConnection("jdbc:duckdb:");
        Statement statement = connection.createStatement();
        ResultSet resultSet = statement.executeQuery("EXPLAIN SELECT 42");
        TestDuckDBJDBC.assertTrue(resultSet.next());
        TestDuckDBJDBC.assertTrue(resultSet.getString(1) != null);
        TestDuckDBJDBC.assertTrue(resultSet.getString(2) != null);
        resultSet.close();
        statement.close();
        connection.close();
    }

    public static void test_appender_numbers() throws Exception {
        DuckDBConnection duckDBConnection = (DuckDBConnection)DriverManager.getConnection("jdbc:duckdb:");
        Statement statement = duckDBConnection.createStatement();
        statement.execute("CREATE TABLE numbers (a BIGINT, b INTEGER, c SMALLINT, d TINYINT, e DOUBLE, f FLOAT)");
        DuckDBAppender duckDBAppender = duckDBConnection.createAppender("main", "numbers");
        for (int i = 0; i < 50; ++i) {
            duckDBAppender.beginRow();
            duckDBAppender.append(Long.MAX_VALUE - (long)i);
            duckDBAppender.append(Integer.MAX_VALUE - i);
            duckDBAppender.append(Short.MAX_VALUE - i);
            duckDBAppender.append(127 - i);
            duckDBAppender.append(i);
            duckDBAppender.append(i);
            duckDBAppender.endRow();
        }
        duckDBAppender.close();
        ResultSet resultSet = statement.executeQuery("SELECT max(a), max(b), max(c), max(d), max(e), max(f) FROM numbers");
        TestDuckDBJDBC.assertFalse(resultSet.isClosed());
        TestDuckDBJDBC.assertTrue(resultSet.next());
        long l = resultSet.getLong(1);
        TestDuckDBJDBC.assertEquals(l, Long.MAX_VALUE);
        int n = resultSet.getInt(2);
        TestDuckDBJDBC.assertEquals(n, Integer.MAX_VALUE);
        short s = resultSet.getShort(3);
        TestDuckDBJDBC.assertEquals(s, (short)Short.MAX_VALUE);
        byte by = resultSet.getByte(4);
        TestDuckDBJDBC.assertEquals(by, (byte)127);
        double d = resultSet.getDouble(5);
        TestDuckDBJDBC.assertEquals(d, 49.0);
        float f = resultSet.getFloat(6);
        TestDuckDBJDBC.assertEquals(Float.valueOf(f), Float.valueOf(49.0f));
        resultSet.close();
        statement.close();
        duckDBConnection.close();
    }

    public static void test_appender_int_string() throws Exception {
        DuckDBConnection duckDBConnection = (DuckDBConnection)DriverManager.getConnection("jdbc:duckdb:");
        Statement statement = duckDBConnection.createStatement();
        statement.execute("CREATE TABLE data (a INTEGER, s VARCHAR)");
        DuckDBAppender duckDBAppender = duckDBConnection.createAppender("main", "data");
        for (int i = 0; i < 1000; ++i) {
            duckDBAppender.beginRow();
            duckDBAppender.append(i);
            duckDBAppender.append("str " + i);
            duckDBAppender.endRow();
        }
        duckDBAppender.close();
        ResultSet resultSet = statement.executeQuery("SELECT max(a), min(s) FROM data");
        TestDuckDBJDBC.assertFalse(resultSet.isClosed());
        TestDuckDBJDBC.assertTrue(resultSet.next());
        int n = resultSet.getInt(1);
        TestDuckDBJDBC.assertEquals(n, 999);
        String string = resultSet.getString(2);
        TestDuckDBJDBC.assertEquals(string, "str 0");
        resultSet.close();
        statement.close();
        duckDBConnection.close();
    }

    public static void test_appender_string_with_emoji() throws Exception {
        DuckDBConnection duckDBConnection = (DuckDBConnection)DriverManager.getConnection("jdbc:duckdb:");
        Statement statement = duckDBConnection.createStatement();
        statement.execute("CREATE TABLE data (str_value VARCHAR(10))");
        String string = "\u4b54\ud86d\udf7c\ud83d\udd25\ud83d\ude1c";
        AutoCloseable autoCloseable = duckDBConnection.createAppender("main", "data");
        Object object = null;
        try {
            ((DuckDBAppender)autoCloseable).beginRow();
            ((DuckDBAppender)autoCloseable).append(string);
            ((DuckDBAppender)autoCloseable).endRow();
        }
        catch (Throwable throwable) {
            object = throwable;
            throw throwable;
        }
        finally {
            if (autoCloseable != null) {
                if (object != null) {
                    try {
                        ((DuckDBAppender)autoCloseable).close();
                    }
                    catch (Throwable throwable) {
                        ((Throwable)object).addSuppressed(throwable);
                    }
                } else {
                    ((DuckDBAppender)autoCloseable).close();
                }
            }
        }
        autoCloseable = statement.executeQuery("SELECT str_value FROM data");
        TestDuckDBJDBC.assertFalse(autoCloseable.isClosed());
        TestDuckDBJDBC.assertTrue(autoCloseable.next());
        object = autoCloseable.getString(1);
        TestDuckDBJDBC.assertEquals(object, string);
        autoCloseable.close();
        statement.close();
        duckDBConnection.close();
    }

    public static void test_appender_table_does_not_exist() throws Exception {
        DuckDBConnection duckDBConnection = (DuckDBConnection)DriverManager.getConnection("jdbc:duckdb:");
        Statement statement = duckDBConnection.createStatement();
        try {
            DuckDBAppender duckDBAppender = duckDBConnection.createAppender("main", "data");
            TestDuckDBJDBC.fail();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        statement.close();
        duckDBConnection.close();
    }

    public static void test_appender_table_deleted() throws Exception {
        DuckDBConnection duckDBConnection = (DuckDBConnection)DriverManager.getConnection("jdbc:duckdb:");
        Statement statement = duckDBConnection.createStatement();
        statement.execute("CREATE TABLE data (a INTEGER)");
        DuckDBAppender duckDBAppender = duckDBConnection.createAppender("main", "data");
        duckDBAppender.beginRow();
        duckDBAppender.append(1);
        duckDBAppender.endRow();
        statement.execute("DROP TABLE data");
        duckDBAppender.beginRow();
        duckDBAppender.append(2);
        duckDBAppender.endRow();
        try {
            duckDBAppender.close();
            TestDuckDBJDBC.fail();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        statement.close();
        duckDBConnection.close();
    }

    public static void test_appender_append_too_many_columns() throws Exception {
        DuckDBConnection duckDBConnection = (DuckDBConnection)DriverManager.getConnection("jdbc:duckdb:");
        Statement statement = duckDBConnection.createStatement();
        statement.execute("CREATE TABLE data (a INTEGER)");
        statement.close();
        DuckDBAppender duckDBAppender = duckDBConnection.createAppender("main", "data");
        try {
            duckDBAppender.beginRow();
            duckDBAppender.append(1);
            duckDBAppender.append(2);
            TestDuckDBJDBC.fail();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        duckDBConnection.close();
    }

    public static void test_appender_append_too_few_columns() throws Exception {
        DuckDBConnection duckDBConnection = (DuckDBConnection)DriverManager.getConnection("jdbc:duckdb:");
        Statement statement = duckDBConnection.createStatement();
        statement.execute("CREATE TABLE data (a INTEGER, b INTEGER)");
        statement.close();
        DuckDBAppender duckDBAppender = duckDBConnection.createAppender("main", "data");
        try {
            duckDBAppender.beginRow();
            duckDBAppender.append(1);
            duckDBAppender.endRow();
            TestDuckDBJDBC.fail();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        duckDBConnection.close();
    }

    public static void test_appender_type_mismatch() throws Exception {
        DuckDBConnection duckDBConnection = (DuckDBConnection)DriverManager.getConnection("jdbc:duckdb:");
        Statement statement = duckDBConnection.createStatement();
        statement.execute("CREATE TABLE data (a INTEGER)");
        DuckDBAppender duckDBAppender = duckDBConnection.createAppender("main", "data");
        try {
            duckDBAppender.beginRow();
            duckDBAppender.append("str");
            TestDuckDBJDBC.fail();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        statement.close();
        duckDBConnection.close();
    }

    public static void test_appender_null_integer() throws Exception {
        DuckDBConnection duckDBConnection = (DuckDBConnection)DriverManager.getConnection("jdbc:duckdb:");
        Statement statement = duckDBConnection.createStatement();
        statement.execute("CREATE TABLE data (a INTEGER)");
        DuckDBAppender duckDBAppender = duckDBConnection.createAppender("main", "data");
        duckDBAppender.beginRow();
        duckDBAppender.append(null);
        duckDBAppender.endRow();
        duckDBAppender.flush();
        duckDBAppender.close();
        ResultSet resultSet = statement.executeQuery("SELECT * FROM data");
        TestDuckDBJDBC.assertTrue(resultSet.next());
        TestDuckDBJDBC.assertEquals(0, resultSet.getInt(1));
        TestDuckDBJDBC.assertTrue(resultSet.wasNull());
        resultSet.close();
        statement.close();
        duckDBConnection.close();
    }

    public static void test_appender_null_varchar() throws Exception {
        DuckDBConnection duckDBConnection = (DuckDBConnection)DriverManager.getConnection("jdbc:duckdb:");
        Statement statement = duckDBConnection.createStatement();
        statement.execute("CREATE TABLE data (a VARCHAR)");
        DuckDBAppender duckDBAppender = duckDBConnection.createAppender("main", "data");
        duckDBAppender.beginRow();
        duckDBAppender.append(null);
        duckDBAppender.endRow();
        duckDBAppender.flush();
        duckDBAppender.close();
        ResultSet resultSet = statement.executeQuery("SELECT * FROM data");
        TestDuckDBJDBC.assertTrue(resultSet.next());
        TestDuckDBJDBC.assertNull(resultSet.getString(1));
        TestDuckDBJDBC.assertTrue(resultSet.wasNull());
        resultSet.close();
        statement.close();
        duckDBConnection.close();
    }

    public static void test_get_catalog() throws Exception {
        DuckDBConnection duckDBConnection = (DuckDBConnection)DriverManager.getConnection("jdbc:duckdb:");
        ResultSet resultSet = duckDBConnection.getMetaData().getCatalogs();
        TestDuckDBJDBC.assertTrue(resultSet.next());
        String string = resultSet.getString(1);
        TestDuckDBJDBC.assertFalse(resultSet.next());
        resultSet.close();
        TestDuckDBJDBC.assertEquals(duckDBConnection.getCatalog(), string);
        duckDBConnection.close();
    }

    public static void test_set_catalog() throws Exception {
        DuckDBConnection duckDBConnection = (DuckDBConnection)DriverManager.getConnection("jdbc:duckdb:");
        duckDBConnection.setCatalog("we do not have this feature yet, sorry");
        duckDBConnection.close();
    }

    public static void test_get_table_types_bug1258() throws Exception {
        DuckDBConnection duckDBConnection = (DuckDBConnection)DriverManager.getConnection("jdbc:duckdb:");
        Statement statement = duckDBConnection.createStatement();
        statement.execute("CREATE TABLE a1 (i INTEGER)");
        statement.execute("CREATE TABLE a2 (i INTEGER)");
        statement.execute("CREATE TEMPORARY TABLE b (i INTEGER)");
        statement.execute("CREATE VIEW c AS SELECT * FROM a1");
        statement.close();
        ResultSet resultSet = duckDBConnection.getMetaData().getTables(null, null, null, null);
        TestDuckDBJDBC.assertTrue(resultSet.next());
        TestDuckDBJDBC.assertEquals(resultSet.getString("TABLE_NAME"), "a1");
        TestDuckDBJDBC.assertTrue(resultSet.next());
        TestDuckDBJDBC.assertEquals(resultSet.getString("TABLE_NAME"), "a2");
        TestDuckDBJDBC.assertTrue(resultSet.next());
        TestDuckDBJDBC.assertEquals(resultSet.getString("TABLE_NAME"), "b");
        TestDuckDBJDBC.assertTrue(resultSet.next());
        TestDuckDBJDBC.assertEquals(resultSet.getString("TABLE_NAME"), "c");
        TestDuckDBJDBC.assertFalse(resultSet.next());
        resultSet.close();
        resultSet = duckDBConnection.getMetaData().getTables(null, null, null, new String[0]);
        TestDuckDBJDBC.assertTrue(resultSet.next());
        TestDuckDBJDBC.assertEquals(resultSet.getString("TABLE_NAME"), "a1");
        TestDuckDBJDBC.assertTrue(resultSet.next());
        TestDuckDBJDBC.assertEquals(resultSet.getString("TABLE_NAME"), "a2");
        TestDuckDBJDBC.assertTrue(resultSet.next());
        TestDuckDBJDBC.assertEquals(resultSet.getString("TABLE_NAME"), "b");
        TestDuckDBJDBC.assertTrue(resultSet.next());
        TestDuckDBJDBC.assertEquals(resultSet.getString("TABLE_NAME"), "c");
        TestDuckDBJDBC.assertFalse(resultSet.next());
        resultSet.close();
        resultSet = duckDBConnection.getMetaData().getTables(null, null, null, new String[]{"BASE TABLE"});
        TestDuckDBJDBC.assertTrue(resultSet.next());
        TestDuckDBJDBC.assertEquals(resultSet.getString("TABLE_NAME"), "a1");
        TestDuckDBJDBC.assertTrue(resultSet.next());
        TestDuckDBJDBC.assertEquals(resultSet.getString("TABLE_NAME"), "a2");
        TestDuckDBJDBC.assertFalse(resultSet.next());
        resultSet.close();
        resultSet = duckDBConnection.getMetaData().getTables(null, null, null, new String[]{"BASE TABLE", "VIEW"});
        TestDuckDBJDBC.assertTrue(resultSet.next());
        TestDuckDBJDBC.assertEquals(resultSet.getString("TABLE_NAME"), "a1");
        TestDuckDBJDBC.assertTrue(resultSet.next());
        TestDuckDBJDBC.assertEquals(resultSet.getString("TABLE_NAME"), "a2");
        TestDuckDBJDBC.assertTrue(resultSet.next());
        TestDuckDBJDBC.assertEquals(resultSet.getString("TABLE_NAME"), "c");
        TestDuckDBJDBC.assertFalse(resultSet.next());
        resultSet.close();
        resultSet = duckDBConnection.getMetaData().getTables(null, null, null, new String[]{"XXXX"});
        TestDuckDBJDBC.assertFalse(resultSet.next());
        resultSet.close();
        duckDBConnection.close();
    }

    public static void test_utf_string_bug1271() throws Exception {
        DuckDBConnection duckDBConnection = (DuckDBConnection)DriverManager.getConnection("jdbc:duckdb:");
        Statement statement = duckDBConnection.createStatement();
        ResultSet resultSet = statement.executeQuery("SELECT 'M\u00fchleisen', '\ud83e\udd86', '\ud83e\udd84\u0f80\u0f72123456789'");
        TestDuckDBJDBC.assertEquals(resultSet.getMetaData().getColumnName(1), "'M\u00fchleisen'");
        TestDuckDBJDBC.assertEquals(resultSet.getMetaData().getColumnName(2), "'\ud83e\udd86'");
        TestDuckDBJDBC.assertEquals(resultSet.getMetaData().getColumnName(3), "'\ud83e\udd84\u0f80\u0f72123456789'");
        TestDuckDBJDBC.assertTrue(resultSet.next());
        TestDuckDBJDBC.assertEquals(resultSet.getString(1), "M\u00fchleisen");
        TestDuckDBJDBC.assertEquals(resultSet.getString(2), "\ud83e\udd86");
        TestDuckDBJDBC.assertEquals(resultSet.getString(3), "\ud83e\udd84\u0f80\u0f72123456789");
        resultSet.close();
        statement.close();
        duckDBConnection.close();
    }

    public static void test_statement_creation_bug1268() throws Exception {
        DuckDBConnection duckDBConnection = (DuckDBConnection)DriverManager.getConnection("jdbc:duckdb:");
        Statement statement = duckDBConnection.createStatement();
        statement.close();
        statement = duckDBConnection.createStatement(1003, 1007);
        statement.close();
        statement = duckDBConnection.createStatement(1003, 1007, 0);
        statement.close();
        PreparedStatement preparedStatement = duckDBConnection.prepareStatement("SELECT 42");
        preparedStatement.close();
        preparedStatement = duckDBConnection.prepareStatement("SELECT 42", 1003, 1007);
        preparedStatement.close();
        preparedStatement = duckDBConnection.prepareStatement("SELECT 42", 1003, 1007, 0);
        preparedStatement.close();
        duckDBConnection.close();
    }

    private static String blob_to_string(Blob blob) throws SQLException {
        return new String(blob.getBytes(0L, (int)blob.length()), StandardCharsets.US_ASCII);
    }

    public static void test_blob_bug1090() throws Exception {
        DuckDBConnection duckDBConnection = (DuckDBConnection)DriverManager.getConnection("jdbc:duckdb:");
        Statement statement = duckDBConnection.createStatement();
        String string = "asdf";
        String string2 = "asdxxxxxxxxxxxxxxf";
        ResultSet resultSet = statement.executeQuery("SELECT '" + string + "'::BLOB a, NULL::BLOB b, '" + string2 + "'::BLOB c");
        TestDuckDBJDBC.assertTrue(resultSet.next());
        TestDuckDBJDBC.assertTrue(string.equals(TestDuckDBJDBC.blob_to_string(resultSet.getBlob(1))));
        TestDuckDBJDBC.assertTrue(string.equals(TestDuckDBJDBC.blob_to_string(resultSet.getBlob("a"))));
        TestDuckDBJDBC.assertTrue(string2.equals(TestDuckDBJDBC.blob_to_string(resultSet.getBlob("c"))));
        resultSet.getBlob("a");
        TestDuckDBJDBC.assertFalse(resultSet.wasNull());
        resultSet.getBlob("b");
        TestDuckDBJDBC.assertTrue(resultSet.wasNull());
        resultSet.close();
        statement.close();
        duckDBConnection.close();
    }

    public static void test_unsiged_integers() throws Exception {
        DuckDBConnection duckDBConnection = (DuckDBConnection)DriverManager.getConnection("jdbc:duckdb:");
        Statement statement = duckDBConnection.createStatement();
        ResultSet resultSet = statement.executeQuery("SELECT 201::utinyint uint8, 40001::usmallint uint16, 4000000001::uinteger uint32, 18446744073709551615::ubigint uint64");
        TestDuckDBJDBC.assertTrue(resultSet.next());
        TestDuckDBJDBC.assertEquals(resultSet.getShort("uint8"), (short)201);
        TestDuckDBJDBC.assertEquals(resultSet.getObject("uint8"), (short)201);
        TestDuckDBJDBC.assertEquals(resultSet.getInt("uint8"), 201);
        TestDuckDBJDBC.assertEquals(resultSet.getInt("uint16"), 40001);
        TestDuckDBJDBC.assertEquals(resultSet.getObject("uint16"), 40001);
        TestDuckDBJDBC.assertEquals(resultSet.getLong("uint16"), 40001L);
        TestDuckDBJDBC.assertEquals(resultSet.getLong("uint32"), 4000000001L);
        TestDuckDBJDBC.assertEquals(resultSet.getObject("uint32"), 4000000001L);
        TestDuckDBJDBC.assertEquals(resultSet.getObject("uint64"), new BigInteger("18446744073709551615"));
        resultSet.close();
        resultSet = statement.executeQuery("SELECT NULL::utinyint uint8, NULL::usmallint uint16, NULL::uinteger uint32, NULL::ubigint uint64");
        TestDuckDBJDBC.assertTrue(resultSet.next());
        resultSet.getObject(1);
        TestDuckDBJDBC.assertTrue(resultSet.wasNull());
        resultSet.getObject(2);
        TestDuckDBJDBC.assertTrue(resultSet.wasNull());
        resultSet.getObject(3);
        TestDuckDBJDBC.assertTrue(resultSet.wasNull());
        resultSet.getObject(4);
        TestDuckDBJDBC.assertTrue(resultSet.wasNull());
        statement.close();
        duckDBConnection.close();
    }

    public static void test_get_schema() throws Exception {
        DuckDBConnection duckDBConnection = (DuckDBConnection)DriverManager.getConnection("jdbc:duckdb:");
        TestDuckDBJDBC.assertEquals(duckDBConnection.getSchema(), "main");
        try (Statement statement = duckDBConnection.createStatement();){
            statement.execute("CREATE SCHEMA alternate_schema;");
            statement.execute("SET search_path = \"alternate_schema\";");
        }
        TestDuckDBJDBC.assertEquals(duckDBConnection.getSchema(), "alternate_schema");
        duckDBConnection.close();
        try {
            duckDBConnection.getSchema();
            TestDuckDBJDBC.fail();
        }
        catch (SQLException sQLException) {
            TestDuckDBJDBC.assertEquals(sQLException.getMessage(), "Invalid connection");
        }
    }

    public static void test_cached_row_set() throws Exception {
        CachedRowSet cachedRowSet = RowSetProvider.newFactory().createCachedRowSet();
        cachedRowSet.setUrl("jdbc:duckdb:");
        cachedRowSet.setCommand("select 1");
        cachedRowSet.execute();
        cachedRowSet.next();
        TestDuckDBJDBC.assertEquals(cachedRowSet.getInt(1), 1);
    }

    public static void test_json() throws Exception {
        JsonNode jsonNode;
        ResultSet resultSet;
        DuckDBConnection duckDBConnection = (DuckDBConnection)DriverManager.getConnection("jdbc:duckdb:");
        try (Statement statement = duckDBConnection.createStatement();){
            resultSet = statement.executeQuery("select [1, 5]::JSON");
            resultSet.next();
            jsonNode = (JsonNode)resultSet.getObject(1);
            TestDuckDBJDBC.assertTrue(jsonNode.isArray());
            TestDuckDBJDBC.assertEquals(jsonNode.toString(), "[1, 5]");
        }
        statement = duckDBConnection.createStatement();
        var2_2 = null;
        try {
            resultSet = statement.executeQuery("select 'hello'::JSON");
            resultSet.next();
            jsonNode = (JsonNode)resultSet.getObject(1);
            TestDuckDBJDBC.assertTrue(jsonNode.isString());
            TestDuckDBJDBC.assertEquals(jsonNode.toString(), "hello");
        }
        catch (Throwable throwable) {
            var2_2 = throwable;
            throw throwable;
        }
        finally {
            if (statement != null) {
                if (var2_2 != null) {
                    try {
                        statement.close();
                    }
                    catch (Throwable throwable) {
                        var2_2.addSuppressed(throwable);
                    }
                } else {
                    statement.close();
                }
            }
        }
    }

    public static void test_bug4218_prepare_types() throws Exception {
        DuckDBConnection duckDBConnection = (DuckDBConnection)DriverManager.getConnection("jdbc:duckdb:");
        String string = "SELECT ($1 || $2)";
        duckDBConnection.prepareStatement(string);
        TestDuckDBJDBC.assertTrue(true);
    }

    public static void test_bug532_timestamp() throws Exception {
        Connection connection = DriverManager.getConnection("jdbc:duckdb:");
        Statement statement = connection.createStatement();
        statement.execute("CREATE TABLE t0(c0 DATETIME);");
        statement.execute("INSERT INTO t0 VALUES(DATE '1-1-1');");
        ResultSet resultSet = statement.executeQuery("SELECT t0.c0 FROM t0; ");
        resultSet.next();
        resultSet.getObject(1);
    }

    public static void test_bug966_typeof() throws Exception {
        Connection connection = DriverManager.getConnection("jdbc:duckdb:");
        Statement statement = connection.createStatement();
        ResultSet resultSet = statement.executeQuery("select typeof(1);");
        resultSet.next();
        TestDuckDBJDBC.assertEquals(resultSet.getString(1), "INTEGER");
    }

    public static void main(String[] stringArray) throws Exception {
        Method[] methodArray = TestDuckDBJDBC.class.getMethods();
        Arrays.sort(methodArray, new Comparator<Method>(){

            @Override
            public int compare(Method method, Method method2) {
                return method.getName().compareTo(method2.getName());
            }
        });
        boolean bl = false;
        for (Method method : methodArray) {
            if (!method.getName().startsWith("test_")) continue;
            System.out.print(method.getName() + " ");
            LocalDateTime localDateTime = LocalDateTime.now();
            try {
                method.invoke(null, new Object[0]);
                System.out.println("success in " + Duration.between(localDateTime, LocalDateTime.now()).getSeconds() + " seconds");
            }
            catch (Throwable throwable) {
                System.out.println("failed with " + throwable);
                throwable.printStackTrace(System.out);
                bl = true;
            }
        }
        System.out.println("OK");
        System.exit(bl ? 1 : 0);
    }

    static {
        try {
            Class.forName("org.duckdb.DuckDBDriver");
        }
        catch (ClassNotFoundException classNotFoundException) {
            classNotFoundException.printStackTrace();
        }
    }
}

